/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.ceph;

import com.ceph.rbd.Rbd;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.ceph.CephRbdAdapter;
import com.eucalyptus.blockstorage.ceph.CephRbdFormatTwoAdapter;
import com.eucalyptus.blockstorage.ceph.CephRbdResource;
import com.eucalyptus.blockstorage.ceph.entities.CephRbdInfo;
import com.eucalyptus.blockstorage.ceph.exceptions.CannotDeleteCephImageException;
import com.eucalyptus.blockstorage.ceph.exceptions.CephImageNotFoundException;
import com.eucalyptus.blockstorage.ceph.exceptions.EucalyptusCephException;
import com.eucalyptus.blockstorage.san.common.SANManager;
import com.eucalyptus.blockstorage.san.common.SANProvider;
import com.eucalyptus.util.EucalyptusCloudException;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@StorageManagers.StorageManagerProperty(value="ceph-rbd", manager=SANManager.class)
public class CephRbdProvider
implements SANProvider {
    private static final Logger LOG = Logger.getLogger(CephRbdProvider.class);
    private static final Logger LOGD = Logger.getLogger(CephRbdImageDeleter.class);
    private CephRbdAdapter rbdService;
    private CephRbdInfo cachedConfig;
    private static ScheduledExecutorService deletionService;

    @Override
    public void initialize() {
        LOG.info((Object)"Initializing CephInfo entity");
        CephRbdInfo.getStorageInfo();
    }

    @Override
    public void configure() throws EucalyptusCloudException {
        CephRbdInfo cephInfo = CephRbdInfo.getStorageInfo();
        this.initializeRbdService(cephInfo);
        this.initializeDeletionService();
    }

    private void initializeRbdService(CephRbdInfo info) {
        LOG.info((Object)"Initializing Ceph RBD service provider");
        this.cachedConfig = info;
        if (this.rbdService == null) {
            this.rbdService = new CephRbdFormatTwoAdapter(this.cachedConfig);
        } else {
            this.rbdService.setCephConfig(this.cachedConfig);
        }
    }

    private void initializeDeletionService() {
        if (deletionService != null) {
            deletionService.shutdownNow();
        }
        deletionService = Executors.newScheduledThreadPool(1);
        deletionService.scheduleWithFixedDelay(new CephRbdImageDeleter(), 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void checkConnection() throws EucalyptusCloudException {
        CephRbdInfo info = CephRbdInfo.getStorageInfo();
        if (info != null && !this.cachedConfig.isSame(info)) {
            LOG.info((Object)"Detected a change in Ceph configuration");
            this.initializeRbdService(info);
        }
        if (deletionService == null || deletionService.isTerminated() || deletionService.isShutdown()) {
            this.initializeDeletionService();
        }
    }

    @Override
    public String createVolume(String volumeId, String snapshotId, int snapSize, int size) throws EucalyptusCloudException {
        String iqn = null;
        iqn = size > snapSize ? this.rbdService.cloneAndResizeImage(snapshotId, "sp-on-" + snapshotId, volumeId, (long)size * 0x40000000L) : this.rbdService.cloneAndResizeImage(snapshotId, "sp-on-" + snapshotId, volumeId, null);
        return iqn;
    }

    @Override
    public String cloneVolume(String volumeId, String parentVolumeId) throws EucalyptusCloudException {
        String iqn = this.rbdService.cloneAndResizeImage(parentVolumeId, null, volumeId, null);
        return iqn;
    }

    @Override
    public StorageResource connectTarget(String iqn) throws EucalyptusCloudException {
        if (iqn.contains(",")) {
            String[] parts = iqn.split(",");
            return new CephRbdResource(parts[0], parts[0]);
        }
        return new CephRbdResource(iqn, iqn);
    }

    @Override
    public String getVolumeConnectionString(String volumeId) {
        return CephRbdInfo.getStorageInfo().getVirshSecret() + ",,,";
    }

    @Override
    public String createVolume(String volumeName, int size) throws EucalyptusCloudException {
        long sizeInBytes = (long)size * 0x40000000L;
        String iqn = this.rbdService.createImage(volumeName, sizeInBytes);
        return iqn;
    }

    @Override
    public boolean deleteVolume(String volumeId) {
        try {
            this.rbdService.renameImage(volumeId, this.cachedConfig.getDeletedImagePrefix() + volumeId);
        }
        catch (CephImageNotFoundException e) {
            return true;
        }
        catch (EucalyptusCephException e) {
            return false;
        }
        return true;
    }

    @Override
    public String createSnapshot(String volumeId, String snapshotId, String snapshotPointId) throws EucalyptusCloudException {
        String iqn = this.rbdService.cloneAndResizeImage(volumeId, snapshotPointId, snapshotId, null);
        return iqn;
    }

    @Override
    public boolean deleteSnapshot(String volumeId, String snapshotId, boolean locallyCreated) {
        try {
            this.rbdService.renameImage(snapshotId, this.cachedConfig.getDeletedImagePrefix() + snapshotId);
        }
        catch (CephImageNotFoundException e) {
            return true;
        }
        catch (EucalyptusCephException e) {
            return false;
        }
        return true;
    }

    @Override
    public void deleteUser(String userName) throws EucalyptusCloudException {
    }

    @Override
    public void addUser(String userName) throws EucalyptusCloudException {
    }

    @Override
    public void disconnectTarget(String snapshotId, String iqn) throws EucalyptusCloudException {
        if (iqn.contains(",")) {
            String snapshotPoint = "sp-on-" + snapshotId;
            this.rbdService.createSnapshot(snapshotId, snapshotPoint);
        }
    }

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        try {
            int[] version = Rbd.getVersion();
            if (version == null || version.length != 3) {
                throw new EucalyptusCloudException("Invalid librbd version info");
            }
            LOG.info((Object)("librbd version: " + new StringBuffer().append(version[0]).append('.').append(version[1]).append('.').append(version[2]).toString()));
        }
        catch (Exception e) {
            LOG.warn((Object)"librbd version not found, librbd may not be installed!");
            throw new EucalyptusCloudException("librbd version not found, librbd may not be installed!", (Throwable)e);
        }
    }

    @Override
    public String addInitiatorRule(String volumeId, String nodeIqn) throws EucalyptusCloudException {
        try {
            String pool = this.rbdService.getImagePool(volumeId);
            return pool + '/' + volumeId;
        }
        catch (Exception e) {
            throw new EucalyptusCloudException("Unable to export " + volumeId, (Throwable)e);
        }
    }

    @Override
    public void removeInitiatorRule(String volumeId, String nodeIqn) throws EucalyptusCloudException {
    }

    @Override
    public void removeAllInitiatorRules(String volumeId) throws EucalyptusCloudException {
    }

    @Override
    public void getStorageProps(ArrayList<ComponentProperty> componentProperties) {
    }

    @Override
    public void setStorageProps(ArrayList<ComponentProperty> storageProps) {
    }

    @Override
    public void stop() throws EucalyptusCloudException {
        if (deletionService != null && !deletionService.isShutdown()) {
            deletionService.shutdownNow();
        }
    }

    @Override
    public String getAuthType() {
        return null;
    }

    @Override
    public String getOptionalChapUser() {
        return null;
    }

    @Override
    public String createSnapshotHolder(String snapshotId, long snapSizeInMB) throws EucalyptusCloudException {
        long sizeInBytes = snapSizeInMB * 0x100000L;
        String iqn = this.rbdService.createImage(snapshotId, sizeInBytes);
        return iqn;
    }

    @Override
    public boolean snapshotExists(String snapshotId) throws EucalyptusCloudException {
        return this.volumeExists(snapshotId);
    }

    @Override
    public String createSnapshotPoint(String parentVolumeId, String snapshotId) throws EucalyptusCloudException {
        String snapshotPoint = "sp-for-" + snapshotId;
        this.rbdService.createSnapshot(parentVolumeId, snapshotPoint);
        return snapshotPoint;
    }

    @Override
    public void deleteSnapshotPoint(String parentVolumeId, String snapshotPointId) throws EucalyptusCloudException {
        this.rbdService.deleteSnapshot(parentVolumeId, snapshotPointId);
    }

    @Override
    public boolean checkSANCredentialsExist() {
        return true;
    }

    @Override
    public boolean volumeExists(String volumeId) throws EucalyptusCloudException {
        try {
            return null != this.rbdService.getImagePool(volumeId);
        }
        catch (Exception e) {
            LOG.debug((Object)("Caught error in check for " + volumeId), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getProtocol() {
        return "rbd";
    }

    @Override
    public String getProviderName() {
        return "ceph";
    }

    class CephRbdImageDeleter
    implements Runnable {
        CephRbdImageDeleter() {
        }

        @Override
        public void run() {
            try {
                HashSet<String> poolSet = new HashSet<String>(Arrays.asList(CephRbdProvider.this.cachedConfig.getCephVolumePools().split(",")));
                poolSet.addAll(Arrays.asList(CephRbdProvider.this.cachedConfig.getCephSnapshotPools().split(",")));
                for (String pool : poolSet) {
                    for (String image : CephRbdProvider.this.rbdService.listPool(pool)) {
                        if (!image.startsWith(CephRbdProvider.this.cachedConfig.getDeletedImagePrefix())) continue;
                        LOGD.debug((Object)("Image " + image + " was marked for deletion, cleaning it up"));
                        try {
                            CephRbdProvider.this.rbdService.deleteImage(image, pool);
                        }
                        catch (CannotDeleteCephImageException e) {
                            LOGD.debug((Object)("Will retry deleting image " + image + " when it has no clones/children"));
                        }
                        catch (Exception e) {
                            LOGD.warn((Object)("Failed to delete image " + image + ". Will keep retrying"));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Caught error during clean up of deleted images", (Throwable)e);
            }
        }
    }
}

