/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.ceph;

import com.ceph.rbd.RbdException;
import com.ceph.rbd.RbdImage;
import com.ceph.rbd.jna.RbdSnapInfo;
import com.eucalyptus.blockstorage.ceph.CephRbdAdapter;
import com.eucalyptus.blockstorage.ceph.CephRbdConnectionManager;
import com.eucalyptus.blockstorage.ceph.entities.CephRbdInfo;
import com.eucalyptus.blockstorage.ceph.exceptions.CannotDeleteCephImageException;
import com.eucalyptus.blockstorage.ceph.exceptions.CephImageNotFoundException;
import com.eucalyptus.blockstorage.ceph.exceptions.EucalyptusCephException;
import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class CephRbdFormatTwoAdapter
implements CephRbdAdapter {
    private static final Logger LOG = Logger.getLogger(CephRbdFormatTwoAdapter.class);
    private CephRbdInfo config;

    public CephRbdFormatTwoAdapter(CephRbdInfo cephInfo) {
        this.config = cephInfo;
    }

    @Override
    public void setCephConfig(CephRbdInfo cephInfo) {
        this.config = cephInfo;
    }

    @Override
    public String createImage(final String imageName, final long imageSize) {
        return this.executeRbdOpInRandomPool(new Function<CephRbdConnectionManager, String>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public String apply(@Nonnull CephRbdConnectionManager arg0) {
                String string;
                RbdImage image = null;
                try {
                    LOG.debug((Object)("Creating image=" + imageName + ", pool=" + arg0.getPool() + ", size=" + imageSize));
                    int features = 1;
                    arg0.getRbd().create(imageName, imageSize, (long)features, 0);
                    LOG.trace((Object)("Opening image=" + imageName + ", pool=" + arg0.getPool() + ", mode=read-only"));
                    image = arg0.getRbd().openReadOnly(imageName);
                    string = arg0.getPool() + "/" + imageName;
                    if (image == null) return string;
                }
                catch (RbdException e) {
                    try {
                        LOG.warn((Object)("Caught error while creating image " + imageName + ": " + e.getMessage()));
                        throw new EucalyptusCephException("Failed to create image " + imageName, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (image == null) throw throwable;
                        try {
                            LOG.trace((Object)("Closing image=" + imageName + ", pool=" + arg0.getPool()));
                            arg0.getRbd().close(image);
                            throw throwable;
                        }
                        catch (Exception e2) {
                            LOG.debug((Object)("Caught exception closing image " + imageName + ", pool=" + arg0.getPool()), (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    LOG.trace((Object)("Closing image=" + imageName + ", pool=" + arg0.getPool()));
                    arg0.getRbd().close(image);
                    return string;
                }
                catch (Exception e) {
                    LOG.debug((Object)("Caught exception closing image " + imageName + ", pool=" + arg0.getPool()), (Throwable)e);
                }
                return string;
            }
        }, imageName);
    }

    @Override
    public void deleteImage(final String imageName, final String poolName) {
        this.executeRbdOpInPool(new Function<CephRbdConnectionManager, String>(){

            public String apply(CephRbdConnectionManager arg0) {
                RbdImage image = null;
                try {
                    LOG.trace((Object)("Opening image=" + imageName + ", pool=" + arg0.getPool() + ", mode=read-write"));
                    image = arg0.getRbd().open(imageName);
                    boolean canBeDeleted = true;
                    List snapChildren = null;
                    LOG.trace((Object)("Listing snapshots of image=" + imageName + ", pool=" + arg0.getPool()));
                    List snapList = image.snapList();
                    if (snapList != null && !snapList.isEmpty()) {
                        for (RbdSnapInfo snap : snapList) {
                            LOG.trace((Object)("Listing clones of snapshot=" + snap.name + ", image=" + imageName + ", pool=" + arg0.getPool()));
                            snapChildren = image.listChildren(snap.name);
                            if (snapChildren != null && !snapChildren.isEmpty()) {
                                LOG.trace((Object)("Found clones of snapshot=" + snap.name + ": " + snapChildren));
                                canBeDeleted = false;
                                break;
                            }
                            LOG.trace((Object)("No clones found for snapshot=" + snap.name));
                            if (image.snapIsProtected(snap.name)) {
                                LOG.trace((Object)("Unprotecting snapshot=" + snap.name + ", image=" + imageName + ", pool=" + arg0.getPool()));
                                image.snapUnprotect(snap.name);
                            }
                            LOG.debug((Object)("Removing snapshot=" + snap.name + ", image=" + imageName + ", pool=" + arg0.getPool()));
                            image.snapRemove(snap.name);
                        }
                    }
                    if (!canBeDeleted) {
                        LOG.debug((Object)("Cannot delete image " + imageName + " in pool " + poolName + " as it may be associated with other images by a parent-child relationship"));
                        throw new CannotDeleteCephImageException("Cannot delete image " + imageName + " in pool " + poolName + " as it may be associated with other images by a parent-child relationship");
                    }
                    arg0.getRbd().close(image);
                    image = null;
                    LOG.debug((Object)("Deleting image=" + imageName + ", pool=" + arg0.getPool()));
                    arg0.getRbd().remove(imageName);
                    String string = null;
                    return string;
                }
                catch (RbdException e) {
                    LOG.warn((Object)("Caught error while checking and or deleting image " + imageName + " in pool " + poolName + ": " + e.getMessage()));
                    throw new EucalyptusCephException("Caught error while checking and or deleting image " + imageName + " in pool " + poolName, (Throwable)e);
                }
                finally {
                    if (image != null) {
                        try {
                            LOG.trace((Object)("Closing image=" + imageName + ", pool=" + arg0.getPool()));
                            arg0.getRbd().close(image);
                        }
                        catch (Exception e) {
                            LOG.debug((Object)("Caught exception closing image " + imageName), (Throwable)e);
                        }
                    }
                }
            }
        }, poolName);
    }

    @Override
    public void renameImage(final String imageName, final String newImageName) {
        this.findAndExecuteRbdOp(new Function<CephRbdConnectionManager, String>(){

            public String apply(@Nonnull CephRbdConnectionManager arg0) {
                try {
                    LOG.debug((Object)("Renaming image=" + imageName + ", pool=" + arg0.getPool() + " to image=" + newImageName));
                    arg0.getRbd().rename(imageName, newImageName);
                    return null;
                }
                catch (RbdException e) {
                    LOG.warn((Object)("Caught error while renaming image " + imageName + ": " + e.getMessage()));
                    throw new EucalyptusCephException("Failed to delete image " + imageName, (Throwable)e);
                }
            }
        }, imageName);
    }

    @Override
    public String getImagePool(String imageName) {
        return this.findAndExecuteRbdOp(new Function<CephRbdConnectionManager, String>(){

            public String apply(@Nonnull CephRbdConnectionManager arg0) {
                return arg0.getPool();
            }
        }, imageName);
    }

    @Override
    public String createSnapshot(final String parentName, final String snapName) {
        return this.findAndExecuteRbdOp(new Function<CephRbdConnectionManager, String>(){

            public String apply(@Nonnull CephRbdConnectionManager arg0) {
                RbdImage image = null;
                try {
                    LOG.trace((Object)("Opening image=" + parentName + ", pool=" + arg0.getPool() + ", mode=read-write"));
                    image = arg0.getRbd().open(parentName);
                    LOG.debug((Object)("Creating snapshot=" + snapName + ", image=" + parentName + ", pool=" + arg0.getPool()));
                    image.snapCreate(snapName);
                    LOG.debug((Object)("Protecting snapshot=" + snapName + ", image=" + parentName + ", pool=" + arg0.getPool()));
                    image.snapProtect(snapName);
                    String string = arg0.getPool() + "/" + parentName + "@" + snapName;
                    return string;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Caught error while creating snapshot " + snapName + " on parent " + parentName + ": " + e.getMessage()));
                    throw new EucalyptusCephException("Failed to create snapshot " + snapName + " on parent " + parentName, (Throwable)e);
                }
                finally {
                    if (image != null) {
                        try {
                            LOG.trace((Object)("Closing image=" + parentName + ", pool=" + arg0.getPool()));
                            arg0.getRbd().close(image);
                        }
                        catch (Exception e) {
                            LOG.debug((Object)("Caught exception closing image " + parentName), (Throwable)e);
                        }
                    }
                }
            }
        }, parentName);
    }

    @Override
    public void deleteSnapshot(final String parentName, final String snapName) {
        this.findAndExecuteRbdOp(new Function<CephRbdConnectionManager, String>(){

            public String apply(@Nonnull CephRbdConnectionManager arg0) {
                RbdImage image = null;
                try {
                    LOG.trace((Object)("Opening image=" + parentName + ", pool=" + arg0.getPool() + ", mode=read-write"));
                    image = arg0.getRbd().open(parentName);
                    if (image.snapIsProtected(snapName)) {
                        LOG.debug((Object)("Unprotecting snapshot=" + snapName + ", image=" + parentName + ", pool=" + arg0.getPool()));
                        image.snapUnprotect(snapName);
                    }
                    LOG.debug((Object)("Removing snapshot=" + snapName + ", image=" + parentName + ", pool=" + arg0.getPool()));
                    image.snapRemove(snapName);
                    String string = null;
                    return string;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Caught error while deleting snapshot " + snapName + " on parent " + parentName + ": " + e.getMessage()));
                    throw new EucalyptusCephException("Failed to delete snapshot " + snapName + " on parent " + parentName, (Throwable)e);
                }
                finally {
                    if (image != null) {
                        try {
                            LOG.trace((Object)("Closing image=" + parentName + ", pool=" + arg0.getPool()));
                            arg0.getRbd().close(image);
                        }
                        catch (Exception e) {
                            LOG.debug((Object)("Caught exception closing image " + parentName), (Throwable)e);
                        }
                    }
                }
            }
        }, parentName);
    }

    @Override
    public String cloneAndResizeImage(final String parentName, final String snapName, final String cloneName, final Long size) {
        return this.findAndExecuteRbdOp(new Function<CephRbdConnectionManager, String>(){

            public String apply(final CephRbdConnectionManager parentConn) {
                RbdImage source = null;
                try {
                    LOG.trace((Object)("Opening image=" + parentName + ", pool=" + parentConn.getPool() + ", mode=read-write"));
                    source = parentConn.getRbd().open(parentName);
                    try {
                        if (source.snapIsProtected(snapName)) {
                            LOG.debug((Object)("Snapshot=" + snapName + ", image=" + parentName + ", pool=" + parentConn.getPool() + " is protected"));
                        } else {
                            LOG.debug((Object)("Protecting snapshot=" + snapName + ", image=" + parentName + ", pool=" + parentConn.getPool()));
                            source.snapProtect(snapName);
                        }
                    }
                    catch (Exception e) {
                        throw new EucalyptusCephException("Failed to protect snapshot " + snapName + " on parent " + parentName);
                    }
                    String e = (String)CephRbdFormatTwoAdapter.this.executeRbdOpInRandomPool((Function)new Function<CephRbdConnectionManager, String>(){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public String apply(CephRbdConnectionManager cloneConn) {
                            String string;
                            RbdImage clone = null;
                            try {
                                int features = 1;
                                LOG.debug((Object)("Cloning snapshot=" + snapName + ", image=" + parentName + ", pool=" + parentConn.getPool() + " to image=" + cloneName + ", pool=" + cloneConn.getPool()));
                                parentConn.getRbd().clone(parentName, snapName, cloneConn.getIoContext(), cloneName, (long)features, 0);
                                LOG.trace((Object)("Opening image=" + cloneName + ", pool=" + cloneConn.getPool() + ", mode=read-write"));
                                clone = cloneConn.getRbd().open(cloneName);
                                if (size != null) {
                                    LOG.debug((Object)("Resizing image=" + cloneName + ", pool=" + cloneConn.getPool() + " to " + size + " bytes"));
                                    clone.resize(size.longValue());
                                }
                                if (cloneName.contains("snap-")) {
                                    String spOnSnapshot = "sp-on-" + cloneName;
                                    LOG.debug((Object)("Creating snapshot=" + spOnSnapshot + ", image=" + cloneName + ", pool=" + cloneConn.getPool()));
                                    clone.snapCreate(spOnSnapshot);
                                    LOG.debug((Object)("Protecting snapshot=" + spOnSnapshot + ", image=" + cloneName + ", pool=" + cloneConn.getPool()));
                                    clone.snapProtect(spOnSnapshot);
                                }
                                string = cloneConn.getPool() + "/" + cloneName;
                                if (clone == null) return string;
                            }
                            catch (RbdException e) {
                                try {
                                    LOG.warn((Object)("Caught error while cloning/resizing image " + cloneName + " from source image " + parentName + ": " + e.getMessage()));
                                    throw new EucalyptusCephException("Failed to clone/resize image " + cloneName + " from source image " + parentName, (Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    if (clone == null) throw throwable;
                                    try {
                                        LOG.trace((Object)("Closing image=" + cloneName + ", pool=" + cloneConn.getPool()));
                                        cloneConn.getRbd().close(clone);
                                        throw throwable;
                                    }
                                    catch (Exception e2) {
                                        LOG.debug((Object)("Caught exception closing image " + cloneName), (Throwable)e2);
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                LOG.trace((Object)("Closing image=" + cloneName + ", pool=" + cloneConn.getPool()));
                                cloneConn.getRbd().close(clone);
                                return string;
                            }
                            catch (Exception e) {
                                LOG.debug((Object)("Caught exception closing image " + cloneName), (Throwable)e);
                            }
                            return string;
                        }
                    }, cloneName);
                    return e;
                }
                catch (EucalyptusCephException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Caught error while cloning/resizing image " + cloneName + " from source image " + parentName + ": " + e.getMessage()));
                    throw new EucalyptusCephException("Failed to clone/resize image " + cloneName + " from source image " + parentName, (Throwable)e);
                }
                finally {
                    if (source != null) {
                        try {
                            LOG.trace((Object)("Opening image=" + parentName + ", pool=" + parentConn.getPool()));
                            parentConn.getRbd().close(source);
                        }
                        catch (Exception e) {
                            LOG.debug((Object)("Caught exception closing image " + parentName), (Throwable)e);
                        }
                    }
                }
            }
        }, parentName);
    }

    @Override
    public List<String> listPool(final String poolName) {
        return this.executeRbdOpInPool(new Function<CephRbdConnectionManager, List<String>>(){

            public List<String> apply(CephRbdConnectionManager arg0) {
                try {
                    LOG.trace((Object)("Listing images in pool=" + poolName));
                    return Arrays.asList(arg0.getRbd().list());
                }
                catch (RbdException e) {
                    LOG.warn((Object)("Caught error while listing images in pool " + poolName + ": " + e.getMessage()));
                    throw new EucalyptusCephException("Failed to list images in pool " + poolName, (Throwable)e);
                }
            }
        }, poolName);
    }

    private <T> T executeRbdOpInPool(Function<CephRbdConnectionManager, T> function, String poolName) {
        Object output = null;
        CephRbdConnectionManager conn = null;
        try {
            conn = CephRbdConnectionManager.getConnection((CephRbdInfo)this.config, (String)poolName);
            output = function.apply((Object)conn);
        }
        catch (EucalyptusCephException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EucalyptusCephException("Caught error during ceph operation" + e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return (T)output;
    }

    private <T> T executeRbdOpInRandomPool(Function<CephRbdConnectionManager, T> function, String imageName) {
        Object output = null;
        CephRbdConnectionManager conn = null;
        try {
            conn = imageName.contains("vol-") ? CephRbdConnectionManager.getRandomVolumePoolConnection((CephRbdInfo)this.config) : CephRbdConnectionManager.getRandomSnapshotPoolConnection((CephRbdInfo)this.config);
            output = function.apply((Object)conn);
        }
        catch (EucalyptusCephException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EucalyptusCephException("Caught error during ceph operation" + e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return (T)output;
    }

    private <T> T findAndExecuteRbdOp(Function<CephRbdConnectionManager, T> function, String imageName) {
        Object output = null;
        CephRbdConnectionManager conn = null;
        try {
            Object[] allPools = null;
            allPools = imageName.contains("vol-") ? CephRbdConnectionManager.getAllVolumePools((CephRbdInfo)this.config) : CephRbdConnectionManager.getAllSnapshotPools((CephRbdInfo)this.config);
            for (int i = 0; i < allPools.length; ++i) {
                conn = CephRbdConnectionManager.getConnection((CephRbdInfo)this.config, (String)allPools[i]);
                try {
                    LOG.debug((Object)("Searching for image=" + imageName + ", pool=" + (String)allPools[i]));
                    RbdImage image = conn.getRbd().openReadOnly(imageName);
                    conn.getRbd().close(image);
                    break;
                }
                catch (Exception e) {
                    LOG.trace((Object)("Image=" + imageName + " not found in pool=" + (String)allPools[i] + ". Reason: " + e.getMessage()));
                    conn.disconnect();
                    conn = null;
                    continue;
                }
            }
            if (conn == null) {
                throw new CephImageNotFoundException("Unable to find image " + imageName + " in configured pools: " + Arrays.toString(allPools));
            }
            output = function.apply(conn);
        }
        catch (EucalyptusCephException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EucalyptusCephException("Caught error during ceph operation" + e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return (T)output;
    }
}

