/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.util.EucalyptusCloudException;
import java.util.List;
import org.apache.log4j.Logger;

public class VolumeStateChecker
extends CheckerTask {
    private static Logger LOG = Logger.getLogger(VolumeStateChecker.class);
    LogicalStorageManager blockManager;

    public VolumeStateChecker(LogicalStorageManager blockManager) {
        this.name = "VolumeStatusChecker";
        this.blockManager = blockManager;
    }

    public void run() {
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo volumeInfo = new VolumeInfo();
            volumeInfo.setStatus(StorageProperties.Status.available.toString());
            List volumes = Entities.query((Object)volumeInfo);
            for (VolumeInfo volume : volumes) {
                try {
                    this.blockManager.checkVolume(volume.getVolumeId());
                }
                catch (EucalyptusCloudException ex) {
                    LOG.error((Object)ex);
                }
            }
            tran.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }
}

