/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.Faults;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TGTWrapper {
    private static final String TGTADM = "tgtadm";
    public static final String TGT_SERVICE_NAME = "tgtd";
    private static final Logger LOG = Logger.getLogger(TGTWrapper.class);
    private static final String ROOT_WRAP = StorageProperties.EUCA_ROOT_WRAPPER;
    private static final ReadWriteLock serviceLock = new ReentrantReadWriteLock();
    private static ExecutorService service;
    private static final int RESOURCE_NOT_FOUND = 22;
    private static final int TGT_HOSED = 2000;
    private static final int TGT_CORRUPTED = 2002;
    private static final Joiner JOINER;
    private static final Splitter LINE_SPLITTER;
    private static final Pattern LUN_PATTERN;
    private static final Pattern TARGET_PATTERN;
    private static final Pattern RESOURCE_PATTERN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        serviceLock.writeLock().lock();
        try {
            if (service == null) {
                service = Executors.newFixedThreadPool(10);
            }
        }
        finally {
            serviceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        serviceLock.writeLock().lock();
        try {
            ExecutorService toShutdown = service;
            service = null;
            toShutdown.shutdownNow();
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to shutdown thread pool", (Throwable)e);
        }
        finally {
            serviceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutor() {
        serviceLock.readLock().lock();
        try {
            if (service == null) {
                throw new IllegalStateException("Not started");
            }
            ExecutorService executorService = service;
            return executorService;
        }
        finally {
            serviceLock.readLock().unlock();
        }
    }

    private static ExecutorService getExecutorWithInit() {
        ExecutorService service;
        try {
            service = TGTWrapper.getExecutor();
        }
        catch (IllegalStateException e) {
            TGTWrapper.start();
            service = TGTWrapper.getExecutor();
        }
        return service;
    }

    private static SystemUtil.CommandOutput execute(@Nonnull String[] command, @Nonnull Long timeout) throws EucalyptusCloudException, CallTimeoutException {
        try {
            Integer returnValue = -999999;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            StreamConsumer error = new StreamConsumer(process.getErrorStream());
            StreamConsumer output = new StreamConsumer(process.getInputStream());
            error.start();
            output.start();
            ProcessMonitor processMonitor = new ProcessMonitor(process);
            Future<Integer> processController = TGTWrapper.getExecutorWithInit().submit(processMonitor);
            try {
                returnValue = processController.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException tex) {
                String commandStr = TGTWrapper.buildCommand(command);
                LOG.error((Object)(commandStr + " timed out. Cancelling the process, logging a fault and exceptioning out"));
                processController.cancel(true);
                Faults.forComponent(Storage.class).havingId(2000).withVar("component", "Storage Controller").withVar("timeout", Long.toString(timeout)).log();
                throw new CallTimeoutException("No response from the command " + commandStr + ". Process timed out after waiting for " + timeout + " milliseconds");
            }
            output.join();
            error.join();
            LOG.debug((Object)("TGTWrapper executed: " + JOINER.join((Object[])command) + "\n return=" + returnValue + "\n stdout=" + output.getReturnValue() + "\n stderr=" + error.getReturnValue()));
            return new SystemUtil.CommandOutput(returnValue.intValue(), output.getReturnValue(), error.getReturnValue());
        }
        catch (CallTimeoutException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException((Throwable)ex);
        }
    }

    private static SystemUtil.CommandOutput executeTGT(@Nonnull String[] command, @Nonnull Long timeout) throws OperationFailedException, CallTimeoutException, ResourceNotFoundException {
        SystemUtil.CommandOutput output = null;
        try {
            output = TGTWrapper.execute(command, timeout);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (CallTimeoutException e) {
            throw e;
        }
        catch (EucalyptusCloudException e) {
            throw new OperationFailedException(e);
        }
        if (output.returnValue == 22) {
            if (output.error.contains("target")) {
                throw new ResourceNotFoundException("target");
            }
            if (output.error.contains("account")) {
                throw new ResourceNotFoundException("account");
            }
            if (output.error.contains("logicalunit")) {
                throw new ResourceNotFoundException("logicalunit");
            }
            throw new ResourceNotFoundException();
        }
        return output;
    }

    private static String buildCommand(@Nonnull String[] command) {
        StringBuilder builder = new StringBuilder();
        for (String part : command) {
            builder.append(part).append(' ');
        }
        return builder.toString();
    }

    public static void precheckService(Long timeout) throws EucalyptusCloudException {
        SystemUtil.CommandOutput output = null;
        output = TGTWrapper.execute(new String[]{ROOT_WRAP, TGTADM, "--help"}, timeout);
        if (output.returnValue != 0 || StringUtils.isNotBlank((String)output.error)) {
            Faults.forComponent(Storage.class).havingId(2002).withVar("component", "Storage Controller").withVar("operation", "tgtadm --help").withVar("error", output.error).log();
            throw new EucalyptusCloudException("tgtadm not found: Is tgt installed?");
        }
        output = TGTWrapper.execute(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--mode", "target", "--op", "show"}, timeout);
        if (output.returnValue != 0 || StringUtils.isNotBlank((String)output.error)) {
            LOG.warn((Object)"Unable to connect to tgt daemon. Is tgtd loaded?");
            LOG.info((Object)"Attempting to start tgtd ISCSI daemon");
            output = TGTWrapper.execute(new String[]{ROOT_WRAP, "service", TGT_SERVICE_NAME, "status"}, timeout);
            if (output.returnValue != 0 || StringUtils.isNotBlank((String)output.error)) {
                output = TGTWrapper.execute(new String[]{ROOT_WRAP, "service", TGT_SERVICE_NAME, "start"}, timeout);
                if (output.returnValue != 0 || StringUtils.isNotBlank((String)output.error)) {
                    Faults.forComponent(Storage.class).havingId(2002).withVar("component", "Storage Controller").withVar("operation", "service tgt start").withVar("error", output.error).log();
                    throw new EucalyptusCloudException("Unable to start tgt daemon. Cannot proceed.");
                }
            } else {
                output = TGTWrapper.execute(new String[]{ROOT_WRAP, "service", "tgt", "start"}, timeout);
                if (output.returnValue != 0 || StringUtils.isNotBlank((String)output.error)) {
                    Faults.forComponent(Storage.class).havingId(2002).withVar("component", "Storage Controller").withVar("operation", "service tgt start").withVar("error", output.error).log();
                    throw new EucalyptusCloudException("Unable to start tgt daemon. Cannot proceed.");
                }
            }
        }
    }

    public static void checkService(Long timeout) throws EucalyptusCloudException {
        try {
            SystemUtil.CommandOutput output = TGTWrapper.execute(new String[]{ROOT_WRAP, "service", TGT_SERVICE_NAME, "status"}, timeout);
            if (StringUtils.isNotBlank((String)output.error)) {
                Faults.forComponent(Storage.class).havingId(2002).withVar("component", "Storage Controller").withVar("operation", "service tgt status").withVar("error", output.error).log();
                throw new EucalyptusCloudException("tgt service check failed with error: " + output.error);
            }
        }
        catch (CallTimeoutException e) {
            LOG.error((Object)"Call timed out checking service.", (Throwable)((Object)e));
            throw e;
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)"Check service failed", (Throwable)e);
            throw e;
        }
    }

    public static void createTarget(@Nonnull String volumeId, int tid, @Nonnull String name, @Nonnull Long timeout) throws CallTimeoutException, OperationFailedException, ResourceNotFoundException {
        SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "new", "--mode", "target", "--tid", String.valueOf(tid), "-T", name}, timeout);
        if (output.failed() || StringUtils.isNotBlank((String)output.error)) {
            throw new OperationFailedException(output.output, output.error, output.returnValue);
        }
    }

    public static void deleteTarget(@Nonnull String volumeId, int tid, @Nonnull Long timeout, boolean force) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        LOG.debug((Object)("Tearing down target " + tid + " for volume " + volumeId));
        SystemUtil.CommandOutput output = null;
        output = force ? TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "delete", "--mode", "target", "--tid", String.valueOf(tid), "--force"}, timeout) : TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "delete", "--mode", "target", "--tid", String.valueOf(tid)}, timeout);
        if (output.failed() || StringUtils.isNotBlank((String)output.error)) {
            throw new OperationFailedException(output.output, output.error, output.returnValue);
        }
    }

    public static void createLun(@Nonnull String volumeId, int tid, int lun, @Nonnull String resourcePath, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "new", "--mode", "logicalunit", "--tid", String.valueOf(tid), "--lun", String.valueOf(lun), "-b", resourcePath}, timeout);
        if (output.failed() || StringUtils.isNotBlank((String)output.error)) {
            if (output.returnValue == 22) {
                throw new ResourceNotFoundException(String.valueOf(tid));
            }
            throw new OperationFailedException("Create lun operation failed");
        }
    }

    public static void deleteLun(@Nonnull String volumeId, int tid, int lun, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        LOG.debug((Object)("Removing LUN " + lun + " from target " + tid + " for volume " + volumeId));
        SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "delete", "--mode", "logicalunit", "--tid", String.valueOf(tid), "--lun", String.valueOf(lun)}, timeout);
        if (output.failed() || StringUtils.isNotBlank((String)output.error)) {
            if (output.returnValue == 22 && output.error.contains("can't find the logical unit")) {
                LOG.debug((Object)("Volume: " + volumeId + " logical unit already removed."));
            }
            throw new OperationFailedException("Delete lun operation failed");
        }
    }

    public static void bindUser(@Nonnull String volumeId, @Nonnull String user, int tid, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "bind", "--mode", "account", "--tid", String.valueOf(tid), "--user", user}, timeout);
        if (output.failed() || StringUtils.isNotBlank((String)output.error)) {
            if (output.returnValue == 22 && output.error.contains("account")) {
                throw new ResourceNotFoundException(user);
            }
            if (output.returnValue == 22 && output.error.contains("target")) {
                throw new ResourceNotFoundException("Target " + String.valueOf(tid));
            }
            throw new OperationFailedException("Bind user operation failed");
        }
    }

    public static void bindTarget(@Nonnull String volumeId, int tid, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        try {
            SystemUtil.CommandOutput commandOutput = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "bind", "--mode", "target", "--tid", String.valueOf(tid), "-I", "ALL"}, timeout);
        }
        catch (EucalyptusCloudException eucalyptusCloudException) {
            // empty catch block
        }
    }

    public static void unbindTarget(String volumeId, int tid, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        LOG.debug((Object)("Unbinding target " + tid + " for volume " + volumeId));
        SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "unbind", "--mode", "target", "--tid", String.valueOf(tid), "-I", "ALL"}, timeout);
        if (output.failed() || StringUtils.isNotBlank((String)output.error)) {
            if (output.returnValue == 22 && output.error.contains("can't find the target")) {
                LOG.debug((Object)("Volume: " + volumeId + " target not found, cannot unbind, returning unbind success."));
                throw new ResourceNotFoundException("target " + tid);
            }
            LOG.error((Object)("Volume: " + volumeId + " Unable to unbind tid: " + tid));
            throw new OperationFailedException(output.output, output.error, output.returnValue);
        }
    }

    public static boolean targetExists(@Nonnull String volumeId, int tid, String resource, @Nonnull Long timeout) throws EucalyptusCloudException {
        try {
            SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "show", "--mode", "target", "--tid", String.valueOf(tid)}, timeout);
            if (StringUtils.isBlank((String)output.error)) {
                if (resource != null) {
                    output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "show", "--mode", "target"}, timeout);
                    return TGTWrapper.hasResource(output.output, tid, resource);
                }
                LOG.debug((Object)("Volume " + volumeId + " check for target " + tid + " returning true. Target exists"));
                return true;
            }
            LOG.debug((Object)("Volume: " + volumeId + " Target: " + tid + " not found"));
        }
        catch (ResourceNotFoundException output) {
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)("Caught unexpected exception checking for target existence for volume " + volumeId), (Throwable)e);
            throw e;
        }
        return false;
    }

    public static boolean targetHasLun(@Nonnull String volumeId, int tid, int lun, @Nonnull Long timeout) throws EucalyptusCloudException {
        try {
            SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "show", "--mode", "target", "--tid", String.valueOf(tid)}, timeout);
            output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "show", "--mode", "target"}, timeout);
            return TGTWrapper.hasLun(output.output, tid, lun);
        }
        catch (ResourceNotFoundException output) {
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)("Caught unexpected exception checking for target existence for volume " + volumeId), (Throwable)e);
            throw e;
        }
        return false;
    }

    private static boolean hasResource(@Nonnull String output, int tid, @Nonnull String resource) {
        Matcher targetMatcher = null;
        Matcher resourceMatcher = null;
        String target = null;
        for (String line : LINE_SPLITTER.split((CharSequence)output)) {
            targetMatcher = TARGET_PATTERN.matcher(line);
            if (targetMatcher.matches()) {
                target = targetMatcher.group(1);
                if (Integer.parseInt(targetMatcher.group(1)) == tid) continue;
                target = null;
                continue;
            }
            if (target == null || !(resourceMatcher = RESOURCE_PATTERN.matcher(line)).matches() || !resourceMatcher.group(1).equals(resource)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLun(@Nonnull String output, int tid, int lun) {
        Matcher targetMatcher = null;
        Matcher lunMatcher = null;
        String target = null;
        for (String line : LINE_SPLITTER.split((CharSequence)output)) {
            targetMatcher = TARGET_PATTERN.matcher(line);
            if (targetMatcher.matches()) {
                target = targetMatcher.group(1);
                if (Integer.parseInt(targetMatcher.group(1)) == tid) continue;
                target = null;
                continue;
            }
            if (target == null || !(lunMatcher = LUN_PATTERN.matcher(line)).matches() || !lunMatcher.group(1).equals(String.valueOf(lun))) continue;
            return true;
        }
        return false;
    }

    public static void addUser(@Nonnull String username, @Nonnull String password, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "new", "--mode", "account", "--user", username, "--password", password}, timeout);
    }

    public static void deleteUser(@Nonnull String username, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--lld", "iscsi", "--op", "delete", "--mode", "account", "--user", username}, timeout);
    }

    public static boolean userExists(@Nonnull String username, @Nonnull Long timeout) throws OperationFailedException, ResourceNotFoundException, CallTimeoutException {
        SystemUtil.CommandOutput output = TGTWrapper.executeTGT(new String[]{ROOT_WRAP, TGTADM, "--op", "show", "--mode", "account"}, timeout);
        String returnValue = output.output;
        if (returnValue.length() > 0) {
            Pattern p = Pattern.compile(username);
            Matcher m = p.matcher(returnValue);
            return m.find();
        }
        return false;
    }

    static {
        JOINER = Joiner.on((String)" ").skipNulls();
        LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings().trimResults();
        LUN_PATTERN = Pattern.compile("\\s*LUN:\\s*(\\d+)\\s*");
        TARGET_PATTERN = Pattern.compile("\\s*Target\\s*(\\d+):\\s+(\\S+)\\s*");
        RESOURCE_PATTERN = Pattern.compile("\\s*Backing store path:\\s*(\\S+)\\s*");
    }

    public static class ProcessMonitor
    implements Callable<Integer> {
        private Process process;

        ProcessMonitor(Process process) {
            this.process = process;
        }

        @Override
        public Integer call() throws Exception {
            this.process.waitFor();
            return this.process.exitValue();
        }
    }

    public static class CallTimeoutException
    extends EucalyptusCloudException {
        private static final long serialVersionUID = 1L;

        public CallTimeoutException() {
            super("Call timed out");
        }

        public CallTimeoutException(String command) {
            super("Call timed for " + command);
        }
    }

    public static class OperationFailedException
    extends EucalyptusCloudException {
        private static final Long serialVersionUID = 1L;
        private int errorCode = -1;
        private String outputContent = null;
        private String errorContent = null;

        public OperationFailedException() {
            super("TGT operation failed");
        }

        public OperationFailedException(String message) {
            super("TGT operation failed: " + message);
        }

        public OperationFailedException(String operation, String message) {
            super("TGT operation " + operation + " failed: " + message);
        }

        public OperationFailedException(String output, String errorOutput, int errorCode) {
            super("TGT operation failed");
            this.outputContent = output;
            this.errorCode = errorCode;
            this.errorContent = errorOutput;
        }

        public OperationFailedException(EucalyptusCloudException e) {
            super((Throwable)e);
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public String getOutputContent() {
            return this.outputContent;
        }

        public void setOutput(String output) {
            this.outputContent = output;
        }

        public String getErrorContent() {
            return this.errorContent;
        }

        public void setErrorContent(String errorOutput) {
            this.errorContent = errorOutput;
        }
    }

    public static class ResourceNotFoundException
    extends EucalyptusCloudException {
        private static final Long serialVersionUID = 1L;

        public ResourceNotFoundException() {
            super("Resource not found");
        }

        public ResourceNotFoundException(String resource) {
            super("Resource " + resource + " not found");
        }
    }
}

