/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class StorageManagers
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(StorageManagers.class);
    private static final String UNSET = "unset";
    private static final Map<String, Class> managers = Maps.newHashMap();
    private static final Map<String, Class> providers = Maps.newHashMap();
    public static final Predicate<String> SUPPORTED_PROVIDER_PREDICATE = new Predicate<String>(){

        public boolean apply(String arg0) {
            return !arg0.startsWith("(") || !arg0.endsWith(")");
        }
    };
    private static final LoadingCache<String, LogicalStorageManager> managerInstances = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, LogicalStorageManager>(){

        public LogicalStorageManager load(String arg0) {
            LogicalStorageManager bsm = (LogicalStorageManager)Classes.newInstance(StorageManagers.lookupManager(arg0), (Object[])new Object[0]);
            try {
                bsm.checkPreconditions();
                return bsm;
            }
            catch (EucalyptusCloudException ex) {
                throw new ComputationException((Throwable)ex);
            }
        }
    });
    private static AtomicReference<String> lastManager = new AtomicReference();

    public boolean processClass(Class candidate) throws Exception {
        if (Ats.from((Object)candidate).has(StorageManagerProperty.class) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isInterface(candidate.getModifiers())) {
            StorageManagerProperty candidateType = (StorageManagerProperty)Ats.from((Object)candidate).get(StorageManagerProperty.class);
            String propName = candidateType.value();
            if (LogicalStorageManager.class.isAssignableFrom(candidate)) {
                managers.put(propName, candidate);
            } else {
                managers.put(propName, candidateType.manager());
                providers.put(propName, candidate);
            }
            return true;
        }
        return false;
    }

    public Double getPriority() {
        return 0.0;
    }

    public static LogicalStorageManager getInstance() {
        if (lastManager.get() == null || UNSET.equals(lastManager.get())) {
            throw new NoSuchElementException("SC blockstorageamanger not configured. Found empty or unset manager(" + lastManager + ").  Legal values are: " + Joiner.on((String)",").join(Maps.filterKeys(managers, SUPPORTED_PROVIDER_PREDICATE).keySet()));
        }
        return (LogicalStorageManager)managerInstances.getUnchecked((Object)lastManager.get());
    }

    public static LogicalStorageManager getInstance(String propertyBackend) throws InstantiationException, IllegalAccessException, EucalyptusCloudException {
        if (managers.containsKey(propertyBackend)) {
            lastManager.set(propertyBackend);
        }
        return StorageManagers.getInstance();
    }

    public static Set<String> list() {
        return managers.keySet();
    }

    public static boolean contains(Object key) {
        return managers.containsKey(key);
    }

    public static synchronized void flushManagerInstances() throws EucalyptusCloudException {
        LOG.debug((Object)"Flushing all block storage manager instances");
        managerInstances.invalidateAll();
        lastManager.set(UNSET);
    }

    public static synchronized void flushManagerInstance(String key) throws EucalyptusCloudException {
        LOG.debug((Object)("Flusing block storage manager instance: " + key));
        lastManager.set(UNSET);
        managerInstances.invalidate((Object)key);
    }

    public static Class<? extends LogicalStorageManager> lookupManager(String arg0) {
        if (!managers.containsKey(arg0)) {
            throw new NoSuchElementException("Not a valid value:  " + arg0 + ".  Legal values are: " + Joiner.on((String)",").join(Maps.filterKeys(managers, SUPPORTED_PROVIDER_PREDICATE).keySet()));
        }
        return managers.get(arg0);
    }

    public static Class lookupProvider(String arg0) {
        if (!providers.containsKey(arg0)) {
            throw new NoSuchElementException("Not a valid value:  " + arg0 + ".  Legal values are: " + Joiner.on((String)",").join(Maps.filterKeys(providers, SUPPORTED_PROVIDER_PREDICATE).keySet()));
        }
        return providers.get(arg0);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StorageManagerProperty {
        public String value();

        public Class<? extends LogicalStorageManager> manager() default LogicalStorageManager.class;
    }
}

