/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageManagerTestingProxy
implements LogicalStorageManager,
GroovyObject {
    private LogicalStorageManager delegateStorageManager;
    protected static int fakeDeviceCapacity;
    protected static volatile int capacityUsed;
    protected static final ConcurrentMap<String, Integer> sizeMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166443773;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public StorageManagerTestingProxy(LogicalStorageManager logicalStorageManager) {
        void manager;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var3_3 = manager;
        this.delegateStorageManager = var3_3;
    }

    protected static void check(String name, int size) throws EucalyptusCloudException {
        if (fakeDeviceCapacity > 0) {
            StorageManagerTestingProxy.addVolumeUsage(name, size);
            if (capacityUsed > fakeDeviceCapacity) {
                throw (Throwable)new EucalyptusCloudException("FakedInsufficientCapacity");
            }
        }
    }

    protected static void addVolumeUsage(String name, int size) {
        capacityUsed = capacityUsed + size;
        sizeMap.put(name, size);
    }

    protected static void removeVolumeUsage(String name) {
        capacityUsed = DefaultTypeTransformation.intUnbox((Object)NumberNumberMinus.minus((Number)capacityUsed, (Number)(sizeMap.get(name) == null ? Integer.valueOf(0) : (Integer)ScriptBytecodeAdapter.castToType(sizeMap.get(name), Integer.class))));
    }

    @Override
    public int createVolume(String volume, String snapshot, int size) throws EucalyptusCloudException {
        StorageManagerTestingProxy.check(volume, size);
        int n = this.delegateStorageManager.createVolume(volume, snapshot, size);
        try {
            return n;
        }
        catch (Throwable f) {
            StorageManagerTestingProxy.removeVolumeUsage(volume);
            throw f;
        }
    }

    @Override
    public void cloneVolume(String volumeId, String parentVolumeId) throws EucalyptusCloudException {
        this.delegateStorageManager.cloneVolume(volumeId, parentVolumeId);
    }

    @Override
    public void addSnapshot(String snapshotId) throws EucalyptusCloudException {
        this.delegateStorageManager.addSnapshot(snapshotId);
    }

    @Override
    public void deleteVolume(String volume) throws EucalyptusCloudException {
        this.delegateStorageManager.deleteVolume(volume);
        StorageManagerTestingProxy.removeVolumeUsage(volume);
    }

    @Override
    public void deleteSnapshot(String snapshotId) throws EucalyptusCloudException {
        StorageManagerTestingProxy.removeVolumeUsage(snapshotId);
        this.delegateStorageManager.deleteSnapshot(snapshotId);
    }

    @Override
    public String getVolumeConnectionString(String volumeId) throws EucalyptusCloudException {
        return this.delegateStorageManager.getVolumeConnectionString(volumeId);
    }

    @Override
    public void loadSnapshots(List<String> snapshotSet, List<String> snapshotFileNames) throws EucalyptusCloudException {
        this.delegateStorageManager.loadSnapshots(snapshotSet, snapshotFileNames);
    }

    @Override
    public int getSnapshotSize(String snapshotId) throws EucalyptusCloudException {
        return this.delegateStorageManager.getSnapshotSize(snapshotId);
    }

    @Override
    public void finishVolume(String snapshotId) throws EucalyptusCloudException {
        this.delegateStorageManager.finishVolume(snapshotId);
    }

    @Override
    public StorageResource prepareSnapshot(String snapshotId, int sizeExpected, long actualSizeInMB) throws EucalyptusCloudException {
        return this.delegateStorageManager.prepareSnapshot(snapshotId, sizeExpected, actualSizeInMB);
    }

    @Override
    public ArrayList<ComponentProperty> getStorageProps() {
        return this.delegateStorageManager.getStorageProps();
    }

    @Override
    public void setStorageProps(ArrayList<ComponentProperty> storageParams) {
        this.delegateStorageManager.setStorageProps(storageParams);
    }

    @Override
    public String getStorageRootDirectory() {
        return this.delegateStorageManager.getStorageRootDirectory();
    }

    @Override
    public String getVolumePath(String volumeId) throws EucalyptusCloudException {
        return this.delegateStorageManager.getVolumePath(volumeId);
    }

    @Override
    public void importVolume(String volumeId, String volumePath, int size) throws EucalyptusCloudException {
        this.delegateStorageManager.importVolume(volumeId, volumePath, size);
    }

    @Override
    public String getSnapshotPath(String snapshotId) throws EucalyptusCloudException {
        return this.delegateStorageManager.getSnapshotPath(snapshotId);
    }

    @Override
    public void importSnapshot(String snapshotId, String snapPath, String volumeId, int size) throws EucalyptusCloudException {
        this.delegateStorageManager.importSnapshot(snapshotId, snapPath, volumeId, size);
    }

    @Override
    public String exportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException {
        return this.delegateStorageManager.exportVolume(volumeId, nodeIqn);
    }

    @Override
    public void unexportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException, UnsupportedOperationException {
        this.delegateStorageManager.unexportVolume(volumeId, nodeIqn);
    }

    @Override
    public void unexportVolumeFromAll(String volumeId) throws EucalyptusCloudException {
        this.delegateStorageManager.unexportVolumeFromAll(volumeId);
    }

    @Override
    public String createSnapshotPoint(String parentVolumeId, String volumeId) throws EucalyptusCloudException {
        return this.delegateStorageManager.createSnapshotPoint(parentVolumeId, volumeId);
    }

    @Override
    public void deleteSnapshotPoint(String parentVolumeId, String volumeId, String snapshotPointId) throws EucalyptusCloudException {
        this.delegateStorageManager.deleteSnapshotPoint(parentVolumeId, volumeId, snapshotPointId);
    }

    @Override
    public void checkReady() throws EucalyptusCloudException {
        this.delegateStorageManager.checkReady();
    }

    @Override
    public void stop() throws EucalyptusCloudException {
        this.delegateStorageManager.stop();
    }

    @Override
    public void enable() throws EucalyptusCloudException {
        this.delegateStorageManager.enable();
    }

    @Override
    public void disable() throws EucalyptusCloudException {
        this.delegateStorageManager.disable();
    }

    @Override
    public boolean getFromBackend(String snapshotId, int size) throws EucalyptusCloudException {
        return this.delegateStorageManager.getFromBackend(snapshotId, size);
    }

    @Override
    public void checkVolume(String volumeId) throws EucalyptusCloudException {
        this.delegateStorageManager.checkVolume(volumeId);
    }

    @Override
    public List<CheckerTask> getCheckers() {
        return this.delegateStorageManager.getCheckers();
    }

    @Override
    public void createVolume(String volume, int size) throws EucalyptusCloudException {
        try {
            StorageManagerTestingProxy.check(volume, size);
            this.delegateStorageManager.createVolume(volume, size);
        }
        catch (Throwable f) {
            StorageManagerTestingProxy.removeVolumeUsage(volume);
            throw f;
        }
    }

    @Override
    public void initialize() throws EucalyptusCloudException {
        int n;
        int n2;
        fakeDeviceCapacity = n2 = -1;
        capacityUsed = n = 0;
        sizeMap.clear();
        this.delegateStorageManager.initialize();
    }

    @Override
    public void configure() throws EucalyptusCloudException {
        this.delegateStorageManager.configure();
    }

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        this.delegateStorageManager.checkPreconditions();
    }

    @Override
    public void reload() {
        this.delegateStorageManager.reload();
    }

    @Override
    public void startupChecks() throws EucalyptusCloudException {
        this.delegateStorageManager.startupChecks();
    }

    @Override
    public void cleanVolume(String volumeId) {
        StorageManagerTestingProxy.removeVolumeUsage(volumeId);
        this.delegateStorageManager.cleanVolume(volumeId);
    }

    @Override
    public void cleanSnapshot(String snapshotId) {
        StorageManagerTestingProxy.removeVolumeUsage(snapshotId);
        this.delegateStorageManager.cleanSnapshot(snapshotId);
    }

    @Override
    public StorageResource createSnapshot(String volumeId, String snapshotId, String snapshotPointId, Boolean shouldTransferSnapshots) throws EucalyptusCloudException {
        StorageManagerTestingProxy.check(snapshotId, DefaultTypeTransformation.intUnbox(sizeMap.get(volumeId)));
        StorageResource storageResource = this.delegateStorageManager.createSnapshot(volumeId, snapshotId, snapshotPointId, shouldTransferSnapshots);
        try {
            return storageResource;
        }
        catch (Throwable f) {
            StorageManagerTestingProxy.removeVolumeUsage(volumeId);
            throw f;
        }
    }

    @Override
    public List<String> prepareForTransfer(String snapshotId) throws EucalyptusCloudException {
        return this.delegateStorageManager.prepareForTransfer(snapshotId);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StorageManagerTestingProxy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StorageManagerTestingProxy.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, StorageManagerTestingProxy.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(StorageManagerTestingProxy.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        ConcurrentMap concurrentMap;
        int n;
        int n2;
        long l;
        long l2;
        StorageManagerTestingProxy.__$swapInit();
        __timeStamp__239_neverHappen1453166443773 = l2 = 0L;
        __timeStamp = l = 1453166443773L;
        capacityUsed = n2 = 0;
        fakeDeviceCapacity = n = -1;
        sizeMap = concurrentMap = Maps.newConcurrentMap();
    }

    public LogicalStorageManager getDelegateStorageManager() {
        return this.delegateStorageManager;
    }

    public void setDelegateStorageManager(LogicalStorageManager logicalStorageManager) {
        this.delegateStorageManager = logicalStorageManager;
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(StorageManagerTestingProxy.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StorageManagerTestingProxy.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

