/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.system.Threads;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class StorageCheckerService {
    private Logger LOG = Logger.getLogger(StorageCheckerService.class);
    private final ScheduledExecutorService exec;
    private ConcurrentHashMap<String, CheckerTask> checkers = new ConcurrentHashMap();

    public StorageCheckerService() {
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (CheckerTask checker : StorageCheckerService.this.checkers.values()) {
                    Threads.lookup(Storage.class).submit((Runnable)checker);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void add(CheckerTask checker) {
        this.checkers.putIfAbsent(checker.getName(), checker);
    }

    public void shutdown() {
        this.exec.shutdownNow();
        this.checkers.clear();
    }
}

