/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.entities.SnapshotPart;
import com.eucalyptus.blockstorage.entities.SnapshotUploadInfo;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.storage.common.CheckerTask;
import com.google.common.collect.Maps;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;

public class SnapshotUploadCheckerTask
extends CheckerTask {
    private Logger LOG = Logger.getLogger(SnapshotUploadCheckerTask.class);

    public SnapshotUploadCheckerTask() {
        this.name = SnapshotUploadCheckerTask.class.getName();
    }

    public void run() {
        this.cleanupAbortedUploads();
        this.deleteExpiredUploads();
    }

    private void cleanupAbortedUploads() {
        try (TransactionResource snapTran = Entities.transactionFor(SnapshotUploadInfo.class);){
            List snapUploadInfoList = Entities.query((Object)new SnapshotUploadInfo().withState(SnapshotUploadInfo.SnapshotUploadState.aborted));
            for (SnapshotUploadInfo snapUploadInfo : snapUploadInfoList) {
                this.LOG.debug((Object)("Cleaning aborted entity " + snapUploadInfo));
                try (TransactionResource partTran = Entities.transactionFor(SnapshotPart.class);){
                    List parts = Entities.query((Object)new SnapshotPart(snapUploadInfo.getSnapshotId(), snapUploadInfo.getBucketName(), snapUploadInfo.getKeyName(), snapUploadInfo.getUploadId()));
                    for (SnapshotPart part : parts) {
                        if (StringUtils.isNotBlank((String)part.getFileName())) {
                            this.LOG.debug((Object)("Deleting snapshot part from disk: " + part.getFileName()));
                            if (!Files.deleteIfExists(Paths.get(part.getFileName(), new String[0]))) {
                                this.LOG.warn((Object)("Could not delete snapshot part from disk: " + part.getFileName()));
                            }
                        }
                        part.setState(SnapshotPart.SnapshotPartState.cleaned);
                    }
                    partTran.commit();
                }
                snapUploadInfo.setPurgeTime(Long.valueOf(System.currentTimeMillis() + SnapshotUploadInfo.PURGE_INTERVAL));
                snapUploadInfo.setState(SnapshotUploadInfo.SnapshotUploadState.cleaned);
            }
            snapTran.commit();
        }
        catch (Exception e) {
            this.LOG.debug((Object)("Error updating snapshot upload state during clean up" + e));
        }
    }

    private void deleteExpiredUploads() {
        try (TransactionResource snapTran = Entities.transactionFor(SnapshotUploadInfo.class);){
            LogicalExpression criterion = Restrictions.and((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"state", (Object)SnapshotUploadInfo.SnapshotUploadState.cleaned), (Criterion)Restrictions.like((String)"state", (Object)SnapshotUploadInfo.SnapshotUploadState.uploaded)), (Criterion)Restrictions.le((String)"purgeTime", (Object)System.currentTimeMillis()));
            List snapshotUploadInfoList = Entities.query((Object)new SnapshotUploadInfo(), (boolean)Boolean.FALSE, (Criterion)criterion, (Map)Collections.EMPTY_MAP);
            for (SnapshotUploadInfo snapUploadInfo : snapshotUploadInfoList) {
                this.LOG.debug((Object)("Deleting expired entity from DB " + snapUploadInfo));
                HashMap parameters = Maps.newHashMap();
                parameters.put("snapshotId", snapUploadInfo.getSnapshotId());
                parameters.put("bucketName", snapUploadInfo.getBucketName());
                parameters.put("keyName", snapUploadInfo.getKeyName());
                if (snapUploadInfo.getUploadId() != null) {
                    parameters.put("uploadId", snapUploadInfo.getUploadId());
                    Entities.deleteAllMatching(SnapshotPart.class, (String)"WHERE snapshot_id = :snapshotId AND bucket_name = :bucketName AND key_name = :keyName AND upload_id = :uploadId", (Map)parameters);
                } else {
                    Entities.deleteAllMatching(SnapshotPart.class, (String)"WHERE snapshot_id = :snapshotId AND bucket_name = :bucketName AND key_name = :keyName", (Map)parameters);
                }
                Entities.delete((Object)snapUploadInfo);
            }
            snapTran.commit();
        }
        catch (Exception e) {
            this.LOG.debug((Object)("Error deleting expired snapshot upload info entities" + e));
        }
    }
}

