/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.entities.SnapshotInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.storage.common.CallBack;
import com.eucalyptus.system.Threads;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class SnapshotProgressCallback
implements CallBack {
    private static Logger LOG = Logger.getLogger(SnapshotProgressCallback.class);
    private static final int PROGRESS_TICK = 3;
    private String snapshotId;
    private long uploadSize;
    private long bytesTransferred;
    private int lastProgress;
    private ServiceConfiguration scConfig;

    public SnapshotProgressCallback(String snapshotId) {
        this.snapshotId = snapshotId;
        this.uploadSize = 0L;
        this.bytesTransferred = 0L;
        this.scConfig = Components.lookup(Storage.class).getLocalServiceConfiguration();
        this.lastProgress = 1;
        Threads.enqueue((ServiceConfiguration)this.scConfig, SnapshotProgressCallback.class, (Integer)1, (Callable)new ProgressSetter(this.snapshotId, this.lastProgress));
    }

    public void setUploadSize(long uploadSize) {
        this.uploadSize = uploadSize;
    }

    public void update(long bytesTransferred) {
        if (this.uploadSize > 0L) {
            this.bytesTransferred += bytesTransferred;
            int progress = (int)(this.bytesTransferred * 100L / this.uploadSize);
            if (progress >= 100 || progress - this.lastProgress < 3) {
                return;
            }
            this.lastProgress = progress;
            Threads.enqueue((ServiceConfiguration)this.scConfig, SnapshotProgressCallback.class, (Integer)1, (Callable)new ProgressSetter(this.snapshotId, this.lastProgress));
        }
    }

    public void finish() {
    }

    public void failed() {
    }

    class ProgressSetter
    implements Callable<Boolean> {
        private String snapshotId;
        private int progress;

        public ProgressSetter(String snapshotId, int progress) {
            this.snapshotId = snapshotId;
            this.progress = progress;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean call() throws Exception {
            try (TransactionResource db = Entities.transactionFor(SnapshotInfo.class);){
                SnapshotInfo snap = (SnapshotInfo)Entities.uniqueResult((Object)new SnapshotInfo(this.snapshotId));
                StorageProperties.Status snapStatus = StorageProperties.Status.valueOf((String)snap.getStatus());
                if (StorageProperties.Status.pending.equals((Object)snapStatus) || StorageProperties.Status.creating.equals((Object)snapStatus)) {
                    snap.setProgress(String.valueOf(this.progress));
                }
                db.commit();
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.debug((Object)("Could not update snapshot progress in DB for " + this.snapshotId + " to " + SnapshotProgressCallback.this.lastProgress + "% due to " + e.getMessage()));
                return false;
            }
        }
    }
}

