/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.blockstorage.FileInputStreamWithCallback;
import com.eucalyptus.blockstorage.SnapshotProgressCallback;
import com.eucalyptus.blockstorage.SnapshotTransfer;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.entities.SnapshotInfo;
import com.eucalyptus.blockstorage.entities.SnapshotPart;
import com.eucalyptus.blockstorage.entities.SnapshotTransferConfiguration;
import com.eucalyptus.blockstorage.entities.SnapshotUploadInfo;
import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.blockstorage.exceptions.SnapshotFinalizeMpuException;
import com.eucalyptus.blockstorage.exceptions.SnapshotInitializeMpuException;
import com.eucalyptus.blockstorage.exceptions.SnapshotTransferException;
import com.eucalyptus.blockstorage.exceptions.SnapshotUploadPartException;
import com.eucalyptus.blockstorage.util.BlockStorageUtil;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class S3SnapshotTransfer
implements SnapshotTransfer {
    private static Logger LOG = Logger.getLogger(S3SnapshotTransfer.class);
    private String snapshotId;
    private String bucketName;
    private String keyName;
    private String uploadId;
    private EucaS3Client eucaS3Client;
    private Long partSize;
    private Integer queueSize;
    private Integer transferRetries;
    private Integer transferTimeout;
    private Integer poolSize;
    private Integer readBufferSize;
    private Integer writeBufferSize;
    private ServiceConfiguration serviceConfig;
    private static Role role;
    private static final Integer TX_RETRIES;
    private static final Integer REFRESH_TOKEN_RETRIES;
    private static final String UNCOMPRESSED_SIZE_KEY = "uncompressedsize";

    public S3SnapshotTransfer() throws SnapshotTransferException {
        this.initializeEucaS3Client();
    }

    public S3SnapshotTransfer(String snapshotId, String bucketName, String keyName) throws SnapshotTransferException {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
    }

    public S3SnapshotTransfer(String snapshotId, String keyName) throws SnapshotTransferException {
        this();
        this.snapshotId = snapshotId;
        this.keyName = keyName;
    }

    protected S3SnapshotTransfer(boolean mock) {
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    @Override
    public String prepareForUpload() throws SnapshotTransferException {
        this.bucketName = this.createAndReturnBucketName();
        return this.bucketName;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void upload(StorageResource storageResource) throws SnapshotTransferException {
        this.validateInput();
        this.loadTransferConfig();
        SnapshotProgressCallback progressCallback = new SnapshotProgressCallback(this.snapshotId);
        Boolean error = Boolean.FALSE;
        ArrayBlockingQueue<SnapshotPart> partQueue = null;
        SnapshotPart part = null;
        SnapshotUploadInfo snapUploadInfo = null;
        Future uploadPartsFuture = null;
        Future completeUploadFuture = null;
        byte[] buffer = new byte[this.readBufferSize.intValue()];
        Long readOffset = 0L;
        Long bytesRead = 0L;
        Long bytesWritten = 0L;
        int partNumber = 1;
        try {
            Long uncompressedSize = storageResource.getSize();
            snapUploadInfo = SnapshotUploadInfo.create((String)this.snapshotId, (String)this.bucketName, (String)this.keyName);
            Path zipFilePath = Files.createTempFile(this.keyName + '-', '-' + String.valueOf(partNumber), new FileAttribute[0]);
            part = SnapshotPart.createPart((SnapshotUploadInfo)snapUploadInfo, (String)zipFilePath.toString(), (Integer)partNumber, (Long)readOffset);
            InputStream inputStream = storageResource.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = new GZIPOutputStream(baos);
            FileOutputStream outputStream = new FileOutputStream(zipFilePath.toString());
            try {
                int len;
                LOG.debug((Object)("Reading snapshot " + this.snapshotId + " and compressing it to disk in chunks of size " + this.partSize + " bytes or greater"));
                while ((len = inputStream.read(buffer)) > 0) {
                    bytesRead = bytesRead + (long)len;
                    gzipStream.write(buffer, 0, len);
                    if (bytesWritten + (long)baos.size() < this.partSize) {
                        baos.writeTo(outputStream);
                        bytesWritten = bytesWritten + (long)baos.size();
                        baos.reset();
                        continue;
                    }
                    gzipStream.close();
                    baos.writeTo(outputStream);
                    bytesWritten = bytesWritten + (long)baos.size();
                    baos.reset();
                    outputStream.close();
                    if (partNumber > 1) {
                        part = part.updateStateCreated(bytesWritten, bytesRead, Boolean.FALSE);
                    } else {
                        LOG.info((Object)("Uploading snapshot " + this.snapshotId + " to objectstorage using multipart upload"));
                        progressCallback.setUploadSize(uncompressedSize);
                        this.uploadId = this.initiateMulitpartUpload(uncompressedSize);
                        snapUploadInfo = snapUploadInfo.updateUploadId(this.uploadId);
                        part = part.updateStateCreated(this.uploadId, bytesWritten, bytesRead, Boolean.FALSE);
                        partQueue = new ArrayBlockingQueue<SnapshotPart>(this.queueSize);
                        uploadPartsFuture = Threads.enqueue((ServiceConfiguration)this.serviceConfig, UploadPartTask.class, (Integer)this.poolSize, (Callable)new UploadPartTask(partQueue, progressCallback));
                    }
                    if (uploadPartsFuture != null && uploadPartsFuture.isDone()) {
                        throw new SnapshotUploadPartException("Error uploading parts, aborting part creation process. Check previous log messages for the exact error");
                    }
                    partQueue.put(part);
                    readOffset = readOffset + bytesRead;
                    bytesRead = 0L;
                    bytesWritten = 0L;
                    zipFilePath = Files.createTempFile(this.keyName + '-', '-' + String.valueOf(++partNumber), new FileAttribute[0]);
                    part = SnapshotPart.createPart((SnapshotUploadInfo)snapUploadInfo, (String)zipFilePath.toString(), (Integer)partNumber, (Long)readOffset);
                    gzipStream = new GZIPOutputStream(baos);
                    outputStream = new FileOutputStream(zipFilePath.toString());
                }
                gzipStream.close();
                baos.writeTo(outputStream);
                bytesWritten = bytesWritten + (long)baos.size();
                baos.reset();
                outputStream.close();
                inputStream.close();
                part = part.updateStateCreated(bytesWritten, bytesRead, Boolean.TRUE);
                snapUploadInfo = snapUploadInfo.updateStateCreatedParts(Integer.valueOf(partNumber));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to upload " + this.snapshotId + " due to: "), (Throwable)e);
                error = Boolean.TRUE;
                throw new SnapshotTransferException("Failed to upload " + this.snapshotId + " due to: ", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
                baos.reset();
            }
            if (partNumber > 1) {
                if (uploadPartsFuture != null && uploadPartsFuture.isDone()) {
                    throw new SnapshotUploadPartException("Error uploading parts, aborting part upload process. Check previous log messages for the exact error");
                }
                partQueue.put(part);
                completeUploadFuture = Threads.enqueue((ServiceConfiguration)this.serviceConfig, CompleteMpuTask.class, (Integer)this.poolSize, (Callable)new CompleteMpuTask(uploadPartsFuture, snapUploadInfo, partNumber));
            } else {
                try {
                    LOG.info((Object)("Uploading snapshot " + this.snapshotId + " to objectstorage as a single object. Compressed size of snapshot (" + bytesWritten + " bytes) is less than minimum part size (" + this.partSize + " bytes) for multipart upload"));
                    PutObjectResult putResult = this.uploadSnapshotAsSingleObject(zipFilePath.toString(), bytesWritten, uncompressedSize, progressCallback);
                    this.markSnapshotAvailable();
                    try {
                        part = part.updateStateUploaded(putResult.getETag());
                        snapUploadInfo = snapUploadInfo.updateStateUploaded(putResult.getETag());
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Failed to update status in DB for " + snapUploadInfo));
                    }
                    LOG.info((Object)("Uploaded snapshot " + this.snapshotId + " to objectstorage"));
                }
                catch (Exception e) {
                    error = Boolean.TRUE;
                    LOG.error((Object)("Failed to upload snapshot " + this.snapshotId + " due to: "), (Throwable)e);
                    throw new SnapshotTransferException("Failed to upload snapshot " + this.snapshotId + " due to: ", (Throwable)e);
                }
                finally {
                    this.deleteFile(zipFilePath);
                }
            }
            if (error == false) return;
            this.abortUpload(snapUploadInfo);
            if (uploadPartsFuture != null && !uploadPartsFuture.isDone()) {
                uploadPartsFuture.cancel(true);
            }
        }
        catch (SnapshotTransferException e) {
            try {
                error = Boolean.TRUE;
                throw e;
                catch (Exception e2) {
                    error = Boolean.TRUE;
                    LOG.error((Object)("Failed to upload snapshot " + this.snapshotId + " due to: "), (Throwable)e2);
                    throw new SnapshotTransferException("Failed to upload snapshot " + this.snapshotId + " due to: ", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (error == false) throw throwable;
                this.abortUpload(snapUploadInfo);
                if (uploadPartsFuture != null && !uploadPartsFuture.isDone()) {
                    uploadPartsFuture.cancel(true);
                }
                if (completeUploadFuture == null) throw throwable;
                if (completeUploadFuture.isDone()) throw throwable;
                completeUploadFuture.cancel(true);
                throw throwable;
            }
        }
        if (completeUploadFuture == null) return;
        if (completeUploadFuture.isDone()) return;
        completeUploadFuture.cancel(true);
    }

    @Override
    public void cancelUpload() throws SnapshotTransferException {
        this.validateInput();
        try (TransactionResource db = Entities.transactionFor(SnapshotUploadInfo.class);){
            SnapshotUploadInfo snapUploadInfo = (SnapshotUploadInfo)Entities.uniqueResult((Object)new SnapshotUploadInfo(this.snapshotId, this.bucketName, this.keyName));
            this.uploadId = snapUploadInfo.getUploadId();
            this.abortMultipartUpload();
            snapUploadInfo.setState(SnapshotUploadInfo.SnapshotUploadState.aborted);
            db.commit();
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to cancel upload for snapshot " + this.snapshotId), (Throwable)e);
            throw new SnapshotTransferException("Failed to cancel upload for snapshot " + this.snapshotId, (Throwable)e);
        }
    }

    @Override
    public void resumeUpload(StorageResource storageResource) throws SnapshotTransferException {
        throw new SnapshotTransferException("Not supported yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(StorageResource storageResource) throws SnapshotTransferException {
        this.validateInput();
        this.loadTransferConfig();
        S3Object snapObj = this.download();
        if (snapObj != null && snapObj.getObjectContent() != null) {
            byte[] buffer = new byte[10 * this.readBufferSize];
            GZIPInputStream gzipInputStream = null;
            try {
                gzipInputStream = new GZIPInputStream((InputStream)new BufferedInputStream((InputStream)snapObj.getObjectContent(), buffer.length * 3), buffer.length * 2);
                if (storageResource.isDownloadSynchronous().booleanValue()) {
                    OutputStream outputStream = null;
                    try {
                        int len;
                        outputStream = storageResource.getOutputStream();
                        while ((len = gzipInputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, len);
                        }
                        gzipInputStream.close();
                        outputStream.close();
                        buffer = null;
                    }
                    finally {
                        try {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                ArrayBlockingQueue<SnapshotPart> partQueue = new ArrayBlockingQueue<SnapshotPart>(this.queueSize);
                Future storageWriterFuture = Threads.enqueue((ServiceConfiguration)this.serviceConfig, StorageWriterTask.class, (Integer)this.poolSize, (Callable)new StorageWriterTask(partQueue, storageResource));
                FileOutputStream fileOutputStream = null;
                long bytesWritten = 0L;
                int partNumber = 1;
                try {
                    int len;
                    Path filePath = Files.createTempFile(this.snapshotId + '-', '-' + String.valueOf(partNumber), new FileAttribute[0]);
                    fileOutputStream = new FileOutputStream(filePath.toString());
                    SnapshotPart part = new SnapshotPart();
                    part.setFileName(filePath.toString());
                    part.setPartNumber(Integer.valueOf(partNumber));
                    part.setIsLast(Boolean.FALSE);
                    while ((len = gzipInputStream.read(buffer)) > 0) {
                        if (bytesWritten + (long)len < (long)this.writeBufferSize.intValue()) {
                            fileOutputStream.write(buffer, 0, len);
                            bytesWritten += (long)len;
                            continue;
                        }
                        fileOutputStream.write(buffer, 0, len);
                        bytesWritten += (long)len;
                        fileOutputStream.close();
                        if (storageWriterFuture.isDone()) {
                            throw new SnapshotTransferException("Error writing snapshot to backend, check previous log messages for more details. Aborting download and unzip process");
                        }
                        part.setSize(Long.valueOf(bytesWritten));
                        partQueue.put(part);
                        bytesWritten = 0L;
                        filePath = Files.createTempFile(this.snapshotId + '-', '-' + String.valueOf(++partNumber), new FileAttribute[0]);
                        fileOutputStream = new FileOutputStream(filePath.toString());
                        part = new SnapshotPart();
                        part.setFileName(filePath.toString());
                        part.setPartNumber(Integer.valueOf(partNumber));
                        part.setIsLast(Boolean.FALSE);
                    }
                    gzipInputStream.close();
                    fileOutputStream.close();
                    buffer = null;
                    part.setSize(Long.valueOf(bytesWritten));
                    part.setIsLast(Boolean.TRUE);
                    partQueue.put(part);
                    if (StringUtils.isNotBlank((String)((String)storageWriterFuture.get(this.transferTimeout.intValue(), TimeUnit.HOURS)))) {
                        LOG.info((Object)("Downloaded snapshot " + this.snapshotId + " to storage backend"));
                    }
                    throw new SnapshotTransferException("Failed to download snapshot " + this.snapshotId + " to storage backend");
                }
                catch (Exception e) {
                    try {
                        if (!storageWriterFuture.isDone()) {
                            storageWriterFuture.cancel(true);
                        }
                        ArrayList remainingParts = new ArrayList();
                        partQueue.drainTo(remainingParts);
                        for (SnapshotPart part : remainingParts) {
                            this.deleteFile(part.getFileName());
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Unable to clean up artifacts left by a failed attempt to download " + this.snapshotId + " to storage backend"), (Throwable)ex);
                    }
                    throw e;
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SnapshotTransferException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SnapshotTransferException("Failed to download snapshot " + this.snapshotId + " to storage backend", (Throwable)e);
            }
            finally {
                try {
                    if (gzipInputStream != null) {
                        gzipInputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    snapObj.getObjectContent().close();
                }
                catch (Exception exception) {}
            }
        } else {
            LOG.warn((Object)("No snapshot content available from objectstorage gateway: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
            throw new SnapshotTransferException("No snapshot content available: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName);
        }
    }

    @Override
    public void delete() throws SnapshotTransferException {
        LOG.debug((Object)("Deleting snapshot from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
        this.validateInput();
        try {
            this.retryAfterRefresh(new Function<DeleteObjectRequest, String>(){

                @Nullable
                public String apply(@Nullable DeleteObjectRequest arg0) {
                    S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                    S3SnapshotTransfer.this.eucaS3Client.deleteObject(arg0);
                    return null;
                }
            }, new DeleteObjectRequest(this.bucketName, this.keyName), REFRESH_TOKEN_RETRIES);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to delete snapshot from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
            throw new SnapshotTransferException("Failed to delete snapshot from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName, (Throwable)e);
        }
    }

    @Override
    public Long getSizeInBytes() throws SnapshotTransferException {
        LOG.debug((Object)("Fetching snapshot metadata from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
        this.validateInput();
        ObjectMetadata metadata = null;
        Map userMetadata = null;
        try {
            metadata = this.retryAfterRefresh(new Function<GetObjectMetadataRequest, ObjectMetadata>(){

                @Nullable
                public ObjectMetadata apply(@Nullable GetObjectMetadataRequest arg0) {
                    S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                    return S3SnapshotTransfer.this.eucaS3Client.getObjectMetadata(arg0);
                }
            }, new GetObjectMetadataRequest(this.bucketName, this.keyName), REFRESH_TOKEN_RETRIES);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get snapshot metadata from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
            throw new SnapshotTransferException("Failed to get snapshot metadata from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName, (Throwable)e);
        }
        if (metadata != null && (userMetadata = metadata.getUserMetadata()) != null && userMetadata.containsKey(UNCOMPRESSED_SIZE_KEY)) {
            try {
                return Long.parseLong((String)userMetadata.get(UNCOMPRESSED_SIZE_KEY));
            }
            catch (Exception e) {
                throw new SnapshotTransferException("Unable to parse size from snapshot metadata: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName + ", metadata key:value pair=" + UNCOMPRESSED_SIZE_KEY + ":" + (String)userMetadata.get(UNCOMPRESSED_SIZE_KEY), (Throwable)e);
            }
        }
        throw new SnapshotTransferException("Snapshot metadata from objectstorage does not contain uncompressed size: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName);
    }

    private void initializeEucaS3Client() throws SnapshotTransferException {
        if (role == null) {
            try {
                role = BlockStorageUtil.checkAndConfigureBlockStorageAccount();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to initialize account for snapshot transfers due to " + e));
                throw new SnapshotTransferException("Failed to initialize eucalyptus account for snapshot transfers", (Throwable)e);
            }
        }
        try {
            this.eucaS3Client = EucaS3ClientFactory.getEucaS3ClientByRole((Role)role, (int)((int)TimeUnit.HOURS.toSeconds(1L)));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to initialize S3 client for snapshot transfers due to " + e));
            throw new SnapshotTransferException("Failed to initialize S3 client for snapshot transfers", (Throwable)e);
        }
    }

    private void loadTransferConfig() {
        StorageInfo info = StorageInfo.getStorageInfo();
        this.partSize = info.getSnapshotPartSizeInMB() * 1024 * 1024;
        this.queueSize = info.getMaxSnapshotPartsQueueSize();
        this.transferRetries = info.getMaxSnapTransferRetries();
        this.transferTimeout = info.getSnapshotTransferTimeoutInHours();
        this.serviceConfig = Components.lookup(Storage.class).getLocalServiceConfiguration();
        this.poolSize = info.getMaxConcurrentSnapshotTransfers();
        this.readBufferSize = info.getReadBufferSizeInMB() * 1024 * 1024;
        this.writeBufferSize = info.getWriteBufferSizeInMB() * 1024 * 1024;
    }

    private void validateInput() throws SnapshotTransferException {
        if (StringUtils.isBlank((String)this.snapshotId)) {
            throw new SnapshotTransferException("Snapshot ID is invalid. Cannot upload snapshot");
        }
        if (StringUtils.isBlank((String)this.bucketName)) {
            throw new SnapshotTransferException("Bucket name is invalid. Cannot upload snapshot " + this.snapshotId);
        }
        if (StringUtils.isBlank((String)this.keyName)) {
            throw new SnapshotTransferException("Key name is invalid. Cannot upload snapshot " + this.snapshotId);
        }
        if (this.eucaS3Client == null) {
            throw new SnapshotTransferException("S3 client reference is invalid. Cannot upload snapshot " + this.snapshotId);
        }
    }

    private String createAndReturnBucketName() throws SnapshotTransferException {
        String bucket = null;
        int bucketCreationRetries = 10;
        while (true) {
            --bucketCreationRetries;
            if (StringUtils.isBlank(bucket)) {
                try {
                    bucket = SnapshotTransferConfiguration.getInstance().getSnapshotBucket();
                }
                catch (Exception ex1) {
                    try {
                        bucket = SnapshotTransferConfiguration.updateBucketName((String)("snapshots-" + UUID.randomUUID().toString().replaceAll("-", ""))).getSnapshotBucket();
                    }
                    catch (Exception ex2) {
                        bucket = "snapshots-" + UUID.randomUUID().toString().replaceAll("-", "");
                    }
                }
            }
            try {
                this.retryAfterRefresh(new Function<String, Bucket>(){

                    @Nullable
                    public Bucket apply(@Nullable String arg0) {
                        S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                        return S3SnapshotTransfer.this.eucaS3Client.createBucket(arg0);
                    }
                }, bucket, REFRESH_TOKEN_RETRIES);
            }
            catch (Exception ex) {
                if (bucketCreationRetries > 0) {
                    LOG.debug((Object)("Unable to create snapshot upload bucket " + bucket + ". Will retry with a different bucket name"));
                    try {
                        bucket = SnapshotTransferConfiguration.updateBucketName((String)("snapshots-" + UUID.randomUUID().toString().replaceAll("-", ""))).getSnapshotBucket();
                    }
                    catch (Exception ex2) {
                        bucket = "snapshots-" + UUID.randomUUID().toString().replaceAll("-", "");
                    }
                    continue;
                }
                throw new SnapshotTransferException("Unable to create bucket for snapshot uploads after 10 retries");
                if (bucketCreationRetries > 0) continue;
            }
            break;
        }
        return bucket;
    }

    private S3Object download() throws SnapshotTransferException {
        try {
            LOG.debug((Object)("Dowloading snapshot from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
            return this.retryAfterRefresh(new Function<GetObjectRequest, S3Object>(){

                @Nullable
                public S3Object apply(@Nullable GetObjectRequest arg0) {
                    S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                    return S3SnapshotTransfer.this.eucaS3Client.getObject(arg0);
                }
            }, new GetObjectRequest(this.bucketName, this.keyName), REFRESH_TOKEN_RETRIES);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to download snapshot from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName));
            throw new SnapshotTransferException("Failed to download snapshot from objectstorage: snapshotId=" + this.snapshotId + ", bucket=" + this.bucketName + ", key=" + this.keyName, (Throwable)e);
        }
    }

    private PutObjectResult uploadSnapshotAsSingleObject(final String compressedSnapFileName, Long actualSize, Long uncompressedSize, final SnapshotProgressCallback callback) throws Exception {
        callback.setUploadSize(actualSize);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        HashMap<String, String> userMetadataMap = new HashMap<String, String>();
        userMetadataMap.put(UNCOMPRESSED_SIZE_KEY, String.valueOf(uncompressedSize));
        objectMetadata.setUserMetadata(userMetadataMap);
        objectMetadata.setContentLength(actualSize.longValue());
        return this.retryAfterRefresh(new Function<PutObjectRequest, PutObjectResult>(){

            @Nullable
            public PutObjectResult apply(@Nullable PutObjectRequest arg0) {
                S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                try {
                    arg0.setInputStream((InputStream)new FileInputStreamWithCallback(new File(compressedSnapFileName), callback));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to upload snapshot to objectstorage: snapshotId=" + S3SnapshotTransfer.this.snapshotId + ", bucket=" + S3SnapshotTransfer.this.bucketName + ", key=" + S3SnapshotTransfer.this.keyName + ", reason: unable to initialize FileInputStreamWithCallback for file " + compressedSnapFileName), (Throwable)e);
                    Exceptions.toUndeclared((Throwable)e);
                }
                return S3SnapshotTransfer.this.eucaS3Client.putObject(arg0);
            }
        }, new PutObjectRequest(this.bucketName, this.keyName, null, objectMetadata), REFRESH_TOKEN_RETRIES);
    }

    private String initiateMulitpartUpload(Long uncompressedSize) throws SnapshotInitializeMpuException {
        InitiateMultipartUploadResult initResponse = null;
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucketName, this.keyName);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        HashMap<String, String> userMetadataMap = new HashMap<String, String>();
        userMetadataMap.put(UNCOMPRESSED_SIZE_KEY, String.valueOf(uncompressedSize));
        objectMetadata.setUserMetadata(userMetadataMap);
        initRequest.setObjectMetadata(objectMetadata);
        try {
            LOG.info((Object)("Inititating multipart upload: snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName));
            initResponse = this.retryAfterRefresh(new Function<InitiateMultipartUploadRequest, InitiateMultipartUploadResult>(){

                @Nullable
                public InitiateMultipartUploadResult apply(@Nullable InitiateMultipartUploadRequest arg0) {
                    S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                    return S3SnapshotTransfer.this.eucaS3Client.initiateMultipartUpload(arg0);
                }
            }, initRequest, REFRESH_TOKEN_RETRIES);
        }
        catch (Exception ex) {
            throw new SnapshotInitializeMpuException("Failed to initialize multipart upload part for snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName, (Throwable)ex);
        }
        if (StringUtils.isBlank((String)initResponse.getUploadId())) {
            throw new SnapshotInitializeMpuException("Invalid upload ID for multipart upload part for snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName);
        }
        return initResponse.getUploadId();
    }

    private PartETag uploadPart(SnapshotPart part, SnapshotProgressCallback progressCallback) throws SnapshotUploadPartException {
        try {
            part = part.updateStateUploading();
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to update part status in DB. Moving on. " + part));
        }
        try {
            LOG.debug((Object)("Uploading " + part));
            UploadPartResult uploadPartResult = this.retryAfterRefresh(new Function<UploadPartRequest, UploadPartResult>(){

                @Nullable
                public UploadPartResult apply(@Nullable UploadPartRequest arg0) {
                    S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                    return S3SnapshotTransfer.this.eucaS3Client.uploadPart(arg0);
                }
            }, new UploadPartRequest().withBucketName(part.getBucketName()).withKey(part.getKeyName()).withUploadId(part.getUploadId()).withPartNumber(part.getPartNumber().intValue()).withPartSize(part.getSize().longValue()).withFile(new File(part.getFileName())), REFRESH_TOKEN_RETRIES);
            progressCallback.update(part.getInputFileBytesRead());
            try {
                part = part.updateStateUploaded(uploadPartResult.getPartETag().getETag());
            }
            catch (Exception e) {
                LOG.debug((Object)("Failed to update part status in DB. Moving on. " + part));
            }
            LOG.debug((Object)("Uploaded " + part));
            PartETag e = uploadPartResult.getPartETag();
            return e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to upload part " + part), (Throwable)e);
            try {
                part = part.updateStateFailed();
            }
            catch (Exception ie) {
                LOG.debug((Object)("Failed to update part status in DB. Moving on. " + part));
            }
            throw new SnapshotUploadPartException("Failed to upload part " + part, (Throwable)e);
        }
        finally {
            this.deleteFile(part.getFileName());
        }
    }

    private String finalizeMultipartUpload(List<PartETag> partETags) throws SnapshotFinalizeMpuException {
        try {
            LOG.info((Object)("Finalizing multipart upload: snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName + ", uploadId=" + this.uploadId));
            CompleteMultipartUploadResult result = this.retryAfterRefresh(new Function<CompleteMultipartUploadRequest, CompleteMultipartUploadResult>(){

                @Nullable
                public CompleteMultipartUploadResult apply(@Nullable CompleteMultipartUploadRequest arg0) {
                    S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                    return S3SnapshotTransfer.this.eucaS3Client.completeMultipartUpload(arg0);
                }
            }, new CompleteMultipartUploadRequest(this.bucketName, this.keyName, this.uploadId, partETags), REFRESH_TOKEN_RETRIES);
            return result.getETag();
        }
        catch (Exception ex) {
            LOG.debug((Object)("Failed to finalize multipart upload for snapshotId=" + this.snapshotId + ", bucketName=" + ", keyName=" + this.keyName), (Throwable)ex);
            throw new SnapshotFinalizeMpuException("Failed to initialize multipart upload part after for snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName);
        }
    }

    private void abortMultipartUpload() {
        if (this.uploadId != null) {
            try {
                LOG.debug((Object)("Aborting multipart upload: snapshotId=" + this.snapshotId + ", bucketName=" + ", keyName=" + this.keyName + ", uploadId=" + this.uploadId));
                this.retryAfterRefresh(new Function<AbortMultipartUploadRequest, String>(){

                    @Nullable
                    public String apply(@Nullable AbortMultipartUploadRequest arg0) {
                        S3SnapshotTransfer.this.eucaS3Client.refreshEndpoint();
                        S3SnapshotTransfer.this.eucaS3Client.abortMultipartUpload(arg0);
                        return null;
                    }
                }, new AbortMultipartUploadRequest(this.bucketName, this.keyName, this.uploadId), REFRESH_TOKEN_RETRIES);
            }
            catch (Exception e) {
                LOG.debug((Object)("Failed to abort multipart upload for snapshot " + this.snapshotId));
            }
        }
    }

    private void abortUpload(SnapshotUploadInfo snapUploadInfo) {
        this.abortMultipartUpload();
        if (snapUploadInfo != null) {
            try {
                snapUploadInfo.updateStateAborted();
            }
            catch (EucalyptusCloudException e) {
                LOG.debug((Object)("Failed to update status in DB for " + snapUploadInfo));
            }
        }
    }

    private void deleteFile(String fileName) {
        if (StringUtils.isNotBlank((String)fileName)) {
            try {
                Files.deleteIfExists(Paths.get(fileName, new String[0]));
            }
            catch (IOException e) {
                LOG.debug((Object)("Failed to delete file: " + fileName));
            }
        }
    }

    private void deleteFile(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to delete file: " + path.toString()));
        }
    }

    private void markSnapshotAvailable() throws TransactionException, NoSuchElementException {
        Function<String, SnapshotInfo> updateFunction = new Function<String, SnapshotInfo>(){

            public SnapshotInfo apply(String arg0) {
                try {
                    SnapshotInfo snap = (SnapshotInfo)Entities.uniqueResult((Object)new SnapshotInfo(arg0));
                    snap.setStatus(StorageProperties.Status.available.toString());
                    snap.setProgress("100");
                    snap.setSnapPointId(null);
                    return snap;
                }
                catch (TransactionException | NoSuchElementException e) {
                    LOG.error((Object)("Failed to retrieve snapshot entity from DB for " + arg0), e);
                    return null;
                }
            }
        };
        Entities.asTransaction(SnapshotInfo.class, (Function)updateFunction, (int)TX_RETRIES).apply((Object)this.snapshotId);
    }

    private void markSnapshotFailed() throws TransactionException, NoSuchElementException {
        Function<String, SnapshotInfo> updateFunction = new Function<String, SnapshotInfo>(){

            public SnapshotInfo apply(String arg0) {
                try {
                    SnapshotInfo snap = (SnapshotInfo)Entities.uniqueResult((Object)new SnapshotInfo(arg0));
                    snap.setStatus(StorageProperties.Status.failed.toString());
                    snap.setProgress("0");
                    return snap;
                }
                catch (TransactionException | NoSuchElementException e) {
                    LOG.error((Object)("Failed to retrieve snapshot entity from DB for " + arg0), e);
                    return null;
                }
            }
        };
        Entities.asTransaction(SnapshotInfo.class, (Function)updateFunction, (int)TX_RETRIES).apply((Object)this.snapshotId);
    }

    private <F, T> T retryAfterRefresh(Function<F, T> function, F input, int retries) throws SnapshotTransferException {
        int failedAttempts = 0;
        Object output = null;
        do {
            try {
                output = function.apply(input);
                break;
            }
            catch (AmazonServiceException e) {
                if (failedAttempts < retries && e.getStatusCode() == HttpResponseStatus.FORBIDDEN.getCode()) {
                    LOG.debug((Object)("Snapshot transfer operation failed because of " + e.getMessage() + ". Will refresh credentials and retry"));
                    this.initializeEucaS3Client();
                    continue;
                }
                throw new SnapshotTransferException("Snapshot transfer operation failed because of", (Throwable)e);
            }
            catch (Exception e) {
                throw new SnapshotTransferException("Snapshot transfer operation failed because of", (Throwable)e);
            }
        } while (++failedAttempts <= retries);
        return (T)output;
    }

    static {
        TX_RETRIES = 20;
        REFRESH_TOKEN_RETRIES = 1;
    }

    class StorageWriterTask
    implements Callable<String> {
        private ArrayBlockingQueue<SnapshotPart> partQueue;
        private StorageResource storageResource;

        public StorageWriterTask(ArrayBlockingQueue<SnapshotPart> partQueue, StorageResource storageResource) {
            this.partQueue = partQueue;
            this.storageResource = storageResource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            String returnValue = null;
            SnapshotPart part = null;
            OutputStream outStream = null;
            byte[] buffer = new byte[S3SnapshotTransfer.this.writeBufferSize.intValue()];
            try {
                outStream = this.storageResource.getOutputStream();
                do {
                    part = this.partQueue.take();
                    FileInputStream inStream = null;
                    try {
                        int len;
                        inStream = new FileInputStream(part.getFileName());
                        while ((len = inStream.read(buffer)) > 0) {
                            outStream.write(buffer, 0, len);
                        }
                        inStream.close();
                    }
                    finally {
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        S3SnapshotTransfer.this.deleteFile(part.getFileName());
                    }
                } while (!part.getIsLast().booleanValue());
                outStream.close();
                buffer = null;
                returnValue = this.storageResource.getId();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to write snapshot " + S3SnapshotTransfer.this.snapshotId + " to storage backend due to:"), (Throwable)e);
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return returnValue;
        }
    }

    class CompleteMpuTask
    implements Callable<String> {
        private Future<List<PartETag>> uploadTaskFuture;
        private SnapshotUploadInfo snapUploadInfo;
        private Integer totalParts;

        public CompleteMpuTask(Future<List<PartETag>> uploadTaskFuture, SnapshotUploadInfo snapUploadInfo, Integer totalParts) {
            this.uploadTaskFuture = uploadTaskFuture;
            this.snapUploadInfo = snapUploadInfo;
            this.totalParts = totalParts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            String etag;
            block13: {
                Boolean error = Boolean.FALSE;
                etag = null;
                try {
                    List<PartETag> partETags = this.uploadTaskFuture.get(S3SnapshotTransfer.this.transferTimeout.intValue(), TimeUnit.HOURS);
                    if (partETags != null && partETags.size() == this.totalParts.intValue()) {
                        try {
                            etag = S3SnapshotTransfer.this.finalizeMultipartUpload(partETags);
                            S3SnapshotTransfer.this.markSnapshotAvailable();
                            try {
                                this.snapUploadInfo = this.snapUploadInfo.updateStateUploaded(etag);
                            }
                            catch (Exception e) {
                                LOG.debug((Object)("Failed to update status in DB for " + this.snapUploadInfo));
                            }
                            LOG.info((Object)("Uploaded snapshot " + this.snapUploadInfo.getSnapshotId() + " to objectstorage"));
                        }
                        catch (Exception e) {
                            error = Boolean.TRUE;
                            LOG.error((Object)("Failed to upload " + S3SnapshotTransfer.this.snapshotId + " due to an error completing the upload"), (Throwable)e);
                        }
                        break block13;
                    }
                    error = Boolean.TRUE;
                    LOG.error((Object)("Failed to upload " + S3SnapshotTransfer.this.snapshotId + " as the total number of parts does not tally up against the part Etags"));
                }
                catch (TimeoutException tex) {
                    error = Boolean.TRUE;
                    LOG.error((Object)("Failed to upload " + S3SnapshotTransfer.this.snapshotId + ". Complete upload task timed out waiting on upload part task after " + S3SnapshotTransfer.this.transferTimeout + " hours"));
                }
                catch (Exception ex) {
                    error = Boolean.TRUE;
                    LOG.error((Object)("Failed to upload " + S3SnapshotTransfer.this.snapshotId), (Throwable)ex);
                }
                finally {
                    if (error.booleanValue()) {
                        S3SnapshotTransfer.this.markSnapshotFailed();
                        S3SnapshotTransfer.this.abortUpload(this.snapUploadInfo);
                    }
                }
            }
            return etag;
        }
    }

    class UploadPartTask
    implements Callable<List<PartETag>> {
        private ArrayBlockingQueue<SnapshotPart> partQueue;
        private SnapshotProgressCallback progressCallback;
        private List<PartETag> partETags;

        public UploadPartTask(ArrayBlockingQueue<SnapshotPart> partQueue, SnapshotProgressCallback progressCallback) throws EucalyptusCloudException {
            if (partQueue == null || progressCallback == null) {
                throw new EucalyptusCloudException("Invalid constructor parameters. Cannot proceed without part queue and or snapshot progress callback");
            }
            this.partQueue = partQueue;
            this.progressCallback = progressCallback;
            this.partETags = new ArrayList<PartETag>();
        }

        @Override
        public List<PartETag> call() throws Exception {
            Boolean isLast = Boolean.FALSE;
            do {
                SnapshotPart part = null;
                try {
                    part = this.partQueue.take();
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)("Failed to upload snapshot " + S3SnapshotTransfer.this.snapshotId + " due to an retrieving parts from queue"), (Throwable)ex);
                    return null;
                }
                isLast = part.getIsLast();
                if (part.getState().equals((Object)SnapshotPart.SnapshotPartState.created) || part.getState().equals((Object)SnapshotPart.SnapshotPartState.uploading) || part.getState().equals((Object)SnapshotPart.SnapshotPartState.failed)) {
                    try {
                        this.partETags.add(S3SnapshotTransfer.this.uploadPart(part, this.progressCallback));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to upload a part for " + S3SnapshotTransfer.this.snapshotId + ". Aborting the part upload process"));
                        return null;
                    }
                } else {
                    LOG.warn((Object)("Not sure what to do with this part, just keep going: " + part));
                }
            } while (!isLast.booleanValue());
            return this.partETags;
        }
    }
}

