/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.storage.common.CallBack;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PutMethod;

public class PutMethodWithProgress
extends PutMethod {
    private File outFile;
    private CallBack callback;

    public PutMethodWithProgress(String path) {
        super(path);
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public void setCallBack(CallBack callback) {
        this.callback = callback;
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException {
        ChunkedOutputStream chunkedOut;
        FileInputStream inputStream;
        if (this.outFile != null) {
            int bytesRead;
            inputStream = new FileInputStream(this.outFile);
            chunkedOut = new ChunkedOutputStream(conn.getRequestOutputStream());
            byte[] buffer = new byte[StorageProperties.TRANSFER_CHUNK_SIZE];
            long totalBytesProcessed = 0L;
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) > 0) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                GZIPOutputStream zip = new GZIPOutputStream(out);
                zip.write(buffer, 0, bytesRead);
                zip.close();
                chunkedOut.write(out.toByteArray());
                this.callback.update(totalBytesProcessed += (long)bytesRead);
            }
            if (totalBytesProcessed > 0L) {
                this.callback.finish();
            } else {
                this.callback.failed();
            }
        } else {
            return false;
        }
        chunkedOut.finish();
        ((InputStream)inputStream).close();
        return true;
    }
}

