/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.blockstorage.DASManager;
import com.eucalyptus.blockstorage.FileResource;
import com.eucalyptus.blockstorage.LVMWrapper;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.entities.DirectStorageInfo;
import com.eucalyptus.blockstorage.entities.ISCSIVolumeInfo;
import com.eucalyptus.blockstorage.entities.LVMVolumeInfo;
import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Joiner;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@StorageManagers.StorageManagerProperty(value="overlay")
public class OverlayManager
extends DASManager {
    private static Logger LOG = Logger.getLogger(OverlayManager.class);
    public static boolean zeroFillVolumes = false;
    private static final Joiner JOINER = Joiner.on((String)" ").skipNulls();

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        if (!new File(StorageProperties.EUCA_ROOT_WRAPPER).exists()) {
            throw new EucalyptusCloudException("root wrapper (euca_rootwrap) does not exist in " + StorageProperties.EUCA_ROOT_WRAPPER);
        }
        File varDir = new File(EUCA_VAR_RUN_PATH);
        if (!varDir.exists()) {
            varDir.mkdirs();
        }
        try {
            String returnValue = LVMWrapper.getLvmVersion();
            if (returnValue.length() == 0) {
                throw new EucalyptusCloudException("Is lvm installed?");
            }
            LOG.debug((Object)("lvm version: " + returnValue));
            exportManager.checkPreconditions();
        }
        catch (EucalyptusCloudException ex) {
            String error = "Unable to run command: " + ex.getMessage();
            LOG.error((Object)error);
            throw new EucalyptusCloudException(error);
        }
    }

    private String findFreeLoopback() throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "losetup", "-f"}).replaceAll("\n", "");
    }

    private String getLoopback(String loDevName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "losetup", loDevName});
    }

    private String removeLoopback(String loDevName) throws EucalyptusCloudException {
        int retryCount = 0;
        do {
            try {
                Object[] command = new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "losetup", "-d", loDevName};
                SystemUtil.CommandOutput resultObj1 = SystemUtil.runWithRawOutput((String[])command);
                LOG.debug((Object)("Executed: " + JOINER.join(command) + "\n return=" + resultObj1.returnValue + "\n stdout=" + resultObj1.output + "\n stderr=" + resultObj1.error));
                command = new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "losetup", loDevName};
                SystemUtil.CommandOutput resultObj2 = SystemUtil.runWithRawOutput((String[])command);
                LOG.debug((Object)("Executed: " + JOINER.join(command) + "\n return=" + resultObj2.returnValue + "\n stdout=" + resultObj2.output + "\n stderr=" + resultObj2.error));
                if (!StringUtils.isNotBlank((String)resultObj2.output)) {
                    LOG.debug((Object)("Detached loop device: " + loDevName));
                    return "";
                }
                LOG.debug((Object)("Unable to disconnect the loop device at: " + loDevName));
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                LOG.error((Object)"Error removing loop device", (Throwable)e);
            }
        } while (++retryCount < 3);
        LOG.error((Object)("All attempts to remove loop device " + loDevName + " failed."));
        return "";
    }

    private boolean volumeGroupExists(String vgName) {
        boolean success = false;
        String returnValue = SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "vgdisplay", vgName});
        if (returnValue.length() > 0) {
            success = true;
        }
        return success;
    }

    private boolean physicalVolumeExists(String pvName) {
        boolean success = false;
        String returnValue = SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "pvdisplay", pvName});
        if (returnValue.length() > 0) {
            success = true;
        }
        return success;
    }

    private int losetup(String absoluteFileName, String loDevName) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "losetup", loDevName, absoluteFileName});
            StreamConsumer error = new StreamConsumer(proc.getErrorStream());
            StreamConsumer output = new StreamConsumer(proc.getInputStream());
            error.start();
            output.start();
            int errorCode = proc.waitFor();
            output.join();
            LOG.info((Object)("Finished executing: losetup " + loDevName + " " + absoluteFileName));
            LOG.info((Object)("Result of: losetup " + loDevName + " " + absoluteFileName + " stdout: " + output.getReturnValue()));
            LOG.info((Object)("Result of: losetup" + loDevName + " " + absoluteFileName + " return value: " + error.getReturnValue()));
            return errorCode;
        }
        catch (Exception t) {
            LOG.error((Object)t);
            return -1;
        }
    }

    @Override
    public void initialize() throws EucalyptusCloudException {
        File storageRootDir = new File(this.getStorageRootDirectory());
        if (!storageRootDir.exists() && !storageRootDir.mkdirs()) {
            throw new EucalyptusCloudException("Unable to make volume root directory: " + this.getStorageRootDirectory());
        }
        if (!initialized) {
            initialized = true;
        }
    }

    @Override
    public void configure() throws EucalyptusCloudException {
        exportManager.configure();
        LOG.info((Object)("" + StorageInfo.getStorageInfo().getName()));
        this.checkVolumesDir();
    }

    private void checkVolumesDir() {
        String volumesDir = DirectStorageInfo.getStorageInfo().getVolumesDir();
        File volumes = new File(volumesDir);
        if (!volumes.exists()) {
            if (!volumes.mkdirs()) {
                LOG.fatal((Object)("Unable to make volume root directory: " + volumesDir));
            }
        } else if (!volumes.canWrite()) {
            LOG.fatal((Object)("Cannot write to volume root directory: " + volumesDir));
        }
        try {
            SystemUtil.setEucaReadWriteOnly((String)volumesDir);
        }
        catch (EucalyptusCloudException ex) {
            LOG.fatal((Object)ex);
        }
    }

    @Override
    public void cleanVolume(String volumeId) {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo lvmVolInfo = volumeManager.getVolumeInfo(volumeId);
        if (lvmVolInfo != null) {
            String loDevName = lvmVolInfo.getLoDevName();
            volumeManager.unexportVolume(lvmVolInfo);
            String vgName = lvmVolInfo.getVgName();
            String lvName = lvmVolInfo.getLvName();
            String absoluteLVName = "/dev/" + vgName + "/" + lvName;
            try {
                String returnValue = LVMWrapper.removeLogicalVolume(absoluteLVName);
                returnValue = LVMWrapper.removeVolumeGroup(vgName);
                returnValue = LVMWrapper.removePhysicalVolume(loDevName);
                this.removeLoopback(loDevName);
                lvmVolInfo.setLoDevName(null);
            }
            catch (EucalyptusCloudException ex) {
                volumeManager.abort();
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
            }
            volumeManager.remove(lvmVolInfo);
            File volFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + lvmVolInfo.getVolumeId());
            if (volFile.exists() && !volFile.delete()) {
                LOG.error((Object)("Unable to delete: " + volFile.getAbsolutePath() + " for failed volume"));
            }
        }
        volumeManager.finish();
    }

    @Override
    public void cleanSnapshot(String snapshotId) {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo lvmVolInfo = volumeManager.getVolumeInfo(snapshotId);
        if (lvmVolInfo != null) {
            volumeManager.remove(lvmVolInfo);
            File volFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + lvmVolInfo.getVolumeId());
            if (volFile.exists() && !volFile.delete()) {
                LOG.error((Object)("Unable to delete: " + volFile.getAbsolutePath() + " for failed snapshot"));
            }
        }
        volumeManager.finish();
    }

    @Override
    public void unexportVolumeFromAll(String volumeId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo volumeInfo = volumeManager.getVolumeInfo(volumeId);
        if (volumeInfo == null) {
            volumeManager.abort();
            LOG.error((Object)("Cannot unexport volume for all hosts because volume " + volumeId + " not found in db"));
            throw new EucalyptusCloudException("Volume " + volumeId + " not found");
        }
        LOG.debug((Object)("Unexporting volume " + volumeId));
        try {
            this.doUnexport(volumeId);
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)("Unexport failed for volume " + volumeId));
            throw e;
        }
        finally {
            volumeManager.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dupFile(String oldFileName, String newFileName) {
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel out = null;
        FileInputStream fileInputStream = null;
        AbstractInterruptibleChannel in = null;
        try {
            fileOutputStream = new FileOutputStream(new File(newFileName));
            out = fileOutputStream.getChannel();
            fileInputStream = new FileInputStream(new File(oldFileName));
            in = fileInputStream.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    out.close();
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
            if (fileInputStream != null) {
                try {
                    in.close();
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    public String createDuplicateLoopback(String oldRawFileName, String rawFileName) throws EucalyptusCloudException {
        this.dupFile(oldRawFileName, rawFileName);
        return this.createLoopback(rawFileName);
    }

    public String createLoopback(String fileName, int size) throws EucalyptusCloudException {
        this.createEmptyFile(fileName, size);
        if (!new File(fileName).exists()) {
            throw new EucalyptusCloudException("Unable to create file " + fileName);
        }
        return this.createLoopback(fileName);
    }

    public synchronized String createLoopback(String fileName) throws EucalyptusCloudException {
        String loDevName;
        int number_of_retries = 0;
        int status = -1;
        do {
            if ((loDevName = this.findFreeLoopback()).length() <= 0) continue;
            status = this.losetup(fileName, loDevName);
        } while (number_of_retries++ < 256 && status != 0);
        if (status != 0) {
            throw new EucalyptusCloudException("Could not create loopback device for " + fileName + ". Please check the max loop value and permissions");
        }
        return loDevName;
    }

    public int createLoopback(String absoluteFileName, String loDevName) {
        return this.losetup(absoluteFileName, loDevName);
    }

    public String createLoopback(String fileName, long size) throws EucalyptusCloudException {
        this.createAbsoluteEmptyFile(fileName, size);
        if (!new File(fileName).exists()) {
            throw new EucalyptusCloudException("Unable to create file " + fileName);
        }
        return this.createLoopback(fileName);
    }

    public void createEmptyFile(String fileName, long size) throws EucalyptusCloudException {
        this.createAbsoluteEmptyFile(fileName, size);
        if (!new File(fileName).exists()) {
            throw new EucalyptusCloudException("Unable to create file " + fileName);
        }
    }

    public void createLogicalVolume(String volumeId, String loDevName, String vgName, String lvName) throws EucalyptusCloudException {
        String returnValue = LVMWrapper.createPhysicalVolume(loDevName);
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to create physical volume for " + loDevName);
        }
        returnValue = LVMWrapper.createVolumeGroup(loDevName, vgName);
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to create volume group " + vgName + " for " + loDevName);
        }
        returnValue = LVMWrapper.createLogicalVolume(volumeId, vgName, lvName);
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to create logical volume " + lvName + " in volume group " + vgName);
        }
    }

    public void createSnapshotLogicalVolume(String loDevName, String vgName, String lvName, String snapLvName) throws EucalyptusCloudException {
        String returnValue = LVMWrapper.createPhysicalVolume(loDevName);
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to create physical volume for " + loDevName);
        }
        returnValue = LVMWrapper.extendVolumeGroup(loDevName, vgName);
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to extend volume group " + vgName + " for " + loDevName);
        }
        returnValue = LVMWrapper.createSnapshotLogicalVolume(lvName, snapLvName);
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to create snapshot logical volume " + snapLvName + " for volume " + lvName);
        }
    }

    @Override
    public void createVolume(String volumeId, int size) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        ISCSIVolumeInfo lvmVolumeInfo = null;
        lvmVolumeInfo = new ISCSIVolumeInfo();
        volumeManager.finish();
        String rawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + volumeId;
        long absoluteSize = (long)size * 0x40000000L + 0x400000L;
        try {
            String vgName = OverlayManager.generateVGName(volumeId);
            String lvName = OverlayManager.generateLVName(volumeId);
            String loDevName = this.createLoopback(rawFileName, absoluteSize);
            lvmVolumeInfo.setVolumeId(volumeId);
            lvmVolumeInfo.setLoDevName(loDevName);
            this.createLogicalVolume(volumeId, loDevName, vgName, lvName);
            lvmVolumeInfo.setVgName(vgName);
            lvmVolumeInfo.setLvName(lvName);
            lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
            lvmVolumeInfo.setSize(Integer.valueOf(size));
            String absoluteLVName = "/dev/" + vgName + "/" + lvName;
            LVMWrapper.disableLogicalVolume(absoluteLVName);
            this.removeLoopback(loDevName);
            lvmVolumeInfo.setLoDevName(null);
            volumeManager = new DASManager.VolumeMetadataManager();
            volumeManager.add((LVMVolumeInfo)lvmVolumeInfo);
        }
        catch (EucalyptusCloudException ex) {
            String error = "Unable to run command: " + ex.getMessage();
            LOG.error((Object)error);
            throw new EucalyptusCloudException(error);
        }
        finally {
            try {
                if (volumeManager != null) {
                    volumeManager.finish();
                } else {
                    LOG.error((Object)"Cannot commit to db. MetadataManager is null");
                }
            }
            catch (Throwable e) {
                LOG.error((Object)("Volume: " + volumeId + " db commit error: " + e.getMessage()));
            }
        }
    }

    @Override
    public int createVolume(String volumeId, String snapshotId, int size) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
        if (foundSnapshotInfo != null) {
            String status = foundSnapshotInfo.getStatus();
            if (status.equals(StorageProperties.Status.available.toString())) {
                String vgName = OverlayManager.generateVGName(volumeId);
                String lvName = OverlayManager.generateLVName(volumeId);
                String loFileName = foundSnapshotInfo.getLoFileName();
                String snapId = foundSnapshotInfo.getVolumeId();
                LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
                volumeManager.finish();
                try {
                    long absoluteSize;
                    String rawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + volumeId;
                    File snapshotFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + snapId);
                    assert (snapshotFile.exists());
                    if (size <= 0 || size == foundSnapshotInfo.getSize()) {
                        size = (int)(snapshotFile.length() / 0x40000000L);
                        absoluteSize = snapshotFile.length() + 0x400000L;
                    } else {
                        absoluteSize = (long)size * 0x40000000L + 0x400000L;
                    }
                    String loDevName = this.createLoopback(rawFileName, absoluteSize);
                    lvmVolumeInfo.setVolumeId(volumeId);
                    lvmVolumeInfo.setLoDevName(loDevName);
                    this.createLogicalVolume(volumeId, loDevName, vgName, lvName);
                    String absoluteLVName = "/dev/" + vgName + "/" + lvName;
                    this.duplicateLogicalVolume(loFileName, absoluteLVName);
                    lvmVolumeInfo.setVgName(vgName);
                    lvmVolumeInfo.setLvName(lvName);
                    lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
                    lvmVolumeInfo.setSize(Integer.valueOf(size));
                    LVMWrapper.disableLogicalVolume(absoluteLVName);
                    this.removeLoopback(loDevName);
                    lvmVolumeInfo.setLoDevName(null);
                    volumeManager = new DASManager.VolumeMetadataManager();
                    volumeManager.add(lvmVolumeInfo);
                }
                catch (EucalyptusCloudException ex) {
                    String error = "Unable to run command: " + ex.getMessage();
                    LOG.error((Object)error);
                    throw new EucalyptusCloudException(error);
                }
                finally {
                    try {
                        if (volumeManager != null) {
                            volumeManager.finish();
                        } else {
                            LOG.error((Object)"Cannot commit to db. MetadataManager is null");
                        }
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Volume: " + volumeId + " could not commit db transaction. " + e.getMessage()));
                    }
                }
            }
        } else {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find snapshot: " + snapshotId);
        }
        return size;
    }

    @Override
    public void cloneVolume(String volumeId, String parentVolumeId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundVolumeInfo = volumeManager.getVolumeInfo(parentVolumeId);
        if (foundVolumeInfo != null) {
            String vgName = OverlayManager.generateVGName(volumeId);
            String lvName = OverlayManager.generateLVName(volumeId);
            String parentVgName = foundVolumeInfo.getVgName();
            String parentLvName = foundVolumeInfo.getLvName();
            LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
            int size = foundVolumeInfo.getSize();
            volumeManager.finish();
            try {
                String rawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + volumeId;
                File parentVolumeFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + parentVolumeId);
                assert (parentVolumeFile.exists());
                long absoluteSize = parentVolumeFile.length();
                String loDevName = this.createLoopback(rawFileName, absoluteSize);
                lvmVolumeInfo.setLoDevName(loDevName);
                this.createLogicalVolume(volumeId, loDevName, vgName, lvName);
                String absoluteLVName = "/dev/" + vgName + "/" + lvName;
                String absoluteParentLVName = "/dev/" + parentVgName + "/" + parentLvName;
                this.duplicateLogicalVolume(absoluteParentLVName, absoluteLVName);
                try {
                    volumeManager.exportVolume(lvmVolumeInfo, vgName, lvName);
                }
                catch (EucalyptusCloudException ex) {
                    String returnValue = LVMWrapper.removeLogicalVolume(absoluteLVName);
                    returnValue = LVMWrapper.removeVolumeGroup(vgName);
                    returnValue = LVMWrapper.removePhysicalVolume(loDevName);
                    this.removeLoopback(loDevName);
                    lvmVolumeInfo.setLoDevName(null);
                    throw ex;
                }
                lvmVolumeInfo.setVolumeId(volumeId);
                lvmVolumeInfo.setPvName(loDevName);
                lvmVolumeInfo.setVgName(vgName);
                lvmVolumeInfo.setLvName(lvName);
                lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
                lvmVolumeInfo.setSize(Integer.valueOf(size));
                volumeManager = new DASManager.VolumeMetadataManager();
                volumeManager.add(lvmVolumeInfo);
            }
            catch (EucalyptusCloudException ex) {
                volumeManager.abort();
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
                throw new EucalyptusCloudException(error);
            }
            finally {
                if (null != volumeManager) {
                    try {
                        volumeManager.finish();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Error committing to db.", e);
                    }
                }
            }
        }
        volumeManager.abort();
        throw new EucalyptusCloudException("Unable to find volume: " + parentVolumeId);
    }

    @Override
    public void addSnapshot(String snapshotId) throws EucalyptusCloudException {
        String snapshotRawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + snapshotId;
        File snapshotFile = new File(snapshotRawFileName);
        if (!snapshotFile.exists()) {
            throw new EucalyptusCloudException("Snapshot backing file does not exist for: " + snapshotId);
        }
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
        lvmVolumeInfo.setVolumeId(snapshotId);
        lvmVolumeInfo.setLoFileName(snapshotRawFileName);
        lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
        lvmVolumeInfo.setSize(Integer.valueOf((int)(snapshotFile.length() / 0x40000000L)));
        volumeManager.add(lvmVolumeInfo);
        volumeManager.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVolume(String volumeId) throws EucalyptusCloudException {
        LVMVolumeInfo foundLVMVolumeInfo = null;
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        try {
            foundLVMVolumeInfo = volumeManager.getVolumeInfo(volumeId);
        }
        finally {
            volumeManager.finish();
        }
        if (foundLVMVolumeInfo != null) {
            DASManager.VolumeOpMonitor volumeOpMonitor;
            boolean isReadyForDelete = false;
            int retryCount = 0;
            DASManager.VolumeOpMonitor monitor = this.getMonitor(foundLVMVolumeInfo.getVolumeId());
            DASManager.VolumeMetadataManager outerVolumeManager = null;
            do {
                LOG.debug((Object)("Trying to lock volume for export detection" + volumeId));
                volumeOpMonitor = monitor;
                synchronized (volumeOpMonitor) {
                    block30: {
                        DASManager.VolumeMetadataManager volumeManager2 = new DASManager.VolumeMetadataManager();
                        try {
                            foundLVMVolumeInfo = volumeManager2.getVolumeInfo(volumeId);
                            if (exportManager.isExported(foundLVMVolumeInfo)) {
                                LOG.error((Object)("Cannot delete volume " + volumeId + " because it is currently exported"));
                                volumeManager2.finish();
                                break block30;
                            }
                            LOG.debug((Object)("Volume " + volumeId + " is prepped for deletion"));
                            isReadyForDelete = true;
                            break;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error trying to check volume status", (Throwable)e);
                        }
                        finally {
                            if (isReadyForDelete) {
                                outerVolumeManager = volumeManager2;
                            } else {
                                volumeManager2.abort();
                            }
                        }
                    }
                    LOG.debug((Object)("Lap: " + retryCount++));
                }
                if (isReadyForDelete) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    throw new EucalyptusCloudException("Thread interrupted. Failing volume delete for volume " + volumeId);
                }
            } while (!isReadyForDelete && retryCount < 20);
            LOG.debug((Object)("Trying to lock volume for volume deletion" + volumeId));
            volumeOpMonitor = monitor;
            synchronized (volumeOpMonitor) {
                if (isReadyForDelete) {
                    try {
                        LOG.debug((Object)("Deleting volume " + volumeId));
                        File volFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + volumeId);
                        if (volFile.exists() && !volFile.delete()) {
                            LOG.error((Object)("Unable to delete: " + volFile.getAbsolutePath()));
                            throw new EucalyptusCloudException("Unable to delete volume file: " + volFile.getAbsolutePath());
                        }
                        outerVolumeManager.remove(foundLVMVolumeInfo);
                        try {
                            outerVolumeManager.finish();
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error deleting volume " + volumeId + ", failed to commit DB transaction"), (Throwable)e);
                        }
                    }
                    finally {
                        outerVolumeManager.abort();
                    }
                } else {
                    LOG.error((Object)("All attempts to cleanup volume " + volumeId + " failed"));
                    throw new EucalyptusCloudException("Unable to delete volume: " + volumeId + ". All attempts to cleanup the volume failed");
                }
            }
        }
        throw new EucalyptusCloudException("Unable to find volume: " + volumeId);
        this.removeMonitor(volumeId);
    }

    private synchronized void deleteLogicalVolume(String loDevName, String vgName, String absoluteLVName) throws EucalyptusCloudException, EucalyptusCloudException {
        String returnValue;
        if (LVMWrapper.logicalVolumeExists(absoluteLVName) && (returnValue = LVMWrapper.removeLogicalVolume(absoluteLVName)).length() == 0) {
            throw new EucalyptusCloudException("Unable to remove logical volume " + absoluteLVName + " " + returnValue);
        }
        if (this.volumeGroupExists(vgName) && (returnValue = LVMWrapper.removeVolumeGroup(vgName)).length() == 0) {
            throw new EucalyptusCloudException("Unable to remove volume group " + vgName + " " + returnValue);
        }
        if (this.physicalVolumeExists(loDevName) && (returnValue = LVMWrapper.removePhysicalVolume(loDevName)).length() == 0) {
            throw new EucalyptusCloudException("Unable to remove physical volume " + loDevName + " " + returnValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageResource createSnapshot(String volumeId, String snapshotId, String snapshotPointId, Boolean shouldTransferSnapshot) throws EucalyptusCloudException {
        if (snapshotPointId != null) {
            throw new EucalyptusCloudException("Synchronous snapshot points not supported in Overlay storage manager");
        }
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(volumeId);
        FileResource snapInfo = null;
        if (foundLVMVolumeInfo != null) {
            LVMVolumeInfo snapshotInfo = volumeManager.getVolumeInfo();
            snapshotInfo.setVolumeId(snapshotId);
            String vgName = foundLVMVolumeInfo.getVgName();
            String lvName = OverlayManager.generateLVName(snapshotId);
            String absoluteLVName = "/dev/" + vgName + "/" + foundLVMVolumeInfo.getLvName();
            int size = foundLVMVolumeInfo.getSize();
            long snapshotSize = (long)size * 0x40000000L / 2L;
            String rawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + volumeId + Hashes.getRandom((int)6);
            volumeManager.finish();
            try {
                DASManager.VolumeOpMonitor monitor = this.getMonitor(volumeId);
                String absoluteVolLVName = "/dev/" + foundLVMVolumeInfo.getVgName() + "/" + foundLVMVolumeInfo.getLvName();
                String volLoDevName = foundLVMVolumeInfo.getLoDevName();
                boolean tearDown = false;
                DASManager.VolumeOpMonitor volumeOpMonitor = monitor;
                synchronized (volumeOpMonitor) {
                    if (!LVMWrapper.logicalVolumeExists(absoluteVolLVName)) {
                        volLoDevName = this.createLoopback(DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + volumeId);
                        LVMWrapper.enableLogicalVolume(absoluteVolLVName);
                        tearDown = true;
                    }
                    snapshotInfo.setStatus(StorageProperties.Status.pending.toString());
                    snapshotInfo.setSize(Integer.valueOf(size));
                    snapshotInfo.setSnapshotOf(volumeId);
                    volumeManager = new DASManager.VolumeMetadataManager();
                    volumeManager.add(snapshotInfo);
                    volumeManager.finish();
                    String loDevName = this.createLoopback(rawFileName, snapshotSize);
                    this.createSnapshotLogicalVolume(loDevName, vgName, absoluteLVName, lvName);
                    String snapRawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + snapshotId;
                    String absoluteSnapLVName = "/dev/" + vgName + "/" + lvName;
                    this.duplicateLogicalVolume(absoluteSnapLVName, snapRawFileName);
                    String returnValue = LVMWrapper.removeLogicalVolume(absoluteSnapLVName);
                    if (returnValue.length() == 0) {
                        throw new EucalyptusCloudException("Unable to remove logical volume " + absoluteSnapLVName);
                    }
                    returnValue = LVMWrapper.reduceVolumeGroup(vgName, loDevName);
                    if (returnValue.length() == 0) {
                        throw new EucalyptusCloudException("Unable to reduce volume group " + vgName + " logical volume: " + loDevName);
                    }
                    returnValue = LVMWrapper.removePhysicalVolume(loDevName);
                    if (returnValue.length() == 0) {
                        throw new EucalyptusCloudException("Unable to remove physical volume " + loDevName);
                    }
                    returnValue = this.removeLoopback(loDevName);
                    if (!new File(rawFileName).delete()) {
                        LOG.error((Object)("Unable to remove temporary snapshot file: " + rawFileName));
                    }
                    if (tearDown) {
                        LOG.info((Object)("Snapshot complete. Detaching loop device" + volLoDevName));
                        LVMWrapper.disableLogicalVolume(absoluteVolLVName);
                        this.removeLoopback(volLoDevName);
                    }
                    snapInfo = new FileResource(snapshotId, snapRawFileName);
                    volumeManager = new DASManager.VolumeMetadataManager();
                    LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
                    foundSnapshotInfo.setLoFileName(snapRawFileName);
                    foundSnapshotInfo.setStatus(StorageProperties.Status.available.toString());
                    volumeManager.finish();
                }
            }
            catch (EucalyptusCloudException ex) {
                if (volumeManager != null) {
                    volumeManager.abort();
                }
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
                throw new EucalyptusCloudException(error);
            }
        }
        return snapInfo;
    }

    @Override
    public List<String> prepareForTransfer(String snapshotId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(snapshotId);
        ArrayList<String> returnValues = new ArrayList<String>();
        if (foundLVMVolumeInfo == null) {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find snapshot: " + snapshotId);
        }
        returnValues.add(DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + foundLVMVolumeInfo.getVolumeId());
        volumeManager.finish();
        return returnValues;
    }

    @Override
    public void deleteSnapshot(String snapshotId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(snapshotId);
        if (foundLVMVolumeInfo != null) {
            volumeManager.remove(foundLVMVolumeInfo);
            File snapFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + foundLVMVolumeInfo.getVolumeId());
            volumeManager.finish();
            if (snapFile.exists() && !snapFile.delete()) {
                throw new EucalyptusCloudException("Unable to delete: " + snapFile.getAbsolutePath());
            }
        } else {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find snapshot: " + snapshotId);
        }
    }

    @Override
    public void loadSnapshots(List<String> snapshotSet, List<String> snapshotFileNames) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        assert (snapshotSet.size() == snapshotFileNames.size());
        int i = 0;
        for (String snapshotFileName : snapshotFileNames) {
            try {
                String loDevName = this.createLoopback(snapshotFileName);
                LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
                lvmVolumeInfo.setVolumeId(snapshotSet.get(i++));
                lvmVolumeInfo.setLoDevName(loDevName);
                lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
                volumeManager.add(lvmVolumeInfo);
            }
            catch (EucalyptusCloudException ex) {
                volumeManager.abort();
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
                throw new EucalyptusCloudException(error);
            }
        }
        volumeManager.finish();
    }

    @Override
    public void reload() {
        LOG.info((Object)"Initiating SC Reload of iSCSI targets");
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        List<LVMVolumeInfo> volumeInfos = volumeManager.getAllVolumeInfos();
        LOG.info((Object)("SC Reload found " + volumeInfos.size() + " volumes in the DB"));
        for (LVMVolumeInfo foundVolumeInfo : volumeInfos) {
            String loDevName = foundVolumeInfo.getLoDevName();
            if (loDevName == null) continue;
            String loFileName = foundVolumeInfo.getVolumeId();
            LOG.info((Object)("SC Reload: found volume " + loFileName + " was exported at last shutdown. Ensuring export restored"));
            String absoluteLoFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + loFileName;
            if (!new File(absoluteLoFileName).exists()) {
                LOG.error((Object)("SC Reload: Backing volume: " + absoluteLoFileName + " not found. Invalidating volume."));
                foundVolumeInfo.setStatus(StorageProperties.Status.failed.toString());
                continue;
            }
            try {
                String returnValue = this.getLoopback(loDevName);
                if (returnValue.length() <= 0) {
                    LOG.info((Object)("SC Reload: volume " + loFileName + " previously used loopback " + loDevName + ". No conflict detected, reusing same loopback"));
                    this.createLoopback(absoluteLoFileName, loDevName);
                    continue;
                }
                if (!returnValue.contains(loFileName)) {
                    String newLoDev = this.createLoopback(absoluteLoFileName);
                    foundVolumeInfo.setLoDevName(newLoDev);
                    LOG.info((Object)("SC Reload: volume " + loFileName + " previously used loopback " + loDevName + ", but loopback already in used by something else. Using new loopback: " + newLoDev));
                    continue;
                }
                LOG.info((Object)("SC Reload: Detection of loopback for volume " + loFileName + " got " + returnValue + ". Appears that loopback is already in-place. No losetup needed for this volume."));
            }
            catch (EucalyptusCloudException ex) {
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
            }
        }
        try {
            LOG.info((Object)"SC Reload: Scanning volume groups. This might take a little while...");
            LVMWrapper.scanVolumeGroups();
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)e);
        }
        LOG.info((Object)"SC Reload: ensuring configured volumes are exported via iSCSI targets");
        for (LVMVolumeInfo foundVolumeInfo : volumeInfos) {
            try {
                if (foundVolumeInfo.getLoDevName() != null && foundVolumeInfo.getVgName() != null) {
                    LOG.info((Object)("SC Reload: exporting " + foundVolumeInfo.getVolumeId() + " in VG: " + foundVolumeInfo.getVgName()));
                    volumeManager.exportVolume(foundVolumeInfo);
                    continue;
                }
                LOG.info((Object)("SC Reload: no loopback configured for " + foundVolumeInfo.getVolumeId() + ". Skipping export for this volume."));
            }
            catch (EucalyptusCloudException ex) {
                LOG.error((Object)("SC Reload: Unable to reload volume: " + foundVolumeInfo.getVolumeId() + ex.getMessage()));
            }
        }
        volumeManager.finish();
    }

    @Override
    public int getSnapshotSize(String snapshotId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo(snapshotId);
        if (lvmVolumeInfo != null) {
            int snapSize = lvmVolumeInfo.getSize();
            volumeManager.finish();
            return snapSize;
        }
        volumeManager.abort();
        return 0;
    }

    @Override
    public void finishVolume(String snapshotId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
        if (null != foundSnapshotInfo) {
            foundSnapshotInfo.setStatus(StorageProperties.Status.available.toString());
        }
        volumeManager.finish();
    }

    @Override
    public StorageResource prepareSnapshot(String snapshotId, int sizeExpected, long actualSizeInMB) throws EucalyptusCloudException {
        String deviceName = null;
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
        if (null == foundSnapshotInfo) {
            LVMVolumeInfo snapshotInfo = volumeManager.getVolumeInfo();
            snapshotInfo.setStatus(StorageProperties.Status.pending.toString());
            snapshotInfo.setVolumeId(snapshotId);
            snapshotInfo.setSize(Integer.valueOf(sizeExpected));
            snapshotInfo.setLoFileName(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + snapshotId);
            deviceName = snapshotInfo.getLoFileName();
            volumeManager.add(snapshotInfo);
        }
        volumeManager.finish();
        return new FileResource(snapshotId, deviceName);
    }

    @Override
    public ArrayList<ComponentProperty> getStorageProps() {
        String alias;
        String root;
        ArrayList componentProperties = null;
        ConfigurableClass configurableClass = StorageInfo.class.getAnnotation(ConfigurableClass.class);
        if (configurableClass != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
        }
        if ((configurableClass = DirectStorageInfo.class.getAnnotation(ConfigurableClass.class)) != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            if (componentProperties == null) {
                componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
            } else {
                componentProperties.addAll(PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias));
            }
        }
        return componentProperties;
    }

    @Override
    public void setStorageProps(ArrayList<ComponentProperty> storageProps) {
        for (ComponentProperty prop : storageProps) {
            try {
                ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)prop.getQualifiedName());
                entry.setValue(prop.getValue());
            }
            catch (ConfigurablePropertyException | IllegalAccessException e) {
                LOG.error((Object)e, e);
            }
        }
        this.checkVolumesDir();
    }

    @Override
    public String getStorageRootDirectory() {
        return DirectStorageInfo.getStorageInfo().getVolumesDir();
    }

    @Override
    public String getVolumePath(String volumeId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo volInfo = volumeManager.getVolumeInfo(volumeId);
        if (volInfo != null) {
            String volumePath = "/dev" + File.separator + volInfo.getVgName() + File.separator + volInfo.getLvName();
            volumeManager.finish();
            return volumePath;
        }
        volumeManager.abort();
        throw new EntityNotFoundException("Unable to find volume with id: " + volumeId);
    }

    @Override
    public void importVolume(String volumeId, String volumePath, int size) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo volInfo = volumeManager.getVolumeInfo(volumeId);
        if (volInfo != null) {
            volumeManager.finish();
            throw new EucalyptusCloudException("Volume " + volumeId + " already exists. Import failed.");
        }
        volumeManager.finish();
        this.createVolume(volumeId, size);
        volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo volumeInfo = volumeManager.getVolumeInfo(volumeId);
        if (volumeInfo == null) {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find volume with id: " + volumeId);
        }
        SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + volumePath, "of=/dev" + File.separator + volumeInfo.getVgName() + File.separator + volumeInfo.getLvName(), "bs=1M"});
    }

    @Override
    public String getSnapshotPath(String snapshotId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo volInfo = volumeManager.getVolumeInfo(snapshotId);
        if (volInfo != null) {
            String snapPath = volInfo.getLoFileName();
            volumeManager.finish();
            return snapPath;
        }
        volumeManager.abort();
        throw new EntityNotFoundException("Unable to find snapshot with id: " + snapshotId);
    }

    @Override
    public void importSnapshot(String snapshotId, String volumeId, String snapPath, int size) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo snapInfo = volumeManager.getVolumeInfo(snapshotId);
        if (snapInfo != null) {
            volumeManager.finish();
            throw new EucalyptusCloudException("Snapshot " + snapshotId + " already exists. Import failed.");
        }
        volumeManager.finish();
        String snapFileName = this.getStorageRootDirectory() + File.separator + snapshotId;
        SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + snapPath, "of=" + snapFileName, "bs=1M"});
        volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo snapshotInfo = volumeManager.getVolumeInfo();
        snapshotInfo.setVolumeId(snapshotId);
        snapshotInfo.setLoFileName(snapFileName);
        snapshotInfo.setSize(Integer.valueOf(size));
        snapshotInfo.setSnapshotOf(volumeId);
        volumeManager.add(snapshotInfo);
        volumeManager.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException {
        LVMVolumeInfo lvmVolumeInfo = null;
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        try {
            lvmVolumeInfo = volumeManager.getVolumeInfo(volumeId);
        }
        finally {
            volumeManager.finish();
        }
        if (lvmVolumeInfo != null) {
            DASManager.VolumeOpMonitor monitor;
            String rawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + "/" + volumeId;
            DASManager.VolumeOpMonitor volumeOpMonitor = monitor = this.getMonitor(volumeId);
            synchronized (volumeOpMonitor) {
                DASManager.VolumeMetadataManager volumeManager2 = new DASManager.VolumeMetadataManager();
                try {
                    lvmVolumeInfo = volumeManager2.getVolumeInfo(volumeId);
                    String loDevName = lvmVolumeInfo.getLoDevName();
                    if (loDevName == null) {
                        try {
                            loDevName = this.createLoopback(rawFileName);
                            lvmVolumeInfo.setLoDevName(loDevName);
                        }
                        catch (EucalyptusCloudException ex) {
                            LOG.error((Object)("Unable to create loop back device for " + volumeId), (Throwable)ex);
                            throw ex;
                        }
                    }
                    String vgName = lvmVolumeInfo.getVgName();
                    String lvName = lvmVolumeInfo.getLvName();
                    String absoluteLVName = "/dev/" + vgName + "/" + lvName;
                    LVMWrapper.enableLogicalVolume(absoluteLVName);
                    try {
                        volumeManager2.exportVolume(lvmVolumeInfo, vgName, lvName);
                        lvmVolumeInfo.setCleanup(Boolean.valueOf(false));
                    }
                    catch (EucalyptusCloudException ex) {
                        LOG.error((Object)("Unable to export volume " + volumeId), (Throwable)ex);
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to attach volume " + volumeId), (Throwable)ex);
                    throw new EucalyptusCloudException("Failed to attach volume " + volumeId, (Throwable)ex);
                }
                finally {
                    try {
                        volumeManager2.finish();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable to commit the database transaction after an attempt to attach volume " + volumeId), (Throwable)e);
                    }
                }
            }
        }
        return this.getVolumeConnectionString(volumeId);
    }

    @Override
    public boolean getFromBackend(String snapshotId, int size) throws EucalyptusCloudException {
        return false;
    }

    @Override
    public void checkVolume(String volumeId) throws EucalyptusCloudException {
        DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
        LVMVolumeInfo lvmVolInfo = volumeManager.getVolumeInfo(volumeId);
        if (lvmVolInfo != null && !new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + lvmVolInfo.getVolumeId()).exists()) {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find backing volume for: " + volumeId);
        }
        volumeManager.finish();
    }

    @Override
    public List<CheckerTask> getCheckers() {
        ArrayList<CheckerTask> checkers = new ArrayList<CheckerTask>();
        return checkers;
    }

    @Override
    public String createSnapshotPoint(String volumeId, String snapshotId) throws EucalyptusCloudException {
        return null;
    }

    @Override
    public void deleteSnapshotPoint(String volumeId, String snapshotId, String snapshotPointId) throws EucalyptusCloudException {
        throw new EucalyptusCloudException("Synchronous snapshot points not supported in Overlay storage manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnexport(String volumeId) throws EucalyptusCloudException {
        try {
            DASManager.VolumeOpMonitor monitor;
            DASManager.VolumeMetadataManager volumeManager = new DASManager.VolumeMetadataManager();
            LVMVolumeInfo volume = volumeManager.getVolumeInfo(volumeId);
            DASManager.VolumeOpMonitor volumeOpMonitor = monitor = this.getMonitor(volume.getVolumeId());
            synchronized (volumeOpMonitor) {
                try {
                    LOG.info((Object)("Cleaning up volume: " + volume.getVolumeId()));
                    String path = "/dev/" + volume.getVgName() + "/" + volume.getLvName();
                    try {
                        if (LVMWrapper.logicalVolumeExists(path)) {
                            LOG.debug((Object)("Found logical volume at " + path + " for " + volume.getVolumeId() + ". Now cleaning up"));
                            exportManager.cleanup(volume);
                        } else {
                            LOG.debug((Object)("Failed to find logical volume at " + path + " for " + volume.getVolumeId() + ". Skipping cleanup for tgt and lvm"));
                        }
                    }
                    catch (EucalyptusCloudException ee) {
                        LOG.error((Object)("Error cleaning up volume iscsi state " + volume.getVolumeId()), (Throwable)ee);
                        throw ee;
                    }
                    finally {
                        volumeManager.finish();
                    }
                    volumeManager = new DASManager.VolumeMetadataManager();
                    try {
                        volume = volumeManager.getVolumeInfo(volumeId);
                        String loDevName = volume.getLoDevName();
                        if (loDevName != null && volume != null) {
                            if (!volumeManager.areSnapshotsPending(volume.getVolumeId())) {
                                LVMWrapper.disableLogicalVolume(path);
                                LOG.info((Object)("Detaching loop device: " + loDevName + " for volume " + volume.getVolumeId()));
                                this.removeLoopback(loDevName);
                                volume.setLoDevName(null);
                                LOG.info((Object)("Done cleaning up: " + volume.getVolumeId()));
                                volume.setCleanup(Boolean.valueOf(false));
                            } else {
                                LOG.info((Object)"Snapshot in progress. Not detaching loop device.");
                            }
                        }
                    }
                    catch (EucalyptusCloudException e) {
                        LOG.error((Object)e, (Throwable)e);
                        throw e;
                    }
                    finally {
                        volumeManager.finish();
                    }
                }
                finally {
                    monitor.notifyAll();
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Error unexporting " + volumeId + " from all hosts"), (Throwable)ex);
            throw new EucalyptusCloudException((Throwable)ex);
        }
    }
}

