/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.StorageExportManager;
import com.eucalyptus.blockstorage.TGTService;
import com.eucalyptus.blockstorage.TGTServiceUsingTGTWrapper;
import com.eucalyptus.blockstorage.TGTWrapper;
import com.eucalyptus.blockstorage.entities.CHAPUserInfo;
import com.eucalyptus.blockstorage.entities.DirectStorageInfo;
import com.eucalyptus.blockstorage.entities.ISCSIMetaInfo;
import com.eucalyptus.blockstorage.entities.ISCSIVolumeInfo;
import com.eucalyptus.blockstorage.entities.LVMVolumeInfo;
import com.eucalyptus.blockstorage.util.BlockStorageUtilSvc;
import com.eucalyptus.blockstorage.util.BlockStorageUtilSvcImpl;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.EucalyptusCloudException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ISCSIManager
implements StorageExportManager {
    private static Logger LOG = Logger.getLogger(ISCSIManager.class);
    protected TGTService tgtService;
    protected BlockStorageUtilSvc blockStorageUtilSvc;

    public ISCSIManager() {
        this.tgtService = new TGTServiceUsingTGTWrapper();
        this.blockStorageUtilSvc = new BlockStorageUtilSvcImpl();
    }

    public ISCSIManager(TGTService tgtService, BlockStorageUtilSvc blockStorageUtilSvc) {
        this.tgtService = tgtService;
        this.blockStorageUtilSvc = blockStorageUtilSvc;
    }

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
        this.tgtService.precheckService(timeout);
    }

    @Override
    public void check() throws EucalyptusCloudException {
        Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
        TGTWrapper.checkService(timeout);
    }

    public void addUser(String username, String password) throws EucalyptusCloudException {
        Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
        this.tgtService.addUser(username, password, timeout);
    }

    public void deleteUser(String username) throws EucalyptusCloudException {
        Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
        this.tgtService.deleteUser(username, timeout);
    }

    public void exportTarget(String volumeId, int tid, String name, int lun, String path, String user) throws EucalyptusCloudException {
        LOG.debug((Object)("Exporting " + volumeId + " as target: " + tid + "," + name + "," + lun + "," + path + "," + user));
        this.checkAndAddUser();
        Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
        if (this.tgtService.targetExists(volumeId, tid, path, timeout)) {
            LOG.debug((Object)("Target " + tid + " already exists for " + volumeId + " with path " + path + " no need to export again"));
            return;
        }
        try {
            LOG.debug((Object)("Creating target " + tid + " for " + volumeId));
            this.tgtService.createTarget(volumeId, tid, name, timeout);
            LOG.debug((Object)("Creating lun " + lun + " for " + volumeId));
            this.tgtService.createLun(volumeId, tid, lun, path, timeout);
            LOG.debug((Object)("Binding user " + user + " for " + volumeId));
            this.tgtService.bindUser(volumeId, user, tid, timeout);
            LOG.debug((Object)("Binding target " + tid + " for " + volumeId));
            this.tgtService.bindTarget(volumeId, tid, timeout);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed creating target " + tid + " for " + volumeId));
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public void unexportTarget(String volumeId, int tid, int lun, String path) throws EucalyptusCloudException {
        int opMaxRetry = 3;
        try {
            Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
            LOG.debug((Object)("Unexport target: tid=" + tid + ",lun=" + lun + " for " + volumeId));
            if (!this.tgtService.targetExists(volumeId, tid, path, timeout)) {
                LOG.info((Object)("Volume: " + volumeId + " Target: " + tid + " not found, cannot unexport it."));
                return;
            }
            LOG.info((Object)("Attempting to unexport target: " + tid));
            LOG.debug((Object)("Unbinding target " + tid + " for " + volumeId));
            this.tgtService.unbindTarget(volumeId, tid, timeout);
            int retryCount = 0;
            while (true) {
                try {
                    LOG.debug((Object)("Deleting lun " + lun + " on target " + tid + " for " + volumeId));
                    this.tgtService.deleteLun(volumeId, tid, lun, timeout);
                }
                catch (TGTWrapper.ResourceNotFoundException e) {
                    LOG.warn((Object)("Resource not found when deleting lun for " + volumeId + ". Continuing unexport"), (Throwable)((Object)e));
                }
                catch (EucalyptusCloudException e) {
                    LOG.warn((Object)("Volume " + volumeId + " Unable to delete lun for target: " + tid));
                    Thread.sleep(1000L);
                    if (retryCount++ < 3) continue;
                }
                break;
            }
            if (retryCount >= 3) {
                LOG.error((Object)("Volume: " + volumeId + " Gave up deleting the lun for: " + tid));
            }
            retryCount = 0;
            do {
                try {
                    LOG.debug((Object)("Deleting target " + tid + " for " + volumeId));
                    this.tgtService.deleteTarget(volumeId, tid, timeout, false);
                }
                catch (TGTWrapper.ResourceNotFoundException e) {
                    LOG.warn((Object)("Resource not found when deleting target for volume " + volumeId + " Continuing."), (Throwable)((Object)e));
                }
                catch (EucalyptusCloudException e) {
                    LOG.warn((Object)("Volume: " + volumeId + " Unable to delete target: " + tid), (Throwable)e);
                    Thread.sleep(1000L);
                    continue;
                }
                if (!this.tgtService.targetExists(volumeId, tid, null, timeout)) break;
                LOG.warn((Object)("Volume: " + volumeId + " Target: " + tid + " still exists..."));
                Thread.sleep(1000L);
            } while (retryCount++ < 3);
            if (retryCount >= 3 && !this.tgtService.targetHasLun(volumeId, tid, lun, timeout)) {
                LOG.info((Object)("Forcibly deleting volume " + volumeId + " iscsi target " + tid));
                this.tgtService.deleteTarget(volumeId, tid, timeout, true);
                if (this.tgtService.targetExists(volumeId, tid, null, timeout)) {
                    LOG.error((Object)("Volume: " + volumeId + " Target: " + tid + " still exists after forcible deletion"));
                    throw new Exception("Failed to delete iscsi target " + tid + " for volume " + volumeId);
                }
            }
        }
        catch (Exception t) {
            LOG.error((Object)("Unexpected error encountered during unexport process for volume " + volumeId), (Throwable)t);
        }
    }

    @Override
    public void configure() {
        ISCSIMetaInfo metaInfo = new ISCSIMetaInfo(StorageProperties.NAME);
        try (TransactionResource tran = Entities.transactionFor(ISCSIMetaInfo.class);){
            List metaInfoList = Entities.query((Object)metaInfo);
            if (metaInfoList.size() <= 0) {
                metaInfo.setStorePrefix(StorageProperties.STORE_PREFIX);
                metaInfo.setStoreNumber(Integer.valueOf(0));
                metaInfo.setStoreUser("eucalyptus");
                metaInfo.setTid(Integer.valueOf(1));
                Entities.persist((Object)metaInfo);
                tran.commit();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.checkAndAddUser();
    }

    private void checkAndAddUser() {
        block51: {
            try (TransactionResource outter = Entities.transactionFor(CHAPUserInfo.class);){
                CHAPUserInfo userInfo = (CHAPUserInfo)Entities.uniqueResult((Object)new CHAPUserInfo("eucalyptus"));
                outter.commit();
                if (this.checkUser("eucalyptus")) break block51;
                try {
                    this.addUser("eucalyptus", this.blockStorageUtilSvc.decryptSCTargetPassword(userInfo.getEncryptedPassword()));
                }
                catch (EucalyptusCloudException e1) {
                    LOG.error((Object)e1);
                    if (outter != null) {
                        if (var2_4 != null) {
                            try {
                                outter.close();
                            }
                            catch (Throwable x2) {
                                var2_4.addSuppressed(x2);
                            }
                        } else {
                            outter.close();
                        }
                    }
                    return;
                }
            }
            catch (NoSuchElementException ex) {
                boolean addUser = true;
                String encryptedPassword = null;
                try (TransactionResource inner = Entities.transactionFor(CHAPUserInfo.class);){
                    if (this.checkUser("eucalyptus")) {
                        try {
                            LOG.debug((Object)"No DB record found for chapuser although a eucalyptus account exists on SC. Looking for all records with chapuser eucalyptus");
                            CHAPUserInfo userInfo = new CHAPUserInfo("eucalyptus");
                            userInfo.setScName(null);
                            CHAPUserInfo currentUserInfo = (CHAPUserInfo)Entities.uniqueResult((Object)userInfo);
                            if (null != currentUserInfo && null != currentUserInfo.getEncryptedPassword()) {
                                LOG.debug((Object)"Found a DB record, copying the password to the new record");
                                addUser = false;
                                encryptedPassword = currentUserInfo.getEncryptedPassword();
                            }
                        }
                        catch (Exception e1) {
                            LOG.debug((Object)"No old DB records found. The only way is to delete the chapuser and create a fresh account");
                            try {
                                this.deleteUser("eucalyptus");
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Failed to delete chapuser", (Throwable)e);
                            }
                        }
                    }
                    if (addUser) {
                        String password = Hashes.getRandom((int)16);
                        password = password.substring(0, 16);
                        try {
                            this.addUser("eucalyptus", password);
                            encryptedPassword = this.blockStorageUtilSvc.encryptSCTargetPassword(password);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to add chapuser to SC", (Throwable)e);
                            if (inner != null) {
                                if (var5_13 != null) {
                                    try {
                                        inner.close();
                                    }
                                    catch (Throwable x2) {
                                        var5_13.addSuppressed(x2);
                                    }
                                } else {
                                    inner.close();
                                }
                            }
                            return;
                        }
                    }
                    try {
                        Entities.persist((Object)new CHAPUserInfo("eucalyptus", encryptedPassword));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                    inner.commit();
                }
            }
            catch (TransactionException e) {
                LOG.error((Object)e);
            }
        }
    }

    @Override
    public synchronized void allocateTarget(LVMVolumeInfo volumeInfo) throws EucalyptusCloudException {
        if (volumeInfo instanceof ISCSIVolumeInfo) {
            List metaInfoList;
            ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)volumeInfo;
            LOG.debug((Object)("Allocate target: " + iscsiVolumeInfo));
            if (iscsiVolumeInfo.getTid() > -1) {
                LOG.info((Object)("Volume already associated with a tid: " + iscsiVolumeInfo.getTid()));
                return;
            }
            int tid = -1;
            int storeNumber = -1;
            try (TransactionResource tran = Entities.transactionFor(ISCSIMetaInfo.class);){
                metaInfoList = Entities.query((Object)new ISCSIMetaInfo(StorageProperties.NAME));
                if (metaInfoList.size() > 0) {
                    ISCSIMetaInfo foundMetaInfo = (ISCSIMetaInfo)metaInfoList.get(0);
                    storeNumber = foundMetaInfo.getStoreNumber();
                    tid = foundMetaInfo.getTid();
                }
                tran.commit();
            }
            int i = tid;
            Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
            do {
                if (this.tgtService.targetExists(volumeInfo.getVolumeId(), i, null, timeout)) continue;
                tid = i;
                break;
            } while ((i = (i + 1) % Integer.MAX_VALUE) != tid);
            LOG.debug((Object)("Volume " + iscsiVolumeInfo.getVolumeId() + " Target allocation found tid: " + tid));
            if (tid > 0) {
                try (TransactionResource tran = Entities.transactionFor(ISCSIMetaInfo.class);){
                    metaInfoList = Entities.query((Object)new ISCSIMetaInfo(StorageProperties.NAME));
                    if (metaInfoList.size() > 0) {
                        ISCSIMetaInfo foundMetaInfo = (ISCSIMetaInfo)metaInfoList.get(0);
                        foundMetaInfo.setStoreNumber(Integer.valueOf(++storeNumber));
                        foundMetaInfo.setTid(Integer.valueOf(tid + 1));
                        iscsiVolumeInfo.setStoreName(foundMetaInfo.getStorePrefix() + StorageProperties.NAME + ":store" + storeNumber);
                        iscsiVolumeInfo.setStoreUser(foundMetaInfo.getStoreUser());
                        iscsiVolumeInfo.setTid(Integer.valueOf(tid));
                        iscsiVolumeInfo.setLun(Integer.valueOf(1));
                    }
                    tran.commit();
                }
            } else {
                iscsiVolumeInfo.setTid(Integer.valueOf(-1));
                LOG.fatal((Object)("Unable to allocate ISCSI target id for volume " + iscsiVolumeInfo.getVolumeId()));
            }
        }
    }

    private boolean checkUser(String username) {
        try {
            Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
            return this.tgtService.userExists(username, timeout);
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getEncryptedPassword() throws EucalyptusCloudException {
        try (TransactionResource tran = Entities.transactionFor(CHAPUserInfo.class);){
            CHAPUserInfo userInfo = (CHAPUserInfo)Entities.uniqueResult((Object)new CHAPUserInfo("eucalyptus"));
            String encryptedPassword = userInfo.getEncryptedPassword();
            tran.commit();
            String string = this.blockStorageUtilSvc.encryptNodeTargetPassword(this.blockStorageUtilSvc.decryptSCTargetPassword(encryptedPassword), this.blockStorageUtilSvc.getPartitionForLocalService(Storage.class));
            return string;
        }
        catch (TransactionException | NoSuchElementException ex) {
            throw new EucalyptusCloudException("Unable to get CHAP password for: eucalyptus");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cleanup(LVMVolumeInfo volumeInfo) throws EucalyptusCloudException {
        if (volumeInfo instanceof ISCSIVolumeInfo) {
            ISCSIVolumeInfo volInfo = (ISCSIVolumeInfo)volumeInfo;
            try (TransactionResource tran = Entities.transactionFor(ISCSIVolumeInfo.class);){
                ISCSIVolumeInfo volEntity = (ISCSIVolumeInfo)Entities.merge((Object)volInfo);
                if (this.isExported((LVMVolumeInfo)volEntity)) {
                    this.unexportTarget(volEntity.getVolumeId(), volEntity.getTid(), volEntity.getLun(), volEntity.getAbsoluteLVPath());
                    if (this.isExported((LVMVolumeInfo)volEntity)) throw new EucalyptusCloudException("Unable to remove tid: " + volEntity.getTid());
                    volEntity.setTid(Integer.valueOf(-1));
                    volEntity.setLun(Integer.valueOf(-1));
                    volEntity.setStoreName(null);
                } else {
                    volEntity.setTid(Integer.valueOf(-1));
                    volEntity.setLun(Integer.valueOf(-1));
                    volEntity.setStoreName(null);
                    volEntity.setStoreUser(null);
                }
                tran.commit();
                return;
            }
            catch (Exception e) {
                LOG.error((Object)("Something went wrong, exiting iscsi cleanup for volume " + volumeInfo.getVolumeId()));
            }
            return;
        }
        LOG.error((Object)("Unknown volume type for volume " + volumeInfo.getVolumeId() + " - cannot cleanpup"));
        throw new EucalyptusCloudException("Unknown type for volumeInfo in ISCSI cleanup. Did not find ISCSIVolumeInfo as expected");
    }

    @Override
    public void stop() {
        this.tgtService.stop();
    }

    @Override
    public boolean isExported(LVMVolumeInfo volumeInfo) throws EucalyptusCloudException {
        if (volumeInfo instanceof ISCSIVolumeInfo && ((ISCSIVolumeInfo)volumeInfo).getTid() > -1) {
            ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)volumeInfo;
            Long timeout = DirectStorageInfo.getStorageInfo().getTimeoutInMillis();
            return this.tgtService.targetExists(iscsiVolumeInfo.getVolumeId(), iscsiVolumeInfo.getTid(), iscsiVolumeInfo.getAbsoluteLVPath(), timeout);
        }
        return false;
    }
}

