/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.PutMethodWithProgress;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

@Deprecated
public class HttpTransfer {
    private static Logger LOG = Logger.getLogger(HttpTransfer.class);
    protected HttpClient httpClient;
    protected HttpMethodBase method;
    protected static final String EUCA2_AUTH_ID = "EUCA2-RSA-SHA256";
    protected static final String EUCA2_AUTH_HEADER_NAME = "Authorization";
    protected static final String ISO_8601_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String EUCALYPTUS_OPERATION = "EucaOperation";
    private static final String EUCALYPTUS_HEADER = "EucaHeader";

    public static void signEucaInternal(HttpMethodBase httpBaseRequest) {
        StringBuilder canonicalRequest = new StringBuilder();
        String canonicalURI = null;
        String verb = httpBaseRequest.getName();
        canonicalURI = httpBaseRequest.getPath();
        String canonicalQuery = HttpTransfer.calcCanonicalQuery(httpBaseRequest);
        String[] processedHeaders = HttpTransfer.getCanonicalAndSignedHeaders(httpBaseRequest);
        String canonicalHeaders = processedHeaders[0];
        String signedHeaders = processedHeaders[1];
        canonicalRequest.append(verb).append('\n');
        canonicalRequest.append(canonicalURI).append('\n');
        canonicalRequest.append(canonicalQuery).append('\n');
        canonicalRequest.append(canonicalHeaders).append('\n');
        canonicalRequest.append(signedHeaders);
        StringBuilder authHeader = new StringBuilder(EUCA2_AUTH_ID);
        String signature = null;
        String fingerprint = null;
        try {
            SystemCredentials.Credentials ccCreds = SystemCredentials.lookup(Storage.class);
            PrivateKey ccPrivateKey = ccCreds.getPrivateKey();
            fingerprint = ccCreds.getCertFingerprint();
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(ccPrivateKey);
            LOG.debug((Object)("Signing canonical request: " + canonicalRequest.toString()));
            sign.update(canonicalRequest.toString().getBytes());
            byte[] sig = sign.sign();
            signature = new String(Base64.encode((byte[])sig));
        }
        catch (Exception ex) {
            LOG.error((Object)"Signing error while signing request", (Throwable)ex);
        }
        authHeader.append(" ").append(fingerprint.toLowerCase()).append(" ").append(signedHeaders.toString()).append(" ").append(signature);
        httpBaseRequest.addRequestHeader(EUCA2_AUTH_HEADER_NAME, authHeader.toString());
    }

    private static String calcCanonicalQuery(HttpMethodBase httpBaseRequest) {
        StringBuilder canonicalQuery = new StringBuilder();
        String tmpQuery = httpBaseRequest.getQueryString();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)tmpQuery)) {
            String[] rawQueryParams = tmpQuery.split("&");
            Object[] queryParamNames = new String[rawQueryParams.length];
            String[] tmpKV = null;
            int i = 0;
            for (String paramKV : rawQueryParams) {
                tmpKV = paramKV.split("=");
                queryParamNames[i++] = tmpKV[0];
                if (tmpKV.length == 2) {
                    parameters.put(tmpKV[0], tmpKV[1]);
                    continue;
                }
                parameters.put(tmpKV[0], "");
            }
            Arrays.sort(queryParamNames);
            for (Object paramName : queryParamNames) {
                canonicalQuery.append((String)paramName).append('=');
                if (parameters.get(paramName) != null) {
                    canonicalQuery.append((String)parameters.get(paramName));
                } else {
                    canonicalQuery.append("");
                }
                canonicalQuery.append('&');
            }
            if (canonicalQuery.length() > 0) {
                canonicalQuery.deleteCharAt(canonicalQuery.length() - 1);
            }
        }
        return canonicalQuery.toString();
    }

    private static String[] getCanonicalAndSignedHeaders(HttpMethodBase httpBaseRequest) {
        try {
            httpBaseRequest.addRequestHeader("Host", httpBaseRequest.getURI().getHost() + ":" + httpBaseRequest.getURI().getPort());
        }
        catch (URIException e) {
            LOG.error((Object)"Could not add Host header for canonical headers during authorization header creation in HTTP client: ", (Throwable)e);
            return null;
        }
        Header[] headers = httpBaseRequest.getRequestHeaders();
        StringBuilder signedHeaders = new StringBuilder();
        StringBuilder canonicalHeaders = new StringBuilder();
        if (headers != null) {
            Arrays.sort(headers, new Comparator<Header>(){

                @Override
                public int compare(Header arg0, Header arg1) {
                    return arg0.getName().toLowerCase().compareTo(arg1.getName().toLowerCase());
                }
            });
            for (Header header : headers) {
                signedHeaders.append(header.getName().toLowerCase()).append(';');
                canonicalHeaders.append(header.getName().toLowerCase()).append(':').append(header.getValue().trim()).append('\n');
            }
            if (signedHeaders.length() > 0) {
                signedHeaders.deleteCharAt(signedHeaders.length() - 1);
            }
            if (canonicalHeaders.length() > 0) {
                canonicalHeaders.deleteCharAt(canonicalHeaders.length() - 1);
            }
        }
        String[] result = new String[]{canonicalHeaders.toString(), signedHeaders.toString()};
        return result;
    }

    public HttpMethodBase constructHttpMethod(String verb, String addr, String eucaOperation, String eucaHeader, boolean signRequest) {
        String date = DateUtil.formatDate((Date)new Date(), (String)ISO_8601_FORMAT);
        String httpVerb = verb;
        String addrPath = null;
        URI addrUri = null;
        try {
            addrUri = new URL(addr).toURI();
            addrPath = addrUri.getPath().toString();
            String query = addrUri.getQuery();
            if (query != null) {
                addrPath = addrPath + "?" + query;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
        Object method = null;
        method = httpVerb.equals("PUT") ? new PutMethodWithProgress(addr) : (httpVerb.equals("DELETE") ? new DeleteMethod(addr) : new GetMethod(addr));
        method.setRequestHeader("Date", date);
        method.setRequestHeader(EUCALYPTUS_OPERATION, eucaOperation);
        if (eucaHeader != null) {
            method.setRequestHeader(EUCALYPTUS_HEADER, eucaHeader);
        }
        if (signRequest) {
            HttpTransfer.signEucaInternal((HttpMethodBase)method);
        }
        return method;
    }

    public void abortTransfer() throws EucalyptusCloudException {
        if (this.httpClient != null && this.method != null) {
            this.method.abort();
            this.method.releaseConnection();
        }
    }
}

