/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.blockstorage.HttpTransfer;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataMessage;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Logger;

@Deprecated
public class HttpReader
extends HttpTransfer {
    private static Logger LOG = Logger.getLogger(HttpReader.class);
    private LinkedBlockingQueue<ObjectStorageDataMessage> getQueue;
    private File file;
    private String tempPath;
    private boolean compressed;

    public HttpReader(String path, LinkedBlockingQueue<ObjectStorageDataMessage> getQueue, File file, String eucaOperation, String eucaHeader) {
        this.getQueue = getQueue;
        this.file = file;
        this.httpClient = new HttpClient();
        String httpVerb = "GET";
        String addr = StorageProperties.WALRUS_URL + "/" + path;
        this.method = this.constructHttpMethod(httpVerb, addr, eucaOperation, eucaHeader, true);
    }

    public HttpReader(String path, LinkedBlockingQueue<ObjectStorageDataMessage> getQueue, File file, String eucaOperation, String eucaHeader, boolean compressed, String tempPath) {
        this(path, getQueue, file, eucaOperation, eucaHeader);
        this.compressed = compressed;
        this.tempPath = tempPath;
    }

    public String getResponseAsString() {
        try {
            int bytesRead;
            this.httpClient.executeMethod((HttpMethod)this.method);
            InputStream inputStream = this.compressed ? new GZIPInputStream(this.method.getResponseBodyAsStream()) : this.method.getResponseBodyAsStream();
            String responseString = "";
            byte[] bytes = new byte[StorageProperties.TRANSFER_CHUNK_SIZE];
            while ((bytesRead = inputStream.read(bytes)) > 0) {
                responseString = responseString + new String(bytes, 0, bytesRead);
            }
            this.method.releaseConnection();
            return responseString;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResponseToFile() {
        block29: {
            byte[] bytes = new byte[StorageProperties.TRANSFER_CHUNK_SIZE];
            FileOutputStream fileOutputStream = null;
            FilterOutputStream bufferedOut = null;
            try {
                int bytesRead;
                File outFile = null;
                File outFileUncompressed = null;
                if (this.compressed) {
                    String outFileNameUncompressed = this.tempPath + File.pathSeparator + this.file.getName() + Hashes.getRandom((int)16);
                    outFileUncompressed = new File(outFileNameUncompressed);
                    outFile = new File(outFileNameUncompressed + ".gz");
                } else {
                    outFile = this.file;
                }
                this.httpClient.executeMethod((HttpMethod)this.method);
                InputStream httpIn = this.method.getResponseBodyAsStream();
                fileOutputStream = new FileOutputStream(outFile);
                bufferedOut = new BufferedOutputStream(fileOutputStream);
                while ((bytesRead = httpIn.read(bytes)) > 0) {
                    ((BufferedOutputStream)bufferedOut).write(bytes, 0, bytesRead);
                }
                bufferedOut.close();
                if (!this.compressed) break block29;
                try {
                    Runtime rt = Runtime.getRuntime();
                    Process proc = rt.exec(new String[]{"/bin/gunzip", outFile.getAbsolutePath()});
                    StreamConsumer error = new StreamConsumer(proc.getErrorStream());
                    StreamConsumer output = new StreamConsumer(proc.getInputStream());
                    error.start();
                    output.start();
                    output.join();
                    error.join();
                }
                catch (Exception t) {
                    LOG.error((Object)t);
                }
                if (outFileUncompressed != null && !outFileUncompressed.renameTo(this.file)) {
                    LOG.error((Object)("Unable to uncompress: " + outFile.getAbsolutePath()));
                    return;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            finally {
                this.method.releaseConnection();
                if (bufferedOut != null) {
                    try {
                        bufferedOut.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResponseToQueue() {
        byte[] bytes = new byte[StorageProperties.TRANSFER_CHUNK_SIZE];
        try {
            int bytesRead;
            this.httpClient.executeMethod((HttpMethod)this.method);
            InputStream httpIn = this.method.getResponseBodyAsStream();
            this.getQueue.add(ObjectStorageDataMessage.StartOfData((long)0L));
            while ((bytesRead = httpIn.read(bytes)) > 0) {
                this.getQueue.add(ObjectStorageDataMessage.DataMessage((byte[])bytes, (int)bytesRead));
            }
            this.getQueue.add(ObjectStorageDataMessage.EOF());
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        finally {
            this.method.releaseConnection();
        }
    }

    public void run() {
        if (this.getQueue != null) {
            this.getResponseToQueue();
        } else if (this.file != null) {
            this.getResponseToFile();
        }
    }

    public String getResponseHeader(String headerName) {
        try {
            this.httpClient.executeMethod((HttpMethod)this.method);
            Header value = this.method.getResponseHeader(headerName);
            this.method.releaseConnection();
            if (value != null) {
                return value.getValue();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return null;
    }
}

