/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.blockstorage.FileResource;
import com.eucalyptus.blockstorage.ISCSIManager;
import com.eucalyptus.blockstorage.LVMWrapper;
import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.blockstorage.StorageExportManager;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.entities.DASInfo;
import com.eucalyptus.blockstorage.entities.DirectStorageInfo;
import com.eucalyptus.blockstorage.entities.ISCSIVolumeInfo;
import com.eucalyptus.blockstorage.entities.LVMVolumeInfo;
import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.util.EucalyptusCloudException;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

@StorageManagers.StorageManagerProperty(value="das")
public class DASManager
implements LogicalStorageManager {
    private static Logger LOG = Logger.getLogger(DASManager.class);
    public static final String lvmRootDirectory = "/dev";
    protected static final long LVM_HEADER_LENGTH = 0x400000L;
    public static final String PATH_SEPARATOR = "/";
    public static boolean initialized = false;
    public static final int MAX_LOOP_DEVICES = 256;
    public static final String EUCA_ROOT_WRAPPER = BaseDirectory.LIBEXEC.toString() + "/euca_rootwrap";
    public static final String EUCA_VAR_RUN_PATH = System.getProperty("euca.run.dir");
    public static final StorageExportManager exportManager = new ISCSIManager();
    private static String volumeGroup;
    protected ConcurrentHashMap<String, VolumeOpMonitor> volumeOps;

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        if (!new File(EUCA_ROOT_WRAPPER).exists()) {
            throw new EucalyptusCloudException("root wrapper (euca_rootwrap) does not exist in " + EUCA_ROOT_WRAPPER);
        }
        File varDir = new File(EUCA_VAR_RUN_PATH);
        if (!varDir.exists()) {
            varDir.mkdirs();
        }
        try {
            String returnValue = LVMWrapper.getLvmVersion();
            if (returnValue.length() == 0) {
                throw new EucalyptusCloudException("Is lvm installed?");
            }
            LOG.debug((Object)("lvm version: " + returnValue));
            if (exportManager != null) {
                exportManager.checkPreconditions();
            }
        }
        catch (EucalyptusCloudException ex) {
            String error = "Unable to run command: " + ex.getMessage();
            LOG.error((Object)error);
            throw new EucalyptusCloudException(error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateVolumeGroup() throws EucalyptusCloudException {
        if (volumeGroup != null) return;
        String dasDevice = DASInfo.getStorageInfo().getDASDevice();
        if (dasDevice == null) throw new EucalyptusCloudException("DAS partition not yet configured. Please specify partition.");
        try {
            boolean volumeGroupFound = false;
            String returnValue = null;
            try {
                returnValue = LVMWrapper.getVolumeGroup(dasDevice);
                if (returnValue.length() > 0) {
                    volumeGroupFound = true;
                }
            }
            catch (EucalyptusCloudException e) {
                LOG.warn((Object)e);
            }
            if (volumeGroupFound) {
                Pattern volumeGroupPattern = Pattern.compile("(?s:.*VG Name)(.*)\n.*");
                Matcher m = volumeGroupPattern.matcher(returnValue);
                if (!m.find()) throw new EucalyptusCloudException("Not a volume group: " + dasDevice);
                volumeGroup = m.group(1).trim();
                return;
            }
            boolean physicalVolumeGroupFound = false;
            try {
                returnValue = LVMWrapper.getPhysicalVolume(dasDevice);
                if (returnValue.matches("(?s:.*)PV Name.*" + dasDevice + "(?s:.*)")) {
                    physicalVolumeGroupFound = true;
                }
            }
            catch (EucalyptusCloudException e) {
                LOG.warn((Object)e);
            }
            if (!physicalVolumeGroupFound && (returnValue = LVMWrapper.createPhysicalVolume(dasDevice)).length() == 0) {
                throw new EucalyptusCloudException("Unable to create physical volume on device: " + dasDevice);
            }
            returnValue = LVMWrapper.getPhysicalVolumeVerbose(dasDevice);
            if (returnValue.matches("(?s:.*)PV Name.*" + dasDevice + "(?s:.*)")) {
                Pattern volumeGroupPattern = Pattern.compile("(?s:.*VG Name)(.*)\n.*");
                Matcher m = volumeGroupPattern.matcher(returnValue);
                if (m.find()) {
                    volumeGroup = m.group(1).trim();
                }
                if (volumeGroup != null && volumeGroup.length() != 0 || (returnValue = LVMWrapper.createVolumeGroup(dasDevice, volumeGroup = DASManager.generateVGName(Hashes.getRandom((int)10)))).length() != 0) return;
                throw new EucalyptusCloudException("Unable to create volume group: " + volumeGroup + " physical volume: " + dasDevice);
            } else {
                Pattern volumeGroupPattern = Pattern.compile("(?s:.*VG Name)(.*)\n.*");
                Matcher m = volumeGroupPattern.matcher(returnValue);
                if (!m.find()) throw new EucalyptusCloudException("Unable to get volume group for physical volume: " + dasDevice);
                volumeGroup = m.group(1).trim();
            }
            return;
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    protected String duplicateLogicalVolume(String oldLvName, String newLvName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "dd", "if=" + oldLvName, "of=" + newLvName, "bs=1M"});
    }

    protected String createFile(String fileName, long size) throws EucalyptusCloudException {
        if (!DirectStorageInfo.getStorageInfo().getZeroFillVolumes().booleanValue()) {
            return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "dd", "if=/dev/zero", "of=" + fileName, "count=1", "bs=1M", "seek=" + (size - 1L)});
        }
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "dd", "if=/dev/zero", "of=" + fileName, "count=" + size, "bs=1M"});
    }

    protected String createEmptyFile(String fileName, int size) throws EucalyptusCloudException {
        long fileSize = size * 1024;
        return this.createFile(fileName, fileSize);
    }

    public String createAbsoluteEmptyFile(String fileName, long size) throws EucalyptusCloudException {
        return this.createFile(fileName, size /= 0x100000L);
    }

    @Override
    public void initialize() throws EucalyptusCloudException {
        if (!initialized) {
            initialized = true;
        }
    }

    @Override
    public void configure() throws EucalyptusCloudException {
        exportManager.configure();
        StorageInfo.getStorageInfo();
        DirectStorageInfo.getStorageInfo();
        DASInfo.getStorageInfo();
    }

    @Override
    public void startupChecks() {
        this.reload();
    }

    @Override
    public void cleanVolume(String volumeId) {
        block4: {
            try {
                this.updateVolumeGroup();
                VolumeMetadataManager volumeManager = new VolumeMetadataManager();
                LVMVolumeInfo lvmVolInfo = volumeManager.getVolumeInfo(volumeId);
                if (lvmVolInfo == null) break block4;
                volumeManager.unexportVolume(lvmVolInfo);
                String lvName = lvmVolInfo.getLvName();
                String absoluteLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + lvName;
                try {
                    String string = LVMWrapper.removeLogicalVolume(absoluteLVName);
                }
                catch (EucalyptusCloudException ex) {
                    volumeManager.abort();
                    String error = "Unable to run command: " + ex.getMessage();
                    LOG.error((Object)error);
                }
                volumeManager.remove(lvmVolInfo);
                volumeManager.finish();
            }
            catch (EucalyptusCloudException e) {
                LOG.debug((Object)("Failed to clean volume: " + volumeId), (Throwable)e);
                return;
            }
        }
    }

    @Override
    public void cleanSnapshot(String snapshotId) {
        try {
            this.updateVolumeGroup();
            VolumeMetadataManager volumeManager = new VolumeMetadataManager();
            LVMVolumeInfo lvmVolInfo = volumeManager.getVolumeInfo(snapshotId);
            if (lvmVolInfo != null) {
                volumeManager.remove(lvmVolInfo);
            }
            volumeManager.finish();
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)("Failed to clean snapshotId: " + snapshotId), (Throwable)e);
            return;
        }
    }

    public native void registerSignals();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dupFile(String oldFileName, String newFileName) {
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel out = null;
        FileInputStream fileInputStream = null;
        AbstractInterruptibleChannel in = null;
        try {
            fileOutputStream = new FileOutputStream(new File(newFileName));
            out = fileOutputStream.getChannel();
            fileInputStream = new FileInputStream(new File(oldFileName));
            in = fileInputStream.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    out.close();
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
            if (fileInputStream != null) {
                try {
                    in.close();
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    public void createLogicalVolume(String volumeId, String lvName, long size) throws EucalyptusCloudException {
        if (volumeGroup != null) {
            String returnValue = LVMWrapper.createLogicalVolume(volumeId, volumeGroup, lvName, size);
            if (returnValue.length() == 0) {
                throw new EucalyptusCloudException("Unable to create logical volume " + lvName + " in volume group " + volumeGroup);
            }
        } else {
            throw new EucalyptusCloudException("Volume group is null! This should never happen");
        }
    }

    @Override
    public void createVolume(String volumeId, int size) throws EucalyptusCloudException {
        this.updateVolumeGroup();
        File volumeDir = new File(DirectStorageInfo.getStorageInfo().getVolumesDir());
        volumeDir.mkdirs();
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        String lvName = DASManager.generateLVName(volumeId);
        ISCSIVolumeInfo lvmVolumeInfo = null;
        lvmVolumeInfo = new ISCSIVolumeInfo();
        volumeManager.finish();
        try {
            this.createLogicalVolume(volumeId, lvName, (long)size * 1024L);
            lvmVolumeInfo.setVolumeId(volumeId);
            lvmVolumeInfo.setVgName(volumeGroup);
            lvmVolumeInfo.setLvName(lvName);
            lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
            lvmVolumeInfo.setSize(Integer.valueOf(size));
            volumeManager = new VolumeMetadataManager();
            volumeManager.add((LVMVolumeInfo)lvmVolumeInfo);
            volumeManager.finish();
        }
        catch (EucalyptusCloudException ex) {
            String error = "Unable to run command: " + ex.getMessage();
            volumeManager.abort();
            LOG.error((Object)error);
            throw new EucalyptusCloudException(error);
        }
    }

    @Override
    public int createVolume(String volumeId, String snapshotId, int size) throws EucalyptusCloudException {
        this.updateVolumeGroup();
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
        if (foundSnapshotInfo != null) {
            String status = foundSnapshotInfo.getStatus();
            if (status.equals(StorageProperties.Status.available.toString())) {
                String lvName = DASManager.generateLVName(volumeId);
                LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
                String snapId = foundSnapshotInfo.getVolumeId();
                String loFileName = foundSnapshotInfo.getLoFileName();
                volumeManager.finish();
                try {
                    long absoluteSize;
                    File snapshotFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + PATH_SEPARATOR + snapId);
                    assert (snapshotFile.exists());
                    if (size <= 0 || size == foundSnapshotInfo.getSize()) {
                        absoluteSize = snapshotFile.length() / 0x100000L;
                        size = (int)(absoluteSize / 1024L);
                    } else {
                        absoluteSize = (long)size * 1024L;
                    }
                    this.createLogicalVolume(volumeId, lvName, absoluteSize);
                    String absoluteLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + lvName;
                    this.duplicateLogicalVolume(loFileName, absoluteLVName);
                    lvmVolumeInfo.setVolumeId(volumeId);
                    lvmVolumeInfo.setVgName(volumeGroup);
                    lvmVolumeInfo.setLvName(lvName);
                    lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
                    lvmVolumeInfo.setSize(Integer.valueOf(size));
                    volumeManager = new VolumeMetadataManager();
                    volumeManager.add(lvmVolumeInfo);
                    volumeManager.finish();
                }
                catch (EucalyptusCloudException ex) {
                    volumeManager.abort();
                    String error = "Unable to run command: " + ex.getMessage();
                    LOG.error((Object)error);
                    throw new EucalyptusCloudException(error);
                }
            }
        } else {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find snapshot: " + snapshotId);
        }
        return size;
    }

    @Override
    public void cloneVolume(String volumeId, String parentVolumeId) throws EucalyptusCloudException {
        this.updateVolumeGroup();
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundVolumeInfo = volumeManager.getVolumeInfo(parentVolumeId);
        if (foundVolumeInfo != null) {
            String status = foundVolumeInfo.getStatus();
            String lvName = DASManager.generateLVName(volumeId);
            LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
            String parentLvName = foundVolumeInfo.getLvName();
            int size = foundVolumeInfo.getSize();
            volumeManager.finish();
            try {
                File parentVolumeFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + PATH_SEPARATOR + parentVolumeId);
                assert (parentVolumeFile.exists());
                long absouluteSize = parentVolumeFile.length() / 0x100000L;
                this.createLogicalVolume(volumeId, lvName, absouluteSize);
                String absoluteLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + lvName;
                String absoluteParentLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + parentLvName;
                this.duplicateLogicalVolume(absoluteParentLVName, absoluteLVName);
                try {
                    volumeManager.exportVolume(lvmVolumeInfo, volumeGroup, lvName);
                }
                catch (EucalyptusCloudException ex) {
                    String returnValue = LVMWrapper.removeLogicalVolume(absoluteLVName);
                    throw ex;
                }
                lvmVolumeInfo.setVolumeId(volumeId);
                lvmVolumeInfo.setVgName(volumeGroup);
                lvmVolumeInfo.setLvName(lvName);
                lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
                lvmVolumeInfo.setSize(Integer.valueOf(size));
                volumeManager = new VolumeMetadataManager();
                volumeManager.add(lvmVolumeInfo);
                volumeManager.finish();
            }
            catch (EucalyptusCloudException ex) {
                volumeManager.abort();
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
                throw new EucalyptusCloudException(error);
            }
        }
        volumeManager.abort();
        throw new EucalyptusCloudException("Unable to find volume: " + parentVolumeId);
    }

    @Override
    public void addSnapshot(String snapshotId) throws EucalyptusCloudException {
        String snapshotRawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + PATH_SEPARATOR + snapshotId;
        File snapshotFile = new File(snapshotRawFileName);
        if (!snapshotFile.exists()) {
            throw new EucalyptusCloudException("Snapshot backing file does not exist for: " + snapshotId);
        }
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo();
        lvmVolumeInfo.setVolumeId(snapshotId);
        lvmVolumeInfo.setLoFileName(snapshotRawFileName);
        lvmVolumeInfo.setStatus(StorageProperties.Status.available.toString());
        lvmVolumeInfo.setSize(Integer.valueOf((int)(snapshotFile.length() / 0x40000000L)));
        volumeManager.add(lvmVolumeInfo);
        volumeManager.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVolume(String volumeId) throws EucalyptusCloudException {
        this.updateVolumeGroup();
        LVMVolumeInfo foundLVMVolumeInfo = null;
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        try {
            foundLVMVolumeInfo = volumeManager.getVolumeInfo(volumeId);
        }
        finally {
            volumeManager.finish();
        }
        if (foundLVMVolumeInfo != null) {
            VolumeOpMonitor volumeOpMonitor;
            boolean isReadyForDelete = false;
            int retryCount = 0;
            VolumeOpMonitor monitor = this.getMonitor(foundLVMVolumeInfo.getVolumeId());
            VolumeMetadataManager outerVolumeManager = null;
            do {
                LOG.debug((Object)("Trying to lock volume for export detection" + volumeId));
                volumeOpMonitor = monitor;
                synchronized (volumeOpMonitor) {
                    block33: {
                        VolumeMetadataManager volumeManager2 = new VolumeMetadataManager();
                        try {
                            foundLVMVolumeInfo = volumeManager2.getVolumeInfo(volumeId);
                            if (exportManager.isExported(foundLVMVolumeInfo)) {
                                LOG.error((Object)("Cannot delete volume " + volumeId + " because it is currently exported"));
                                volumeManager2.finish();
                                break block33;
                            }
                            LOG.debug((Object)("Volume " + volumeId + " is prepped for deletion"));
                            isReadyForDelete = true;
                            break;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error trying to check volume status", (Throwable)e);
                        }
                        finally {
                            if (isReadyForDelete) {
                                outerVolumeManager = volumeManager2;
                            } else {
                                volumeManager2.abort();
                            }
                        }
                    }
                    LOG.debug((Object)("Lap: " + retryCount++));
                }
                if (isReadyForDelete) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    throw new EucalyptusCloudException("Thread interrupted. Failing volume delete for volume " + volumeId);
                }
            } while (!isReadyForDelete && retryCount < 20);
            LOG.debug((Object)("Trying to lock volume for volume deletion" + volumeId));
            volumeOpMonitor = monitor;
            synchronized (volumeOpMonitor) {
                if (isReadyForDelete) {
                    try {
                        LOG.info((Object)("Deleting volume " + volumeId));
                        String lvName = foundLVMVolumeInfo.getLvName();
                        String absoluteLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + lvName;
                        String returnValue = "";
                        for (int i = 0; !(i >= 5 || (returnValue = LVMWrapper.removeLogicalVolume(absoluteLVName)).length() != 0 && returnValue.contains("successfully removed")); ++i) {
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                LOG.error((Object)e);
                                break;
                            }
                        }
                        if (returnValue.length() == 0) {
                            throw new EucalyptusCloudException("Unable to remove logical volume " + absoluteLVName);
                        }
                        outerVolumeManager.remove(foundLVMVolumeInfo);
                        try {
                            outerVolumeManager.finish();
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error deleting volume " + volumeId + ", failed to commit DB transaction"), (Throwable)e);
                        }
                    }
                    finally {
                        outerVolumeManager.abort();
                    }
                } else {
                    LOG.error((Object)("All attempts to cleanup volume " + volumeId + " failed"));
                    throw new EucalyptusCloudException("Unable to delete volume: " + volumeId + ". All attempts to cleanup the volume failed");
                }
            }
        }
        throw new EucalyptusCloudException("Unable to find volume: " + volumeId);
        this.removeMonitor(volumeId);
    }

    protected static String generateLVName(String baseName) {
        return "euca-" + baseName;
    }

    protected static String generateVGName(String baseName) {
        return "euca-ebs-storage-vg-" + baseName;
    }

    @Override
    public StorageResource createSnapshot(String volumeId, String snapshotId, String snapshotPointId, Boolean shouldTransferSnapshot) throws EucalyptusCloudException {
        if (snapshotPointId != null) {
            throw new EucalyptusCloudException("Synchronous snapshot points not supported in DAS storage manager");
        }
        this.updateVolumeGroup();
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(volumeId);
        FileResource snapInfo = null;
        if (foundLVMVolumeInfo != null) {
            LVMVolumeInfo snapshotInfo = volumeManager.getVolumeInfo();
            snapshotInfo.setVolumeId(snapshotId);
            File snapshotDir = new File(DirectStorageInfo.getStorageInfo().getVolumesDir());
            snapshotDir.mkdirs();
            String lvName = DASManager.generateLVName(snapshotId);
            String absoluteLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + foundLVMVolumeInfo.getLvName();
            int size = foundLVMVolumeInfo.getSize();
            volumeManager.finish();
            volumeManager = null;
            try {
                String returnValue;
                long absoluteSize;
                SystemUtil.CommandOutput result = SystemUtil.runWithRawOutput((String[])new String[]{EUCA_ROOT_WRAPPER, "blockdev", "--getsize64", absoluteLVName});
                if (null != result && result.returnValue == 0 && StringUtils.isNotBlank((String)StringUtils.trim((String)result.output))) {
                    try {
                        absoluteSize = Long.parseLong(StringUtils.trim((String)result.output)) / 0x100000L;
                    }
                    catch (NumberFormatException e) {
                        LOG.debug((Object)("Failed to parse size of volume " + volumeId), (Throwable)e);
                        absoluteSize = (long)size * 1024L;
                    }
                } else {
                    absoluteSize = (long)size * 1024L;
                }
                if ((returnValue = LVMWrapper.createSnapshotLogicalVolume(absoluteLVName, lvName, absoluteSize)).length() == 0) {
                    throw new EucalyptusCloudException("Unable to create snapshot logical volume " + lvName + " for volume " + lvName);
                }
                String snapRawFileName = DirectStorageInfo.getStorageInfo().getVolumesDir() + PATH_SEPARATOR + snapshotId;
                String absoluteSnapLVName = "/dev/" + volumeGroup + PATH_SEPARATOR + lvName;
                this.duplicateLogicalVolume(absoluteSnapLVName, snapRawFileName);
                returnValue = LVMWrapper.removeLogicalVolume(absoluteSnapLVName);
                if (returnValue.length() == 0) {
                    throw new EucalyptusCloudException("Unable to remove logical volume " + absoluteSnapLVName);
                }
                snapshotInfo.setLoFileName(snapRawFileName);
                snapshotInfo.setSize(Integer.valueOf(size));
                volumeManager = new VolumeMetadataManager();
                volumeManager.add(snapshotInfo);
                snapInfo = new FileResource(snapshotId, snapRawFileName);
            }
            catch (Exception ex) {
                if (volumeManager != null) {
                    volumeManager.abort();
                }
                String error = "Unable to run command: " + ex.getMessage();
                LOG.error((Object)error);
                throw new EucalyptusCloudException(error);
            }
        }
        volumeManager.finish();
        return snapInfo;
    }

    @Override
    public List<String> prepareForTransfer(String snapshotId) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(snapshotId);
        ArrayList<String> returnValues = new ArrayList<String>();
        if (foundLVMVolumeInfo == null) {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find snapshot: " + snapshotId);
        }
        returnValues.add(DirectStorageInfo.getStorageInfo().getVolumesDir() + PATH_SEPARATOR + foundLVMVolumeInfo.getVolumeId());
        volumeManager.finish();
        return returnValues;
    }

    @Override
    public void deleteSnapshot(String snapshotId) throws EucalyptusCloudException {
        this.updateVolumeGroup();
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(snapshotId);
        if (foundLVMVolumeInfo != null) {
            volumeManager.remove(foundLVMVolumeInfo);
            File snapFile = new File(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + foundLVMVolumeInfo.getVolumeId());
            volumeManager.finish();
            if (snapFile.exists() && !snapFile.delete()) {
                throw new EucalyptusCloudException("Unable to delete: " + snapFile.getAbsolutePath());
            }
        } else {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find snapshot: " + snapshotId);
        }
    }

    @Override
    public String getVolumeConnectionString(String volumeId) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        String returnValue = volumeManager.getConnectionString(volumeId);
        volumeManager.finish();
        return returnValue;
    }

    @Override
    public void reload() {
        LOG.info((Object)"Reload: starting reload process to re-export volumes if necessary");
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        List<LVMVolumeInfo> volumeInfos = volumeManager.getAllVolumeInfos();
        for (LVMVolumeInfo foundVolumeInfo : volumeInfos) {
            try {
                LOG.info((Object)("Reload: Checking volume " + foundVolumeInfo.getVolumeId() + " for export"));
                if (foundVolumeInfo.getVgName() != null && volumeManager.shouldExportOnReload(foundVolumeInfo)) {
                    LOG.info((Object)("Reload: Volume " + foundVolumeInfo.getVolumeId() + " was exported at shutdown. Not found to be already exported. Re-exporting volume."));
                    volumeManager.exportVolume(foundVolumeInfo);
                    continue;
                }
                LOG.info((Object)("Reload: volume " + foundVolumeInfo.getVolumeId() + " not previously exported or already exported, no action required. Skipping"));
            }
            catch (EucalyptusCloudException ex) {
                LOG.error((Object)("Unable to reload volume: " + foundVolumeInfo.getVolumeId() + " due to: " + (Object)((Object)ex)));
            }
        }
        volumeManager.finish();
    }

    @Override
    public int getSnapshotSize(String snapshotId) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo lvmVolumeInfo = volumeManager.getVolumeInfo(snapshotId);
        if (lvmVolumeInfo != null) {
            int snapSize = lvmVolumeInfo.getSize();
            volumeManager.finish();
            return snapSize;
        }
        volumeManager.abort();
        return 0;
    }

    @Override
    public void loadSnapshots(List<String> snapshotSet, List<String> snapshotFileNames) throws EucalyptusCloudException {
    }

    @Override
    public StorageResource prepareSnapshot(String snapshotId, int sizeExpected, long actualSizeInMB) throws EucalyptusCloudException {
        String deviceName = null;
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
        if (null == foundSnapshotInfo) {
            LVMVolumeInfo snapshotInfo = volumeManager.getVolumeInfo();
            snapshotInfo.setVolumeId(snapshotId);
            snapshotInfo.setSize(Integer.valueOf(sizeExpected));
            snapshotInfo.setLoFileName(DirectStorageInfo.getStorageInfo().getVolumesDir() + File.separator + snapshotId);
            deviceName = snapshotInfo.getLoFileName();
            volumeManager.add(snapshotInfo);
        }
        volumeManager.finish();
        return new FileResource(snapshotId, deviceName);
    }

    @Override
    public ArrayList<ComponentProperty> getStorageProps() {
        String alias;
        String root;
        ArrayList componentProperties = null;
        ConfigurableClass configurableClass = StorageInfo.class.getAnnotation(ConfigurableClass.class);
        if (configurableClass != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
        }
        if ((configurableClass = DirectStorageInfo.class.getAnnotation(ConfigurableClass.class)) != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            if (componentProperties == null) {
                componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
            } else {
                componentProperties.addAll(PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias));
            }
        }
        if ((configurableClass = DASInfo.class.getAnnotation(ConfigurableClass.class)) != null) {
            root = configurableClass.root();
            alias = configurableClass.alias();
            if (componentProperties == null) {
                componentProperties = (ArrayList)PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias);
            } else {
                componentProperties.addAll(PropertyDirectory.getComponentPropertySet((String)(StorageProperties.NAME + "." + root), (String)alias));
            }
        }
        return componentProperties;
    }

    @Override
    public void setStorageProps(ArrayList<ComponentProperty> storageProps) {
        for (ComponentProperty prop : storageProps) {
            try {
                ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)prop.getQualifiedName());
                entry.setValue(prop.getValue());
            }
            catch (ConfigurablePropertyException | IllegalAccessException e) {
                LOG.error((Object)e, e);
            }
        }
    }

    @Override
    public String getStorageRootDirectory() {
        return DirectStorageInfo.getStorageInfo().getVolumesDir();
    }

    @Override
    public void finishVolume(String snapshotId) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo foundSnapshotInfo = volumeManager.getVolumeInfo(snapshotId);
        if (null != foundSnapshotInfo) {
            foundSnapshotInfo.setStatus(StorageProperties.Status.available.toString());
        }
        volumeManager.finish();
    }

    @Override
    public String getSnapshotPath(String snapshotId) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo volInfo = volumeManager.getVolumeInfo(snapshotId);
        if (volInfo != null) {
            String snapPath = volInfo.getLoFileName();
            volumeManager.finish();
            return snapPath;
        }
        volumeManager.abort();
        throw new EntityNotFoundException("Unable to find snapshot with id: " + snapshotId);
    }

    @Override
    public String getVolumePath(String volumeId) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo volInfo = volumeManager.getVolumeInfo(volumeId);
        if (volInfo != null) {
            String volumePath = lvmRootDirectory + File.separator + volInfo.getVgName() + File.separator + volInfo.getLvName();
            volumeManager.finish();
            return volumePath;
        }
        volumeManager.abort();
        throw new EntityNotFoundException("Unable to find volume with id: " + volumeId);
    }

    @Override
    public void importSnapshot(String snapshotId, String snapPath, String volumeId, int size) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo snapInfo = volumeManager.getVolumeInfo(snapshotId);
        if (snapInfo != null) {
            volumeManager.finish();
            throw new EucalyptusCloudException("Snapshot " + snapshotId + " already exists. Import failed.");
        }
        volumeManager.finish();
        String snapFileName = this.getStorageRootDirectory() + File.separator + snapshotId;
        SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + snapPath, "of=" + snapFileName, "bs=1M"});
        volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo snapshotInfo = volumeManager.getVolumeInfo();
        snapshotInfo.setVolumeId(snapshotId);
        snapshotInfo.setLoFileName(snapFileName);
        snapshotInfo.setSize(Integer.valueOf(size));
        snapshotInfo.setSnapshotOf(volumeId);
        volumeManager.add(snapshotInfo);
        volumeManager.finish();
    }

    @Override
    public void importVolume(String volumeId, String volumePath, int size) throws EucalyptusCloudException {
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo volInfo = volumeManager.getVolumeInfo(volumeId);
        if (volInfo != null) {
            volumeManager.finish();
            throw new EucalyptusCloudException("Volume " + volumeId + " already exists. Import failed.");
        }
        volumeManager.finish();
        this.createVolume(volumeId, size);
        volumeManager = new VolumeMetadataManager();
        LVMVolumeInfo volumeInfo = volumeManager.getVolumeInfo(volumeId);
        if (volumeInfo == null) {
            volumeManager.abort();
            throw new EucalyptusCloudException("Unable to find volume with id: " + volumeId);
        }
        SystemUtil.run((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + volumePath, "of=/dev" + File.separator + volumeInfo.getVgName() + File.separator + volumeInfo.getLvName(), "bs=1M"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException {
        try {
            this.updateVolumeGroup();
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)e);
            throw e;
        }
        LVMVolumeInfo lvmVolumeInfo = null;
        VolumeMetadataManager volumeManager = new VolumeMetadataManager();
        try {
            lvmVolumeInfo = volumeManager.getVolumeInfo(volumeId);
        }
        finally {
            volumeManager.finish();
        }
        if (lvmVolumeInfo != null) {
            VolumeOpMonitor monitor;
            VolumeOpMonitor volumeOpMonitor = monitor = this.getMonitor(volumeId);
            synchronized (volumeOpMonitor) {
                VolumeMetadataManager volumeManager2 = new VolumeMetadataManager();
                try {
                    lvmVolumeInfo = volumeManager2.getVolumeInfo(volumeId);
                    String lvName = lvmVolumeInfo.getLvName();
                    if (lvmVolumeInfo.getVgName() == null) {
                        lvmVolumeInfo.setVgName(volumeGroup);
                    }
                    try {
                        volumeManager2.exportVolume(lvmVolumeInfo, volumeGroup, lvName);
                    }
                    catch (EucalyptusCloudException ex) {
                        LOG.error((Object)("Unable to export volume " + volumeId), (Throwable)ex);
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to attach volume " + volumeId), (Throwable)ex);
                    throw new EucalyptusCloudException("Failed to attach volume " + volumeId, (Throwable)ex);
                }
                finally {
                    try {
                        volumeManager2.finish();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable to commit the database transaction after an attempt to attach volume " + volumeId), (Throwable)e);
                    }
                }
            }
        }
        return this.getVolumeConnectionString(volumeId);
    }

    @Override
    public void unexportVolume(String volumeId, String nodeIqn) throws EucalyptusCloudException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DASManager does not support node-specific export/unexport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unexportVolumeFromAll(String volumeId) throws EucalyptusCloudException {
        block16: {
            VolumeMetadataManager volumeManager = new VolumeMetadataManager();
            try {
                LVMVolumeInfo foundLVMVolumeInfo = volumeManager.getVolumeInfo(volumeId);
                if (foundLVMVolumeInfo != null) {
                    VolumeOpMonitor monitor;
                    LOG.info((Object)("Unexporting volume " + volumeId + " from all clients"));
                    VolumeOpMonitor volumeOpMonitor = monitor = this.getMonitor(volumeId);
                    synchronized (volumeOpMonitor) {
                        try {
                            LOG.info((Object)("Unexporting volume " + foundLVMVolumeInfo.getVolumeId()));
                            try {
                                String path = "/dev/" + volumeGroup + PATH_SEPARATOR + foundLVMVolumeInfo.getLvName();
                                if (LVMWrapper.logicalVolumeExists(path)) {
                                    exportManager.cleanup(foundLVMVolumeInfo);
                                }
                                foundLVMVolumeInfo.setStatus("available");
                                LOG.info((Object)("Done cleaning up: " + foundLVMVolumeInfo.getVolumeId()));
                            }
                            catch (EucalyptusCloudException ee) {
                                LOG.error((Object)ee, (Throwable)ee);
                                throw ee;
                            }
                        }
                        finally {
                            monitor.notifyAll();
                        }
                        break block16;
                    }
                }
                volumeManager.abort();
                throw new EucalyptusCloudException("Unable to find volume: " + volumeId);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to unexport volume " + volumeId));
                throw new EucalyptusCloudException("Failed to unexport volume " + volumeId);
            }
            finally {
                volumeManager.finish();
            }
        }
    }

    @Override
    public void checkReady() throws EucalyptusCloudException {
        if (!new File(StorageProperties.EUCA_ROOT_WRAPPER).exists()) {
            throw new EucalyptusCloudException("root wrapper (euca_rootwrap) does not exist in " + StorageProperties.EUCA_ROOT_WRAPPER);
        }
        File varDir = new File(EUCA_VAR_RUN_PATH);
        if (!varDir.exists()) {
            varDir.mkdirs();
        }
        exportManager.check();
    }

    @Override
    public void stop() throws EucalyptusCloudException {
        exportManager.stop();
    }

    @Override
    public void disable() throws EucalyptusCloudException {
        this.volumeOps.clear();
        this.volumeOps = null;
    }

    @Override
    public void enable() throws EucalyptusCloudException {
        this.volumeOps = new ConcurrentHashMap();
    }

    @Override
    public boolean getFromBackend(String snapshotId, int size) throws EucalyptusCloudException {
        return false;
    }

    @Override
    public void checkVolume(String volumeId) throws EucalyptusCloudException {
    }

    @Override
    public List<CheckerTask> getCheckers() {
        ArrayList<CheckerTask> checkers = new ArrayList<CheckerTask>();
        return checkers;
    }

    @Override
    public String createSnapshotPoint(String volumeId, String snapshotId) throws EucalyptusCloudException {
        return null;
    }

    @Override
    public void deleteSnapshotPoint(String volumeId, String snapshotId, String snapshotPointId) throws EucalyptusCloudException {
        throw new EucalyptusCloudException("Synchronous snapshot points not supported in DAS storage manager");
    }

    protected VolumeOpMonitor getMonitor(String key) {
        VolumeOpMonitor monitor = this.volumeOps.putIfAbsent(key, new VolumeOpMonitor());
        if (monitor == null) {
            monitor = this.volumeOps.get(key);
        }
        return monitor;
    }

    public void removeMonitor(String key) {
        this.volumeOps.remove(key);
    }

    protected class VolumeOpMonitor {
    }

    protected static class VolumeMetadataManager {
        private TransactionResource transaction = Entities.transactionFor(VolumeInfo.class);

        protected VolumeMetadataManager() {
        }

        public boolean shouldExportOnReload(LVMVolumeInfo lvmVolumeInfo) {
            if (lvmVolumeInfo instanceof ISCSIVolumeInfo) {
                ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)lvmVolumeInfo;
                try {
                    return iscsiVolumeInfo.getTid() >= 0 && !exportManager.isExported(lvmVolumeInfo);
                }
                catch (EucalyptusCloudException e) {
                    LOG.error((Object)("Failed to determine if volume " + lvmVolumeInfo.getVolumeId() + " is already exported. Returning false"), (Throwable)e);
                }
            }
            return false;
        }

        public List<String> getSnapshotValues(String snapshotId) {
            ArrayList<String> returnValues = new ArrayList<String>();
            LVMVolumeInfo lvmVolumeInfo = this.getVolumeInfo(snapshotId);
            return returnValues;
        }

        public void exportVolume(LVMVolumeInfo lvmVolumeInfo) throws EucalyptusCloudException {
            if (lvmVolumeInfo instanceof ISCSIVolumeInfo) {
                ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)lvmVolumeInfo;
                String absoluteLVName = "/dev/" + iscsiVolumeInfo.getVgName() + DASManager.PATH_SEPARATOR + iscsiVolumeInfo.getLvName();
                if (!LVMWrapper.logicalVolumeExists(absoluteLVName)) {
                    LOG.error((Object)("Backing volume not found: " + absoluteLVName));
                    throw new EucalyptusCloudException("Logical volume not found: " + absoluteLVName);
                }
                try {
                    LVMWrapper.enableLogicalVolume(absoluteLVName);
                }
                catch (EucalyptusCloudException ex) {
                    String error = "Unable to run command: " + ex.getMessage();
                    LOG.error((Object)error);
                    throw new EucalyptusCloudException((Throwable)ex);
                }
                ((ISCSIManager)exportManager).exportTarget(iscsiVolumeInfo.getVolumeId(), iscsiVolumeInfo.getTid(), iscsiVolumeInfo.getStoreName(), iscsiVolumeInfo.getLun(), absoluteLVName, iscsiVolumeInfo.getStoreUser());
            }
        }

        public String getConnectionString(String volumeId) {
            LVMVolumeInfo lvmVolumeInfo = this.getVolumeInfo(volumeId);
            if (lvmVolumeInfo != null) {
                String encryptedPassword;
                ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)lvmVolumeInfo;
                String storeName = iscsiVolumeInfo.getStoreName();
                try {
                    encryptedPassword = ((ISCSIManager)exportManager).getEncryptedPassword();
                }
                catch (EucalyptusCloudException e) {
                    LOG.error((Object)e);
                    return null;
                }
                return "iscsi,tgt,,,," + encryptedPassword + ",," + StorageProperties.STORAGE_HOST + "," + storeName;
            }
            return null;
        }

        public void unexportVolume(LVMVolumeInfo volumeInfo) {
            StorageExportManager manager = exportManager;
            if (!(exportManager instanceof ISCSIManager)) {
                manager = new ISCSIManager();
            }
            ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)volumeInfo;
            String absoluteLVName = "/dev/" + iscsiVolumeInfo.getVgName() + DASManager.PATH_SEPARATOR + iscsiVolumeInfo.getLvName();
            if (LVMWrapper.logicalVolumeExists(absoluteLVName)) {
                try {
                    ((ISCSIManager)manager).unexportTarget(volumeInfo.getVolumeId(), iscsiVolumeInfo.getTid(), iscsiVolumeInfo.getLun(), absoluteLVName);
                }
                catch (EucalyptusCloudException e) {
                    LOG.error((Object)("Error unexporting target for volume " + volumeInfo.getVolumeId()), (Throwable)e);
                    return;
                }
            }
            iscsiVolumeInfo.setTid(Integer.valueOf(-1));
        }

        protected void finish() {
            try {
                this.transaction.commit();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                this.transaction.rollback();
            }
        }

        protected void abort() {
            this.transaction.rollback();
        }

        protected LVMVolumeInfo getVolumeInfo(String volumeId) {
            ISCSIVolumeInfo ISCSIVolumeInfo2 = new ISCSIVolumeInfo(volumeId);
            List ISCSIVolumeInfos = Entities.query((Object)ISCSIVolumeInfo2);
            if (ISCSIVolumeInfos.size() > 0) {
                return (LVMVolumeInfo)ISCSIVolumeInfos.get(0);
            }
            return null;
        }

        protected boolean areSnapshotsPending(String volumeId) {
            ISCSIVolumeInfo ISCSIVolumeInfo2 = new ISCSIVolumeInfo();
            ISCSIVolumeInfo2.setSnapshotOf(volumeId);
            ISCSIVolumeInfo2.setStatus(StorageProperties.Status.pending.toString());
            List ISCSIVolumeInfos = Entities.query((Object)ISCSIVolumeInfo2);
            return ISCSIVolumeInfos.size() > 0;
        }

        protected LVMVolumeInfo getVolumeInfo() {
            return new ISCSIVolumeInfo();
        }

        protected List<LVMVolumeInfo> getAllVolumeInfos() {
            ArrayList<LVMVolumeInfo> volumeInfos = new ArrayList<LVMVolumeInfo>();
            volumeInfos.addAll(Entities.query((Object)new ISCSIVolumeInfo()));
            return volumeInfos;
        }

        protected void add(LVMVolumeInfo volumeInfo) {
            Entities.persist((Object)volumeInfo);
        }

        protected void remove(LVMVolumeInfo volumeInfo) {
            Entities.delete((Object)volumeInfo);
        }

        protected String encryptTargetPassword(String password) throws EucalyptusCloudException {
            try {
                List partitionConfigs = ServiceConfigurations.listPartition(ClusterController.class, (String)StorageProperties.NAME);
                ServiceConfiguration clusterConfig = (ServiceConfiguration)partitionConfigs.get(0);
                PublicKey ncPublicKey = Partitions.lookup((ServiceConfiguration)clusterConfig).getNodeCertificate().getPublicKey();
                Cipher cipher = Ciphers.RSA_PKCS1.get();
                cipher.init(1, (Key)ncPublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
                return new String(Base64.encode((byte[])cipher.doFinal(password.getBytes())));
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to encrypt storage target password");
                throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
            }
        }

        protected void exportVolume(LVMVolumeInfo lvmVolumeInfo, String vgName, String lvName) throws EucalyptusCloudException {
            ISCSIVolumeInfo iscsiVolumeInfo = (ISCSIVolumeInfo)lvmVolumeInfo;
            String absoluteLVName = "/dev/" + vgName + DASManager.PATH_SEPARATOR + lvName;
            int max_tries = 10;
            int i = 0;
            EucalyptusCloudException ex = null;
            while (true) {
                exportManager.allocateTarget((LVMVolumeInfo)iscsiVolumeInfo);
                try {
                    ((ISCSIManager)exportManager).exportTarget(iscsiVolumeInfo.getVolumeId(), iscsiVolumeInfo.getTid(), iscsiVolumeInfo.getStoreName(), iscsiVolumeInfo.getLun(), absoluteLVName, iscsiVolumeInfo.getStoreUser());
                    ex = null;
                }
                catch (EucalyptusCloudException e) {
                    ex = e;
                    LOG.error((Object)e);
                    if (i++ < max_tries) continue;
                }
                break;
            }
            if (null != ex) {
                throw ex;
            }
        }
    }
}

