/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.BlockStorageChecker;
import com.eucalyptus.blockstorage.FileResource;
import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.blockstorage.S3SnapshotTransfer;
import com.eucalyptus.blockstorage.SnapshotService;
import com.eucalyptus.blockstorage.SnapshotTransfer;
import com.eucalyptus.blockstorage.SnapshotUploadCheckerTask;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.StorageCheckerService;
import com.eucalyptus.blockstorage.StorageManagerTestingProxy;
import com.eucalyptus.blockstorage.StorageManagers;
import com.eucalyptus.blockstorage.StorageResource;
import com.eucalyptus.blockstorage.VolumeService;
import com.eucalyptus.blockstorage.VolumeStateChecker;
import com.eucalyptus.blockstorage.entities.BlockStorageGlobalConfiguration;
import com.eucalyptus.blockstorage.entities.SnapshotInfo;
import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.blockstorage.entities.VolumeExportRecord;
import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.blockstorage.entities.VolumeToken;
import com.eucalyptus.blockstorage.exceptions.AccessDeniedException;
import com.eucalyptus.blockstorage.exceptions.SnapshotNotFoundException;
import com.eucalyptus.blockstorage.exceptions.SnapshotTooLargeException;
import com.eucalyptus.blockstorage.msgs.AttachStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.AttachStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.CloneVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.CloneVolumeType;
import com.eucalyptus.blockstorage.msgs.ConvertVolumesResponseType;
import com.eucalyptus.blockstorage.msgs.ConvertVolumesType;
import com.eucalyptus.blockstorage.msgs.CreateStorageSnapshotResponseType;
import com.eucalyptus.blockstorage.msgs.CreateStorageSnapshotType;
import com.eucalyptus.blockstorage.msgs.CreateStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.CreateStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageSnapshotResponseType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageSnapshotType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageSnapshotsResponseType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageSnapshotsType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageVolumesResponseType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageVolumesType;
import com.eucalyptus.blockstorage.msgs.DetachStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.DetachStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.ExportVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.ExportVolumeType;
import com.eucalyptus.blockstorage.msgs.GetStorageConfigurationResponseType;
import com.eucalyptus.blockstorage.msgs.GetStorageConfigurationType;
import com.eucalyptus.blockstorage.msgs.GetStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.GetStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenResponseType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenType;
import com.eucalyptus.blockstorage.msgs.StorageSnapshot;
import com.eucalyptus.blockstorage.msgs.StorageVolume;
import com.eucalyptus.blockstorage.msgs.UnexportVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.UnexportVolumeType;
import com.eucalyptus.blockstorage.msgs.UpdateStorageConfigurationResponseType;
import com.eucalyptus.blockstorage.msgs.UpdateStorageConfigurationType;
import com.eucalyptus.blockstorage.util.BlockStorageUtil;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.storage.common.CheckerTask;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.InvalidParameterValueException;
import edu.ucsb.eucalyptus.cloud.NoSuchVolumeException;
import edu.ucsb.eucalyptus.cloud.SnapshotInUseException;
import edu.ucsb.eucalyptus.cloud.VolumeAlreadyExistsException;
import edu.ucsb.eucalyptus.cloud.VolumeNotReadyException;
import edu.ucsb.eucalyptus.cloud.VolumeSizeExceededException;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import edu.ucsb.eucalyptus.util.EucaSemaphore;
import edu.ucsb.eucalyptus.util.EucaSemaphoreDirectory;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class BlockStorageController {
    private static Logger LOG = Logger.getLogger(BlockStorageController.class);
    static LogicalStorageManager blockManager;
    static BlockStorageChecker checker;
    static VolumeService volumeService;
    static SnapshotService snapshotService;
    static StorageCheckerService checkerService;
    public static Random randomGenerator;

    static boolean setUseTestingDelegateManager(boolean enableDelegate) {
        if (enableDelegate && !(blockManager instanceof StorageManagerTestingProxy)) {
            LOG.info((Object)"Switching to use delegating storage manager for testing");
            blockManager = new StorageManagerTestingProxy(blockManager);
        } else if (!enableDelegate && blockManager instanceof StorageManagerTestingProxy) {
            LOG.info((Object)"Switching to NOT use delegating storage manager anymore");
            blockManager = ((StorageManagerTestingProxy)blockManager).getDelegateStorageManager();
        }
        return enableDelegate;
    }

    public static void configure() throws EucalyptusCloudException {
        BlockStorageGlobalConfiguration.getInstance();
        StorageProperties.updateWalrusUrl();
        StorageProperties.updateName();
        StorageProperties.updateStorageHost();
        try {
            blockManager = StorageManagers.getInstance();
            if (blockManager == null) {
                throw new EucalyptusCloudException("Got null block manager. Cannot configure.");
            }
            blockManager.initialize();
        }
        catch (Exception e) {
            throw new EucalyptusCloudException((Throwable)e);
        }
        volumeService = new VolumeService();
        snapshotService = new SnapshotService();
        checkerService = new StorageCheckerService();
        try {
            BlockStorageUtil.checkAndConfigureBlockStorageAccount();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error checking and or configuring blockstorage account during bootstrap. Moving on with the SC bootstrap process");
        }
    }

    public BlockStorageController() {
    }

    public BlockStorageController(LogicalStorageManager blockManager) {
        BlockStorageController.blockManager = blockManager;
    }

    private static void startupChecks() throws EucalyptusCloudException {
        if (checker != null) {
            checker.startupChecks();
        }
    }

    public static void checkPending() {
        if (checker != null) {
            StorageProperties.updateWalrusUrl();
            try {
                checker.transferPendingSnapshots();
            }
            catch (Exception ex) {
                LOG.error((Object)"unable to transfer pending snapshots", (Throwable)ex);
            }
        }
    }

    public static void check() throws EucalyptusCloudException {
        blockManager.checkReady();
    }

    public static void stop() throws EucalyptusCloudException {
        if (blockManager != null) {
            LOG.info((Object)"Stopping blockmanager");
            blockManager.stop();
        }
        blockManager = null;
        checker = null;
        if (volumeService != null) {
            volumeService.shutdown();
        }
        if (snapshotService != null) {
            snapshotService.shutdown();
        }
        if (checkerService != null) {
            checkerService.shutdown();
        }
        StorageProperties.enableSnapshots = false;
    }

    public static void enable() throws EucalyptusCloudException {
        blockManager.configure();
        blockManager.enable();
        checkerService.add(new VolumeStateChecker(blockManager));
        for (CheckerTask checker : blockManager.getCheckers()) {
            checkerService.add(checker);
        }
        checkerService.add(new VolumeDeleterTask());
        checkerService.add(new SnapshotDeleterTask());
        checkerService.add(new SnapshotUploadCheckerTask());
        StorageProperties.enableStorage = true;
        StorageProperties.enableSnapshots = true;
        checker = new BlockStorageChecker(blockManager);
        try {
            BlockStorageController.startupChecks();
        }
        catch (EucalyptusCloudException ex) {
            LOG.error((Object)"Startup checks failed ", (Throwable)ex);
        }
    }

    public static void disable() throws EucalyptusCloudException {
        blockManager.disable();
    }

    public static void addChecker(CheckerTask checkerTask) {
        if (checkerService != null) {
            checkerService.add(checkerTask);
        }
    }

    public UpdateStorageConfigurationResponseType UpdateStorageConfiguration(UpdateStorageConfigurationType request) throws EucalyptusCloudException {
        UpdateStorageConfigurationResponseType reply = (UpdateStorageConfigurationResponseType)request.getReply();
        if (((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name().equals(request.getEffectiveUserId())) {
            throw new AccessDeniedException("Only admin can change walrus properties.");
        }
        StorageProperties.updateWalrusUrl();
        try {
            blockManager.checkPreconditions();
            StorageProperties.enableStorage = true;
        }
        catch (Exception ex) {
            StorageProperties.enableStorage = false;
            LOG.error((Object)ex);
        }
        if (request.getStorageParams() != null) {
            for (ComponentProperty param : request.getStorageParams()) {
                LOG.debug((Object)("Storage Param: " + param.getDisplayName() + " Qname: " + param.getQualifiedName() + " Value: " + param.getValue()));
            }
            blockManager.setStorageProps(request.getStorageParams());
        }
        return reply;
    }

    public GetStorageConfigurationResponseType GetStorageConfiguration(GetStorageConfigurationType request) throws EucalyptusCloudException {
        GetStorageConfigurationResponseType reply = (GetStorageConfigurationResponseType)request.getReply();
        StorageProperties.updateName();
        if (((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name().equals(request.getEffectiveUserId())) {
            throw new AccessDeniedException("Only admin can change walrus properties.");
        }
        if (StorageProperties.NAME.equals(request.getName())) {
            reply.setName(StorageProperties.NAME);
            ArrayList<ComponentProperty> storageParams = blockManager.getStorageProps();
            reply.setStorageParams(storageParams);
        }
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetVolumeTokenResponseType GetVolumeToken(GetVolumeTokenType request) throws EucalyptusCloudException {
        GetVolumeTokenResponseType reply = (GetVolumeTokenResponseType)request.getReply();
        String volumeId = request.getVolumeId();
        LOG.info((Object)("Processing GetVolumeToken request for volume " + volumeId));
        if (null == volumeId) {
            LOG.error((Object)"Cannot get token for a null-valued volumeId");
            throw new EucalyptusCloudException("No volumeId specified in token request");
        }
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo vol = (VolumeInfo)Entities.uniqueResult((Object)new VolumeInfo(volumeId));
            VolumeToken token = vol.getOrCreateAttachmentToken();
            String encryptedToken = BlockStorageUtil.encryptForNode((String)token.getToken(), (Partition)BlockStorageUtil.getPartitionForLocalService(Storage.class));
            reply.setToken(encryptedToken);
            reply.setVolumeId(volumeId);
            tran.commit();
            LOG.debug((Object)reply.toSimpleString());
            GetVolumeTokenResponseType getVolumeTokenResponseType = reply;
            return getVolumeTokenResponseType;
        }
        catch (NoSuchElementException e) {
            throw new EucalyptusCloudException("Volume " + request.getVolumeId() + " not found", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get volume token: " + e.getMessage()));
            throw new EucalyptusCloudException("Could not get volume token for volume " + request.getVolumeId(), (Throwable)e);
        }
    }

    public UnexportVolumeResponseType UnexportVolume(UnexportVolumeType request) throws EucalyptusCloudException {
        UnexportVolumeResponseType reply = (UnexportVolumeResponseType)request.getReply();
        final String token = request.getToken();
        String volumeId = request.getVolumeId();
        final String nodeIqn = request.getIqn();
        final String nodeIp = request.getIp();
        LOG.info((Object)("Processing UnexportVolume request for volume " + volumeId + " from node " + nodeIp + " with iqn " + nodeIqn));
        VolumeInfo volumeEntity = null;
        VolumeToken validToken = null;
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo foundVolume = (VolumeInfo)Entities.uniqueResult((Object)new VolumeInfo(volumeId));
            volumeEntity = (VolumeInfo)Entities.merge((Object)foundVolume);
            try {
                validToken = volumeEntity.getAttachmentTokenIfValid(token);
            }
            catch (Exception e) {
                LOG.error((Object)("Invalid token in request for volume " + volumeId + ". Encrypted token: " + token));
                throw new EucalyptusCloudException((Throwable)e);
            }
            if (validToken.hasOnlyExport(nodeIp, nodeIqn)) {
                blockManager.unexportVolumeFromAll(volumeId);
            } else {
                try {
                    blockManager.unexportVolume(volumeEntity.getVolumeId(), nodeIqn);
                }
                catch (UnsupportedOperationException e) {
                    LOG.info((Object)("Volume " + volumeId + ": UnexportVolume for single host not supported by backend. Treating as no-op and continuing normally."));
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not detach volume: " + volumeId), (Throwable)e);
                    throw e;
                }
            }
            if (!((Boolean)Entities.asTransaction(VolumeInfo.class, (Function)new Function<VolumeInfo, Boolean>(){

                public Boolean apply(VolumeInfo vol) {
                    VolumeInfo entity = (VolumeInfo)Entities.merge((Object)vol);
                    try {
                        entity.invalidateExport(token, nodeIp, nodeIqn);
                        return true;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error invalidating export: " + e.getMessage()));
                        return false;
                    }
                }
            }).apply((Object)volumeEntity)).booleanValue()) {
                LOG.error((Object)("Error invalidating the export record in the DB for volume " + volumeId));
            }
            tran.commit();
            reply.set_return(Boolean.valueOf(true));
        }
        catch (NoSuchElementException e) {
            LOG.error((Object)("Volume " + volumeId + " not found in DB"), (Throwable)e);
            throw new EucalyptusCloudException("Volume " + volumeId + " not found");
        }
        catch (Exception e) {
            LOG.error((Object)("Failed UnexportVolume due to: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ExportVolumeResponseType ExportVolume(ExportVolumeType request) throws EucalyptusCloudException {
        ExportVolumeResponseType reply = (ExportVolumeResponseType)request.getReply();
        final String volumeId = request.getVolumeId();
        final String token = request.getToken();
        final String ip = request.getIp();
        final String iqn = request.getIqn();
        reply.setVolumeId(volumeId);
        LOG.info((Object)("Processing ExportVolume request for volume " + volumeId));
        Function<VolumeInfo, String> exportAndAttach = new Function<VolumeInfo, String>(){

            public String apply(VolumeInfo volume) {
                int tokenRetry = 3;
                VolumeToken tokenInfo = null;
                VolumeInfo volEntity = (VolumeInfo)Entities.merge((Object)volume);
                for (int i = 0; i < tokenRetry; ++i) {
                    try {
                        tokenInfo = volEntity.getAttachmentTokenIfValid(token);
                        if (tokenInfo != null) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Could not check for valid token. Will retry. ", (Throwable)e);
                        tokenInfo = null;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Token check backoff sleep interrupted", e);
                    }
                }
                if (tokenInfo == null) {
                    throw new RuntimeException("Cannot export, due to invalid token");
                }
                VolumeExportRecord export = null;
                try {
                    export = tokenInfo.getValidExport(ip, iqn);
                }
                catch (EucalyptusCloudException e2) {
                    LOG.error((Object)("Failed when checking/getting valid export for " + ip + " - " + iqn));
                    return null;
                }
                if (export == null) {
                    String connectionString = null;
                    try {
                        connectionString = blockManager.exportVolume(volumeId, iqn);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not attach volume: " + e.getMessage()));
                        LOG.trace((Object)"Failed volume attach", (Throwable)e);
                        return null;
                    }
                    try {
                        tokenInfo.addExport(ip, iqn, connectionString);
                        return connectionString;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not export volume " + volumeId + " failed to add export record"));
                        try {
                            LOG.info((Object)("Unexporting volume " + volumeId + " to " + iqn + " for export failure cleanup"));
                            blockManager.unexportVolume(volumeId, iqn);
                        }
                        catch (EucalyptusCloudException e1) {
                            LOG.error((Object)"Failed to detach volume during invalidation failure", (Throwable)e);
                        }
                        return null;
                    }
                }
                LOG.debug((Object)("Found extant valid export for " + ip + " and " + iqn + " returning connection information for that export"));
                return export.getConnectionString();
            }
        };
        VolumeInfo searchVol = new VolumeInfo(volumeId);
        VolumeInfo vol = null;
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            vol = (VolumeInfo)Entities.uniqueResult((Object)searchVol);
            tran.commit();
        }
        catch (NoSuchElementException e) {
            LOG.error((Object)("No volume db record found for " + volumeId), (Throwable)e);
            throw new EucalyptusCloudException("Volume not found " + volumeId);
        }
        catch (TransactionException e) {
            LOG.error((Object)"Failed to Export due to db error", (Throwable)e);
            throw new EucalyptusCloudException("Could not export volume", (Throwable)e);
        }
        try {
            String connectionString = (String)Entities.asTransaction(VolumeInfo.class, (Function)exportAndAttach).apply((Object)vol);
            if (connectionString == null) {
                throw new Exception("Got null record result. Cannot set connection string");
            }
            reply.setConnectionString(connectionString);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed ExportVolume transaction due to: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Failed to add export", (Throwable)e);
        }
        return reply;
    }

    public GetStorageVolumeResponseType GetStorageVolume(GetStorageVolumeType request) throws EucalyptusCloudException {
        GetStorageVolumeResponseType reply = (GetStorageVolumeResponseType)request.getReply();
        if (!StorageProperties.enableStorage) {
            LOG.error((Object)"BlockStorage has been disabled. Please check your setup");
            return reply;
        }
        String volumeId = request.getVolumeId();
        LOG.info((Object)("Processing GetStorageVolume request for volume " + volumeId));
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo volumeInfo = new VolumeInfo();
            volumeInfo.setVolumeId(volumeId);
            List volumeInfos = Entities.query((Object)volumeInfo);
            if (volumeInfos.size() > 0) {
                VolumeInfo foundVolumeInfo = (VolumeInfo)volumeInfos.get(0);
                String deviceName = blockManager.getVolumeConnectionString(volumeId);
                reply.setVolumeId(foundVolumeInfo.getVolumeId());
                reply.setSize(foundVolumeInfo.getSize().toString());
                reply.setStatus(foundVolumeInfo.getStatus());
                reply.setSnapshotId(foundVolumeInfo.getSnapshotId());
                if (deviceName != null) {
                    reply.setActualDeviceName(deviceName);
                } else {
                    reply.setActualDeviceName("invalid");
                }
            } else {
                throw new NoSuchVolumeException(volumeId);
            }
            tran.commit();
        }
        return reply;
    }

    public DeleteStorageVolumeResponseType DeleteStorageVolume(DeleteStorageVolumeType request) throws EucalyptusCloudException {
        DeleteStorageVolumeResponseType reply = (DeleteStorageVolumeResponseType)request.getReply();
        if (!StorageProperties.enableStorage) {
            LOG.error((Object)"BlockStorage has been disabled. Please check your setup");
            return reply;
        }
        String volumeId = request.getVolumeId();
        LOG.info((Object)("Processing DeleteStorageVolume request for volume " + volumeId));
        VolumeInfo volumeInfo = new VolumeInfo();
        volumeInfo.setVolumeId(volumeId);
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo foundVolume = (VolumeInfo)Entities.uniqueResult((Object)volumeInfo);
            String status = foundVolume.getStatus();
            if (status == null) {
                throw new EucalyptusCloudException("Invalid volume status: null");
            }
            if (status.equals(StorageProperties.Status.available.toString()) || status.equals(StorageProperties.Status.failed.toString())) {
                LOG.trace((Object)("Marking volume " + volumeId + " for deletion"));
                foundVolume.setStatus(StorageProperties.Status.deleting.toString());
            } else if (status.equals(StorageProperties.Status.deleting.toString()) || status.equals(StorageProperties.Status.deleted.toString())) {
                LOG.debug((Object)("Volume " + volumeId + " already in deleting/deleted. No-op for delete request."));
            } else {
                throw new EucalyptusCloudException("Cannot delete volume in state: " + status + ". Please retry later");
            }
            reply.set_return(Boolean.TRUE);
            tran.commit();
        }
        catch (NoSuchElementException e) {
            LOG.warn((Object)("Got delete request, but unable to find volume in SC database: " + volumeId));
            reply.set_return(Boolean.TRUE);
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)("Error marking volume " + volumeId + " for deletion: " + e.getMessage()));
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Object)("Exception looking up volume: " + volumeId), e);
            throw new EucalyptusCloudException(e);
        }
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean totalSnapshotSizeLimitExceeded(String snapshotId, int volSize, int sizeLimitGB) throws EucalyptusCloudException {
        int totalSnapshotSize = 0;
        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
            Criteria query = Entities.createCriteria(SnapshotInfo.class);
            query.setReadOnly(true);
            ImmutableSet excludedStates = ImmutableSet.of((Object)StorageProperties.Status.failed.toString(), (Object)StorageProperties.Status.error.toString(), (Object)StorageProperties.Status.deleted.toString());
            query.add(Restrictions.not((Criterion)Restrictions.in((String)"status", (Collection)excludedStates)));
            HashSet<String> idSet = new HashSet<String>();
            List snapshots = query.list();
            tran.commit();
            for (SnapshotInfo snap : snapshots) {
                totalSnapshotSize += snap.getSizeGb() != null && idSet.add(snap.getSnapshotId()) ? snap.getSizeGb() : 0;
            }
            LOG.debug((Object)("Snapshot " + snapshotId + " checking snapshot total size of  " + totalSnapshotSize + " against limit of " + sizeLimitGB));
            boolean bl = totalSnapshotSize + volSize > sizeLimitGB;
            return bl;
        }
        catch (Throwable e) {
            LOG.error((Object)("Error finding total snapshot used size " + e.getMessage()));
            throw new EucalyptusCloudException("Failed to check snapshot total size limit", e);
        }
    }

    public CreateStorageSnapshotResponseType CreateStorageSnapshot(CreateStorageSnapshotType request) throws EucalyptusCloudException {
        CreateStorageSnapshotResponseType reply = (CreateStorageSnapshotResponseType)request.getReply();
        StorageProperties.updateWalrusUrl();
        if (!StorageProperties.enableSnapshots) {
            LOG.error((Object)"Snapshots have been disabled. Please check connection to ObjectStorage.");
            return reply;
        }
        String volumeId = request.getVolumeId();
        LOG.info((Object)("Processing CreateStorageSnapshot request for volume " + volumeId));
        String snapshotId = request.getSnapshotId();
        VolumeInfo sourceVolumeInfo = null;
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo volumeInfo = new VolumeInfo(volumeId);
            sourceVolumeInfo = (VolumeInfo)Entities.uniqueResult((Object)volumeInfo);
            tran.commit();
        }
        catch (NoSuchElementException e) {
            LOG.debug((Object)("Volume " + volumeId + " not found in db"));
            throw new NoSuchVolumeException(volumeId);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Volume " + volumeId + " error getting info from db. May not exist. " + e.getMessage()));
            throw new EucalyptusCloudException("Could not get volume information for volume " + volumeId, e);
        }
        if (sourceVolumeInfo == null) {
            throw new NoSuchVolumeException(volumeId);
        }
        if (!sourceVolumeInfo.getStatus().equals(StorageProperties.Status.available.toString())) {
            throw new VolumeNotReadyException(volumeId);
        }
        if (StorageProperties.shouldEnforceUsageLimits) {
            int maxSize = -1;
            try {
                maxSize = BlockStorageGlobalConfiguration.getInstance().getGlobal_total_snapshot_size_limit_gb();
            }
            catch (Exception e) {
                LOG.error((Object)"Could not determine max global snapshot limit. Aborting snapshot creation", (Throwable)e);
                throw new EucalyptusCloudException("Total size limit not found.", (Throwable)e);
            }
            if (maxSize <= 0) {
                LOG.warn((Object)"Total snapshot size limit is less than or equal to 0");
                throw new EucalyptusCloudException("Total snapshot size limit is less than or equal to 0");
            }
            if (this.totalSnapshotSizeLimitExceeded(snapshotId, sourceVolumeInfo.getSize(), maxSize)) {
                LOG.info((Object)("Snapshot " + snapshotId + " exceeds total snapshot size limit of " + maxSize + "GB"));
                throw new SnapshotTooLargeException(snapshotId, maxSize);
            }
        }
        Snapshotter snapshotter = null;
        SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId);
        Date startTime = new Date();
        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
            snapshotInfo.setUserName(sourceVolumeInfo.getUserName());
            snapshotInfo.setVolumeId(volumeId);
            snapshotInfo.setStartTime(startTime);
            snapshotInfo.setProgress("0");
            snapshotInfo.setSizeGb(sourceVolumeInfo.getSize());
            snapshotInfo.setStatus(StorageProperties.Status.creating.toString());
            String snapPointId = null;
            try {
                snapPointId = blockManager.createSnapshotPoint(volumeId, snapshotId);
                if (snapPointId == null) {
                    LOG.debug((Object)"Synchronous snap point not supported for this backend. Cleanly skipped.");
                } else {
                    snapshotInfo.setSnapPointId(snapPointId);
                }
                snapshotInfo.setStatus(StorageProperties.Status.creating.toString());
                Context ctx = null;
                try {
                    ctx = Contexts.lookup((String)request.getCorrelationId());
                    if (!ctx.getChannel().isOpen()) {
                        throw new NoSuchContextException("Channel is closed");
                    }
                }
                catch (NoSuchContextException e) {
                    if (snapPointId != null) {
                        throw new EucalyptusCloudException("Channel closed, aborting snapshot.");
                    }
                }
            }
            catch (EucalyptusCloudException e) {
                try {
                    blockManager.deleteSnapshotPoint(volumeId, snapshotId, snapPointId);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Snapshot " + snapshotId + " exception on snap point cleanup after failure: " + e.getMessage()));
                }
                LOG.error((Object)("Snapshot " + snapshotId + " failed to create snap point successfully: " + e.getMessage()));
                throw e;
            }
            finally {
                Entities.persist((Object)snapshotInfo);
                tran.commit();
            }
            snapshotter = new Snapshotter(volumeId, snapshotId, snapPointId);
            reply.setSnapshotId(snapshotId);
            reply.setVolumeId(volumeId);
            reply.setStartTime(DateUtils.format((long)startTime.getTime(), (String)"yyyy-MM-dd'T'HH:mm:ss") + ".000Z");
            reply.setProgress(snapshotInfo.getProgress());
        }
        catch (EucalyptusCloudException cloudEx) {
            snapshotInfo.setStatus(StorageProperties.Status.failed.toString());
            LOG.error((Object)("Snapshot " + snapshotId + " creation failed with exception "), (Throwable)cloudEx);
            throw cloudEx;
        }
        catch (Throwable e) {
            snapshotInfo.setStatus(StorageProperties.Status.failed.toString());
            LOG.error((Object)("Snapshot " + snapshotId + " Error committing state update to failed"), e);
            throw new EucalyptusCloudException("Snapshot " + snapshotId + " unexpected throwable exception caught", e);
        }
        reply.setStatus(snapshotInfo.getStatus());
        if (snapshotter != null) {
            snapshotService.add(snapshotter);
        }
        return reply;
    }

    public DescribeStorageSnapshotsResponseType DescribeStorageSnapshots(DescribeStorageSnapshotsType request) throws EucalyptusCloudException {
        DescribeStorageSnapshotsResponseType reply = (DescribeStorageSnapshotsResponseType)request.getReply();
        checker.transferPendingSnapshots();
        ArrayList snapshotSet = request.getSnapshotSet();
        ArrayList snapshotInfos = new ArrayList();
        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
            if (snapshotSet != null && !snapshotSet.isEmpty()) {
                for (String snapshotSetEntry : snapshotSet) {
                    SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotSetEntry);
                    List foundSnapshotInfos = Entities.query((Object)snapshotInfo);
                    if (foundSnapshotInfos.size() <= 0) continue;
                    snapshotInfos.add(foundSnapshotInfos.get(0));
                }
            } else {
                SnapshotInfo snapshotInfo = new SnapshotInfo();
                List foundSnapshotInfos = Entities.query((Object)snapshotInfo);
                for (SnapshotInfo snapInfo : foundSnapshotInfos) {
                    snapshotInfos.add(snapInfo);
                }
            }
            ArrayList snapshots = reply.getSnapshotSet();
            for (SnapshotInfo snapshotInfo : snapshotInfos) {
                snapshots.add(this.convertSnapshotInfo(snapshotInfo));
                if (!snapshotInfo.getStatus().equals(StorageProperties.Status.failed.toString())) continue;
                checker.cleanFailedSnapshot(snapshotInfo.getSnapshotId());
            }
            tran.commit();
        }
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteStorageSnapshotResponseType DeleteStorageSnapshot(DeleteStorageSnapshotType request) throws EucalyptusCloudException {
        DeleteStorageSnapshotResponseType reply = (DeleteStorageSnapshotResponseType)request.getReply();
        StorageProperties.updateWalrusUrl();
        if (!StorageProperties.enableSnapshots) {
            LOG.error((Object)"Snapshots have been disabled. Please check connection to ObjectStorage.");
            return reply;
        }
        String snapshotId = request.getSnapshotId();
        LOG.info((Object)("Processing DeleteStorageSnapshot request for snapshot " + snapshotId));
        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
            SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId);
            List snapshotInfos = Entities.query((Object)snapshotInfo);
            reply.set_return(Boolean.valueOf(false));
            if (snapshotInfos.size() > 0) {
                SnapshotInfo foundSnapshotInfo = (SnapshotInfo)snapshotInfos.get(0);
                String status = foundSnapshotInfo.getStatus();
                if (!status.equals(StorageProperties.Status.available.toString()) && !status.equals(StorageProperties.Status.failed.toString())) {
                    tran.rollback();
                    throw new SnapshotInUseException(snapshotId);
                }
                foundSnapshotInfo.setStatus(StorageProperties.Status.deleting.toString());
                tran.commit();
                reply.set_return(Boolean.valueOf(true));
                return reply;
            }
            reply.set_return(Boolean.valueOf(true));
            tran.rollback();
            return reply;
        }
    }

    public CreateStorageVolumeResponseType CreateStorageVolume(CreateStorageVolumeType request) throws EucalyptusCloudException {
        int sizeAsInt;
        CreateStorageVolumeResponseType reply = (CreateStorageVolumeResponseType)request.getReply();
        if (!StorageProperties.enableStorage) {
            LOG.error((Object)"BlockStorage has been disabled. Please check your setup");
            return reply;
        }
        String snapshotId = request.getSnapshotId();
        String parentVolumeId = request.getParentVolumeId();
        String userId = request.getUserId();
        String volumeId = request.getVolumeId();
        LOG.info((Object)("Processing CreateStorageVolume request for volume " + volumeId));
        String size = request.getSize();
        int n = sizeAsInt = size != null ? Integer.parseInt(size) : 0;
        if (size != null && sizeAsInt <= 0) {
            throw new InvalidParameterValueException("The parameter size (" + sizeAsInt + ") must be greater than zero.");
        }
        if (StorageProperties.shouldEnforceUsageLimits && size != null) {
            int totalVolumeSize = 0;
            VolumeInfo volInfo = new VolumeInfo();
            try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
                List volInfos = Entities.query((Object)volInfo);
                for (VolumeInfo vInfo : volInfos) {
                    if (vInfo.getStatus().equals(StorageProperties.Status.failed.toString()) || vInfo.getStatus().equals(StorageProperties.Status.error.toString()) || vInfo.getStatus().equals(StorageProperties.Status.deleted.toString())) continue;
                    totalVolumeSize += vInfo.getSize().intValue();
                }
                tran.commit();
            }
            if (totalVolumeSize + sizeAsInt > StorageInfo.getStorageInfo().getMaxTotalVolumeSizeInGb()) {
                throw new VolumeSizeExceededException(volumeId, "Total Volume Size Limit Exceeded");
            }
            if (sizeAsInt > StorageInfo.getStorageInfo().getMaxVolumeSizeInGB()) {
                throw new VolumeSizeExceededException(volumeId, "Max Volume Size Limit Exceeded");
            }
        }
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            VolumeInfo volumeInfo = new VolumeInfo(volumeId);
            List volumeInfos = Entities.query((Object)volumeInfo);
            if (volumeInfos.size() > 0) {
                throw new VolumeAlreadyExistsException(volumeId);
            }
            if (snapshotId != null) {
                SnapshotInfo snapInfo = new SnapshotInfo(snapshotId);
                snapInfo.setScName(null);
                snapInfo.setStatus(StorageProperties.Status.available.toString());
                List snapInfos = Entities.query((Object)snapInfo);
                if (snapInfos.size() == 0) {
                    throw new SnapshotNotFoundException("Snapshot " + snapshotId + " does not exist or is unavailable");
                }
                volumeInfo.setSnapshotId(snapshotId);
                reply.setSnapshotId(snapshotId);
            }
            volumeInfo.setUserName(userId);
            volumeInfo.setSize(Integer.valueOf(sizeAsInt));
            volumeInfo.setStatus(StorageProperties.Status.creating.toString());
            Date creationDate = new Date();
            volumeInfo.setCreateTime(creationDate);
            Entities.persist((Object)volumeInfo);
            reply.setVolumeId(volumeId);
            reply.setCreateTime(DateUtils.format((long)creationDate.getTime(), (String)"yyyy-MM-dd'T'HH:mm:ss") + ".000Z");
            reply.setSize(size);
            reply.setStatus(volumeInfo.getStatus());
            tran.commit();
        }
        VolumeCreator volumeCreator = new VolumeCreator(volumeId, "snapset", snapshotId, parentVolumeId, sizeAsInt);
        volumeService.add(volumeCreator);
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSnapshotMarkedFailed(String snapshotId) {
        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
            tran.setRollbackOnly();
            SnapshotInfo snap = (SnapshotInfo)Entities.uniqueResult((Object)new SnapshotInfo(snapshotId));
            if (snap == null) return false;
            if (!StorageProperties.Status.failed.toString().equals(snap.getStatus())) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)("Error determining status of snapshot " + snapshotId));
        }
        return false;
    }

    public DescribeStorageVolumesResponseType DescribeStorageVolumes(DescribeStorageVolumesType request) throws EucalyptusCloudException {
        DescribeStorageVolumesResponseType reply = (DescribeStorageVolumesResponseType)request.getReply();
        ArrayList volumeSet = request.getVolumeSet();
        ArrayList volumeInfos = new ArrayList();
        try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
            if (volumeSet != null && !volumeSet.isEmpty()) {
                for (String volumeSetEntry : volumeSet) {
                    VolumeInfo volumeInfo = new VolumeInfo(volumeSetEntry);
                    List foundVolumeInfos = Entities.query((Object)volumeInfo);
                    if (foundVolumeInfos.size() <= 0) continue;
                    volumeInfos.add(foundVolumeInfos.get(0));
                }
            } else {
                VolumeInfo volumeInfo = new VolumeInfo();
                List foundVolumeInfos = Entities.query((Object)volumeInfo);
                for (VolumeInfo volInfo : foundVolumeInfos) {
                    volumeInfos.add(volInfo);
                }
            }
            ArrayList volumes = reply.getVolumeSet();
            for (VolumeInfo volumeInfo : volumeInfos) {
                volumes.add(this.convertVolumeInfo(volumeInfo));
                if (!volumeInfo.getStatus().equals(StorageProperties.Status.failed.toString()) || System.currentTimeMillis() - volumeInfo.getLastUpdateTimestamp().getTime() <= 600000L) continue;
                LOG.warn((Object)("Failed volume, cleaning it: " + volumeInfo.getVolumeId()));
                checker.cleanFailedVolume(volumeInfo.getVolumeId());
            }
            tran.commit();
        }
        return reply;
    }

    public ConvertVolumesResponseType ConvertVolumes(ConvertVolumesType request) throws EucalyptusCloudException {
        ConvertVolumesResponseType reply = (ConvertVolumesResponseType)request.getReply();
        String provider = request.getOriginalProvider();
        provider = "com.eucalyptus.storage." + provider;
        if (!blockManager.getClass().getName().equals(provider)) {
            try {
                LogicalStorageManager fromBlockManager = (LogicalStorageManager)ClassLoader.getSystemClassLoader().loadClass(provider).newInstance();
                fromBlockManager.checkPreconditions();
                new VolumesConvertor(fromBlockManager).start();
            }
            catch (InstantiationException e) {
                LOG.error((Object)e);
                throw new EucalyptusCloudException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)e);
                throw new EucalyptusCloudException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
                throw new EucalyptusCloudException((Throwable)e);
            }
        }
        return reply;
    }

    public AttachStorageVolumeResponseType attachVolume(AttachStorageVolumeType request) throws EucalyptusCloudException {
        throw new EucalyptusCloudException("Operation not supported");
    }

    public DetachStorageVolumeResponseType detachVolume(DetachStorageVolumeType request) throws EucalyptusCloudException {
        DetachStorageVolumeResponseType reply = (DetachStorageVolumeResponseType)request.getReply();
        String volumeId = request.getVolumeId();
        LOG.info((Object)("Processing DetachVolume request for volume " + volumeId));
        try {
            LOG.info((Object)("Detaching volume " + volumeId + " from all hosts"));
            Entities.asTransaction(VolumeInfo.class, BlockStorageController.invalidateAndDetachAll()).apply((Object)volumeId);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to fully detach volume " + volumeId));
            reply.set_return(Boolean.valueOf(false));
        }
        return reply;
    }

    private static Function<String, VolumeInfo> invalidateAndDetachAll() {
        Predicate<VolumeToken> invalidateExports = new Predicate<VolumeToken>(){

            public boolean apply(VolumeToken volToken) {
                VolumeToken tokenEntity = (VolumeToken)Entities.merge((Object)volToken);
                try {
                    tokenEntity.invalidateAllExportsAndToken();
                    return true;
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed invalidating exports for token " + tokenEntity.getToken()));
                    return false;
                }
            }
        };
        return new Function<String, VolumeInfo>((Predicate)invalidateExports){
            final /* synthetic */ Predicate val$invalidateExports;
            {
                this.val$invalidateExports = predicate;
            }

            public VolumeInfo apply(String volumeId) {
                try {
                    VolumeInfo volumeEntity = (VolumeInfo)Entities.uniqueResult((Object)new VolumeInfo(volumeId));
                    try {
                        LOG.debug((Object)("Invalidating all tokens and all exports for " + volumeId));
                        if (!Iterables.all((Iterable)volumeEntity.getAttachmentTokens(), (Predicate)this.val$invalidateExports)) {
                            LOG.error((Object)"Failed to invalidate all tokens and exports");
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error invalidating tokens", (Throwable)e);
                    }
                    try {
                        LOG.debug((Object)("Unexporting volume " + volumeId + " from all hosts"));
                        blockManager.unexportVolumeFromAll(volumeId);
                    }
                    catch (EucalyptusCloudException ex) {
                        LOG.error((Object)("Detaching volume " + volumeId + " from all hosts failed"), (Throwable)ex);
                    }
                }
                catch (NoSuchElementException e) {
                    LOG.error((Object)("Cannot force detach of volume " + volumeId + " because it is not found in database"));
                    return null;
                }
                catch (TransactionException e) {
                    LOG.error((Object)("Failed to lookup volume " + volumeId));
                }
                return null;
            }
        };
    }

    private StorageVolume convertVolumeInfo(VolumeInfo volInfo) throws EucalyptusCloudException {
        StorageVolume volume = new StorageVolume();
        String volumeId = volInfo.getVolumeId();
        volume.setVolumeId(volumeId);
        volume.setStatus(volInfo.getStatus());
        volume.setCreateTime(DateUtils.format((long)volInfo.getCreateTime().getTime(), (String)"yyyy-MM-dd'T'HH:mm:ss") + ".000Z");
        volume.setSize(String.valueOf(volInfo.getSize()));
        volume.setSnapshotId(volInfo.getSnapshotId());
        VolumeToken tok = volInfo.getCurrentValidToken();
        if (tok != null) {
            volume.setActualDeviceName(BlockStorageUtil.encryptForNode((String)tok.getToken(), (Partition)BlockStorageUtil.getPartitionForLocalService(Storage.class)));
        } else {
            volume.setActualDeviceName("invalid");
        }
        return volume;
    }

    private StorageSnapshot convertSnapshotInfo(SnapshotInfo snapInfo) {
        StorageSnapshot snapshot = new StorageSnapshot();
        snapshot.setVolumeId(snapInfo.getVolumeId());
        snapshot.setStatus(snapInfo.getStatus());
        snapshot.setSnapshotId(snapInfo.getSnapshotId());
        String progress = snapInfo.getProgress();
        progress = progress != null ? progress + "%" : progress;
        snapshot.setProgress(progress);
        snapshot.setStartTime(DateUtils.format((long)snapInfo.getStartTime().getTime(), (String)"yyyy-MM-dd'T'HH:mm:ss") + ".000Z");
        return snapshot;
    }

    public CloneVolumeResponseType CloneVolume(CloneVolumeType request) throws EucalyptusCloudException {
        CloneVolumeResponseType reply = (CloneVolumeResponseType)request.getReply();
        CreateStorageVolumeType createStorageVolume = new CreateStorageVolumeType();
        createStorageVolume.setParentVolumeId(request.getVolumeId());
        this.CreateStorageVolume(createStorageVolume);
        return reply;
    }

    static {
        randomGenerator = new Random();
    }

    public static class SnapshotDeleterTask
    extends CheckerTask {
        private S3SnapshotTransfer mock;

        public SnapshotDeleterTask() {
            this.name = "SnapshotDeleter";
        }

        public SnapshotDeleterTask(S3SnapshotTransfer mock) {
            this.mock = mock;
        }

        public void run() {
            SnapshotInfo searchSnap = new SnapshotInfo();
            searchSnap.setStatus(StorageProperties.Status.deleting.toString());
            List snapshotsToBeDeleted = null;
            try {
                snapshotsToBeDeleted = Transactions.findAll((Object)searchSnap);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to lookup snapshots marked for deletion", (Throwable)e);
                return;
            }
            if (snapshotsToBeDeleted != null && !snapshotsToBeDeleted.isEmpty()) {
                S3SnapshotTransfer snapshotTransfer = null;
                for (SnapshotInfo snap : snapshotsToBeDeleted) {
                    SnapshotInfo foundSnapshotInfo;
                    String snapshotId = snap.getSnapshotId();
                    LOG.info((Object)("Snapshot: " + snapshotId + " was marked for deletion. Cleaning up..."));
                    try {
                        blockManager.deleteSnapshot(snapshotId);
                    }
                    catch (EucalyptusCloudException e1) {
                        LOG.debug((Object)("Failed to delete " + snapshotId), (Throwable)e1);
                        LOG.warn((Object)("Unable to delete " + snapshotId + ". Will retry later"));
                        continue;
                    }
                    SnapshotInfo snapInfo = new SnapshotInfo(snapshotId);
                    try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
                        foundSnapshotInfo = (SnapshotInfo)Entities.uniqueResult((Object)snapInfo);
                        foundSnapshotInfo.setStatus(StorageProperties.Status.deleted.toString());
                        tran.commit();
                    }
                    catch (TransactionException | NoSuchElementException e) {
                        LOG.error((Object)e);
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)foundSnapshotInfo.getSnapshotLocation())) {
                        try {
                            String[] names = SnapshotInfo.getSnapshotBucketKeyNames((String)foundSnapshotInfo.getSnapshotLocation());
                            if (snapshotTransfer == null) {
                                snapshotTransfer = this.mock == null ? new S3SnapshotTransfer() : this.mock;
                            }
                            snapshotTransfer.setSnapshotId(snapshotId);
                            snapshotTransfer.setBucketName(names[0]);
                            snapshotTransfer.setKeyName(names[1]);
                            snapshotTransfer.delete();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Failed to delete snapshot " + snapshotId + " from objectstorage"), (Throwable)e);
                        }
                        continue;
                    }
                    LOG.debug((Object)("Snapshot location missing for " + snapshotId + ". Skipping deletion from ObjectStorageGateway"));
                }
            } else {
                LOG.trace((Object)"No snapshots marked for deletion");
            }
        }
    }

    public static class VolumeDeleterTask
    extends CheckerTask {
        public VolumeDeleterTask() {
            this.name = "VolumeDeleter";
        }

        public void run() {
            VolumeInfo searchVolume = new VolumeInfo();
            searchVolume.setStatus(StorageProperties.Status.deleted.toString());
            try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
                List deletedVolumes = Entities.query((Object)searchVolume);
                for (VolumeInfo deletedVolume : deletedVolumes) {
                    if (!deletedVolume.cleanupOnDeletion()) continue;
                    LOG.info((Object)("Volume deletion time expired for: " + deletedVolume.getVolumeId() + " ...cleaning up."));
                    Entities.delete((Object)deletedVolume);
                }
                tran.commit();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed during clean up of expired volume records", (Throwable)e);
            }
            searchVolume = new VolumeInfo();
            searchVolume.setStatus(StorageProperties.Status.deleting.toString());
            List volumesToBeDeleted = null;
            try {
                volumesToBeDeleted = Transactions.findAll((Object)searchVolume);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to lookup volumes marked for deletion", (Throwable)e);
                return;
            }
            if (volumesToBeDeleted != null && !volumesToBeDeleted.isEmpty()) {
                for (VolumeInfo vol : volumesToBeDeleted) {
                    try {
                        TransactionResource tran = Entities.transactionFor(VolumeInfo.class);
                        Throwable throwable = null;
                        vol = (VolumeInfo)Entities.uniqueResult((Object)vol);
                        final String volumeId = vol.getVolumeId();
                        LOG.info((Object)("Volume: " + volumeId + " marked for deletion. Checking export status"));
                        if (Iterables.any((Iterable)vol.getAttachmentTokens(), (Predicate)new Predicate<VolumeToken>(){

                            public boolean apply(VolumeToken token) {
                                try {
                                    return token.hasActiveExports();
                                }
                                catch (EucalyptusCloudException e) {
                                    LOG.warn((Object)("Failure checking for active exports for volume " + volumeId));
                                    return false;
                                }
                            }
                        })) {
                            LOG.info((Object)("Volume: " + volumeId + " found to be exported. Detaching volume from all hosts"));
                            try {
                                Entities.asTransaction(VolumeInfo.class, (Function)BlockStorageController.invalidateAndDetachAll()).apply((Object)volumeId);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Failed to fully detach volume " + volumeId), (Throwable)e);
                            }
                        }
                        LOG.info((Object)("Volume: " + volumeId + " was marked for deletion. Cleaning up..."));
                        try {
                            blockManager.deleteVolume(volumeId);
                        }
                        catch (EucalyptusCloudException e) {
                            LOG.debug((Object)("Failed to delete " + volumeId), (Throwable)e);
                            LOG.warn((Object)("Unable to delete " + volumeId + ". Will retry later"));
                            if (tran == null) continue;
                            if (throwable != null) {
                                try {
                                    tran.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            tran.close();
                            continue;
                        }
                        try {
                            vol.setStatus(StorageProperties.Status.deleted.toString());
                            vol.setDeletionTime(new Date());
                            EucaSemaphoreDirectory.removeSemaphore((String)volumeId);
                            tran.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                        finally {
                            if (tran == null) continue;
                            if (throwable != null) {
                                try {
                                    tran.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            tran.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error deleting volume " + vol.getVolumeId() + ": " + e.getMessage()));
                        LOG.debug((Object)("Exception during deleting volume " + vol.getVolumeId() + "."), (Throwable)e);
                    }
                }
            } else {
                LOG.trace((Object)"No volumes marked for deletion");
            }
        }
    }

    public static class VolumesConvertor
    extends Thread {
        private LogicalStorageManager fromBlockManager;

        public VolumesConvertor(LogicalStorageManager fromBlockManager) {
            this.fromBlockManager = fromBlockManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogicalStorageManager logicalStorageManager = blockManager;
            synchronized (logicalStorageManager) {
                StorageProperties.enableSnapshots = false;
                StorageProperties.enableStorage = false;
                ArrayList volumes = Lists.newArrayList();
                ArrayList snapshots = Lists.newArrayList();
                try (TransactionResource tran = Entities.transactionFor(VolumeInfo.class);){
                    VolumeInfo volumeInfo = new VolumeInfo();
                    volumeInfo.setStatus(StorageProperties.Status.available.toString());
                    List volumeInfos = Entities.query((Object)volumeInfo);
                    volumes.addAll(volumeInfos);
                    SnapshotInfo snapInfo = new SnapshotInfo();
                    snapInfo.setStatus(StorageProperties.Status.available.toString());
                    List snapshotInfos = Entities.query((Object)snapInfo);
                    snapshots.addAll(snapshotInfos);
                    tran.commit();
                }
                for (VolumeInfo volume : volumes) {
                    String volumeId = volume.getVolumeId();
                    try {
                        LOG.info((Object)("Converting volume: " + volumeId + " please wait..."));
                        String volumePath = this.fromBlockManager.getVolumePath(volumeId);
                        blockManager.importVolume(volumeId, volumePath, volume.getSize());
                        this.fromBlockManager.finishVolume(volumeId);
                        LOG.info((Object)("Done converting volume: " + volumeId));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        try {
                            blockManager.deleteVolume(volumeId);
                        }
                        catch (EucalyptusCloudException e1) {
                            LOG.error((Object)e1);
                        }
                    }
                }
                for (SnapshotInfo snap : snapshots) {
                    String snapshotId = snap.getSnapshotId();
                    try {
                        LOG.info((Object)("Converting snapshot: " + snapshotId + " please wait..."));
                        String snapPath = this.fromBlockManager.getSnapshotPath(snapshotId);
                        int size = this.fromBlockManager.getSnapshotSize(snapshotId);
                        blockManager.importSnapshot(snapshotId, snap.getVolumeId(), snapPath, size);
                        this.fromBlockManager.finishVolume(snapshotId);
                        LOG.info((Object)("Done converting snapshot: " + snapshotId));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        try {
                            blockManager.deleteSnapshot(snapshotId);
                        }
                        catch (EucalyptusCloudException e1) {
                            LOG.error((Object)e1);
                        }
                    }
                }
                LOG.info((Object)"Conversion complete");
                StorageProperties.enableSnapshots = true;
                StorageProperties.enableStorage = true;
            }
        }
    }

    public static class VolumeCreator
    extends VolumeTask {
        private String volumeId;
        private String snapshotId;
        private String parentVolumeId;
        private int size;

        public VolumeCreator(String volumeId, String snapshotSetName, String snapshotId, String parentVolumeId, int size) {
            this.volumeId = volumeId;
            this.snapshotId = snapshotId;
            this.parentVolumeId = parentVolumeId;
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success;
            block92: {
                success = true;
                if (this.snapshotId != null) {
                    try {
                        SnapshotInfo snapshotInfo = new SnapshotInfo(this.snapshotId);
                        List foundSnapshotInfos = Transactions.findAll((Object)snapshotInfo);
                        if (foundSnapshotInfos.size() == 0) {
                            block90: {
                                EucaSemaphore semaphore = EucaSemaphoreDirectory.getSolitarySemaphore((String)this.snapshotId);
                                try {
                                    semaphore.acquire();
                                    foundSnapshotInfos = Transactions.findAll((Object)snapshotInfo);
                                    if (foundSnapshotInfos.size() == 0) {
                                        SnapshotInfo firstSnap = null;
                                        snapshotInfo.setScName(null);
                                        try (TransactionResource tr = Entities.transactionFor(SnapshotInfo.class);){
                                            Criteria snapCriteria = Entities.createCriteria(SnapshotInfo.class).setReadOnly(true).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).setCacheable(true).add((Criterion)Example.create((Object)snapshotInfo).enableLike(MatchMode.EXACT)).addOrder(Order.asc((String)"creationTimestamp"));
                                            foundSnapshotInfos = snapCriteria.list();
                                            tr.commit();
                                        }
                                        if (foundSnapshotInfos == null || foundSnapshotInfos.size() <= 0) {
                                            throw new EucalyptusCloudException("No record of snapshot " + this.snapshotId + " on any SC");
                                        }
                                        firstSnap = (SnapshotInfo)foundSnapshotInfos.get(0);
                                        if (firstSnap.getSizeGb() == null || firstSnap.getSizeGb() <= 0) {
                                            throw new EucalyptusCloudException("Snapshot size for " + this.snapshotId + " is unknown. Cannot prep snapshot holder on the storage backend");
                                        }
                                        if (!blockManager.getFromBackend(this.snapshotId, firstSnap.getSizeGb())) {
                                            LOG.debug((Object)(this.snapshotId + " not found on storage backend. Will attempt to download from objectstorage gateway"));
                                            String bucket = null;
                                            String key = null;
                                            if (StringUtils.isBlank((String)firstSnap.getSnapshotLocation())) {
                                                throw new EucalyptusCloudException("Snapshot location (bucket, key) for " + this.snapshotId + " is unknown. Cannot download snapshot from objectstorage.");
                                            }
                                            String[] names = SnapshotInfo.getSnapshotBucketKeyNames((String)firstSnap.getSnapshotLocation());
                                            bucket = names[0];
                                            key = names[1];
                                            if (StringUtils.isBlank((String)bucket) || StringUtils.isBlank((String)key)) {
                                                throw new EucalyptusCloudException("Failed to parse bucket and key information for downloading " + this.snapshotId + ". Cannot download snapshot from objectstorage.");
                                            }
                                            S3SnapshotTransfer snapshotTransfer = new S3SnapshotTransfer(this.snapshotId, bucket, key);
                                            Long actualSizeInBytes = null;
                                            try {
                                                actualSizeInBytes = snapshotTransfer.getSizeInBytes();
                                            }
                                            catch (Exception e) {
                                                LOG.debug((Object)"Snapshot size not found", (Throwable)e);
                                            }
                                            if (actualSizeInBytes == null) {
                                                String tmpSnapshotFileName = null;
                                                try {
                                                    tmpSnapshotFileName = this.downloadSnapshotToTempFile(snapshotTransfer);
                                                    File snapFile = new File(tmpSnapshotFileName);
                                                    if (!snapFile.exists()) {
                                                        throw new EucalyptusCloudException("Unable to find snapshot " + this.snapshotId + "on SC");
                                                    }
                                                    long actualSnapSizeInMB = (long)Math.ceil((double)snapFile.length() / 1048576.0);
                                                    try {
                                                        StorageResource storageResource = blockManager.prepareSnapshot(this.snapshotId, firstSnap.getSizeGb(), actualSnapSizeInMB);
                                                        if (storageResource != null) {
                                                            if (storageResource.getPath().startsWith("/dev/")) {
                                                                SystemUtil.CommandOutput output = SystemUtil.runWithRawOutput((String[])new String[]{StorageProperties.EUCA_ROOT_WRAPPER, "dd", "if=" + tmpSnapshotFileName, "of=" + storageResource.getPath(), "bs=1M"});
                                                                LOG.debug((Object)("Output of dd command: " + output.error));
                                                                if (output.returnValue != 0) {
                                                                    throw new EucalyptusCloudException("Failed to copy the snapshot to the right location due to: " + output.error);
                                                                }
                                                                this.cleanupFile(tmpSnapshotFileName);
                                                            } else if (!snapFile.renameTo(new File(storageResource.getPath()))) {
                                                                throw new EucalyptusCloudException("Failed to rename the snapshot");
                                                            }
                                                            blockManager.finishVolume(this.snapshotId);
                                                        }
                                                        LOG.warn((Object)("Block Manager replied that " + this.snapshotId + " not on backend, but snapshot preparation indicated that the snapshot is already present"));
                                                    }
                                                    catch (Exception ex) {
                                                        LOG.error((Object)("Failed to prepare the snapshot " + this.snapshotId + " on storage backend. Cleaning up the snapshot on backend"), (Throwable)ex);
                                                        this.cleanFailedSnapshot(this.snapshotId);
                                                        throw ex;
                                                    }
                                                }
                                                catch (Exception ex) {
                                                    LOG.error((Object)("Failed to prepare the snapshot " + this.snapshotId + " on the storage backend. Cleaning up the snapshot on SC"), (Throwable)ex);
                                                    this.cleanupFile(tmpSnapshotFileName);
                                                    throw ex;
                                                }
                                            } else {
                                                long actualSnapSizeInMB = (long)Math.ceil((double)actualSizeInBytes.longValue() / 1048576.0);
                                                try {
                                                    StorageResource storageResource = blockManager.prepareSnapshot(this.snapshotId, firstSnap.getSizeGb(), actualSnapSizeInMB);
                                                    if (storageResource != null) {
                                                        snapshotTransfer.download(storageResource);
                                                        blockManager.finishVolume(this.snapshotId);
                                                    }
                                                    LOG.warn((Object)("Block Manager replied that " + this.snapshotId + " not on backend, but snapshot preparation indicated that the snapshot is already present"));
                                                }
                                                catch (Exception ex) {
                                                    LOG.error((Object)("Failed to prepare the snapshot " + this.snapshotId + " on storage backend. Cleaning up the snapshot on backend"), (Throwable)ex);
                                                    this.cleanFailedSnapshot(this.snapshotId);
                                                    throw ex;
                                                }
                                            }
                                        } else {
                                            LOG.debug((Object)(this.snapshotId + " found on storage backend"));
                                        }
                                        tr = Entities.transactionFor(SnapshotInfo.class);
                                        var7_13 = null;
                                        try {
                                            snapshotInfo = this.copySnapshotInfo(firstSnap);
                                            snapshotInfo.setProgress("100");
                                            snapshotInfo.setStartTime(new Date());
                                            snapshotInfo.setStatus(StorageProperties.Status.available.toString());
                                            Entities.persist((Object)snapshotInfo);
                                            tr.commit();
                                            break block90;
                                        }
                                        catch (Throwable throwable) {
                                            var7_13 = throwable;
                                            throw throwable;
                                        }
                                        finally {
                                            if (tr != null) {
                                                if (var7_13 != null) {
                                                    try {
                                                        tr.close();
                                                    }
                                                    catch (Throwable x2) {
                                                        var7_13.addSuppressed(x2);
                                                    }
                                                } else {
                                                    tr.close();
                                                }
                                            }
                                        }
                                    }
                                    SnapshotInfo foundSnapshotInfo = (SnapshotInfo)foundSnapshotInfos.get(0);
                                    if (!StorageProperties.Status.available.toString().equals(foundSnapshotInfo.getStatus())) {
                                        success = false;
                                        LOG.warn((Object)("snapshot " + foundSnapshotInfo.getSnapshotId() + " not available."));
                                    }
                                }
                                catch (InterruptedException ex) {
                                    throw new EucalyptusCloudException("semaphore could not be acquired");
                                }
                                finally {
                                    try {
                                        semaphore.release();
                                    }
                                    finally {
                                        EucaSemaphoreDirectory.removeSemaphore((String)this.snapshotId);
                                    }
                                }
                            }
                            if (success) {
                                this.size = blockManager.createVolume(this.volumeId, this.snapshotId, this.size);
                            }
                            break block92;
                        }
                        SnapshotInfo foundSnapshotInfo = (SnapshotInfo)foundSnapshotInfos.get(0);
                        if (!StorageProperties.Status.available.toString().equals(foundSnapshotInfo.getStatus())) {
                            success = false;
                            LOG.warn((Object)("snapshot " + foundSnapshotInfo.getSnapshotId() + " not available."));
                            break block92;
                        }
                        this.size = blockManager.createVolume(this.volumeId, this.snapshotId, this.size);
                    }
                    catch (Exception ex) {
                        success = false;
                        LOG.error((Object)("Failed to create volume " + this.volumeId), (Throwable)ex);
                    }
                } else {
                    try {
                        if (this.parentVolumeId != null) {
                            blockManager.cloneVolume(this.volumeId, this.parentVolumeId);
                        } else {
                            blockManager.createVolume(this.volumeId, this.size);
                        }
                    }
                    catch (Exception ex) {
                        success = false;
                        LOG.error((Object)("Failed to create volume " + this.volumeId), (Throwable)ex);
                    }
                }
            }
            VolumeInfo volumeInfo = new VolumeInfo(this.volumeId);
            try (TransactionResource tr = Entities.transactionFor(VolumeInfo.class);){
                VolumeInfo foundVolumeInfo = (VolumeInfo)Entities.uniqueResult((Object)volumeInfo);
                if (foundVolumeInfo != null) {
                    if (success) {
                        foundVolumeInfo.setStatus(StorageProperties.Status.available.toString());
                    } else {
                        foundVolumeInfo.setStatus(StorageProperties.Status.failed.toString());
                    }
                    if (this.snapshotId != null) {
                        foundVolumeInfo.setSize(Integer.valueOf(this.size));
                    }
                } else {
                    LOG.error((Object)("VolumeInfo entity for volume id " + this.volumeId + " was not found in the database"));
                }
                tr.commit();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to update VolumeInfo entity for volume id " + this.volumeId + " in the database"), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanFailedSnapshot(String snapshotId) {
            if (snapshotId == null) {
                return;
            }
            LOG.debug((Object)("Disconnecting and cleaning local snapshot after failed snapshot transfer: " + snapshotId));
            try {
                blockManager.finishVolume(snapshotId);
            }
            catch (Exception e) {
                LOG.error((Object)("Error finishing failed snapshot " + snapshotId), (Throwable)e);
            }
            finally {
                try {
                    blockManager.cleanSnapshot(snapshotId);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error deleting failed snapshot " + snapshotId), (Throwable)e);
                }
            }
        }

        private SnapshotInfo copySnapshotInfo(SnapshotInfo source) {
            SnapshotInfo copy = new SnapshotInfo(source.getSnapshotId());
            copy.setSizeGb(source.getSizeGb());
            copy.setSnapshotLocation(source.getSnapshotLocation());
            copy.setUserName(source.getUserName());
            copy.setVolumeId(source.getVolumeId());
            return copy;
        }

        private String downloadSnapshotToTempFile(SnapshotTransfer snapshotTransfer) throws EucalyptusCloudException {
            String tmpUncompressedFileName = null;
            File tmpUncompressedFile = null;
            int retry = 0;
            int maxRetry = 5;
            while ((tmpUncompressedFile = new File(tmpUncompressedFileName = StorageProperties.storageRootDirectory + File.separator + this.snapshotId + "-" + String.valueOf(randomGenerator.nextInt()))).exists() && retry++ < maxRetry) {
            }
            if (retry >= maxRetry) {
                throw new EucalyptusCloudException("Could not get a temporary file for snapshot " + this.snapshotId + " download after " + maxRetry + " attempts");
            }
            try {
                snapshotTransfer.download((StorageResource)new FileResource(this.snapshotId, tmpUncompressedFileName));
            }
            catch (Exception ex) {
                this.cleanupFile(tmpUncompressedFile);
                throw new EucalyptusCloudException("Failed to download snapshot " + this.snapshotId + " from objectstorage", (Throwable)ex);
            }
            return tmpUncompressedFileName;
        }

        private void cleanupFile(String fileName) {
            try {
                this.cleanupFile(new File(fileName));
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to delete file", (Throwable)e);
            }
        }

        private void cleanupFile(File file) {
            if (file != null && file.exists()) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to delete file", (Throwable)e);
                }
            }
        }
    }

    public static class Snapshotter
    extends SnapshotTask {
        private String volumeId;
        private String snapshotId;
        private String snapPointId;

        public Snapshotter(String volumeId, String snapshotId, String snapPointId) {
            this.volumeId = volumeId;
            this.snapshotId = snapshotId;
            this.snapPointId = snapPointId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block36: {
                EucaSemaphore semaphore = EucaSemaphoreDirectory.getSolitarySemaphore((String)this.volumeId);
                try {
                    String bucket;
                    S3SnapshotTransfer snapshotTransfer;
                    StorageResource snapshotResource;
                    Boolean shouldTransferSnapshots;
                    block34: {
                        shouldTransferSnapshots = true;
                        snapshotResource = null;
                        snapshotTransfer = null;
                        bucket = null;
                        shouldTransferSnapshots = StorageInfo.getStorageInfo().getShouldTransferSnapshots();
                        if (shouldTransferSnapshots.booleanValue()) {
                            snapshotTransfer = new S3SnapshotTransfer(this.snapshotId, this.snapshotId);
                            bucket = snapshotTransfer.prepareForUpload();
                            if (snapshotTransfer == null || StringUtils.isBlank((String)bucket)) {
                                throw new EucalyptusCloudException("Failed to initialize snapshot transfer mechanism for uploading " + this.snapshotId);
                            }
                        }
                        try {
                            try {
                                semaphore.acquire();
                            }
                            catch (InterruptedException ex) {
                                throw new EucalyptusCloudException("Failed to create snapshot " + this.snapshotId + " as the semaphore could not be acquired");
                            }
                            if (!BlockStorageController.isSnapshotMarkedFailed(this.snapshotId)) {
                                snapshotResource = blockManager.createSnapshot(this.volumeId, this.snapshotId, this.snapPointId, shouldTransferSnapshots);
                                break block34;
                            }
                            throw new EucalyptusCloudException("Snapshot " + this.snapshotId + " marked as failed by another thread");
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                    if (shouldTransferSnapshots.booleanValue()) {
                        if (snapshotResource == null) {
                            throw new EucalyptusCloudException("Snapshot file unknown. Cannot transfer snapshot");
                        }
                        String snapshotLocation = SnapshotInfo.generateSnapshotLocationURI((String)"objectstoragegateway", (String)bucket, (String)this.snapshotId);
                        SnapshotInfo snapInfo = new SnapshotInfo(this.snapshotId);
                        SnapshotInfo snapshotInfo = null;
                        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
                            snapshotInfo = (SnapshotInfo)Entities.uniqueResult((Object)snapInfo);
                            snapshotInfo.setSnapshotLocation(snapshotLocation);
                            tran.commit();
                        }
                        catch (TransactionException | NoSuchElementException e) {
                            LOG.debug((Object)("Failed to update upload location for snapshot " + this.snapshotId), e);
                        }
                        if (!BlockStorageController.isSnapshotMarkedFailed(this.snapshotId)) {
                            try {
                                snapshotTransfer.upload(snapshotResource);
                            }
                            catch (Exception e) {
                                throw new EucalyptusCloudException("Failed to upload snapshot " + this.snapshotId + " to objectstorage", (Throwable)e);
                            }
                        } else {
                            throw new EucalyptusCloudException("Snapshot " + this.snapshotId + " marked as failed by another thread");
                        }
                        try {
                            LOG.debug((Object)("Finalizing snapshot " + this.snapshotId + " post upload"));
                            blockManager.finishVolume(this.snapshotId);
                        }
                        catch (EucalyptusCloudException ex) {
                            LOG.error((Object)("Failed to finalize snapshot " + this.snapshotId), (Throwable)ex);
                        }
                        break block36;
                    }
                    Function<String, SnapshotInfo> updateFunction = new Function<String, SnapshotInfo>(){

                        public SnapshotInfo apply(String arg0) {
                            try {
                                SnapshotInfo snap = (SnapshotInfo)Entities.uniqueResult((Object)new SnapshotInfo(arg0));
                                snap.setStatus(StorageProperties.Status.available.toString());
                                snap.setProgress("100");
                                snap.setSnapPointId(null);
                                return snap;
                            }
                            catch (TransactionException | NoSuchElementException e) {
                                LOG.error((Object)("Failed to retrieve snapshot entity from DB for " + arg0), e);
                                return null;
                            }
                        }
                    };
                    Entities.asTransaction(SnapshotInfo.class, (Function)updateFunction).apply((Object)this.snapshotId);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to create snapshot " + this.snapshotId), (Throwable)ex);
                    try {
                        LOG.debug((Object)("Disconnecting snapshot " + this.snapshotId + " on failed snapshot attempt"));
                        blockManager.finishVolume(this.snapshotId);
                    }
                    catch (EucalyptusCloudException e1) {
                        LOG.debug((Object)("Deleting snapshot " + this.snapshotId + " on failed snapshot attempt"), (Throwable)e1);
                        blockManager.cleanSnapshot(this.snapshotId);
                    }
                    Function<String, SnapshotInfo> updateFunction = new Function<String, SnapshotInfo>(){

                        public SnapshotInfo apply(String arg0) {
                            try {
                                SnapshotInfo snap = (SnapshotInfo)Entities.uniqueResult((Object)new SnapshotInfo(arg0));
                                snap.setStatus(StorageProperties.Status.failed.toString());
                                snap.setProgress("0");
                                return snap;
                            }
                            catch (TransactionException | NoSuchElementException e) {
                                LOG.error((Object)("Failed to retrieve snapshot entity from DB for " + arg0), e);
                                return null;
                            }
                        }
                    };
                    Entities.asTransaction(SnapshotInfo.class, (Function)updateFunction).apply((Object)this.snapshotId);
                }
            }
        }
    }

    public static abstract class VolumeTask
    implements Runnable {
    }

    public static abstract class SnapshotTask
    implements Runnable {
    }
}

