/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.LogicalStorageManager;
import com.eucalyptus.blockstorage.S3SnapshotTransfer;
import com.eucalyptus.blockstorage.entities.SnapshotInfo;
import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.EucalyptusCloudException;
import java.util.List;
import org.apache.log4j.Logger;

public class BlockStorageChecker {
    private static Logger LOG = Logger.getLogger(BlockStorageChecker.class);
    private LogicalStorageManager blockManager;
    private static boolean transferredPending = false;
    S3SnapshotTransfer snapshotTransfer;

    public BlockStorageChecker(LogicalStorageManager blockManager) {
        this.blockManager = blockManager;
    }

    public void startupChecks() {
        new StartupChecker().start();
    }

    public void cleanup() throws EucalyptusCloudException {
        LOG.info((Object)"Initiating startup cleanup operation for block storage");
        this.cleanVolumes();
        this.cleanSnapshots();
    }

    public void cleanVolumes() {
        LOG.info((Object)"Initiating volume cleanup for block storage");
        this.cleanStuckVolumes();
        this.cleanFailedVolumes();
    }

    public void cleanSnapshots() {
        LOG.info((Object)"Initiating snapshot cleanup for block storage");
        this.cleanFailedSnapshots();
        this.cleanStuckSnapshots();
    }

    public void cleanStuckVolumes() {
        List volumesInCreating;
        VolumeInfo volumeInfo = new VolumeInfo();
        volumeInfo.setStatus(StorageProperties.Status.creating.toString());
        try {
            volumesInCreating = Transactions.findAll((Object)volumeInfo);
        }
        catch (TransactionException f) {
            LOG.warn((Object)"Failed to execute query for stuck volumes", (Throwable)f);
            volumesInCreating = null;
        }
        if (volumesInCreating == null || volumesInCreating.size() == 0) {
            LOG.info((Object)"No stuck volumes found. No cleanup needed for stuck volumes");
            return;
        }
        for (VolumeInfo volInfo : volumesInCreating) {
            String volumeId = volInfo.getVolumeId();
            LOG.info((Object)("Cleaning stuck volume " + volumeId));
            try {
                this.blockManager.cleanVolume(volumeId);
                volInfo.setStatus(StorageProperties.Status.failed.toString());
                Transactions.save((Object)volInfo);
            }
            catch (Throwable f) {
                LOG.warn((Object)("Failed updating state of volume " + volumeId + " to failed state after back-end cleanup."));
            }
        }
    }

    public void cleanFailedVolumes() {
        VolumeInfo volumeInfo = new VolumeInfo();
        volumeInfo.setStatus(StorageProperties.Status.failed.toString());
        List volumeInfos = null;
        try {
            volumeInfos = Transactions.findAll((Object)volumeInfo);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error querying database for failed volumes", (Throwable)e);
        }
        if (volumeInfos == null || volumeInfos.size() == 0) {
            LOG.info((Object)"No failed volumes found to clean");
            return;
        }
        for (VolumeInfo volInfo : volumeInfos) {
            try {
                LOG.info((Object)("Cleaning failed volume " + volInfo.getVolumeId()));
                this.blockManager.cleanVolume(volInfo.getVolumeId());
                Transactions.delete((Object)volInfo);
            }
            catch (Exception e) {
                LOG.warn((Object)("Erorr cleaning failed volume " + volInfo.getVolumeId()), (Throwable)e);
            }
        }
    }

    public void cleanFailedVolume(String volumeId) {
        try {
            VolumeInfo volInfo = (VolumeInfo)Transactions.find((Object)new VolumeInfo(volumeId));
            LOG.info((Object)("Cleaning failed volume " + volumeId));
            this.blockManager.cleanVolume(volumeId);
            Transactions.delete((Object)volInfo);
        }
        catch (Exception e) {
            LOG.error((Object)"Erorr cleaning failed volume");
        }
    }

    public void cleanStuckSnapshots() {
        try (TransactionResource tran = Entities.transactionFor(SnapshotInfo.class);){
            SnapshotInfo snapshotInfo = new SnapshotInfo();
            snapshotInfo.setStatus(StorageProperties.Status.creating.toString());
            List snapshotInfos = Entities.query((Object)snapshotInfo, (boolean)false);
            for (SnapshotInfo snapInfo : snapshotInfos) {
                snapInfo.setStatus(StorageProperties.Status.failed.toString());
            }
            tran.commit();
        }
        catch (Throwable f) {
            LOG.warn((Object)"Failed cleaning stuck snapshots", f);
        }
    }

    public void cleanFailedSnapshots() {
        List snapshotInfos;
        SnapshotInfo snapshotInfo = new SnapshotInfo();
        snapshotInfo.setStatus(StorageProperties.Status.failed.toString());
        try {
            snapshotInfos = Transactions.findAll((Object)snapshotInfo);
        }
        catch (TransactionException e) {
            LOG.error((Object)"Error querying database for failed snapshots", (Throwable)e);
            snapshotInfos = null;
        }
        if (snapshotInfos == null || snapshotInfos.size() == 0) {
            LOG.info((Object)"No failed snapshots found to clean");
            return;
        }
        for (SnapshotInfo snapInfo : snapshotInfos) {
            try {
                this.cleanSnapshot(snapInfo);
                Transactions.delete((Object)snapInfo);
            }
            catch (Throwable f) {
                LOG.warn((Object)"Failed cleaning failed snapshots", f);
            }
        }
    }

    public void cleanFailedSnapshot(String snapshotId) {
        SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId);
        try {
            SnapshotInfo snapInfo = (SnapshotInfo)Transactions.find((Object)snapshotInfo);
            this.cleanSnapshot(snapInfo);
            Transactions.delete((Object)snapInfo);
        }
        catch (Throwable f) {
            LOG.warn((Object)("Failed cleaning failed snapshot " + snapshotId), f);
        }
    }

    private void cleanSnapshot(SnapshotInfo snapInfo) {
        String snapshotId = snapInfo.getSnapshotId();
        LOG.info((Object)("Checker task cleaning up snapshot " + snapshotId));
        try {
            LOG.debug((Object)("Disconnecting snapshot " + snapshotId + " from the Storage Controller"));
            this.blockManager.finishVolume(snapshotId);
        }
        catch (Exception e) {
            LOG.debug((Object)("Attempt to disconnect snapshot " + snapshotId + " from Storage Controller failed because: " + e.getMessage()));
        }
        try {
            LOG.debug((Object)("Cleaning snapshot " + snapshotId + " on storage backend"));
            this.blockManager.cleanSnapshot(snapshotId);
        }
        catch (Exception e) {
            LOG.debug((Object)("Attempt to clean snapshot " + snapshotId + " on storage backend failed because: " + e.getMessage()));
        }
        try {
            LOG.debug((Object)("Cleaning snapshot " + snapshotId + " from objectsotrage"));
            if (this.snapshotTransfer == null) {
                this.snapshotTransfer = new S3SnapshotTransfer();
            }
            String[] names = SnapshotInfo.getSnapshotBucketKeyNames((String)snapInfo.getSnapshotLocation());
            this.snapshotTransfer.setSnapshotId(snapshotId);
            this.snapshotTransfer.setBucketName(names[0]);
            this.snapshotTransfer.setKeyName(names[1]);
            this.snapshotTransfer.cancelUpload();
        }
        catch (Exception e) {
            LOG.debug((Object)("Attempt to clean uploaded snapshot " + snapshotId + " from objectstorage failed because: " + e.getMessage()));
        }
    }

    public void transferPendingSnapshots() throws EucalyptusCloudException {
        if (!transferredPending) {
            SnapshotTransfer transferrer = new SnapshotTransfer(this);
            transferrer.start();
            transferredPending = true;
        }
    }

    private class SnapshotTransfer
    extends Thread {
        private BlockStorageChecker checker;

        public SnapshotTransfer(BlockStorageChecker checker) {
            this.checker = checker;
        }

        @Override
        public void run() {
        }
    }

    private class StartupChecker
    extends Thread {
        @Override
        public void run() {
            try {
                BlockStorageChecker.this.cleanup();
            }
            catch (EucalyptusCloudException e) {
                LOG.error((Object)"Startup cleanup failed", (Throwable)e);
            }
            try {
                BlockStorageChecker.this.blockManager.startupChecks();
            }
            catch (EucalyptusCloudException e) {
                LOG.error((Object)"Startup checks failed");
            }
        }
    }
}

