/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.worker;

import com.eucalyptus.compute.common.TagInfo;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.imaging.ImagingServiceProperties;
import com.eucalyptus.imaging.backend.worker.ImagingServiceLauncher;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@ConfigurableClass(root="services.imaging.worker", description="Parameters controlling image conversion service")
public class ImagingServiceLaunchers {
    private static Logger LOG = Logger.getLogger(ImagingServiceLaunchers.class);
    private static ImagingServiceLaunchers instance = new ImagingServiceLaunchers();
    private static Map<String, String> launchStateTable = Maps.newConcurrentMap();
    public static final String launcherId = "worker-01";
    public static final String SERVER_CERTIFICATE_NAME = "euca-internal-imaging-service";
    @ConfigurableField(displayName="configured", description="Configure imaging so a worker can be launched. If something goes south with the service thereis a chance that setting it to false and back to true would solve issues", initial="true", readonly=false, type=ConfigurableFieldType.BOOLEAN, changeListener=EnabledChangeListener.class)
    public static Boolean CONFIGURED = true;

    private ImagingServiceLaunchers() {
    }

    public static ImagingServiceLaunchers getInstance() {
        return instance;
    }

    public boolean shouldDisable() {
        if (this.isLauncherLocked(launcherId)) {
            return false;
        }
        return this.tagExists();
    }

    public boolean shouldEnable() {
        if (this.isLauncherLocked(launcherId)) {
            return false;
        }
        return !this.tagExists();
    }

    public boolean isWorkedEnabled() {
        try {
            if (this.isLauncherLocked(launcherId)) {
                return false;
            }
            return this.tagExists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean tagExists() {
        boolean tagFound;
        block3: {
            tagFound = false;
            try {
                List tags = EucalyptusActivityTasks.getInstance().describeTags((List)Lists.newArrayList((Object[])new String[]{"value"}), (List)Lists.newArrayList((Object[])new String[]{"euca-internal-imaging-workers"}));
                if (tags == null) break block3;
                for (TagInfo tag : tags) {
                    if (!"euca-internal-imaging-workers".equals(tag.getValue()) || !"security-group".equals(tag.getResourceType())) continue;
                    tagFound = true;
                    break;
                }
            }
            catch (Exception ex) {
                tagFound = true;
            }
        }
        return tagFound;
    }

    public void enable() throws EucalyptusCloudException {
        if (!this.shouldEnable()) {
            throw new EucalyptusCloudException("Imaging service instances are found in the system");
        }
        this.lockLauncher(launcherId);
        try {
            String emi = ImagingServiceProperties.IMAGE;
            String instanceType = ImagingServiceProperties.INSTANCE_TYPE;
            String keyName = ImagingServiceProperties.KEYNAME;
            ImagingServiceLauncher launcher = null;
            try {
                ImagingServiceLauncher.Builder builder = new ImagingServiceLauncher.Builder(launcherId);
                launcher = builder.checkAdmission().withSecurityGroup().withRole().withInstanceProfile().withRolePermissions().withServerCertificate(SERVER_CERTIFICATE_NAME).withVolumeOperations().withS3Operations().withUserData().withLaunchConfiguration(emi, instanceType, keyName).withAutoScalingGroup().withTag("euca-internal-imaging-workers").build();
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed to prepare imaging service launcher", (Throwable)ex);
            }
            try {
                launcher.launch();
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed launching image service instance", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            this.releaseLauncher(launcherId);
            throw ex;
        }
    }

    public void disable() throws EucalyptusCloudException {
        if (!this.shouldDisable()) {
            throw new EucalyptusCloudException("Imaging service instances are not found in the system");
        }
        this.lockLauncher(launcherId);
        try {
            String emi = ImagingServiceProperties.IMAGE;
            String instanceType = ImagingServiceProperties.INSTANCE_TYPE;
            String keyName = ImagingServiceProperties.KEYNAME;
            String ntpServers = ImagingServiceProperties.NTP_SERVER;
            ImagingServiceLauncher launcher = null;
            try {
                ImagingServiceLauncher.Builder builder = new ImagingServiceLauncher.Builder(launcherId);
                launcher = builder.withSecurityGroup().withRole().withInstanceProfile().withRolePermissions().withServerCertificate(SERVER_CERTIFICATE_NAME).withVolumeOperations().withS3Operations().withUserData().withLaunchConfiguration(emi, instanceType, keyName).withAutoScalingGroup().withTag("euca-internal-imaging-workers").build();
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed to prepare imaging service launcher", (Throwable)ex);
            }
            try {
                launcher.destroy();
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed destroying image service instance", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            this.releaseLauncher(launcherId);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockLauncher(String launcherId) {
        Map<String, String> map = launchStateTable;
        synchronized (map) {
            launchStateTable.put(launcherId, "ENABLING");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLauncher(String launcherId) {
        Map<String, String> map = launchStateTable;
        synchronized (map) {
            launchStateTable.remove(launcherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLauncherLocked(String launcherId) {
        Map<String, String> map = launchStateTable;
        synchronized (map) {
            return launchStateTable.containsKey(launcherId);
        }
    }

    public static class EnabledChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            block9: {
                try {
                    if ("false".equals(((String)newValue).toLowerCase()) && "true".equals(t.getValue())) {
                        try {
                            if (ImagingServiceLaunchers.getInstance().shouldDisable()) {
                                ImagingServiceLaunchers.getInstance().disable();
                            }
                            break block9;
                        }
                        catch (ConfigurablePropertyException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                    }
                    if (!"true".equals((String)newValue)) {
                        throw new ConfigurablePropertyException("Invalid property value");
                    }
                }
                catch (ConfigurablePropertyException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    throw new ConfigurablePropertyException("Could not disable imaging service workers", (Throwable)e);
                }
            }
        }
    }
}

