/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend.worker;

import com.eucalyptus.imaging.backend.worker.AbstractAction;
import com.eucalyptus.imaging.backend.worker.ImagingServiceActions;
import com.eucalyptus.imaging.common.Imaging;
import com.eucalyptus.imaging.worker.ImagingServiceLaunchers;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ImagingServiceLauncher {
    private static Logger LOG = Logger.getLogger(ImagingServiceLauncher.class);
    private String launcherId = null;
    private List<AbstractAction> actions = null;

    private ImagingServiceLauncher(String launcherId, List<AbstractAction> actions) {
        this.launcherId = launcherId;
        this.actions = actions;
    }

    public void launch() throws EucalyptusCloudException {
        LOG.debug((Object)String.format("Enabling image service (%s)", this.launcherId));
        EnableWorker worker = new EnableWorker(this.launcherId, this.actions);
        Threads.enqueue(Imaging.class, ImagingServiceLauncher.class, (Callable)worker);
    }

    public void destroy() throws EucalyptusCloudException {
        LOG.debug((Object)String.format("Disabling imaging service (%s)", this.launcherId));
        DisableWorker worker = new DisableWorker(this.launcherId, this.actions);
        Threads.enqueue(Imaging.class, ImagingServiceLauncher.class, (Callable)worker);
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public String toString() {
        return String.format("ImagingService launcher - ", this.launcherId);
    }

    public static class Builder {
        private String launcherId = null;
        private List<AbstractAction> actions = Lists.newArrayList();
        private LOOKUP lookupAction = new LOOKUP();

        public Builder(String launcherId) {
            this.launcherId = launcherId;
        }

        public Builder withRole() {
            ImagingServiceActions.IamRoleSetup roleSetup = new ImagingServiceActions.IamRoleSetup(this.lookupAction, this.launcherId);
            this.actions.add(roleSetup);
            return this;
        }

        public Builder withInstanceProfile() {
            ImagingServiceActions.IamInstanceProfileSetup instanceProfileSetup = new ImagingServiceActions.IamInstanceProfileSetup(this.lookupAction, this.launcherId);
            this.actions.add(instanceProfileSetup);
            return this;
        }

        public Builder withRolePermissions() {
            ImagingServiceActions.IamRoleAuthorization roleAuthz = new ImagingServiceActions.IamRoleAuthorization(this.lookupAction, this.launcherId);
            this.actions.add(roleAuthz);
            return this;
        }

        public Builder withServerCertificate(String certName) {
            ImagingServiceActions.UploadServerCertificate uploadCert = new ImagingServiceActions.UploadServerCertificate(this.lookupAction, this.launcherId, certName);
            this.actions.add(uploadCert);
            ImagingServiceActions.AuthorizeServerCertificate authCert = new ImagingServiceActions.AuthorizeServerCertificate(this.lookupAction, this.launcherId);
            this.actions.add(authCert);
            return this;
        }

        public Builder withVolumeOperations() {
            ImagingServiceActions.AuthorizeVolumeOperations authVols = new ImagingServiceActions.AuthorizeVolumeOperations(this.lookupAction, this.launcherId);
            this.actions.add(authVols);
            return this;
        }

        public Builder withS3Operations() {
            ImagingServiceActions.AuthorizeS3Operations authS3 = new ImagingServiceActions.AuthorizeS3Operations(this.lookupAction, this.launcherId);
            this.actions.add(authS3);
            return this;
        }

        public Builder withUserData() {
            ImagingServiceActions.UserDataSetup userData = new ImagingServiceActions.UserDataSetup(this.lookupAction, this.launcherId);
            this.actions.add(userData);
            return this;
        }

        public Builder withLaunchConfiguration(String emi, String instanceType) {
            ImagingServiceActions.CreateLaunchConfiguration launchConfig = new ImagingServiceActions.CreateLaunchConfiguration(this.lookupAction, this.launcherId, emi, instanceType);
            this.actions.add(launchConfig);
            return this;
        }

        public Builder withLaunchConfiguration(String emi, String instanceType, String keyName) {
            ImagingServiceActions.CreateLaunchConfiguration launchConfig = new ImagingServiceActions.CreateLaunchConfiguration(this.lookupAction, this.launcherId, emi, instanceType, keyName);
            this.actions.add(launchConfig);
            return this;
        }

        public Builder withAutoScalingGroup() {
            ImagingServiceActions.CreateAutoScalingGroup asg = new ImagingServiceActions.CreateAutoScalingGroup(this.lookupAction, this.launcherId);
            this.actions.add(asg);
            return this;
        }

        public Builder withSecurityGroup() {
            ImagingServiceActions.SecurityGroupSetup sg = new ImagingServiceActions.SecurityGroupSetup(this.lookupAction, this.launcherId);
            this.actions.add(sg);
            return this;
        }

        public Builder withTag(String tagName) {
            ImagingServiceActions.CreateTags tag = new ImagingServiceActions.CreateTags(this.lookupAction, this.launcherId, tagName);
            this.actions.add(tag);
            return this;
        }

        public Builder withTag() {
            ImagingServiceActions.CreateTags tag = new ImagingServiceActions.CreateTags(this.lookupAction, this.launcherId);
            this.actions.add(tag);
            return this;
        }

        public Builder checkAdmission() {
            ImagingServiceActions.AdmissionControl control = new ImagingServiceActions.AdmissionControl(this.lookupAction, this.launcherId);
            this.actions.add(control);
            return this;
        }

        public ImagingServiceLauncher build() {
            return new ImagingServiceLauncher(this.launcherId, this.actions);
        }

        class LOOKUP
        implements Function<Class<? extends AbstractAction>, AbstractAction> {
            LOOKUP() {
            }

            public AbstractAction apply(Class<? extends AbstractAction> arg0) {
                for (AbstractAction action : Builder.this.actions) {
                    if (!action.getClass().isAssignableFrom(arg0)) continue;
                    return action;
                }
                return null;
            }
        }
    }

    private static class DisableWorker
    implements Callable<Boolean> {
        private List<AbstractAction> workerActions = null;
        private String launcherId = null;

        private DisableWorker(String launcherId, List<AbstractAction> actions) {
            this.launcherId = launcherId;
            this.workerActions = actions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            ArrayList executed = Lists.newArrayList();
            try {
                for (AbstractAction action : this.workerActions) {
                    try {
                        executed.add(action);
                        action.apply();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failed to execute imageservice launcher-action", (Throwable)ex);
                        break;
                    }
                }
                boolean rollbackFailed = false;
                for (AbstractAction executedAction : Lists.reverse((List)executed)) {
                    try {
                        executedAction.rollback();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failed to rollback imageservice launcher-action", (Throwable)ex);
                        rollbackFailed = true;
                    }
                }
                if (rollbackFailed || executed.size() != this.workerActions.size()) {
                    throw new EucalyptusCloudException("failed to destroy imaging service");
                }
            }
            catch (Exception exception) {
            }
            finally {
                ImagingServiceLaunchers.getInstance().releaseLauncher(this.launcherId);
            }
            return true;
        }
    }

    private static class EnableWorker
    implements Callable<Boolean> {
        private List<AbstractAction> workerActions = null;
        private String launcherId = null;

        private EnableWorker(String launcherId, List<AbstractAction> actions) {
            this.launcherId = launcherId;
            this.workerActions = actions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Boolean call() throws Exception {
            ArrayList executed = Lists.newArrayList();
            try {
                for (AbstractAction action : this.workerActions) {
                    try {
                        executed.add(action);
                        if (action.apply()) continue;
                        LOG.debug((Object)("Imaging service's launch has been terminated at " + action));
                        return true;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failed to execute imageservice launcher-action", (Throwable)ex);
                        for (AbstractAction executedAction : Lists.reverse((List)executed)) {
                            try {
                                executedAction.rollback();
                            }
                            catch (Exception eex) {
                                LOG.error((Object)"Failed to rollback imageservice launcher-action", (Throwable)ex);
                            }
                        }
                        throw new EucalyptusCloudException("Imaging service launch failed while executing " + action.toString(), (Throwable)ex);
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                return true;
            }
            finally {
                ImagingServiceLaunchers.getInstance().releaseLauncher(this.launcherId);
            }
        }
    }
}

