/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend.worker;

import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.Instance;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.TagDescription;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.imaging.ImagingServiceProperties;
import com.eucalyptus.imaging.backend.worker.AbstractAction;
import com.eucalyptus.imaging.backend.worker.ImagingServiceActionException;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ImagingServiceActions {
    private static Logger LOG = Logger.getLogger(ImagingServiceActions.class);

    public static class CreateTags
    extends AbstractAction {
        private String tagValue = null;
        private String tagKey = "Name";
        private String taggedSgroupId = null;
        private String taggedAsgName = null;

        public CreateTags(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        public CreateTags(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId, String tag) {
            super(lookup, groupId);
            this.tagValue = tag;
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String sgroupId;
            block19: {
                String asgName = null;
                try {
                    asgName = this.getResult(CreateAutoScalingGroup.class);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to get autoscaling group name", ex);
                }
                try {
                    DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups((List)Lists.newArrayList((Object[])new String[]{asgName}));
                    block12: for (AutoScalingGroupType asg : resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember()) {
                        if (asg.getTags() == null) continue;
                        for (TagDescription tag : asg.getTags().getMember()) {
                            if (!this.tagValue.equals(tag.getValue())) continue;
                            this.taggedAsgName = asgName;
                            continue block12;
                        }
                    }
                }
                catch (Exception resp) {
                    // empty catch block
                }
                if (this.taggedAsgName == null) {
                    try {
                        EucalyptusActivityTasks.getInstance().createOrUpdateAutoscalingTags(this.tagKey, this.tagValue, asgName);
                        this.taggedAsgName = asgName;
                    }
                    catch (Exception ex) {
                        throw new ImagingServiceActionException("failed to tag autoscaling group", ex);
                    }
                }
                String sgroupName = null;
                sgroupId = null;
                try {
                    SecurityGroupItemType current;
                    sgroupName = this.getResult(SecurityGroupSetup.class);
                    List groups = EucalyptusActivityTasks.getInstance().describeSecurityGroups((List)Lists.newArrayList((Object[])new String[]{sgroupName}));
                    if (groups != null && groups.size() > 0 && sgroupName.equals((current = (SecurityGroupItemType)groups.get(0)).getGroupName())) {
                        sgroupId = current.getGroupId();
                    }
                    if (sgroupId == null) {
                        throw new Exception(String.format("No security group named %s is found", sgroupName));
                    }
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to get security group name", ex);
                }
                try {
                    List tags = EucalyptusActivityTasks.getInstance().describeTags((List)Lists.newArrayList((Object[])new String[]{"value"}), (List)Lists.newArrayList((Object[])new String[]{this.tagValue}));
                    if (tags == null) break block19;
                    for (TagDescription tag : tags) {
                        if (!sgroupId.equals(tag.getResourceId())) continue;
                        this.taggedSgroupId = sgroupId;
                        break;
                    }
                }
                catch (Exception tags) {
                    // empty catch block
                }
            }
            if (this.taggedSgroupId == null) {
                try {
                    EucalyptusActivityTasks.getInstance().createTags(this.tagKey, this.tagValue, (List)Lists.newArrayList((Object[])new String[]{sgroupId}));
                    this.taggedSgroupId = sgroupId;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to tag security group", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.tagKey != null && this.tagValue != null) {
                if (this.taggedSgroupId != null) {
                    try {
                        EucalyptusActivityTasks.getInstance().deleteTags(this.tagKey, this.tagValue, (List)Lists.newArrayList((Object[])new String[]{this.taggedSgroupId}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.taggedAsgName != null) {
                    try {
                        EucalyptusActivityTasks.getInstance().deleteAutoscalingTags(this.tagKey, this.tagValue, this.taggedAsgName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public String getResult() {
            return this.tagValue;
        }
    }

    public static class AuthorizeS3Operations
    extends AbstractAction {
        public static final String S3_OPS_ROLE_POLICY_NAME_PREFIX = "imaging-iam-policy-s3";
        public static final String ROLE_S3_OPS_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\":[\"s3:*\"],\"Effect\": \"Allow\",\"Resource\": \"*\"}]}";
        private String roleName = null;
        private String createdPolicyName = null;

        public AuthorizeS3Operations(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            try {
                this.roleName = this.getResult(IamRoleSetup.class);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to find the created role name", ex);
            }
            String policyName = String.format("%s-%s", S3_OPS_ROLE_POLICY_NAME_PREFIX, this.getGroupId());
            String rolePolicyDoc = ROLE_S3_OPS_POLICY_DOCUMENT;
            try {
                GetRolePolicyResult rolePolicy = EucalyptusActivityTasks.getInstance().getRolePolicy(this.roleName, policyName);
                if (rolePolicy != null && policyName.equals(rolePolicy.getPolicyName())) {
                    this.createdPolicyName = policyName;
                }
            }
            catch (Exception rolePolicy) {
                // empty catch block
            }
            if (this.createdPolicyName == null) {
                try {
                    EucalyptusActivityTasks.getInstance().putRolePolicy(this.roleName, policyName, ROLE_S3_OPS_POLICY_DOCUMENT);
                    this.createdPolicyName = policyName;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to authorize S3 operations", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdPolicyName != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteRolePolicy(this.roleName, this.createdPolicyName);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to delete role policy for S3 operations", ex);
                }
            }
        }

        @Override
        public String getResult() {
            return this.createdPolicyName;
        }
    }

    public static class AuthorizeVolumeOperations
    extends AbstractAction {
        public static final String VOLUME_OPS_ROLE_POLICY_NAME_PREFIX = "imaging-iam-policy-volumes";
        public static final String ROLE_VOLUME_OPS_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\":[\"ec2:AttachVolume\",\"ec2:DetachVolume\",\"ec2:DescribeVolumes\"],\"Effect\": \"Allow\",\"Resource\": \"*\"}]}";
        private String roleName = null;
        private String createdPolicyName = null;

        public AuthorizeVolumeOperations(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            try {
                this.roleName = this.getResult(IamRoleSetup.class);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to find the created role name", ex);
            }
            String policyName = String.format("%s-%s", VOLUME_OPS_ROLE_POLICY_NAME_PREFIX, this.getGroupId());
            String rolePolicyDoc = ROLE_VOLUME_OPS_POLICY_DOCUMENT;
            try {
                GetRolePolicyResult rolePolicy = EucalyptusActivityTasks.getInstance().getRolePolicy(this.roleName, policyName);
                if (rolePolicy != null && policyName.equals(rolePolicy.getPolicyName())) {
                    this.createdPolicyName = policyName;
                }
            }
            catch (Exception rolePolicy) {
                // empty catch block
            }
            if (this.createdPolicyName == null) {
                try {
                    EucalyptusActivityTasks.getInstance().putRolePolicy(this.roleName, policyName, ROLE_VOLUME_OPS_POLICY_DOCUMENT);
                    this.createdPolicyName = policyName;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to authorize volume operations", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdPolicyName != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteRolePolicy(this.roleName, this.createdPolicyName);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to delete role policy for volume operations", ex);
                }
            }
        }

        @Override
        public String getResult() {
            return this.createdPolicyName;
        }
    }

    public static class AuthorizeServerCertificate
    extends AbstractAction {
        public static final String SERVER_CERT_ROLE_POLICY_NAME_PREFIX = "imaging-iam-policy-servercert";
        public static final String ROLE_SERVER_CERT_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\":[\"iam:DownloadServerCertificate\"],\"Effect\": \"Allow\",\"Resource\": \"CERT_ARN_PLACEHOLDER\"}]}";
        private String roleName = null;
        private String createdPolicyName = null;

        public AuthorizeServerCertificate(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String certName = null;
            String certArn = null;
            try {
                this.roleName = this.getResult(IamRoleSetup.class);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to find the created role name", ex);
            }
            try {
                certName = this.getResult(UploadServerCertificate.class);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to find the uploaded cert name", ex);
            }
            try {
                ServerCertificateType cert = EucalyptusActivityTasks.getInstance().getServerCertificate(certName);
                certArn = cert.getServerCertificateMetadata().getArn();
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to lookup server certificate", ex);
            }
            String policyName = String.format("%s-%s", SERVER_CERT_ROLE_POLICY_NAME_PREFIX, this.getGroupId());
            String rolePolicyDoc = ROLE_SERVER_CERT_POLICY_DOCUMENT.replace("CERT_ARN_PLACEHOLDER", certArn);
            try {
                GetRolePolicyResult rolePolicy = EucalyptusActivityTasks.getInstance().getRolePolicy(this.roleName, policyName);
                if (rolePolicy != null && policyName.equals(rolePolicy.getPolicyName())) {
                    this.createdPolicyName = policyName;
                }
            }
            catch (Exception rolePolicy) {
                // empty catch block
            }
            if (this.createdPolicyName == null) {
                try {
                    EucalyptusActivityTasks.getInstance().putRolePolicy(this.roleName, policyName, rolePolicyDoc);
                    this.createdPolicyName = policyName;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to authorize server certificate", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdPolicyName != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteRolePolicy(this.roleName, this.createdPolicyName);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to delete role policy for server certificate", ex);
                }
            }
        }

        @Override
        public String getResult() {
            return this.createdPolicyName;
        }
    }

    public static class UploadServerCertificate
    extends AbstractAction {
        private static final String DEFAULT_SERVER_CERT_PATH = "/euca-internal";
        private String createdServerCert = null;
        private String certificateName = null;

        public UploadServerCertificate(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId, String certName) {
            super(lookup, groupId);
            this.certificateName = certName;
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String certPath = DEFAULT_SERVER_CERT_PATH;
            try {
                ServerCertificateType cert = EucalyptusActivityTasks.getInstance().getServerCertificate(this.certificateName);
                if (cert != null && cert.getServerCertificateMetadata() != null) {
                    this.createdServerCert = cert.getServerCertificateMetadata().getServerCertificateName();
                }
            }
            catch (Exception ex) {
                this.createdServerCert = null;
            }
            if (this.createdServerCert == null) {
                String certPem = null;
                String pkPem = null;
                try {
                    KeyPair kp = Certs.generateKeyPair();
                    X509Certificate kpCert = Certs.generateCertificate((KeyPair)kp, (String)String.format("Certificate-for-imaging-workers(%s)", this.getGroupId()));
                    certPem = new String(PEMFiles.getBytes((Object)kpCert));
                    pkPem = new String(PEMFiles.getBytes((Object)kp));
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed generating server cert", ex);
                }
                try {
                    EucalyptusActivityTasks.getInstance().uploadServerCertificate(this.certificateName, DEFAULT_SERVER_CERT_PATH, certPem, pkPem, null);
                    this.createdServerCert = this.certificateName;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to upload server cert", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdServerCert != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteServerCertificate(this.createdServerCert);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to delete server certificate");
                }
            }
        }

        @Override
        public String getResult() {
            return this.createdServerCert;
        }
    }

    public static class CreateAutoScalingGroup
    extends AbstractAction {
        private String createdAutoScalingGroup = null;
        public static final int NUM_INSTANCES = 1;

        public CreateAutoScalingGroup(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String asgName = String.format("asg-euca-internal-imaging-%s", this.getGroupId());
            boolean asgFound = false;
            try {
                DescribeAutoScalingGroupsResponseType response = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups((List)Lists.newArrayList((Object[])new String[]{asgName}));
                ArrayList groups = response.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
                if (groups.size() > 0 && ((AutoScalingGroupType)groups.get(0)).getAutoScalingGroupName().equals(asgName)) {
                    asgFound = true;
                }
            }
            catch (Exception ex) {
                asgFound = false;
            }
            if (asgFound) {
                this.createdAutoScalingGroup = asgName;
                return true;
            }
            String launchConfigName = null;
            try {
                launchConfigName = this.getResult(CreateLaunchConfiguration.class);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to find the launch configuration name", ex);
            }
            List availabilityZones = null;
            try {
                availabilityZones = ImagingServiceProperties.listConfiguredZones();
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("Failed to lookup configured availability zones for imaging workers", ex);
            }
            if (availabilityZones.size() <= 0) {
                throw new ImagingServiceActionException("No availability zone is found for deploying imaging workers");
            }
            int capacity = 1 * availabilityZones.size();
            try {
                EucalyptusActivityTasks.getInstance().createAutoScalingGroup(asgName, availabilityZones, capacity, launchConfigName);
                this.createdAutoScalingGroup = asgName;
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("Failed to create autoscaling group", ex);
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdAutoScalingGroup != null) {
                HashSet instances = Sets.newHashSet();
                try {
                    DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups((List)Lists.newArrayList((Object[])new String[]{this.createdAutoScalingGroup}));
                    for (AutoScalingGroupType asg : resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember()) {
                        if (asg.getInstances() == null) continue;
                        for (Instance instance : asg.getInstances().getMember()) {
                            instances.add(instance.getInstanceId());
                        }
                    }
                }
                catch (Exception resp) {
                    // empty catch block
                }
                try {
                    EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(this.createdAutoScalingGroup, null, 0);
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("Unable to set desired capacity for %s", this.createdAutoScalingGroup), (Throwable)ex);
                }
                boolean error = false;
                int NUM_DELETE_ASG_RETRY = 4;
                for (int i = 0; i < 4; ++i) {
                    try {
                        EucalyptusActivityTasks.getInstance().deleteAutoScalingGroup(this.createdAutoScalingGroup, true);
                        boolean asgFound = false;
                        try {
                            DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups((List)Lists.newArrayList((Object[])new String[]{this.createdAutoScalingGroup}));
                            for (AutoScalingGroupType asg : resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember()) {
                                if (!this.createdAutoScalingGroup.equals(asg.getAutoScalingGroupName())) continue;
                                asgFound = true;
                            }
                        }
                        catch (Exception ex) {
                            asgFound = false;
                        }
                        if (asgFound) {
                            throw new Exception("Autoscaling group was not deleted");
                        }
                        error = false;
                    }
                    catch (Exception ex) {
                        error = true;
                        LOG.warn((Object)String.format("Failed to delete autoscale group (%d'th attempt): %s", i + 1, this.createdAutoScalingGroup));
                        try {
                            long sleepMs = (i + 1) * 500;
                            Thread.sleep(sleepMs);
                        }
                        catch (Exception sleepMs) {
                            // empty catch block
                        }
                    }
                    if (!error) break;
                }
                if (error) {
                    throw new ImagingServiceActionException("Failed to delete autoscaling group");
                }
                do {
                    ArrayList terminated = Lists.newArrayList();
                    for (String instanceId : instances) {
                        try {
                            List runningInstances = EucalyptusActivityTasks.getInstance().describeSystemInstances((List)Lists.newArrayList((Object[])new String[]{instanceId}));
                            String state = ((RunningInstancesItemType)runningInstances.get(0)).getStateName();
                            if (!"terminated".equals(state)) continue;
                            terminated.add(instanceId);
                        }
                        catch (Exception ex) {
                            terminated.add(instanceId);
                        }
                    }
                    for (String terminatedId : terminated) {
                        instances.remove(terminatedId);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (instances.size() > 0);
            }
        }

        @Override
        public String getResult() {
            if (this.createdAutoScalingGroup != null) {
                return this.createdAutoScalingGroup;
            }
            return null;
        }
    }

    public static class CreateLaunchConfiguration
    extends AbstractAction {
        private String emi = null;
        private String instanceType = null;
        private String keyName = null;
        private String createdLaunchConfig = null;

        public CreateLaunchConfiguration(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId, String emi, String instanceType) {
            super(lookup, groupId);
            this.emi = emi;
            this.instanceType = instanceType;
        }

        public CreateLaunchConfiguration(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId, String emi, String instanceType, String keyName) {
            this(lookup, groupId, emi, instanceType);
            this.keyName = keyName;
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String launchConfigName = String.format("lc-euca-internal-imaging-%s", this.getGroupId());
            try {
                LaunchConfigurationType lcFound = EucalyptusActivityTasks.getInstance().describeLaunchConfiguration(launchConfigName);
                this.createdLaunchConfig = launchConfigName;
            }
            catch (Exception lcFound) {
                // empty catch block
            }
            if (this.createdLaunchConfig == null) {
                String instanceProfileName = null;
                try {
                    instanceProfileName = this.getResult(IamInstanceProfileSetup.class);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to get the instance profile name", ex);
                }
                String sgName = null;
                try {
                    sgName = this.getResult(SecurityGroupSetup.class);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to get the security group name", ex);
                }
                String userData = null;
                try {
                    userData = this.getResult(UserDataSetup.class);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to get the user-data field", ex);
                }
                try {
                    EucalyptusActivityTasks.getInstance().createLaunchConfiguration(this.emi, this.instanceType, instanceProfileName, launchConfigName, sgName, this.keyName, userData);
                    this.createdLaunchConfig = launchConfigName;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("Failed to create launch configuration", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() {
            if (this.createdLaunchConfig != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(this.createdLaunchConfig);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public String getResult() {
            if (this.createdLaunchConfig != null) {
                return this.createdLaunchConfig;
            }
            return null;
        }
    }

    public static class UserDataSetup
    extends AbstractAction {
        public UserDataSetup(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            return true;
        }

        @Override
        public void rollback() {
        }

        @Override
        public String getResult() {
            String userData = B64.standard.encString((String)String.format("%s\n%s", ImagingServiceProperties.getCredentialsString(), ImagingServiceProperties.getWorkerUserData((String)ImagingServiceProperties.NTP_SERVER, (String)ImagingServiceProperties.LOG_SERVER, (String)ImagingServiceProperties.LOG_SERVER_PORT, (String)ImagingServiceProperties.INIT_SCRIPT)));
            return userData;
        }
    }

    public static class IamRoleAuthorization
    extends AbstractAction {
        public static final String IMAGING_SERVICE_ROLE_POLICY_NAME_PREFIX = "imaging-iam-policy-service-api";
        public static final String IMAGING_ROLE_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\": [\"eucaimaging:GetInstanceImportTask\", \"eucaimaging:PutInstanceImportTaskStatus\"],\"Effect\": \"Allow\",\"Resource\": \"*\"}]}";
        private String createdPolicyName = null;
        private String roleName = null;

        public IamRoleAuthorization(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            try {
                this.roleName = this.getResult(IamRoleSetup.class);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to find the created role name", ex);
            }
            String policyName = String.format("%s-%s", IMAGING_SERVICE_ROLE_POLICY_NAME_PREFIX, this.getGroupId());
            String rolePolicyDoc = IMAGING_ROLE_POLICY_DOCUMENT;
            try {
                GetRolePolicyResult rolePolicy = EucalyptusActivityTasks.getInstance().getRolePolicy(this.roleName, policyName);
                if (rolePolicy != null && policyName.equals(rolePolicy.getPolicyName())) {
                    this.createdPolicyName = policyName;
                }
            }
            catch (Exception rolePolicy) {
                // empty catch block
            }
            if (this.createdPolicyName == null) {
                try {
                    EucalyptusActivityTasks.getInstance().putRolePolicy(this.roleName, policyName, IMAGING_ROLE_POLICY_DOCUMENT);
                    this.createdPolicyName = policyName;
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to authorize imaging service api", ex);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdPolicyName != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteRolePolicy(this.roleName, this.createdPolicyName);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to delete role policy for imaging service api", ex);
                }
            }
        }

        @Override
        public String getResult() {
            return this.createdPolicyName;
        }
    }

    public static class IamInstanceProfileSetup
    extends AbstractAction {
        public static final String DEFAULT_INSTANCE_PROFILE_PATH_PREFIX = "/internal/imaging";
        public static final String DEFAULT_INSTANCE_PROFILE_NAME_PREFIX = "imaging";
        private InstanceProfileType instanceProfile = null;
        private String attachedRole = null;

        public IamInstanceProfileSetup(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String profilePath = DEFAULT_INSTANCE_PROFILE_PATH_PREFIX;
            String profileName = String.format("%s-%s", DEFAULT_INSTANCE_PROFILE_NAME_PREFIX, this.getGroupId());
            String roleName = this.getResult(IamRoleSetup.class);
            try {
                List instanceProfiles = EucalyptusActivityTasks.getInstance().listInstanceProfiles(DEFAULT_INSTANCE_PROFILE_PATH_PREFIX);
                for (InstanceProfileType ip : instanceProfiles) {
                    if (!profileName.equals(ip.getInstanceProfileName())) continue;
                    this.instanceProfile = ip;
                    break;
                }
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("Failed to list instance profiles", ex);
            }
            if (this.instanceProfile == null) {
                try {
                    this.instanceProfile = EucalyptusActivityTasks.getInstance().createInstanceProfile(profileName, DEFAULT_INSTANCE_PROFILE_PATH_PREFIX);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("Failed to create instance profile", ex);
                }
            }
            if (this.instanceProfile == null) {
                throw new ImagingServiceActionException("No instance profile for imaging service VM is found");
            }
            try {
                ArrayList roles = this.instanceProfile.getRoles().getMember();
                boolean roleFound = false;
                for (RoleType role : roles) {
                    if (!role.getRoleName().equals(roleName)) continue;
                    roleFound = true;
                    this.attachedRole = role.getRoleName();
                    break;
                }
                if (!roleFound) {
                    throw new NoSuchElementException();
                }
            }
            catch (Exception ex) {
                if (roleName == null) {
                    throw new ImagingServiceActionException("No role name is found for imaging service VMs");
                }
                try {
                    EucalyptusActivityTasks.getInstance().addRoleToInstanceProfile(this.instanceProfile.getInstanceProfileName(), roleName);
                    this.attachedRole = roleName;
                }
                catch (Exception ex2) {
                    throw new ImagingServiceActionException("Failed to add role to the instance profile", ex2);
                }
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.attachedRole != null && this.instanceProfile != null) {
                try {
                    EucalyptusActivityTasks.getInstance().removeRoleFromInstanceProfile(this.instanceProfile.getInstanceProfileName(), this.attachedRole);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.instanceProfile != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteInstanceProfile(this.instanceProfile.getInstanceProfileName());
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("Failed to delete instance profile", ex);
                }
            }
        }

        @Override
        public String getResult() {
            if (this.instanceProfile != null) {
                return this.instanceProfile.getInstanceProfileName();
            }
            return null;
        }
    }

    public static class IamRoleSetup
    extends AbstractAction {
        private static final String DEFAULT_ROLE_PATH_PREFIX = "/internal/imaging";
        private static final String DEFAULT_ROLE_NAME = "imaging";
        private static final String DEFAULT_ASSUME_ROLE_POLICY = "{\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"ec2.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}";
        private RoleType role = null;

        public IamRoleSetup(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            String roleName;
            block7: {
                String rolePath = DEFAULT_ROLE_PATH_PREFIX;
                roleName = String.format("%s-%s", DEFAULT_ROLE_NAME, this.getGroupId());
                String assumeRolePolicy = DEFAULT_ASSUME_ROLE_POLICY;
                try {
                    List result = EucalyptusActivityTasks.getInstance().listRoles(DEFAULT_ROLE_PATH_PREFIX);
                    if (result == null) break block7;
                    for (RoleType r : result) {
                        if (!roleName.equals(r.getRoleName())) continue;
                        this.role = r;
                        break;
                    }
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("Failed to list IAM roles", ex);
                }
            }
            if (this.role == null) {
                try {
                    this.role = EucalyptusActivityTasks.getInstance().createRole(roleName, DEFAULT_ROLE_PATH_PREFIX, DEFAULT_ASSUME_ROLE_POLICY);
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("Failed to create the role for Imaging Service Vms");
                }
            }
            if (this.role == null) {
                throw new ImagingServiceActionException("No role is found for Imaging Service Vms");
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.role != null) {
                try {
                    EucalyptusActivityTasks.getInstance().deleteRole(this.role.getRoleName());
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("failed to delete the created role");
                }
            }
        }

        @Override
        public String getResult() {
            if (this.role != null) {
                return this.role.getRoleName();
            }
            return null;
        }
    }

    public static class SecurityGroupSetup
    extends AbstractAction {
        private String createdGroup = null;
        private String createdGroupId = null;
        private String groupOwnerAccountId = null;

        public SecurityGroupSetup(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean apply() throws ImagingServiceActionException {
            groupName = String.format("euca-internal-imaging-%s", new Object[]{this.getGroupId()});
            groupDesc = String.format("group for imaging service workers", new Object[0]);
            groupFound = false;
            try {
                groups = EucalyptusActivityTasks.getInstance().describeSecurityGroups((List)Lists.newArrayList((Object[])new String[]{groupName}));
                if (groups != null && groups.size() > 0 && groupName.equals((current = (SecurityGroupItemType)groups.get(0)).getGroupName())) {
                    groupFound = true;
                    this.createdGroup = groupName;
                    this.createdGroupId = current.getGroupId();
                    this.groupOwnerAccountId = current.getAccountId();
                }
            }
            catch (Exception ex) {
                groupFound = false;
            }
            if (!groupFound) {
                try {
                    EucalyptusActivityTasks.getInstance().createSecurityGroup(groupName, groupDesc);
                    this.createdGroup = groupName;
                    groups = EucalyptusActivityTasks.getInstance().describeSecurityGroups((List)Lists.newArrayList((Object[])new String[]{groupName}));
                    if (groups == null || groups.size() <= 0 || !groupName.equals((current = (SecurityGroupItemType)groups.get(0)).getGroupName())) ** GOTO lbl26
                    this.groupOwnerAccountId = current.getAccountId();
                    this.createdGroupId = current.getGroupId();
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException("Failed to create the security group for imaging service", ex);
                }
            } else {
                this.createdGroup = groupName;
            }
lbl26:
            // 3 sources

            if (this.createdGroup == null || this.groupOwnerAccountId == null) {
                throw new ImagingServiceActionException("Failed to create the security group for loadbalancer");
            }
            return true;
        }

        @Override
        public void rollback() throws ImagingServiceActionException {
            if (this.createdGroup == null) {
                return;
            }
            try {
                EucalyptusActivityTasks.getInstance().deleteSecurityGroup(this.createdGroup);
                this.createdGroup = null;
                this.createdGroupId = null;
                this.groupOwnerAccountId = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public String getResult() {
            return this.createdGroup;
        }
    }

    public static class AdmissionControl
    extends AbstractAction {
        public AdmissionControl(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
            super(lookup, groupId);
        }

        @Override
        public boolean apply() throws ImagingServiceActionException {
            boolean asgFound = false;
            try {
                DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(null);
                ArrayList groups = resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
                for (AutoScalingGroupType asg : groups) {
                    if (!asg.getAutoScalingGroupName().contains(this.getGroupId())) continue;
                    asgFound = true;
                    break;
                }
            }
            catch (Exception ex) {
                asgFound = false;
            }
            if (asgFound) {
                return false;
            }
            String emi = ImagingServiceProperties.IMAGE;
            List images = null;
            try {
                images = EucalyptusActivityTasks.getInstance().describeImages((List)Lists.newArrayList((Object[])new String[]{emi}), false);
                if (images == null || images.size() <= 0 || !((ImageDetails)images.get(0)).getImageId().toLowerCase().equals(emi.toLowerCase())) {
                    throw new ImagingServiceActionException("No imaging service EMI is found");
                }
            }
            catch (ImagingServiceActionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to validate the imaging service EMI", ex);
            }
            List clusters = null;
            try {
                clusters = EucalyptusActivityTasks.getInstance().describeAvailabilityZones(true);
            }
            catch (Exception ex) {
                throw new ImagingServiceActionException("failed to validate the zones", ex);
            }
            String instanceType = ImagingServiceProperties.INSTANCE_TYPE;
            int numVm = 1;
            boolean resourceAvailable = false;
            for (ClusterInfoType cluster : clusters) {
                int capacity = this.findAvailableResources(clusters, cluster.getZoneName(), instanceType);
                if (numVm > capacity) continue;
                resourceAvailable = true;
                break;
            }
            if (!resourceAvailable) {
                throw new ImagingServiceActionException("not enough resource in the cloud");
            }
            String keyName = ImagingServiceProperties.KEYNAME;
            if (keyName != null && keyName.length() > 0) {
                try {
                    List keypairs = EucalyptusActivityTasks.getInstance().describeKeyPairs((List)Lists.newArrayList((Object[])new String[]{keyName}));
                    if (keypairs == null || keypairs.size() <= 0 || !((DescribeKeyPairsResponseItemType)keypairs.get(0)).getKeyName().equals(keyName)) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    throw new ImagingServiceActionException(String.format("The configured keyname %s is not found", ImagingServiceProperties.KEYNAME));
                }
            }
            return true;
        }

        private int findAvailableResources(List<ClusterInfoType> clusters, String zoneName, String instanceType) {
            block3: for (int i = 0; i < clusters.size(); ++i) {
                ClusterInfoType cc = clusters.get(i);
                if (!zoneName.equals(cc.getZoneName())) continue;
                for (int j = i + 1; j < clusters.size(); ++j) {
                    String state;
                    String[] tokens;
                    ClusterInfoType candidate = clusters.get(j);
                    if (candidate.getZoneName() == null || !candidate.getZoneName().toLowerCase().contains(instanceType.toLowerCase()) || (tokens = (state = candidate.getZoneState()).split("/")) == null || tokens.length <= 0) continue;
                    try {
                        String strNum = tokens[0].trim().replaceFirst("0+", "");
                        if (strNum.length() <= 0) {
                            strNum = "0";
                        }
                        return Integer.parseInt(strNum);
                    }
                    catch (NumberFormatException ex) {
                        break block3;
                    }
                    catch (Exception ex) {
                        break block3;
                    }
                }
                break;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public void rollback() {
        }

        @Override
        public String getResult() {
            return null;
        }
    }
}

