/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend.worker;

import com.eucalyptus.imaging.backend.worker.ImagingServiceActionException;
import com.google.common.base.Function;

public abstract class AbstractAction {
    private Function<Class<? extends AbstractAction>, AbstractAction> actionLookup = null;
    private String actionGroupId = null;

    public AbstractAction(Function<Class<? extends AbstractAction>, AbstractAction> lookup, String groupId) {
        this.actionLookup = lookup;
        this.actionGroupId = groupId;
    }

    public abstract boolean apply() throws ImagingServiceActionException;

    public abstract void rollback() throws ImagingServiceActionException;

    public abstract String getResult();

    public String getResult(Class<? extends AbstractAction> actionClass) {
        try {
            return ((AbstractAction)this.actionLookup.apply(actionClass)).getResult();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getGroupId() {
        return this.actionGroupId;
    }

    public String toString() {
        return String.format("Imaging Service launch action: %s-%s", this.actionGroupId, this.getClass().toString());
    }
}

