/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.compute.common.ConversionTask;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_imaging")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="metadata_imaging_task")
public class VolumeImagingTask
extends ImagingTask {
    private static Logger LOG = Logger.getLogger(VolumeImagingTask.class);
    @Transient
    private ConversionTask task;
    @Transient
    private ImagingTaskRelationView view;
    @Column(name="metadata_bytes_processed")
    private final Long bytesProcessed;
    @Column(name="metadata_cleaned_up")
    private Boolean cleanUpDone;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="metadata_import_instance_download_manifest_url")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<ImportToDownloadManifestUrl> downloadManifestUrl;

    protected VolumeImagingTask() {
        this(null, null);
        this.task = null;
    }

    VolumeImagingTask(String displayName) {
        this(null, displayName);
    }

    VolumeImagingTask(OwnerFullName owner, String displayName) {
        super(owner, displayName);
        this.bytesProcessed = null;
        this.cleanUpDone = false;
    }

    protected VolumeImagingTask(OwnerFullName ownerFullName, ConversionTask task, ImportTaskState state, long bytesProcessed) {
        super(ownerFullName, task.getConversionTaskId());
        this.task = task;
        this.setState(state);
        this.bytesProcessed = bytesProcessed;
        this.cleanUpDone = false;
    }

    static VolumeImagingTask named(OwnerFullName owner, String taskId) {
        return new VolumeImagingTask(owner, taskId);
    }

    static VolumeImagingTask namedByAccount(String accountNumber) {
        VolumeImagingTask task = new VolumeImagingTask();
        task.setOwnerAccountNumber(accountNumber);
        return task;
    }

    static VolumeImagingTask named(OwnerFullName owner) {
        return new VolumeImagingTask(owner, null);
    }

    static VolumeImagingTask named(ImportTaskState state) {
        VolumeImagingTask task = new VolumeImagingTask(null, null);
        task.setState(state);
        return task;
    }

    static VolumeImagingTask named(String taskId) {
        return new VolumeImagingTask(null, taskId);
    }

    static VolumeImagingTask named() {
        return new VolumeImagingTask();
    }

    public ConversionTask getTask() {
        return this.task;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[name: " + this.displayName + ", state: " + this.getState() + "]";
    }

    public long getBytesProcessed() {
        return this.bytesProcessed;
    }

    protected Boolean getCleanUpDone() {
        return this.cleanUpDone;
    }

    protected void setCleanUpDone(Boolean cleanUpDone) {
        this.cleanUpDone = cleanUpDone;
    }

    @Override
    protected void createTaskFromJSON() {
        if (this.taskInJSON != null) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            JSONObject taskObject = (JSONObject)jsonSlurper.parseText(this.taskInJSON);
            this.task = new ConversionTask(taskObject);
        }
    }

    @Override
    public String getTaskExpirationTime() {
        return this.task.getExpirationTime();
    }

    @Override
    public JSONObject toJSON() {
        return this.task.toJSON();
    }

    @Override
    public void setTaskState(String state) {
        this.task.setState(state);
    }

    @Override
    public String getTaskState() {
        return this.task.getState();
    }

    @Override
    public void setTaskStatusMessage(String msg) {
        this.task.setStatusMessage(msg);
    }

    public List<ImportToDownloadManifestUrlCoreView> getDownloadManifestUrl() {
        return this.view.getDownloadManifstUrls();
    }

    public void addDownloadManifestUrl(String importManifestUrl, String downloadManifestUrl) {
        ImportToDownloadManifestUrl mapping = new ImportToDownloadManifestUrl(importManifestUrl, downloadManifestUrl);
        this.downloadManifestUrl.add(mapping);
    }

    public boolean hasDownloadManifestUrl(String importManifestUrl) {
        for (ImportToDownloadManifestUrlCoreView mapping : this.view.getDownloadManifstUrls()) {
            if (!importManifestUrl.equals(mapping.getImportManifestUrl())) continue;
            return true;
        }
        return false;
    }

    public String getDownloadManifestUrl(String importManifestUrl) {
        for (ImportToDownloadManifestUrlCoreView mapping : this.view.getDownloadManifstUrls()) {
            if (!importManifestUrl.equals(mapping.getImportManifestUrl())) continue;
            return mapping.getDownloadManifestUrl();
        }
        return null;
    }

    public void clearDownloadManifesturl() {
        this.downloadManifestUrl.clear();
    }

    @Override
    @PostLoad
    protected void onLoad() {
        super.onLoad();
        if (this.view == null) {
            this.view = new ImagingTaskRelationView(this);
        }
    }

    public static class ImportToDownloadManifestUrlCoreView {
        private ImportToDownloadManifestUrl sourceObj = null;

        public ImportToDownloadManifestUrlCoreView(ImportToDownloadManifestUrl source) {
            this.sourceObj = source;
        }

        public String getImportManifestUrl() {
            return this.sourceObj.importManifestUrl;
        }

        public String getDownloadManifestUrl() {
            return this.sourceObj.downloadManifestUrl;
        }
    }

    public static enum ImportToDownloadManifestUrlCoreViewTransform implements Function<ImportToDownloadManifestUrl, ImportToDownloadManifestUrlCoreView>
    {
        INSTANCE;


        public ImportToDownloadManifestUrlCoreView apply(ImportToDownloadManifestUrl arg0) {
            return new ImportToDownloadManifestUrlCoreView(arg0);
        }
    }

    public static class ImagingTaskRelationView {
        private VolumeImagingTask imagingTask = null;
        private ImmutableList<ImportToDownloadManifestUrlCoreView> downloadManifestUrls = null;

        ImagingTaskRelationView(VolumeImagingTask task) {
            this.imagingTask = task;
            if (task.downloadManifestUrl != null) {
                this.downloadManifestUrls = ImmutableList.copyOf((Collection)Collections2.transform((Collection)task.downloadManifestUrl, (Function)ImportToDownloadManifestUrlCoreViewTransform.INSTANCE));
            }
        }

        public ImmutableList<ImportToDownloadManifestUrlCoreView> getDownloadManifstUrls() {
            return this.downloadManifestUrls;
        }
    }

    @Embeddable
    public static class ImportToDownloadManifestUrl {
        @Column(name="metadata_import_manifest_url", length=4096)
        private String importManifestUrl;
        @Column(name="metadata_download_manifest_url", length=4096)
        private String downloadManifestUrl;

        private ImportToDownloadManifestUrl() {
        }

        public ImportToDownloadManifestUrl(String importManifestUrl, String downloadManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            this.downloadManifestUrl = downloadManifestUrl;
        }

        public String getImportManifestUrl() {
            return this.importManifestUrl;
        }

        public String getDownloadManifestUrl() {
            return this.downloadManifestUrl;
        }
    }
}

