/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.compute.common.ImportInstanceVolumeDetail;
import com.eucalyptus.imaging.backend.AbstractTaskScheduler;
import com.eucalyptus.imaging.backend.DiskImagingTask;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImagingTasks;
import com.eucalyptus.imaging.backend.ImportInstanceImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.ImportVolumeImagingTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class TaskSchedulers {
    private static Logger LOG = Logger.getLogger(TaskSchedulers.class);

    public static class FCFSTaskScheduler
    extends AbstractTaskScheduler {
        @Override
        public ImagingTask getNext(String availabilityZone) {
            List<ImagingTask> allTasks = null;
            ArrayList pendingTasks = Lists.newArrayList();
            try {
                allTasks = ImagingTasks.getImagingTasks();
                for (ImagingTask t : allTasks) {
                    if (ImportTaskState.PENDING.equals(t.getState())) {
                        pendingTasks.add(t);
                        continue;
                    }
                    if (!ImportTaskState.CONVERTING.equals(t.getState()) || !(t instanceof ImportInstanceImagingTask)) continue;
                    pendingTasks.add(t);
                }
                ImagingTask oldestTask = null;
                Date oldest = new Date(Long.MAX_VALUE);
                for (ImagingTask task : pendingTasks) {
                    if (task instanceof ImportVolumeImagingTask) {
                        if (!availabilityZone.equals(((ImportVolumeImagingTask)task).getAvailabilityZone())) {
                            continue;
                        }
                    } else if (task instanceof ImportInstanceImagingTask) {
                        boolean clusterFound = false;
                        for (ImportInstanceVolumeDetail volume : ((ImportInstanceImagingTask)task).getVolumes()) {
                            String importManifestUrl = volume.getImage().getImportManifestUrl();
                            if (((ImportInstanceImagingTask)task).hasDownloadManifestUrl(importManifestUrl) || !availabilityZone.equals(volume.getAvailabilityZone())) continue;
                            clusterFound = true;
                            break;
                        }
                        if (!clusterFound) continue;
                    }
                    if (!oldest.after(task.getCreationTimestamp())) continue;
                    oldest = task.getCreationTimestamp();
                    oldestTask = task;
                }
                return oldestTask;
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to schedule the task to imaging worker", (Throwable)ex);
                return null;
            }
        }
    }

    public static class ImportImageFirstTaskScheduler
    extends AbstractTaskScheduler {
        @Override
        protected ImagingTask getNext(String availabilityZone) {
            List<ImagingTask> allTasks = null;
            ArrayList imagePendingTasks = Lists.newArrayList();
            ArrayList pendingTasks = Lists.newArrayList();
            try {
                allTasks = ImagingTasks.getImagingTasks();
                for (ImagingTask t : allTasks) {
                    if (t instanceof DiskImagingTask && ImportTaskState.PENDING.equals(t.getState())) {
                        imagePendingTasks.add(t);
                    }
                    if (ImportTaskState.PENDING.equals(t.getState())) {
                        pendingTasks.add(t);
                        continue;
                    }
                    if (!ImportTaskState.CONVERTING.equals(t.getState()) || !(t instanceof ImportInstanceImagingTask)) continue;
                    pendingTasks.add(t);
                }
                ImagingTask oldestTask = null;
                Date oldest = new Date(Long.MAX_VALUE);
                for (ImagingTask task : imagePendingTasks) {
                    if (!oldest.after(task.getCreationTimestamp())) continue;
                    oldest = task.getCreationTimestamp();
                    oldestTask = task;
                }
                if (oldestTask != null) {
                    return oldestTask;
                }
                for (ImagingTask task : pendingTasks) {
                    if (task instanceof ImportVolumeImagingTask) {
                        if (!availabilityZone.equals(((ImportVolumeImagingTask)task).getAvailabilityZone())) {
                            continue;
                        }
                    } else if (task instanceof ImportInstanceImagingTask) {
                        boolean clusterFound = false;
                        for (ImportInstanceVolumeDetail volume : ((ImportInstanceImagingTask)task).getVolumes()) {
                            String importManifestUrl = volume.getImage().getImportManifestUrl();
                            if (((ImportInstanceImagingTask)task).hasDownloadManifestUrl(importManifestUrl) || !availabilityZone.equals(volume.getAvailabilityZone())) continue;
                            clusterFound = true;
                            break;
                        }
                        if (!clusterFound) continue;
                    }
                    if (!oldest.after(task.getCreationTimestamp())) continue;
                    oldest = task.getCreationTimestamp();
                    oldestTask = task;
                }
                return oldestTask;
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to schedule the task to imaging worker", (Throwable)ex);
                return null;
            }
        }
    }
}

