/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.compute.common.ConversionTask;
import com.eucalyptus.compute.common.DiskImageDescription;
import com.eucalyptus.compute.common.DiskImageDetail;
import com.eucalyptus.compute.common.DiskImageVolume;
import com.eucalyptus.compute.common.DiskImageVolumeDescription;
import com.eucalyptus.compute.common.ImportVolumeTaskDetails;
import com.eucalyptus.compute.common.backend.ImportVolumeType;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.imaging.ImportTaskProperties;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.VolumeImagingTask;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.util.Dates;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_imaging")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="volume-imaging-task")
public class ImportVolumeImagingTask
extends VolumeImagingTask {
    private static Logger LOG = Logger.getLogger(ImportVolumeImagingTask.class);

    protected ImportVolumeImagingTask() {
    }

    protected ImportVolumeImagingTask(OwnerFullName owner, String taskId) {
        super(owner, taskId);
    }

    protected ImportVolumeImagingTask(OwnerFullName ownerFullName, ConversionTask conversionTask) {
        super(ownerFullName, conversionTask, ImportTaskState.NEW, 0L);
    }

    public static ImportVolumeImagingTask create(OwnerFullName ownerFullName, ConversionTask conversionTask) {
        return new ImportVolumeImagingTask(ownerFullName, conversionTask);
    }

    public static ImportVolumeImagingTask named(OwnerFullName owner, String taskId) {
        return new ImportVolumeImagingTask(owner, taskId);
    }

    public String getAvailabilityZone() {
        try {
            return this.getTask().getImportVolume().getAvailabilityZone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getVolumeId() {
        try {
            return this.getTask().getImportVolume().getVolume().getId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Integer getVolumeSize() {
        try {
            return this.getTask().getImportVolume().getVolume().getSize();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setVolumeId(String volumeId) {
        this.getTask().getImportVolume().getVolume().setId(volumeId);
        this.serializeTaskToJSON();
    }

    private void setVolumeSize(Integer volumeSize) {
        this.getTask().getImportVolume().getVolume().setSize(volumeSize);
        this.serializeTaskToJSON();
    }

    private void setAvailabilityZone(String availabilityZone) {
        this.getTask().getImportVolume().setAvailabilityZone(availabilityZone);
        this.serializeTaskToJSON();
    }

    public String getFormat() {
        try {
            return this.getTask().getImportVolume().getImage().getFormat();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setFormat(String format) {
        this.getTask().getImportVolume().getImage().setFormat(format);
        this.serializeTaskToJSON();
    }

    public Long getBytes() {
        try {
            return this.getTask().getImportVolume().getBytesConverted();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setBytes(Long bytes) {
        this.getTask().getImportVolume().setBytesConverted(bytes);
        this.serializeTaskToJSON();
    }

    public String getImportManifestUrl() {
        try {
            return this.getTask().getImportVolume().getImage().getImportManifestUrl();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setImportManifestUrl(String importManifestUrl) {
        this.getTask().getImportVolume().getImage().setImportManifestUrl(importManifestUrl);
        this.serializeTaskToJSON();
    }

    public String getDescription() {
        try {
            return this.getTask().getImportVolume().getDescription();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setDescription(String description) {
        this.getTask().getImportVolume().setDescription(description);
        this.serializeTaskToJSON();
    }

    @Override
    public void cleanUp() {
        if (this.getCleanUpDone().booleanValue()) {
            return;
        }
        ImportVolumeTaskDetails volumeDetails = this.getTask().getImportVolume();
        if (volumeDetails.getVolume() != null && volumeDetails.getVolume().getId() != null) {
            try {
                List eucaVolumes = EucalyptusActivityTasks.getInstance().describeVolumesAsUser(this.getOwnerUserId(), (List)Lists.newArrayList((Object[])new String[]{volumeDetails.getVolume().getId()}));
                if (eucaVolumes.size() != 0) {
                    EucalyptusActivityTasks.getInstance().deleteVolumeAsUser(this.getOwnerUserId(), volumeDetails.getVolume().getId());
                }
                this.setCleanUpDone(true);
            }
            catch (Exception ex) {
                LOG.warn((Object)String.format("Failed to delete the volume %s for import task %s", volumeDetails.getVolume().getId(), this.getDisplayName()));
            }
        }
    }

    @TypeMapper
    static enum VolumeImagingTaskTransform implements Function<ImportVolumeType, ImportVolumeImagingTask>
    {
        INSTANCE;


        @Nullable
        public ImportVolumeImagingTask apply(final @Nullable ImportVolumeType request) {
            final DiskImageDetail imageDetails = request.getImage();
            final DiskImageVolume volumeDetails = request.getVolume();
            Context ctx = Contexts.lookup();
            String conversionTaskId = ResourceIdentifiers.generateString((String)"import-vol");
            conversionTaskId = conversionTaskId.toLowerCase();
            ConversionTask conversionTask = new ConversionTask();
            conversionTask.setConversionTaskId(conversionTaskId);
            conversionTask.setExpirationTime(new Date(Dates.hoursFromNow((int)Integer.parseInt(ImportTaskProperties.IMPORT_TASK_EXPIRATION_HOURS)).getTime()).toString());
            conversionTask.setState(ImportTaskState.NEW.getExternalTaskStateName());
            conversionTask.setStatusMessage("");
            DiskImageVolumeDescription volumeImageDescription = new DiskImageVolumeDescription(){
                {
                    this.setSize(volumeDetails.getSize());
                }
            };
            DiskImageDescription diskImageDescription = new DiskImageDescription(){
                {
                    String manifestUrl = imageDetails.getImportManifestUrl();
                    this.setImportManifestUrl(manifestUrl);
                    this.setFormat(imageDetails.getFormat());
                    this.setSize(imageDetails.getBytes());
                }
            };
            ImportVolumeTaskDetails volumeTaskDetails = new ImportVolumeTaskDetails(){
                {
                    this.setAvailabilityZone(request.getAvailabilityZone());
                    this.setBytesConverted(0L);
                    this.setDescription(request.getDescription());
                }
            };
            volumeTaskDetails.setImage(diskImageDescription);
            volumeTaskDetails.setVolume(volumeImageDescription);
            conversionTask.setImportVolume(volumeTaskDetails);
            return ImportVolumeImagingTask.create((OwnerFullName)ctx.getUserFullName(), conversionTask);
        }
    }
}

