/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

public enum ImportTaskState {
    NEW("active", "active", "pending"),
    PENDING("active", "active", "pending"),
    CONVERTING("active", "active", "active"),
    INSTANTIATING("active", "active", "active"),
    CANCELLING("cancelling", "cancelling", ""),
    CANCELLED("cancelled", "cancelled", ""),
    COMPLETED("completed", "completed", ""),
    FAILED("cancelled", "cancelled", "failed (internal server error)");

    private final String externalTaskStateName;
    private final String externalVolumeStateName;
    private final String externalVolumeStatusMessage;
    public static final String STATE_MSG_DONE = "Import task finished successfully";
    public static final String STATE_MSG_FAILED_UNEXPECTED = "Import task failed unexpectedly";
    public static final String STATE_MSG_TASK_INSUFFICIENT_PARAMETERS = "Import task does not have sufficient parameters";
    public static final String STATE_MSG_TASK_EXPIRED = "Import task is expired";
    public static final String STATE_MSG_RUN_FAILURE = "Failed to run instances";
    public static final String STATE_MSG_SNAPSHOT_FAILURE = "Failed to create snapshot";
    public static final String STATE_MSG_REGISTER_FAILURE = "Failed to register image";
    public static final String STATE_MSG_USER_CANCELLATION = "Cancelled by user";
    public static final String STATE_MSG_PENDING_UPLOAD = "Pending import-image upload";
    public static final String STATE_MSG_PENDING_CONVERSION = "Pending conversion";
    public static final String STATE_MSG_IN_CONVERSION = "Converting images";
    public static final String STATE_MSG_CONVERSION_TIMEOUT = "Image conversion timed out";
    public static final String STATE_MSG_LAUNCHING_INSTANCE = "Launching instance";
    public static final String STATE_MSG_CONVERSION_FAILED = "Image conversion failed";
    public static final String STATE_MSG_DOWNLOAD_MANIFEST = "Failed to generate download manifest";
    public static final String STATE_MSG_CREATING_VOLUME = "Creating volumes";

    private ImportTaskState(String externalTaskState, String externalVolumeState, String externalVolumeStatus) {
        this.externalTaskStateName = externalTaskState;
        this.externalVolumeStateName = externalVolumeState;
        this.externalVolumeStatusMessage = externalVolumeStatus;
    }

    public static ImportTaskState fromString(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input can't be null");
        }
        return ImportTaskState.valueOf(input.toUpperCase().replaceAll("-", "_"));
    }

    public boolean validTransition(ImportTaskState newState) {
        if (newState == NEW && this == PENDING) {
            return true;
        }
        return newState.ordinal() > this.ordinal();
    }

    public String getExternalTaskStateName() {
        return this.externalTaskStateName;
    }

    public String getExternalVolumeStateName() {
        return this.externalVolumeStateName;
    }

    public String getExternalVolumeStatusMessage() {
        return this.externalVolumeStatusMessage;
    }
}

