/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.compute.common.ConversionTask;
import com.eucalyptus.compute.common.DiskImage;
import com.eucalyptus.compute.common.DiskImageDescription;
import com.eucalyptus.compute.common.DiskImageVolumeDescription;
import com.eucalyptus.compute.common.ImportInstanceLaunchSpecification;
import com.eucalyptus.compute.common.ImportInstanceTaskDetails;
import com.eucalyptus.compute.common.ImportInstanceType;
import com.eucalyptus.compute.common.ImportInstanceVolumeDetail;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.imaging.ImportTaskProperties;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.VolumeImagingTask;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.util.Dates;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_imaging")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="instance-imaging-task")
public class ImportInstanceImagingTask
extends VolumeImagingTask {
    private static Logger LOG = Logger.getLogger(ImportInstanceImagingTask.class);
    @Column(name="metadata_launchspec_architecture")
    private String architecture;
    @ElementCollection
    @CollectionTable(name="metadata_launchspec_security_groups")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<String> groupNames;
    @Transient
    private ImmutableList<String> groupNamesCopy;
    @ElementCollection
    @CollectionTable(name="metadata_snapshots")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> snapshotIds;
    @Transient
    private ImmutableList<String> snapshotIdsCopy;
    @Type(type="org.hibernate.type.StringClobType")
    @Lob
    @Column(name="metadata_launchspec_userdata")
    private String userData;
    @Column(name="metadata_launchspec_instance_type")
    private String instanceType;
    @Column(name="metadata_launchspec_availability_zone")
    private String availabilityZone;
    @Column(name="metadata_launchspec_monitoring_enabled")
    private Boolean monitoringEnabled;
    @Column(name="metadata_launchspec_subnet_id")
    private String subnetId;
    @Column(name="metadata_launchspec_shutdown_behavior")
    private String shutdownBehavior;
    @Column(name="metadata_launchspec_private_ip_address")
    private String privateIpAddress;
    @Column(name="metadata_launchspec_key_name")
    private String keyName;
    @Column(name="metadata_image_id")
    private String imageId;

    protected ImportInstanceImagingTask() {
    }

    protected ImportInstanceImagingTask(OwnerFullName ownerFullName, ConversionTask conversionTask) {
        super(ownerFullName, conversionTask, ImportTaskState.NEW, 0L);
    }

    public void setLaunchSpecArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getLaunchSpecArchitecture() {
        return this.architecture;
    }

    public List<String> getLaunchSpecGroupNames() {
        return this.groupNamesCopy;
    }

    public void addLaunchSpecGroupName(String groupName) {
        if (this.groupNames == null) {
            this.groupNames = Lists.newArrayList();
        }
        this.groupNames.add(groupName);
    }

    public void setLaunchSpecUserData(String userData) {
        this.userData = userData;
    }

    public String getLaunchSpecUserData() {
        return this.userData;
    }

    public void setLaunchSpecInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getLaunchSpecInstanceType() {
        return this.instanceType;
    }

    public void setLaunchSpecAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getLaunchSpecAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setLaunchSpecMonitoringEnabled(Boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    public Boolean getLaunchSpecMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setLaunchSpecKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getLaunchSpecKeyName() {
        return this.keyName;
    }

    public String getLaunchSpecSubnetId() {
        return this.subnetId;
    }

    public void setLaunchSpecSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getLaunchSpecPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setLaunchSpecPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public List<ImportInstanceVolumeDetail> getVolumes() {
        ImportInstanceTaskDetails importTask = this.getTask().getImportInstance();
        return importTask.getVolumes();
    }

    public List<String> getSnapshotIds() {
        return this.snapshotIdsCopy;
    }

    public void addSnapshotId(String snapshotId) {
        if (this.snapshotIds == null) {
            this.snapshotIds = Sets.newHashSet();
        }
        this.snapshotIds.add(snapshotId);
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    @Override
    @PostLoad
    protected void onLoad() {
        this.snapshotIdsCopy = ImmutableList.copyOf(this.snapshotIds);
        this.groupNamesCopy = ImmutableList.copyOf(this.groupNames);
        super.onLoad();
    }

    @Override
    public void cleanUp() {
        if (this.getCleanUpDone().booleanValue()) {
            return;
        }
        boolean cleanedAllVolumes = true;
        ImportInstanceTaskDetails instanceDetails = this.getTask().getImportInstance();
        if (instanceDetails.getVolumes() == null) {
            return;
        }
        for (ImportInstanceVolumeDetail volumeDetail : instanceDetails.getVolumes()) {
            if (volumeDetail.getVolume() == null || volumeDetail.getVolume().getId() == null) continue;
            try {
                List eucaVolumes = EucalyptusActivityTasks.getInstance().describeVolumesAsUser(this.getOwnerUserId(), (List)Lists.newArrayList((Object[])new String[]{volumeDetail.getVolume().getId()}));
                if (eucaVolumes.size() == 0) continue;
                EucalyptusActivityTasks.getInstance().deleteVolumeAsUser(this.getOwnerUserId(), volumeDetail.getVolume().getId());
            }
            catch (Exception ex) {
                LOG.warn((Object)String.format("Failed to delete the volume %s for import task %s", volumeDetail.getVolume().getId(), this.getDisplayName()));
                cleanedAllVolumes = false;
            }
        }
        if (cleanedAllVolumes) {
            this.setCleanUpDone(true);
        }
    }

    @TypeMapper
    static enum InstanceImagingTaskTransform implements Function<ImportInstanceType, ImportInstanceImagingTask>
    {
        INSTANCE;


        @Nullable
        public ImportInstanceImagingTask apply(ImportInstanceType input) {
            ConversionTask ct = new ConversionTask();
            String conversionTaskId = ResourceIdentifiers.generateString((String)"import-i");
            conversionTaskId = conversionTaskId.toLowerCase();
            ct.setConversionTaskId(conversionTaskId);
            ct.setExpirationTime(new Date(Dates.hoursFromNow((int)Integer.parseInt(ImportTaskProperties.IMPORT_TASK_EXPIRATION_HOURS)).getTime()).toString());
            ct.setState(ImportTaskState.NEW.getExternalTaskStateName());
            ct.setStatusMessage("");
            ImportInstanceTaskDetails instanceTask = new ImportInstanceTaskDetails();
            instanceTask.setDescription(input.getDescription());
            instanceTask.setPlatform(input.getPlatform());
            ImportInstanceLaunchSpecification launchSpec = input.getLaunchSpecification();
            ArrayList volumes = Lists.newArrayList();
            ArrayList disks = input.getDiskImageSet();
            if (disks != null) {
                for (DiskImage disk : disks) {
                    ImportInstanceVolumeDetail volume = new ImportInstanceVolumeDetail();
                    if (launchSpec != null && launchSpec.getPlacement() != null) {
                        volume.setAvailabilityZone(launchSpec.getPlacement().getAvailabilityZone());
                    }
                    volume.setImage(new DiskImageDescription());
                    volume.getImage().setFormat(disk.getImage().getFormat());
                    String manifestUrl = disk.getImage().getImportManifestUrl();
                    volume.getImage().setImportManifestUrl(manifestUrl);
                    volume.getImage().setSize(disk.getImage().getBytes());
                    volume.setVolume(new DiskImageVolumeDescription());
                    volume.getVolume().setSize(disk.getVolume().getSize());
                    volume.setBytesConverted(Long.valueOf(0L));
                    volume.setStatus(ImportTaskState.NEW.getExternalTaskStateName());
                    volumes.add(volume);
                }
            }
            instanceTask.setVolumes(volumes);
            ct.setImportInstance(instanceTask);
            ImportInstanceImagingTask newTask = new ImportInstanceImagingTask((OwnerFullName)Contexts.lookup().getUserFullName(), ct);
            newTask.serializeTaskToJSON();
            if (launchSpec.getArchitecture() == null || launchSpec.getArchitecture().length() <= 0) {
                newTask.setLaunchSpecArchitecture("i386");
            } else {
                newTask.setLaunchSpecArchitecture(launchSpec.getArchitecture());
            }
            if (launchSpec.getUserData() != null && launchSpec.getUserData().getData() != null) {
                newTask.setLaunchSpecUserData(launchSpec.getUserData().getData());
            }
            newTask.setLaunchSpecInstanceType(launchSpec.getInstanceType());
            if (launchSpec.getPlacement() != null) {
                newTask.setLaunchSpecAvailabilityZone(launchSpec.getPlacement().getAvailabilityZone());
            }
            if (launchSpec.getMonitoring() != null) {
                newTask.setLaunchSpecMonitoringEnabled(launchSpec.getMonitoring().getEnabled());
            }
            if (launchSpec.getGroupName() != null) {
                for (String groupName : launchSpec.getGroupName()) {
                    newTask.addLaunchSpecGroupName(groupName);
                }
            }
            if (launchSpec.getKeyName() != null && launchSpec.getKeyName().length() > 0) {
                newTask.setLaunchSpecKeyName(launchSpec.getKeyName());
            }
            if (!Strings.isNullOrEmpty((String)launchSpec.getSubnetId())) {
                newTask.setLaunchSpecSubnetId(launchSpec.getSubnetId());
                newTask.setLaunchSpecPrivateIpAddress(launchSpec.getPrivateIpAddress());
            }
            if (launchSpec.getInstanceInitiatedShutdownBehavior() != null) {
                LOG.warn((Object)"InitiatedShutdownBehavior is not supported for import-instance");
            }
            return newTask;
        }
    }
}

