/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.imaging.ImagingServiceProperties;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImagingTasks;
import com.eucalyptus.imaging.backend.ImagingWorker;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.imaging.common.Imaging;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class ImagingWorkers {
    private static Logger LOG = Logger.getLogger(ImagingWorkers.class);
    public static final int WORKER_TIMEOUT_MIN = 10;
    private static Set<String> verifiedWorkers = new HashSet<String>();
    private static Set<String> FatalTaskErrors = Sets.newHashSet((Object[])new String[]{"FailureToAttachVolume", "FailureToDetachVolume"});

    private static boolean shouldRemove(ImagingWorker worker) {
        Date lastUpdated = worker.getWorkerUpdateTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastUpdated);
        cal.add(12, 60);
        Date expirationTime = cal.getTime();
        return expirationTime.before(new Date());
    }

    private static boolean isTimedOut(ImagingWorker worker) {
        Date lastUpdated = worker.getWorkerUpdateTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastUpdated);
        cal.add(12, 10);
        Date expirationTime = cal.getTime();
        return expirationTime.before(new Date());
    }

    public static boolean hasWorker(String workerId) {
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            try {
                ImagingWorker imagingWorker = (ImagingWorker)((Object)Entities.uniqueResult((Object)((Object)ImagingWorker.named(workerId))));
            }
            catch (Exception ex) {
                boolean bl = false;
                if (db != null) {
                    if (var2_2 != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            var2_2.addSuppressed(x2);
                        }
                    } else {
                        db.close();
                    }
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static boolean canAllocate(String workerId) {
        ImagingWorker worker = ImagingWorkers.getWorker(workerId);
        if (worker == null) {
            return false;
        }
        return ImagingWorker.STATE.RUNNING.equals(worker.getState());
    }

    public static ImagingWorker getWorker(String workerId) {
        Throwable throwable = null;
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            ImagingWorker entity;
            ImagingWorker imagingWorker = entity = (ImagingWorker)((Object)Entities.uniqueResult((Object)((Object)ImagingWorker.named(workerId))));
            return imagingWorker;
        }
        catch (Exception ex) {
            ImagingWorker imagingWorker = null;
            return imagingWorker;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static List<ImagingWorker> listWorkers() {
        Throwable throwable = null;
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            List workers;
            List list = workers = Entities.query((Object)((Object)ImagingWorker.named()));
            return list;
        }
        catch (Exception ex) {
            try {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void verifyWorker(String instanceId, String remoteHost) throws Exception {
        if (!verifiedWorkers.contains(instanceId)) {
            try {
                List instances = EucalyptusActivityTasks.getInstance().describeSystemInstances((List)Lists.newArrayList((Object[])new String[]{instanceId}));
                RunningInstancesItemType workerInstance = (RunningInstancesItemType)instances.get(0);
                boolean tagFound = false;
                for (ResourceTag tag : workerInstance.getTagSet()) {
                    if (!"euca-internal-imaging-workers".equals(tag.getValue())) continue;
                    tagFound = true;
                    break;
                }
                if (!tagFound) {
                    throw new Exception("Instance does not have a proper tag");
                }
                if (!remoteHost.equals(workerInstance.getIpAddress()) && !remoteHost.equals(workerInstance.getPrivateIpAddress())) {
                    throw new Exception("Request came from invalid host address: " + remoteHost);
                }
                verifiedWorkers.add(instanceId);
            }
            catch (Exception ex) {
                throw new Exception("Failed to verify imaging worker", ex);
            }
        }
    }

    public static ImagingWorker createWorker(String workerId) {
        String availabilityZone = null;
        try {
            List instances = EucalyptusActivityTasks.getInstance().describeSystemInstances((List)Lists.newArrayList((Object[])new String[]{workerId}));
            availabilityZone = ((RunningInstancesItemType)instances.get(0)).getPlacement();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((String)("Unable to find the instance named: " + workerId), (Throwable[])new Throwable[0]);
        }
        Throwable throwable = null;
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            try {
                ImagingWorker entity = (ImagingWorker)((Object)Entities.uniqueResult((Object)((Object)ImagingWorker.named(workerId))));
                throw Exceptions.toUndeclared((Throwable)new Exception("Worker already exists"));
            }
            catch (NoSuchElementException ex) {
                ImagingWorker worker = new ImagingWorker(ImagingWorker.STATE.RUNNING, workerId);
                worker.setWorkerUpdateTime();
                worker.setAvailabilityZone(availabilityZone);
                Entities.persist((Object)((Object)worker));
                db.commit();
                ImagingWorker imagingWorker = worker;
                return imagingWorker;
            }
            catch (Exception ex) {
                try {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static void removeWorker(String workerId) {
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            try {
                ImagingWorker entity = (ImagingWorker)((Object)Entities.uniqueResult((Object)((Object)ImagingWorker.named(workerId))));
                Entities.delete((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static void markUpdate(String workerId) {
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            try {
                ImagingWorker entity = (ImagingWorker)((Object)Entities.uniqueResult((Object)((Object)ImagingWorker.named(workerId))));
                entity.setWorkerUpdateTime();
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private static void setWorkerState(String workerId, ImagingWorker.STATE state) {
        try (TransactionResource db = Entities.transactionFor(ImagingWorker.class);){
            try {
                ImagingWorker entity = (ImagingWorker)((Object)Entities.uniqueResult((Object)((Object)ImagingWorker.named(workerId))));
                entity.setState(state);
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static void retireWorker(String workerId) {
        ImagingWorkers.setWorkerState(workerId, ImagingWorker.STATE.RETIRING);
    }

    private static void decommisionWorker(String workerId) {
        String instanceId = null;
        try {
            List instances = EucalyptusActivityTasks.getInstance().describeSystemInstances((List)Lists.newArrayList((Object[])new String[]{workerId}));
            if (instances != null && instances.size() == 1) {
                instanceId = ((RunningInstancesItemType)instances.get(0)).getInstanceId();
            }
        }
        catch (Exception instances) {
            // empty catch block
        }
        if (instanceId != null) {
            try {
                EucalyptusActivityTasks.getInstance().terminateSystemInstance(workerId);
                LOG.debug((Object)("Terminated imaging worker: " + workerId));
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
        ImagingWorkers.setWorkerState(workerId, ImagingWorker.STATE.DECOMMISSIONED);
    }

    public static boolean isFatalError(String errorCode) {
        return FatalTaskErrors.contains(errorCode);
    }

    public static class ImagingWorkerStateManager
    implements EventListener<ClockTick> {
        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new ImagingWorkerStateManager());
        }

        public void fireEvent(ClockTick event) {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabledLocally(Imaging.class)) {
                return;
            }
            if (!ImagingServiceProperties.HEALTHCHECK.booleanValue()) {
                return;
            }
            try {
                List<ImagingWorker> workers = ImagingWorkers.listWorkers();
                ArrayList timedout = Lists.newArrayList();
                ArrayList retiring = Lists.newArrayList();
                ArrayList toRemove = Lists.newArrayList();
                for (ImagingWorker worker : workers) {
                    if (ImagingWorkers.isTimedOut(worker)) {
                        timedout.add(worker);
                    }
                    if (ImagingWorker.STATE.RETIRING.equals(worker.getState())) {
                        retiring.add(worker);
                    }
                    if (!ImagingWorker.STATE.DECOMMISSIONED.equals(worker.getState()) || !ImagingWorkers.shouldRemove(worker)) continue;
                    toRemove.add(worker);
                }
                for (ImagingWorker worker : timedout) {
                    LOG.warn((Object)String.format("Imaging service worker %s is not responding", worker.getDisplayName()));
                    ImagingWorkers.retireWorker(worker.getDisplayName());
                }
                for (ImagingWorker worker : retiring) {
                    ImagingTask task = ImagingTasks.getConvertingTaskByWorkerId(worker.getDisplayName());
                    if (task != null && ImportTaskState.CONVERTING.equals(task.getState())) {
                        ImagingTasks.killAndRerunTask(task.getDisplayName());
                        LOG.debug((Object)String.format("Imaging worker task %s is moved back into queue", task.getDisplayName()));
                    }
                    ImagingWorkers.decommisionWorker(worker.getDisplayName());
                }
                for (ImagingWorker worker : toRemove) {
                    LOG.debug((Object)("Forgetting about imaging worker " + worker.getDisplayName()));
                    ImagingWorkers.removeWorker(worker.getDisplayName());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to check imaging worker's state", (Throwable)ex);
            }
        }
    }
}

