/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.entities.AbstractStatefulPersistent;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_imaging")
@Table(name="metadata_imaging_workers")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ImagingWorker
extends AbstractStatefulPersistent<STATE> {
    @Column(name="metadata_conversion_update_time")
    private Date lastUpdateTime;
    @Column(name="metadata_availability_zone")
    private String availabilityZone;

    private ImagingWorker() {
        super(null, null);
    }

    private ImagingWorker(String instanceId) {
        super(null, instanceId);
    }

    public ImagingWorker(STATE state, String instanceId) {
        super((Enum)state, instanceId);
    }

    public static ImagingWorker named() {
        return new ImagingWorker();
    }

    public static ImagingWorker named(String workerId) {
        return new ImagingWorker(workerId);
    }

    public void setWorkerUpdateTime() {
        this.lastUpdateTime = new Date();
    }

    public Date getWorkerUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setAvailabilityZone(String zone) {
        this.availabilityZone = zone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    static enum STATE {
        RUNNING,
        RETIRING,
        DECOMMISSIONED;

    }
}

