/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.compute.common.ConversionTask;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.DiskImage;
import com.eucalyptus.compute.common.DiskImageDetail;
import com.eucalyptus.compute.common.DiskImageVolume;
import com.eucalyptus.compute.common.ImportInstanceLaunchSpecification;
import com.eucalyptus.compute.common.ImportInstanceVolumeDetail;
import com.eucalyptus.compute.common.InstancePlacement;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.common.backend.ImportInstanceType;
import com.eucalyptus.compute.common.backend.ImportVolumeType;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.imaging.ImagingServiceProperties;
import com.eucalyptus.imaging.backend.DiskImagingTask;
import com.eucalyptus.imaging.backend.ImagingServiceException;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImportInstanceImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.ImportVolumeImagingTask;
import com.eucalyptus.imaging.backend.VolumeImagingTask;
import com.eucalyptus.imaging.common.ConvertedImageDetail;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.imaging.common.ImportDiskImageDetail;
import com.eucalyptus.imaging.common.backend.msgs.ImportImageType;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ImagingTasks {
    private static Logger LOG = Logger.getLogger(ImagingTasks.class);
    private static Object lock = new Object();

    public static ImportVolumeImagingTask createImportVolumeTask(ImportVolumeType request) throws ImagingServiceException {
        String availabilityZone = request.getAvailabilityZone();
        if (availabilityZone == null || availabilityZone.length() <= 0) {
            throw new ImagingServiceException("Availability zone is required");
        }
        try {
            List clusters = ImagingServiceProperties.listConfiguredZones();
            if (!clusters.contains(availabilityZone)) {
                throw new ImagingServiceException(String.format("The availability zone %s is not configured for import", availabilityZone));
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "Failed to verify availability zone");
        }
        String format = request.getImage().getFormat();
        if (format == null || format.length() <= 0) {
            throw new ImagingServiceException("Image format is required");
        }
        try {
            IMAGE_FORMAT iMAGE_FORMAT = IMAGE_FORMAT.valueOf(format.toUpperCase());
        }
        catch (Exception ex) {
            throw new ImagingServiceException("Unsupported image format");
        }
        String manifestUrl = request.getImage().getImportManifestUrl();
        if (manifestUrl == null || manifestUrl.length() <= 0) {
            throw new ImagingServiceException("Import manifest url is required");
        }
        try {
            int volumeSize = request.getVolume().getSize();
            long imageBytes = request.getImage().getBytes();
            long volumeSizeInBytes = (long)volumeSize * (long)Math.pow(1024.0, 3.0);
            if (imageBytes > volumeSizeInBytes) {
                throw new ImagingServiceException("Requested volume size is not enough to hold the image");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "Failed to verify the requested volume size");
        }
        ImportVolumeImagingTask transform = (ImportVolumeImagingTask)TypeMappers.transform((Object)request, ImportVolumeImagingTask.class);
        try (TransactionResource db = Entities.transactionFor(ImportVolumeImagingTask.class);){
            try {
                Entities.persist((Object)transform);
                db.commit();
            }
            catch (Exception ex) {
                throw new ImagingServiceException("500", "Failed to persist VolumeImagingTask", ex);
            }
        }
        return transform;
    }

    public static ImportInstanceImagingTask createImportInstanceTask(ImportInstanceType request) throws ImagingServiceException {
        List clusters;
        ImportInstanceLaunchSpecification launchSpec = request.getLaunchSpecification();
        if (launchSpec == null) {
            throw new ImagingServiceException("Launch specification is required");
        }
        if (launchSpec.getArchitecture() == null || !"i386".equals(launchSpec.getArchitecture()) && !"x86_64".equals(launchSpec.getArchitecture())) {
            throw new ImagingServiceException("Architecture should be either i386 or x86_64");
        }
        if (launchSpec.getInstanceType() == null) {
            throw new ImagingServiceException("Instance type is required");
        }
        if (launchSpec.getKeyName() != null && launchSpec.getKeyName().length() > 0) {
            try {
                List keys = EucalyptusActivityTasks.getInstance().describeKeyPairsAsUser(Contexts.lookup().getUser().getUserId(), (List)Lists.newArrayList((Object[])new String[]{launchSpec.getKeyName()}));
                if (!launchSpec.getKeyName().equals(((DescribeKeyPairsResponseItemType)keys.get(0)).getKeyName())) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new ImagingServiceException("Key " + launchSpec.getKeyName() + " is not found");
            }
        }
        String availabilityZone = null;
        if (Strings.emptyToNull((String)launchSpec.getSubnetId()) != null) {
            try {
                List subnets = EucalyptusActivityTasks.getInstance().describeSubnetsAsUser(Contexts.lookup().getUser().getUserId(), Collections.singleton(launchSpec.getSubnetId()));
                if (subnets.size() != 1) {
                    throw new ImagingServiceException("Subnet " + launchSpec.getSubnetId() + " not found");
                }
                availabilityZone = ((SubnetType)subnets.get(0)).getAvailabilityZone();
                String cidr = ((SubnetType)subnets.get(0)).getCidrBlock();
                String privateIp = Strings.emptyToNull((String)launchSpec.getPrivateIpAddress());
                if (privateIp != null && !Cidr.parse((String)cidr).contains(privateIp)) {
                    throw new ImagingServiceException("Private IP " + privateIp + " not valid for subnet " + launchSpec.getSubnetId());
                }
            }
            catch (Exception ex) {
                Exceptions.findAndRethrow((Throwable)ex, ImagingServiceException.class);
                throw new ImagingServiceException("Subnet " + launchSpec.getSubnetId() + " not found");
            }
        }
        try {
            clusters = ImagingServiceProperties.listConfiguredZones();
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "Failed to verify availability zones");
        }
        if (availabilityZone == null) {
            if (launchSpec.getPlacement() != null) {
                availabilityZone = launchSpec.getPlacement().getAvailabilityZone();
            } else if (clusters.size() > 0) {
                availabilityZone = (String)clusters.get(0);
            } else {
                throw new ImagingServiceException("500", "No availability zone is found in the Cloud");
            }
        }
        if (!clusters.contains(availabilityZone)) {
            throw new ImagingServiceException(String.format("The availability zone %s is not configured for import", availabilityZone));
        }
        if (request.getLaunchSpecification().getPlacement() == null) {
            request.getLaunchSpecification().setPlacement(new InstancePlacement());
        }
        request.getLaunchSpecification().getPlacement().setAvailabilityZone(availabilityZone);
        ArrayList disks = request.getDiskImageSet();
        if (disks == null || disks.size() <= 0) {
            throw new ImagingServiceException("Disk images are required");
        }
        for (DiskImage disk : disks) {
            DiskImageDetail imageDetail = disk.getImage();
            String format = imageDetail.getFormat();
            if (format == null || format.length() <= 0) {
                throw new ImagingServiceException("Image format is required");
            }
            try {
                IMAGE_FORMAT iMAGE_FORMAT = IMAGE_FORMAT.valueOf(format.toUpperCase());
            }
            catch (Exception ex) {
                throw new ImagingServiceException("Unsupported image format: " + format);
            }
            if (imageDetail.getImportManifestUrl() == null) {
                throw new ImagingServiceException("Import manifest url is required");
            }
            DiskImageVolume volumeDetail = disk.getVolume();
            if (volumeDetail == null) {
                throw new ImagingServiceException("Volume detail is required for disk image");
            }
            try {
                long volumeSizeInBytes;
                int volumeSize = volumeDetail.getSize();
                long imageBytes = imageDetail.getBytes();
                if (imageBytes <= (volumeSizeInBytes = (long)volumeSize * (long)Math.pow(1024.0, 3.0))) continue;
                throw new ImagingServiceException("Requested volume size is not enough to hold the image");
            }
            catch (ImagingServiceException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ImagingServiceException("500", "Failed to verify the requested volume size");
            }
        }
        ImportInstanceImagingTask transform = (ImportInstanceImagingTask)TypeMappers.transform((Object)request, ImportInstanceImagingTask.class);
        try (TransactionResource db = Entities.transactionFor(ImportInstanceImagingTask.class);){
            try {
                Entities.persist((Object)transform);
                db.commit();
            }
            catch (Exception ex) {
                throw new ImagingServiceException("500", "Failed to persist InstanceImagingTask", ex);
            }
        }
        return transform;
    }

    public static DiskImagingTask createDiskImagingTask(ImportImageType request) throws ImagingServiceException {
        if (request.getImage().getDiskImageSet() == null || request.getImage().getDiskImageSet().size() <= 0) {
            throw new ImagingServiceException("Image detail for imported image is required");
        }
        if (request.getImage().getConvertedImage() == null) {
            throw new ImagingServiceException("Image detail for converted image is required");
        }
        for (ImportDiskImageDetail image : request.getImage().getDiskImageSet()) {
            String format = image.getFormat();
            String manifestUrl = image.getDownloadManifestUrl();
            String imageId = image.getId();
            if (format == null || format.length() <= 0) {
                throw new ImagingServiceException("Image format is required");
            }
            try {
                IMAGE_FORMAT iMAGE_FORMAT = IMAGE_FORMAT.valueOf(format.toUpperCase());
            }
            catch (Exception ex) {
                throw new ImagingServiceException("Unsupported image format");
            }
            if (manifestUrl == null || manifestUrl.length() <= 0) {
                throw new ImagingServiceException("Import manifest url is required");
            }
            if (imageId != null && imageId.length() > 0) continue;
            throw new ImagingServiceException("Import image's id is required");
        }
        ConvertedImageDetail converted = request.getImage().getConvertedImage();
        String bucket = converted.getBucket();
        String prefix = converted.getPrefix();
        String arch = converted.getArchitecture();
        if (bucket == null || bucket.length() <= 0) {
            throw new ImagingServiceException("bucket name must be specified");
        }
        if (prefix == null || prefix.length() <= 0) {
            throw new ImagingServiceException("prefix must be specified");
        }
        if (arch == null || arch.length() <= 0) {
            throw new ImagingServiceException("architecture must be specified");
        }
        DiskImagingTask transform = null;
        try {
            transform = (DiskImagingTask)TypeMappers.transform((Object)request, DiskImagingTask.class);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ImagingServiceException) {
                throw (ImagingServiceException)((Object)ex.getCause());
            }
            throw new ImagingServiceException("500", "Failed to create DiskImagingTask", ex);
        }
        try (TransactionResource db = Entities.transactionFor(DiskImagingTask.class);){
            try {
                Entities.persist((Object)transform);
                db.commit();
            }
            catch (Exception ex) {
                throw new ImagingServiceException("500", "Failed to persist DiskImagingTask", ex);
            }
        }
        return transform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ImagingTask> getImagingTasks() {
        Object object = lock;
        synchronized (object) {
            List result = Lists.newArrayList();
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                result = Entities.query((Object)ImagingTask.named(), (boolean)true);
            }
            return result;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImagingTask lookup(String taskId) throws NoSuchElementException {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                ImagingTask found;
                try {
                    found = (ImagingTask)Entities.uniqueResult((Object)ImagingTask.named(taskId));
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
                ImagingTask imagingTask = found;
                return imagingTask;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTask(ImagingTask task) {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                try {
                    ImagingTask entity = (ImagingTask)Entities.uniqueResult((Object)task);
                    Entities.delete((Object)entity);
                    db.commit();
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    public static void setState(ImagingTask task, ImportTaskState state, String stateReason) throws NoSuchElementException {
        ImagingTasks.setState(AccountFullName.getInstance((String)task.getOwnerAccountNumber(), (String[])new String[0]), task.getDisplayName(), state, stateReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setState(AccountFullName owningAccount, String taskId, ImportTaskState state, String stateReason) throws NoSuchElementException {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                try {
                    ImagingTask task = (ImagingTask)Entities.uniqueResult((Object)ImagingTask.named(owningAccount, taskId));
                    task.setState(state);
                    if (stateReason != null) {
                        task.setStateReason(stateReason);
                    }
                    String externalState = state.getExternalTaskStateName();
                    task.setTaskState(externalState);
                    if (stateReason != null) {
                        task.setTaskStatusMessage(stateReason);
                    }
                    task.serializeTaskToJSON();
                    task.updateTimeStamps();
                    Entities.persist((Object)task);
                    db.commit();
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transitState(ImagingTask task, ImportTaskState before, ImportTaskState after, String stateMessage) throws Exception {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                try {
                    ImagingTask entity = (ImagingTask)Entities.uniqueResult((Object)task);
                    if (!before.equals(entity.getState())) {
                        throw new Exception("Current state is not " + (Object)((Object)before));
                    }
                    entity.setState(after);
                    if (stateMessage != null) {
                        entity.setStateReason(stateMessage);
                    }
                    String externalState = after.getExternalTaskStateName();
                    entity.setTaskState(externalState);
                    if (stateMessage != null) {
                        entity.setTaskStatusMessage(stateMessage);
                    }
                    entity.serializeTaskToJSON();
                    entity.updateTimeStamps();
                    db.commit();
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTaskInJson(ImagingTask task) {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                try {
                    task.serializeTaskToJSON();
                    ImagingTask update = (ImagingTask)Entities.uniqueResult((Object)task);
                    update.setTaskInJsons(task.getTaskInJsons());
                    Entities.persist((Object)update);
                    db.commit();
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWorkerId(String taskId, String workerId) {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                try {
                    ImagingTask entity = (ImagingTask)Entities.uniqueResult((Object)ImagingTask.named(taskId));
                    entity.setWorkerId(workerId);
                    Entities.persist((Object)entity);
                    db.commit();
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killAndRerunTask(String taskId) {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
                ImagingTask entity = (ImagingTask)Entities.uniqueResult((Object)ImagingTask.named(taskId));
                if (!ImportTaskState.CONVERTING.equals(entity.getState())) {
                    return;
                }
                try {
                    entity.setState(ImportTaskState.PENDING);
                    entity.setWorkerId(null);
                    if (entity instanceof VolumeImagingTask) {
                        ((VolumeImagingTask)entity).clearDownloadManifesturl();
                    }
                    Entities.persist((Object)entity);
                    db.commit();
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    public static ImagingTask getConvertingTaskByWorkerId(String workerId) {
        List<ImagingTask> tasks = ImagingTasks.getImagingTasks();
        for (ImagingTask task : tasks) {
            if (!ImportTaskState.CONVERTING.equals(task.getState()) || !workerId.equals(task.getWorkerId())) continue;
            return task;
        }
        return null;
    }

    public static void timeoutTask(String taskId) {
        try (TransactionResource db = Entities.transactionFor(ImagingTask.class);){
            try {
                ImagingTask entity = (ImagingTask)Entities.uniqueResult((Object)ImagingTask.named(taskId));
                entity.incrementTimeout();
                entity.resetTimeout();
                Entities.persist((Object)entity);
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<VolumeImagingTask> getVolumeImagingTasks() {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(VolumeImagingTask.class);){
                List tasks;
                VolumeImagingTask sample = VolumeImagingTask.named();
                List list = tasks = Entities.query((Object)sample, (boolean)true);
                return list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVolumeId(ImportVolumeImagingTask task, String volumeId) throws NoSuchElementException {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(ImportVolumeImagingTask.class);){
                try {
                    ImportVolumeImagingTask update = (ImportVolumeImagingTask)Entities.uniqueResult((Object)task);
                    update.setVolumeId(volumeId);
                    Entities.persist((Object)update);
                    db.commit();
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    public static void updateBytesConverted(String taskId, String volumeId, long bytesConverted) {
        try (TransactionResource db = Entities.transactionFor(VolumeImagingTask.class);){
            try {
                VolumeImagingTask entity = (VolumeImagingTask)Entities.uniqueResult((Object)VolumeImagingTask.named(taskId));
                ConversionTask task = entity.getTask();
                if (task.getImportVolume() != null) {
                    task.getImportVolume().setBytesConverted(Long.valueOf(bytesConverted));
                } else if (task.getImportInstance() != null && task.getImportInstance().getVolumes() != null) {
                    ArrayList volumes = task.getImportInstance().getVolumes();
                    for (ImportInstanceVolumeDetail volume : volumes) {
                        if (volume.getVolume() == null || !volumeId.equals(volume.getVolume().getId())) continue;
                        volume.setBytesConverted(Long.valueOf(bytesConverted));
                    }
                }
                entity.serializeTaskToJSON();
                Entities.persist((Object)entity);
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDownloadManifestUrl(VolumeImagingTask task, String importManifestUrl, String downloadManifestUrl) {
        Object object = lock;
        synchronized (object) {
            try (TransactionResource db = Entities.transactionFor(VolumeImagingTask.class);){
                try {
                    VolumeImagingTask entity = (VolumeImagingTask)Entities.uniqueResult((Object)task);
                    entity.addDownloadManifestUrl(importManifestUrl, downloadManifestUrl);
                    db.commit();
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
    }

    public static void updateVolumeStatus(VolumeImagingTask imagingTask, String volumeId, ImportTaskState state, String statusMessage) {
        try (TransactionResource db = Entities.transactionFor(VolumeImagingTask.class);){
            try {
                VolumeImagingTask entity = (VolumeImagingTask)Entities.uniqueResult((Object)imagingTask);
                ConversionTask task = entity.getTask();
                if (task.getImportInstance() != null) {
                    ArrayList volumes = task.getImportInstance().getVolumes();
                    for (ImportInstanceVolumeDetail volumeDetail : volumes) {
                        if (volumeDetail.getVolume() == null || !volumeId.equals(volumeDetail.getVolume().getId())) continue;
                        volumeDetail.setStatus(state.getExternalVolumeStateName());
                        if (statusMessage != null) {
                            volumeDetail.setStatusMessage(statusMessage);
                            break;
                        }
                        volumeDetail.setStatusMessage("");
                        break;
                    }
                    entity.serializeTaskToJSON();
                    Entities.persist((Object)entity);
                    db.commit();
                }
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static boolean isConversionDone(VolumeImagingTask imagingTask) {
        Throwable throwable = null;
        try (TransactionResource db = Entities.transactionFor(VolumeImagingTask.class);){
            VolumeImagingTask entity = (VolumeImagingTask)Entities.uniqueResult((Object)imagingTask);
            ConversionTask task = entity.getTask();
            if (task.getImportInstance() != null) {
                ArrayList volumes = task.getImportInstance().getVolumes();
                for (ImportInstanceVolumeDetail volumeDetail : volumes) {
                    if (!"active".equals(volumeDetail.getStatus())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean i$ = true;
                return i$;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            try {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void addSnapshotId(ImportInstanceImagingTask imagingTask, String snapshotId) {
        try (TransactionResource db = Entities.transactionFor(ImportInstanceImagingTask.class);){
            try {
                ImportInstanceImagingTask entity = (ImportInstanceImagingTask)Entities.uniqueResult((Object)imagingTask);
                entity.addSnapshotId(snapshotId);
                Entities.persist((Object)entity);
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static void setImageId(ImportInstanceImagingTask imagingTask, String imageId) {
        try (TransactionResource db = Entities.transactionFor(ImportInstanceImagingTask.class);){
            try {
                ImportInstanceImagingTask entity = (ImportInstanceImagingTask)Entities.uniqueResult((Object)imagingTask);
                entity.setImageId(imageId);
                Entities.persist((Object)entity);
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DiskImagingTask> getDiskImagingTasks(AccountFullName owningAccount, List<String> taskIdList) {
        Object object = lock;
        synchronized (object) {
            ArrayList result = Lists.newArrayList();
            try (TransactionResource db = Entities.transactionFor(DiskImagingTask.class);){
                DiskImagingTask sample = DiskImagingTask.named(owningAccount);
                List tasks = Entities.query((Object)sample, (boolean)true);
                if (taskIdList != null && taskIdList.size() > 0) {
                    for (DiskImagingTask candidate : tasks) {
                        if (!taskIdList.contains(candidate.getDisplayName())) continue;
                        result.add(candidate);
                    }
                } else {
                    result.addAll(tasks);
                }
            }
            return result;
        }
    }

    public static enum IMAGE_FORMAT {
        RAW,
        PARTITION,
        KERNEL,
        RAMDISK,
        VMDK;

    }
}

