/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.ConversionTask;
import com.eucalyptus.compute.common.ImportInstanceTaskDetails;
import com.eucalyptus.compute.common.ImportInstanceVolumeDetail;
import com.eucalyptus.compute.common.Snapshot;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.imaging.backend.DiskImagingTask;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImagingTasks;
import com.eucalyptus.imaging.backend.ImportInstanceImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.ImportVolumeImagingTask;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.imaging.common.Imaging;
import com.eucalyptus.imaging.common.UrlValidator;
import com.eucalyptus.imaging.manifest.ImportImageManifest;
import com.eucalyptus.imaging.worker.ImagingServiceLaunchers;
import com.eucalyptus.util.Dates;
import com.eucalyptus.util.XMLParser;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ImagingTaskStateManager
implements EventListener<ClockTick> {
    private static Logger LOG = Logger.getLogger(ImagingTaskStateManager.class);
    public static final int TASK_PURGE_EXPIRATION_HOURS = 24;
    private static final Map<String, Date> cancellingTimer = Maps.newHashMap();
    private static final int CANCELLING_WAIT_MIN = 2;

    public static void register() {
        Listeners.register(ClockTick.class, (EventListener)new ImagingTaskStateManager());
    }

    public void fireEvent(ClockTick event) {
        if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabledLocally(Imaging.class)) {
            return;
        }
        HashMap taskByState = Maps.newHashMap();
        List<ImagingTask> allTasks = ImagingTasks.getImagingTasks();
        for (ImagingTask task : allTasks) {
            if (!taskByState.containsKey(task.getState())) {
                taskByState.put(task.getState(), Lists.newArrayList());
            }
            ((List)taskByState.get(task.getState())).add(task);
        }
        if (taskByState.containsKey((Object)ImportTaskState.NEW)) {
            this.processNewTasks((List)taskByState.get((Object)ImportTaskState.NEW));
        }
        if (taskByState.containsKey((Object)ImportTaskState.PENDING)) {
            this.processPendingTasks((List)taskByState.get((Object)ImportTaskState.PENDING));
        }
        if (taskByState.containsKey((Object)ImportTaskState.CONVERTING)) {
            this.processConvertingTasks((List)taskByState.get((Object)ImportTaskState.CONVERTING));
        }
        if (taskByState.containsKey((Object)ImportTaskState.INSTANTIATING)) {
            this.processInstantiatingTasks((List)taskByState.get((Object)ImportTaskState.INSTANTIATING));
        }
        if (taskByState.containsKey((Object)ImportTaskState.CANCELLING)) {
            this.processCancellingTasks((List)taskByState.get((Object)ImportTaskState.CANCELLING));
        }
        if (taskByState.containsKey((Object)ImportTaskState.COMPLETED)) {
            this.processCompletedTasks((List)taskByState.get((Object)ImportTaskState.COMPLETED));
        }
        if (taskByState.containsKey((Object)ImportTaskState.CANCELLED)) {
            this.processCancelledTasks((List)taskByState.get((Object)ImportTaskState.CANCELLED));
        }
        if (taskByState.containsKey((Object)ImportTaskState.FAILED)) {
            this.processFailedTasks((List)taskByState.get((Object)ImportTaskState.FAILED));
        }
    }

    private void processPendingTasks(List<ImagingTask> tasks) {
        for (ImagingTask task : tasks) {
            if (!"Pending conversion".equals(task.getStateReason())) {
                try {
                    ImagingTasks.transitState(task, ImportTaskState.PENDING, ImportTaskState.PENDING, "Pending conversion");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isExpired(task)) continue;
            try {
                ImagingTasks.transitState(task, ImportTaskState.PENDING, ImportTaskState.CANCELLING, "Import task is expired");
            }
            catch (Exception exception) {}
        }
    }

    private void processConvertingTasks(List<ImagingTask> tasks) {
        for (ImagingTask task : tasks) {
            if (!"Converting images".equals(task.getStateReason())) {
                try {
                    ImagingTasks.transitState(task, ImportTaskState.CONVERTING, ImportTaskState.CONVERTING, "Converting images");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isExpired(task)) continue;
            try {
                ImagingTasks.transitState(task, ImportTaskState.CONVERTING, ImportTaskState.CANCELLING, "Import task is expired");
            }
            catch (Exception exception) {}
        }
    }

    private void processInstantiatingTasks(List<ImagingTask> tasks) {
        block14: for (ImagingTask task : tasks) {
            ImportInstanceImagingTask instanceTask;
            ConversionTask conversionTask;
            if (!(task instanceof ImportInstanceImagingTask)) {
                try {
                    ImagingTasks.transitState(task, ImportTaskState.INSTANTIATING, ImportTaskState.COMPLETED, "Import task finished successfully");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((conversionTask = (instanceTask = (ImportInstanceImagingTask)task).getTask()).getImportInstance() == null) {
                LOG.warn((Object)"Import instance task should contain ImportInstanceTaskDetail");
                continue;
            }
            String instanceId = conversionTask.getImportInstance().getInstanceId();
            if (instanceId != null && instanceId.length() > 0) {
                try {
                    ImagingTasks.transitState(task, ImportTaskState.INSTANTIATING, ImportTaskState.COMPLETED, "Import task finished successfully");
                }
                catch (Exception ex) {
                    LOG.error((Object)"Failed to update task's state to completed", (Throwable)ex);
                }
                continue;
            }
            String imageId = instanceTask.getImageId();
            if (imageId != null && imageId.length() > 0) {
                try {
                    String userData = Strings.emptyToNull((String)instanceTask.getLaunchSpecUserData());
                    String instanceType = Strings.emptyToNull((String)instanceTask.getLaunchSpecInstanceType());
                    String keyName = Strings.emptyToNull((String)instanceTask.getLaunchSpecKeyName());
                    String subnetId = Strings.emptyToNull((String)instanceTask.getLaunchSpecSubnetId());
                    String privateIp = subnetId == null ? null : Strings.emptyToNull((String)instanceTask.getLaunchSpecPrivateIpAddress());
                    LinkedHashSet groupNames = Sets.newLinkedHashSet();
                    if (subnetId == null && instanceTask.getLaunchSpecGroupNames() != null) {
                        groupNames.addAll(instanceTask.getLaunchSpecGroupNames());
                    }
                    String availabilityZone = subnetId == null ? instanceTask.getLaunchSpecAvailabilityZone() : null;
                    Boolean monitoringEnabled = instanceTask.getLaunchSpecMonitoringEnabled();
                    boolean monitoring = monitoringEnabled != null && monitoringEnabled != false;
                    instanceId = EucalyptusActivityTasks.getInstance().runInstancesAsUser(instanceTask.getOwnerUserId(), imageId, (Set)groupNames, userData, instanceType, availabilityZone, subnetId, privateIp, monitoring, keyName);
                    conversionTask.getImportInstance().setInstanceId(instanceId);
                    ImagingTasks.updateTaskInJson(instanceTask);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Failed to run instances after conversion task", (Throwable)ex);
                    try {
                        ImagingTasks.transitState(instanceTask, ImportTaskState.INSTANTIATING, ImportTaskState.COMPLETED, String.format("Image registered: %s, but run instance failed", imageId));
                    }
                    catch (Exception ex1) {
                        ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Failed to run instances");
                    }
                }
                continue;
            }
            List<String> snapshotIds = instanceTask.getSnapshotIds();
            if (snapshotIds != null && snapshotIds.size() > 0) {
                try {
                    List snapshots = EucalyptusActivityTasks.getInstance().describeSnapshotsAsUser(instanceTask.getOwnerUserId(), snapshotIds);
                    int numCompleted = 0;
                    int numError = 0;
                    for (Snapshot snapshot : snapshots) {
                        if ("completed".equals(snapshot.getStatus())) {
                            ++numCompleted;
                            continue;
                        }
                        if (!"error".equals(snapshot.getStatus()) && !"failed".equals(snapshot.getStatus())) continue;
                        ++numError;
                    }
                    if (numError > 0) {
                        ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Failed to create snapshot");
                        continue;
                    }
                    if (numCompleted != snapshotIds.size()) continue;
                    String snapshotId = null;
                    if (snapshots.size() > 1) {
                        LOG.warn((Object)("More than one snapshots found for import-instance task " + instanceTask.getDisplayName()));
                    }
                    snapshotId = snapshotIds.get(0);
                    String imageName = String.format("image-%s", instanceTask.getDisplayName());
                    String description = conversionTask.getImportInstance().getDescription();
                    String architecture = instanceTask.getLaunchSpecArchitecture();
                    String platform = null;
                    if (conversionTask.getImportInstance().getPlatform() != null && conversionTask.getImportInstance().getPlatform().length() > 0) {
                        platform = conversionTask.getImportInstance().getPlatform().toLowerCase();
                    }
                    try {
                        imageId = EucalyptusActivityTasks.getInstance().registerEBSImageAsUser(instanceTask.getOwnerUserId(), snapshotId, imageName, architecture, platform, description, false);
                        if (imageId == null) {
                            throw new Exception("Null image id");
                        }
                        ImagingTasks.setImageId(instanceTask, imageId);
                    }
                    catch (Exception ex) {
                        ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Failed to register image");
                    }
                }
                catch (Exception ex) {
                    ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Failed to register image");
                }
                continue;
            }
            ArrayList volumes = conversionTask.getImportInstance().getVolumes();
            if (volumes == null || volumes.size() <= 0) {
                ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Import task does not have sufficient parameters:volume");
            }
            ArrayList volumeIds = Lists.newArrayList();
            for (ImportInstanceVolumeDetail volume : volumes) {
                if (volume.getVolume() == null || volume.getVolume().getId() == null) continue;
                volumeIds.add(volume.getVolume().getId());
            }
            if (volumeIds.size() <= 0) {
                ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Import task does not have sufficient parameters:volume");
            }
            for (String volumeId : volumeIds) {
                try {
                    String snapshotId = EucalyptusActivityTasks.getInstance().createSnapshotAsUser(instanceTask.getOwnerUserId(), volumeId);
                    ImagingTasks.addSnapshotId(instanceTask, snapshotId);
                }
                catch (Exception ex) {
                    ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Failed to create snapshot");
                    continue block14;
                }
            }
        }
    }

    private void processCancellingTasks(List<ImagingTask> tasks) {
        for (ImagingTask task : tasks) {
            try {
                Date cancellingExpired;
                if (!cancellingTimer.containsKey(task.getDisplayName())) {
                    cancellingTimer.put(task.getDisplayName(), Dates.minutesFromNow((int)2));
                }
                if (!(cancellingExpired = cancellingTimer.get(task.getDisplayName())).before(new Date())) continue;
                try {
                    task.cleanUp();
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Failed to cleanup resources for " + task.getDisplayName()));
                }
                ImagingTasks.transitState(task, ImportTaskState.CANCELLING, ImportTaskState.CANCELLED, null);
            }
            catch (Exception ex) {
                LOG.error((Object)("Could not process cancelling task " + task.getDisplayName()));
            }
        }
    }

    private void processCompletedTasks(List<ImagingTask> tasks) {
        for (ImagingTask task : tasks) {
            if (!this.shouldPurge(task)) continue;
            try {
                LOG.debug((Object)("forgetting about conversion task(completed) " + task.getDisplayName()));
                ImagingTasks.deleteTask(task);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to delete the conversion task", (Throwable)ex);
            }
        }
    }

    private void processCancelledTasks(List<ImagingTask> tasks) {
        for (ImagingTask task : tasks) {
            if (!this.shouldPurge(task)) continue;
            try {
                LOG.debug((Object)("forgetting about conversion task(cancelled) " + task.getDisplayName()));
                ImagingTasks.deleteTask(task);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to delete the conversion task", (Throwable)ex);
            }
        }
    }

    private void processFailedTasks(List<ImagingTask> tasks) {
        for (ImagingTask task : tasks) {
            try {
                task.cleanUp();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Failed to cleanup resources for " + task.getDisplayName()));
            }
            if (!this.shouldPurge(task)) continue;
            try {
                LOG.debug((Object)("forgetting about conversion task(failed) " + task.getDisplayName()));
                ImagingTasks.deleteTask(task);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to delete the conversion task", (Throwable)ex);
            }
        }
    }

    private boolean isExpired(ImagingTask task) {
        Date expirationTime = task.getExpirationTime();
        return expirationTime.before(new Date());
    }

    private boolean shouldPurge(ImagingTask task) {
        Date lastUpdated = task.getLastUpdateTimestamp();
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastUpdated);
        cal.add(11, 24);
        Date expirationTime = cal.getTime();
        return expirationTime.before(new Date());
    }

    private void processNewTasks(List<ImagingTask> tasks) {
        try {
            if (ImagingServiceLaunchers.getInstance().shouldEnable()) {
                ImagingServiceLaunchers.getInstance().enable();
                LOG.debug((Object)"Imaging service worker launched");
                return;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to enable imaging service workers");
            return;
        }
        if (!ImagingServiceLaunchers.getInstance().isWorkedEnabled()) {
            LOG.warn((Object)"Imaging worker is not currently enabled");
            return;
        }
        for (ImagingTask task : tasks) {
            try {
                if (this.isExpired(task)) {
                    try {
                        ImagingTasks.transitState(task, ImportTaskState.NEW, ImportTaskState.CANCELLING, "Import task is expired");
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (task instanceof ImportVolumeImagingTask) {
                    this.processNewImportVolumeImagingTask((ImportVolumeImagingTask)task);
                    continue;
                }
                if (task instanceof ImportInstanceImagingTask) {
                    this.processNewImportInstanceImagingTask((ImportInstanceImagingTask)task);
                    continue;
                }
                if (task instanceof DiskImagingTask) {
                    ImagingTasks.transitState(task, ImportTaskState.NEW, ImportTaskState.PENDING, "");
                    continue;
                }
                throw new Exception("Invalid ImagingTask");
            }
            catch (Exception ex) {
                try {
                    ImagingTasks.transitState(task, ImportTaskState.NEW, ImportTaskState.FAILED, "Import task failed unexpectedly");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.error((Object)"Failed to process new task", (Throwable)ex);
            }
        }
    }

    private void processNewImportInstanceImagingTask(ImportInstanceImagingTask instanceTask) throws Exception {
        ImportInstanceTaskDetails taskDetail = instanceTask.getTask().getImportInstance();
        ArrayList volumes = taskDetail.getVolumes();
        if (volumes == null) {
            return;
        }
        for (ImportInstanceVolumeDetail volume : volumes) {
            if (volume.getImage().getImportManifestUrl() == null) continue;
            try {
                if (this.doesManifestExist(volume.getImage().getImportManifestUrl())) continue;
                if (!"Pending import-image upload".equals(instanceTask.getStateReason())) {
                    try {
                        ImagingTasks.transitState(instanceTask, ImportTaskState.NEW, ImportTaskState.NEW, "Pending import-image upload");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (Exception ex) {
                throw new Exception("Failed to check import manifest", ex);
            }
        }
        try {
            ImagingTasks.transitState(instanceTask, ImportTaskState.NEW, ImportTaskState.NEW, "Creating volumes");
        }
        catch (Exception i$) {
            // empty catch block
        }
        try {
            int numVolumeCreated = 0;
            for (ImportInstanceVolumeDetail volume : volumes) {
                if (volume.getVolume() == null || volume.getVolume().getId() == null || volume.getVolume().getId().length() <= 0) {
                    String zone = volume.getAvailabilityZone();
                    Integer size = volume.getVolume().getSize();
                    if (zone == null) {
                        throw new Exception("Availability zone is missing from the volume detail");
                    }
                    if (size == null || size <= 0) {
                        throw new Exception("Volume size is missing from the volume detail");
                    }
                    try {
                        String volumeId = EucalyptusActivityTasks.getInstance().createVolumeAsUser(instanceTask.getOwnerUserId(), zone, size.intValue());
                        volume.getVolume().setId(volumeId);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception("Failed to create the volume", ex);
                    }
                }
                String volumeStatus = null;
                try {
                    List eucaVolumes = EucalyptusActivityTasks.getInstance().describeVolumesAsUser(instanceTask.getOwnerUserId(), (List)Lists.newArrayList((Object[])new String[]{volume.getVolume().getId()}));
                    Volume eucaVolume = (Volume)eucaVolumes.get(0);
                    volumeStatus = eucaVolume.getStatus();
                }
                catch (Exception ex) {
                    throw new Exception("Failed to check the state of the volume " + volume.getVolume().getId());
                }
                if ("available".equals(volumeStatus)) {
                    volume.setStatus("active");
                    ++numVolumeCreated;
                    continue;
                }
                if ("creating".equals(volumeStatus)) {
                    volume.setStatus("active");
                    continue;
                }
                volume.setStatus("cancelled");
                volume.setStatusMessage("Failed to create the volume");
                throw new Exception("Volume " + volume.getVolume().getId() + " is in " + volumeStatus);
            }
            if (numVolumeCreated == volumes.size()) {
                try {
                    ImagingTasks.transitState(instanceTask, ImportTaskState.NEW, ImportTaskState.PENDING, "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ImagingTasks.updateTaskInJson(instanceTask);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNewImportVolumeImagingTask(ImportVolumeImagingTask volumeTask) throws Exception {
        block15: {
            if (volumeTask.getImportManifestUrl() != null) {
                try {
                    if (this.doesManifestExist(volumeTask.getImportManifestUrl())) break block15;
                    if ("Pending import-image upload".equals(volumeTask.getStateReason())) return;
                    try {
                        ImagingTasks.transitState(volumeTask, ImportTaskState.NEW, ImportTaskState.NEW, "Pending import-image upload");
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                catch (Exception ex) {
                    throw new Exception("Failed to check import manifest", ex);
                }
            }
        }
        try {
            ImagingTasks.transitState(volumeTask, ImportTaskState.NEW, ImportTaskState.NEW, "Creating volumes");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (volumeTask.getVolumeId() == null || volumeTask.getVolumeId().length() <= 0) {
            String zone = volumeTask.getAvailabilityZone();
            int size = volumeTask.getVolumeSize();
            try {
                String volumeId = EucalyptusActivityTasks.getInstance().createVolumeAsUser(volumeTask.getOwnerUserId(), zone, size);
                ImagingTasks.setVolumeId(volumeTask, volumeId);
                return;
            }
            catch (Exception ex) {
                throw new Exception("Failed to create the volume", ex);
            }
        } else {
            List volumes = EucalyptusActivityTasks.getInstance().describeVolumesAsUser(volumeTask.getOwnerUserId(), (List)Lists.newArrayList((Object[])new String[]{volumeTask.getVolumeId()}));
            Volume volume = (Volume)volumes.get(0);
            String volumeStatus = volume.getStatus();
            if ("available".equals(volumeStatus)) {
                ConversionTask conversionTask = volumeTask.getTask();
                if (conversionTask.getImportVolume() == null) throw new Exception("No importVolume detail is found in the conversion task");
                try {
                    ImagingTasks.transitState(volumeTask, ImportTaskState.NEW, ImportTaskState.PENDING, "");
                    return;
                }
                catch (Exception exception) {}
                return;
            } else {
                if ("creating".equals(volumeStatus)) return;
                throw new Exception("The volume " + volume.getVolumeId() + "'s state is " + volumeStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesManifestExist(String manifestUrl) throws Exception {
        UrlValidator urlValidator = new UrlValidator();
        if (!urlValidator.isEucalyptusUrl(manifestUrl)) {
            throw new RuntimeException("Manifest's URL is not in the Eucalyptus format: " + manifestUrl);
        }
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        client.getParams().setParameter("http.connection.timeout", (Object)10000);
        client.getParams().setParameter("http.socket.timeout", (Object)30000);
        GetMethod method = new GetMethod(manifestUrl);
        String manifest = null;
        try {
            method.setRequestHeader("Connection", "close");
            client.executeMethod((HttpMethod)method);
            manifest = method.getResponseBodyAsString(ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue());
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            if (manifest.contains("<Code>NoSuchKey</Code>") || manifest.contains("The specified key does not exist")) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            method.releaseConnection();
        }
        List<String> partsUrls = this.getPartsHeadUrl(manifest);
        for (String url2 : partsUrls) {
            if (!urlValidator.isEucalyptusUrl(url2)) {
                throw new RuntimeException("Manifest's URL is not in the Eucalyptus format: " + url2);
            }
            HeadMethod partCheck = new HeadMethod(url2);
            int res = client.executeMethod((HttpMethod)partCheck);
            if (res == 200) continue;
            return false;
        }
        return true;
    }

    private List<String> getPartsHeadUrl(String manifest) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        DocumentBuilder builder = XMLParser.getDocBuilder();
        Document inputSource = builder.parse(new ByteArrayInputStream(manifest.getBytes()));
        ArrayList parts = Lists.newArrayList();
        NodeList nodes = (NodeList)xpath.evaluate(ImportImageManifest.INSTANCE.getPartsPath() + "/head-url", inputSource, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            parts.add(nodes.item(i).getTextContent());
        }
        return parts;
    }
}

