/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.imaging.ImportTaskProperties;
import com.eucalyptus.imaging.backend.IConversionTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.common.ImagingMetadata;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_imaging")
@Table(name="metadata_imaging_tasks")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="metadata_imaging_tasks_discriminator", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="metadata_imaging_task")
public class ImagingTask
extends UserMetadata<ImportTaskState>
implements ImagingMetadata.ImagingTaskMetadata,
IConversionTask {
    private static Logger LOG = Logger.getLogger(ImagingTask.class);
    @Type(type="org.hibernate.type.StringClobType")
    @Lob
    @Column(name="metadata_task_in_json")
    protected String taskInJSON;
    @Column(name="metadata_state_message")
    private String stateReason;
    @Column(name="metadata_worker_id")
    private String workerId;
    @Column(name="metadata_worker_timeout")
    private Date workerTimeOut = null;
    @Column(name="metadata_timeout_counter")
    private Integer timeOutCounter = null;

    protected ImagingTask() {
        this(null, null);
    }

    ImagingTask(String displayName) {
        this(null, displayName);
    }

    ImagingTask(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    static ImagingTask named(ImportTaskState state) {
        ImagingTask task = new ImagingTask(null, null);
        task.setState(state);
        return task;
    }

    static ImagingTask named(AccountFullName acctOwner, String taskId) {
        ImagingTask task = new ImagingTask(null, taskId);
        task.setOwnerAccountNumber(acctOwner.getAccountNumber());
        return task;
    }

    static ImagingTask named(OwnerFullName owner, String taskId) {
        return new ImagingTask(owner, taskId);
    }

    static ImagingTask named(String taskId) {
        return new ImagingTask(null, taskId);
    }

    static ImagingTask named() {
        return new ImagingTask();
    }

    public void setStateReason(String reason) {
        this.stateReason = reason;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public void cleanUp() {
        throw new UnsupportedOperationException();
    }

    @PrePersist
    protected void serializeTaskToJSON() {
        this.taskInJSON = JSONSerializer.toJSON((Object)this.toJSON()).toString();
    }

    protected void createTaskFromJSON() {
        throw new UnsupportedOperationException();
    }

    public String getTaskInJsons() {
        return this.taskInJSON;
    }

    public void setTaskInJsons(String taskInJson) {
        this.taskInJSON = taskInJson;
    }

    public Date getExpirationTime() {
        try {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(this.getTaskExpirationTime());
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, Integer.parseInt(ImportTaskProperties.IMPORT_TASK_TIMEOUT_MINUTES));
        this.workerTimeOut = cal.getTime();
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public boolean isTimedOut() {
        if (this.workerTimeOut != null) {
            return this.workerTimeOut.before(new Date());
        }
        return false;
    }

    public void resetTimeout() {
        this.workerTimeOut = null;
    }

    public void incrementTimeout() {
        if (this.timeOutCounter == null) {
            this.timeOutCounter = 0;
        }
        ImagingTask imagingTask = this;
        Integer n = imagingTask.timeOutCounter;
        Integer n2 = imagingTask.timeOutCounter = Integer.valueOf(imagingTask.timeOutCounter + 1);
    }

    public int getTimeoutCount() {
        if (this.timeOutCounter == null) {
            this.timeOutCounter = 0;
        }
        return this.timeOutCounter;
    }

    public String toString() {
        return this.getClass().getName() + "[name: " + this.displayName + ", state: " + this.getState() + "]";
    }

    public String getPartition() {
        return null;
    }

    public FullName getFullName() {
        return null;
    }

    protected void onLoad() {
        this.createTaskFromJSON();
    }

    @Override
    public String getTaskExpirationTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSONObject toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTaskState(String state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTaskState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTaskStatusMessage(String msg) {
        throw new UnsupportedOperationException();
    }
}

