/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.imaging.backend.AbstractTaskScheduler;
import com.eucalyptus.imaging.backend.DiskImagingTask;
import com.eucalyptus.imaging.backend.ImagingServiceException;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImagingTasks;
import com.eucalyptus.imaging.backend.ImagingWorker;
import com.eucalyptus.imaging.backend.ImagingWorkers;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.ImportVolumeImagingTask;
import com.eucalyptus.imaging.backend.VolumeImagingTask;
import com.eucalyptus.imaging.backend.WorkerTaskState;
import com.eucalyptus.imaging.common.DiskImageConversionTask;
import com.eucalyptus.imaging.common.ImagingBackend;
import com.eucalyptus.imaging.common.backend.msgs.CancelConversionTaskResponseType;
import com.eucalyptus.imaging.common.backend.msgs.CancelConversionTaskType;
import com.eucalyptus.imaging.common.backend.msgs.DescribeConversionTasksResponseType;
import com.eucalyptus.imaging.common.backend.msgs.DescribeConversionTasksType;
import com.eucalyptus.imaging.common.backend.msgs.GetInstanceImportTaskResponseType;
import com.eucalyptus.imaging.common.backend.msgs.GetInstanceImportTaskType;
import com.eucalyptus.imaging.common.backend.msgs.ImportImageResponseType;
import com.eucalyptus.imaging.common.backend.msgs.ImportImageType;
import com.eucalyptus.imaging.common.backend.msgs.PutInstanceImportTaskStatusResponseType;
import com.eucalyptus.imaging.common.backend.msgs.PutInstanceImportTaskStatusType;
import com.eucalyptus.imaging.worker.ImagingServiceLaunchers;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ImagingBackendService {
    private static Logger LOG = Logger.getLogger(ImagingBackendService.class);
    private static final int MAX_TIMEOUT_AND_RETRY = 1;

    public static ImportImageResponseType importImage(ImportImageType request) throws ImagingServiceException {
        ImportImageResponseType reply = (ImportImageResponseType)request.getReply();
        Context context = Contexts.lookup();
        try {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabled(ImagingBackend.class)) {
                throw new ImagingServiceException("500", "For import, Imaging service should be enabled");
            }
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "For import, Imaging service should be enabled");
        }
        try {
            if (!context.getUser().isSystemAdmin() || !context.getUser().isAccountAdmin()) {
                throw new ImagingServiceException("400", "Not authorized to import image.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to import image.");
        }
        try {
            if (ImagingServiceLaunchers.getInstance().shouldEnable()) {
                ImagingServiceLaunchers.getInstance().enable();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to enable imaging service workers");
            throw new ImagingServiceException("500", "Could not launch imaging service workers");
        }
        DiskImagingTask task = null;
        try {
            task = ImagingTasks.createDiskImagingTask(request);
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to import image", (Throwable)ex);
            throw new ImagingServiceException("Failed to import image", ex);
        }
        reply.setConversionTask(task.getTask());
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public static DescribeConversionTasksResponseType describeConversionTask(DescribeConversionTasksType request) throws ImagingServiceException {
        DescribeConversionTasksResponseType reply = (DescribeConversionTasksResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean verbose = request.getConversionTaskIdSet().remove("verbose");
        try {
            if (!ctx.getUser().isSystemAdmin() || !ctx.getUser().isAccountAdmin()) {
                throw new ImagingServiceException("400", "Not authorized to describe conversion tasks.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to describe conversion tasks.");
        }
        Collection<Object> ownerInfo = ctx.isAdministrator() && verbose ? Collections.emptyList() : Collections.singleton(ctx.getAccount().getAccountNumber());
        Predicate requestedAndAccessible = RestrictedTypes.filteringFor(DiskImagingTask.class).byId((Collection)request.getConversionTaskIdSet()).byOwningAccount(ownerInfo).byPrivileges().buildPredicate();
        List<DiskImagingTask> tasksToList = ImagingTasks.getDiskImagingTasks(AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]), request.getConversionTaskIdSet());
        for (DiskImagingTask task : Iterables.filter(tasksToList, (Predicate)requestedAndAccessible)) {
            DiskImageConversionTask t = task.getTask();
            reply.getConversionTasks().add(t);
        }
        return reply;
    }

    public CancelConversionTaskResponseType CancelConversionTask(CancelConversionTaskType request) throws ImagingServiceException {
        CancelConversionTaskResponseType reply = (CancelConversionTaskResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            if (!ctx.getUser().isSystemAdmin() || !ctx.getUser().isAccountAdmin()) {
                throw new ImagingServiceException("400", "Not authorized to cancel conversion tasks.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to cancel conversion tasks.");
        }
        try {
            ImagingTask task = ImagingTasks.lookup(request.getConversionTaskId());
            ImportTaskState state = (ImportTaskState)task.getState();
            if (state.equals((Object)ImportTaskState.NEW) || state.equals((Object)ImportTaskState.PENDING) || state.equals((Object)ImportTaskState.CONVERTING) || state.equals((Object)ImportTaskState.INSTANTIATING)) {
                ImagingTasks.setState(AccountFullName.getInstance((Account)Contexts.lookup().getAccount(), (String[])new String[0]), request.getConversionTaskId(), ImportTaskState.CANCELLING, "Cancelled by user");
            }
            reply.set_return(Boolean.valueOf(true));
        }
        catch (NoSuchElementException ex) {
            throw new ImagingServiceException("No task with id=" + request.getConversionTaskId() + " is found");
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "Failed to cancel conversion task", ex);
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PutInstanceImportTaskStatusResponseType PutInstanceImportTaskStatus(PutInstanceImportTaskStatusType request) throws EucalyptusCloudException {
        PutInstanceImportTaskStatusResponseType reply;
        block38: {
            reply = (PutInstanceImportTaskStatusResponseType)request.getReply();
            Context context = Contexts.lookup();
            try {
                if (!(context.getUser().isSystemAdmin() || context.isAdministrator() && Permissions.isAuthorized((String)"eucaimaging", (String)"instance", (String)"", null, (String)"putinstanceimporttaskstatus", (AuthContextSupplier)context.getAuthContext()))) {
                    throw new ImagingServiceException("400", "Not authorized to put import task status.");
                }
            }
            catch (ImagingServiceException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ImagingServiceException("400", "Not authorized to put import task status.");
            }
            try {
                String remoteHost = request.getSourceIp();
                ImagingWorkers.verifyWorker(request.getInstanceId(), remoteHost);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to verify worker", (Throwable)ex);
                throw new ImagingServiceException("400", "Not authorized to put import task status.");
            }
            reply.setCancelled(Boolean.valueOf(false));
            try {
                String taskId = request.getImportTaskId();
                String volumeId = request.getVolumeId();
                if (taskId == null) {
                    throw new Exception("Task id is null");
                }
                ImagingTask imagingTask = null;
                try {
                    imagingTask = ImagingTasks.lookup(taskId);
                }
                catch (Exception ex) {
                    reply.setCancelled(Boolean.valueOf(true));
                    throw new Exception("imaging task with " + taskId + " is not found");
                }
                String instanceId = request.getInstanceId();
                if (instanceId != null) {
                    ImagingWorkers.markUpdate(request.getInstanceId());
                }
                if (ImportTaskState.CONVERTING.equals(imagingTask.getState()) && instanceId.equals(imagingTask.getWorkerId())) {
                    WorkerTaskState workerState = WorkerTaskState.fromString(request.getStatus());
                    if ((WorkerTaskState.EXTANT.equals((Object)workerState) || WorkerTaskState.DONE.equals((Object)workerState)) && imagingTask instanceof VolumeImagingTask) {
                        try {
                            long bytesConverted = request.getBytesConverted();
                            if (bytesConverted > 0L) {
                                ImagingTasks.updateBytesConverted(taskId, volumeId, bytesConverted);
                            }
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)("Failed to update bytes converted(" + taskId + ")"));
                        }
                    }
                    switch (workerState) {
                        case EXTANT: {
                            if (!imagingTask.isTimedOut()) break;
                            try {
                                if (imagingTask.getTimeoutCount() < 1) {
                                    LOG.warn((Object)String.format("Imaging import task %s has timed out; will retry later", imagingTask.getDisplayName()));
                                    ImagingTasks.timeoutTask(taskId);
                                    ImagingTasks.killAndRerunTask(taskId);
                                } else {
                                    LOG.warn((Object)String.format("Imaging import task %s has timed out and failed", imagingTask.getDisplayName()));
                                    ImagingTasks.setState(imagingTask, ImportTaskState.FAILED, "Image conversion timed out");
                                }
                                break block38;
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Failed to handle timed-out task", (Throwable)ex);
                                ImagingTasks.setState(imagingTask, ImportTaskState.FAILED, "Image conversion timed out");
                                break block38;
                            }
                            finally {
                                reply.setCancelled(Boolean.valueOf(true));
                            }
                        }
                        case DONE: {
                            if (imagingTask instanceof VolumeImagingTask) {
                                try {
                                    ImagingTasks.updateVolumeStatus((VolumeImagingTask)imagingTask, volumeId, ImportTaskState.COMPLETED, null);
                                }
                                catch (Exception ex) {
                                    ImagingTasks.transitState(imagingTask, ImportTaskState.CONVERTING, ImportTaskState.FAILED, "Import task failed unexpectedly");
                                    LOG.error((Object)"Failed to update volume's state", (Throwable)ex);
                                    break;
                                }
                                try {
                                    if (imagingTask instanceof ImportVolumeImagingTask) {
                                        ImagingTasks.transitState(imagingTask, ImportTaskState.CONVERTING, ImportTaskState.COMPLETED, "Import task finished successfully");
                                        break;
                                    }
                                    if (ImagingTasks.isConversionDone((VolumeImagingTask)imagingTask)) {
                                        ImagingTasks.transitState(imagingTask, ImportTaskState.CONVERTING, ImportTaskState.INSTANTIATING, "Launching instance");
                                    }
                                    break block38;
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Failed to update imaging task's state to completed", (Throwable)ex);
                                }
                                break;
                            }
                            if (!(imagingTask instanceof DiskImagingTask)) break;
                            ImagingTasks.transitState(imagingTask, ImportTaskState.CONVERTING, ImportTaskState.COMPLETED, "Import task finished successfully");
                            break;
                        }
                        case FAILED: {
                            String stateMsg = "Image conversion failed";
                            if (request.getStatusMessage() != null) {
                                stateMsg = request.getStatusMessage();
                            }
                            ImagingTasks.setState(imagingTask, ImportTaskState.FAILED, stateMsg);
                            LOG.warn((Object)String.format("Worker reported failed conversion: %s-%s", stateMsg, request.getErrorCode() != null ? request.getErrorCode() : "no error code"));
                            String errorCode = request.getErrorCode();
                            if (errorCode == null || errorCode.length() <= 0 || !ImagingWorkers.isFatalError(errorCode)) break;
                            LOG.warn((Object)String.format("A task %s experienced fatal error. Worker instance %s is being retired", request.getImportTaskId(), request.getInstanceId()));
                            ImagingWorkers.retireWorker(request.getInstanceId());
                        }
                    }
                    break block38;
                }
                reply.setCancelled(Boolean.valueOf(true));
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to update the task's state", (Throwable)ex);
            }
        }
        if (reply.getCancelled() != null && reply.getCancelled().booleanValue()) {
            LOG.warn((Object)String.format("Imaging task %s has been cancelled", request.getImportTaskId()));
        }
        return reply;
    }

    public GetInstanceImportTaskResponseType GetInstanceImportTask(GetInstanceImportTaskType request) throws EucalyptusCloudException {
        GetInstanceImportTaskResponseType reply = (GetInstanceImportTaskResponseType)request.getReply();
        Context context = Contexts.lookup();
        try {
            if (!(context.getUser().isSystemAdmin() || context.isAdministrator() && Permissions.isAuthorized((String)"eucaimaging", (String)"instance", (String)"", null, (String)"getinstanceimporttask", (AuthContextSupplier)context.getAuthContext()))) {
                throw new ImagingServiceException("400", "Not authorized to get import task.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to get import task.");
        }
        try {
            String remoteHost = request.getSourceIp();
            ImagingWorkers.verifyWorker(request.getInstanceId(), remoteHost);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to verify worker", (Throwable)ex);
            throw new ImagingServiceException("400", "Not authorized to get instance import task.");
        }
        try {
            AbstractTaskScheduler.WorkerTask task;
            ImagingTask prevTask;
            ImagingWorker worker = ImagingWorkers.getWorker(request.getInstanceId());
            if (worker != null) {
                ImagingWorkers.markUpdate(request.getInstanceId());
                if (!ImagingWorkers.canAllocate(request.getInstanceId())) {
                    LOG.warn((Object)String.format("The worker (%s) is marked invalid", request.getInstanceId()));
                    return reply;
                }
            } else {
                worker = ImagingWorkers.createWorker(request.getInstanceId());
            }
            if ((prevTask = ImagingTasks.getConvertingTaskByWorkerId(request.getInstanceId())) != null) {
                ImagingTasks.killAndRerunTask(prevTask.getDisplayName());
                LOG.warn((Object)String.format("A task (%s:%s) is gone missing [BUG in worker script]", prevTask.getDisplayName(), request.getInstanceId()));
            }
            if ((task = AbstractTaskScheduler.getScheduler().getTask(worker.getAvailabilityZone())) != null) {
                reply.setImportTaskId(task.getImportTaskId());
                reply.setImportTaskType(task.getImportTaskType().toString());
                if (task.getVolumeTask() != null) {
                    reply.setVolumeTask(task.getVolumeTask());
                } else if (task.getInstanceStoreTask() != null) {
                    reply.setInstanceStoreTask(task.getInstanceStoreTask());
                }
                if (request.getInstanceId() != null) {
                    ImagingTasks.setWorkerId(task.getImportTaskId(), request.getInstanceId());
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to schedule a task", (Throwable)ex);
        }
        return reply;
    }
}

