/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.imaging.ImportTaskProperties;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.common.DiskImageConversionTask;
import com.eucalyptus.imaging.common.ImportDiskImage;
import com.eucalyptus.imaging.common.backend.msgs.ImportImageType;
import com.eucalyptus.util.Dates;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Transient;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_imaging")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="disk-imaging-task")
public class DiskImagingTask
extends ImagingTask {
    private static Logger LOG = Logger.getLogger(DiskImagingTask.class);
    @Transient
    private DiskImageConversionTask task;

    protected DiskImagingTask() {
        super(null, null);
    }

    private DiskImagingTask(OwnerFullName ownerFullName, DiskImageConversionTask task, ImportTaskState state) {
        super(ownerFullName, task.getConversionTaskId());
        this.setState(state);
        this.task = task;
    }

    public static DiskImagingTask named(AccountFullName owningAccount) {
        DiskImagingTask task = new DiskImagingTask();
        task.setOwnerAccountNumber(owningAccount.getAccountNumber());
        return task;
    }

    @Override
    protected void createTaskFromJSON() {
        if (this.taskInJSON != null) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            JSONObject taskObject = (JSONObject)jsonSlurper.parseText(this.taskInJSON);
            this.task = new DiskImageConversionTask(taskObject);
        }
    }

    @Override
    public String getTaskExpirationTime() {
        return this.task.getExpirationTime();
    }

    @Override
    public JSONObject toJSON() {
        return this.task.toJSON();
    }

    @Override
    public void setTaskState(String state) {
        this.task.setState(state);
    }

    @Override
    public String getTaskState() {
        return this.task.getState();
    }

    @Override
    public void setTaskStatusMessage(String msg) {
        this.task.setStatusMessage(msg);
    }

    @Override
    @PostLoad
    protected void onLoad() {
        super.onLoad();
    }

    public DiskImageConversionTask getTask() {
        return this.task;
    }

    @TypeMapper
    static enum DiskImagingTaskTransform implements Function<ImportImageType, DiskImagingTask>
    {
        INSTANCE;


        @Nullable
        public DiskImagingTask apply(ImportImageType input) {
            DiskImageConversionTask ct = new DiskImageConversionTask();
            String conversionTaskId = ResourceIdentifiers.generateString((String)"import-is");
            conversionTaskId = conversionTaskId.toLowerCase();
            ct.setConversionTaskId(conversionTaskId);
            ct.setExpirationTime(new Date(Dates.hoursFromNow((int)Integer.parseInt(ImportTaskProperties.IMPORT_TASK_EXPIRATION_HOURS)).getTime()).toString());
            ct.setState(ImportTaskState.NEW.getExternalTaskStateName());
            ct.setStatusMessage("");
            ImportDiskImage image = input.getImage();
            ct.setImportDisk(image);
            DiskImagingTask newTask = new DiskImagingTask((OwnerFullName)Contexts.lookup().getUserFullName(), ct, ImportTaskState.NEW);
            newTask.serializeTaskToJSON();
            return newTask;
        }
    }
}

