/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.backend;

import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.ImportInstanceVolumeDetail;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.imaging.backend.DiskImagingTask;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImagingTasks;
import com.eucalyptus.imaging.backend.ImportInstanceImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.ImportVolumeImagingTask;
import com.eucalyptus.imaging.backend.TaskSchedulers;
import com.eucalyptus.imaging.common.DiskImageConversionTask;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.imaging.common.ImageManifest;
import com.eucalyptus.imaging.common.ImportDiskImageDetail;
import com.eucalyptus.imaging.common.InstanceStoreTask;
import com.eucalyptus.imaging.common.VolumeTask;
import com.eucalyptus.imaging.manifest.BundleImageManifest;
import com.eucalyptus.imaging.manifest.DownloadManifestFactory;
import com.eucalyptus.imaging.manifest.ImageManifestFile;
import com.eucalyptus.imaging.manifest.ImportImageManifest;
import com.eucalyptus.imaging.manifest.InvalidBaseManifestException;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.util.DNSProperties;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.collect.Lists;
import java.net.URI;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class AbstractTaskScheduler {
    private static Logger LOG = Logger.getLogger(AbstractTaskScheduler.class);
    private PublicKey imagingServiceKey = null;
    private String imagingServiceCertArn = null;
    private static Object taskLock = new Object();

    protected abstract ImagingTask getNext(String var1);

    private void loadImagingServiceKey() throws Exception {
        try {
            ServerCertificateType cert = EucalyptusActivityTasks.getInstance().getServerCertificate("euca-internal-imaging-service");
            String certBody = cert.getCertificateBody();
            X509Certificate x509 = PEMFiles.toCertificate((String)B64.url.encString((String)certBody));
            this.imagingServiceKey = x509.getPublicKey();
            this.imagingServiceCertArn = cert.getServerCertificateMetadata().getArn();
        }
        catch (Exception ex) {
            throw new Exception("Failed to load public key of the imaging service", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerTask getTask(String availabilityZone) throws Exception {
        Object object = taskLock;
        synchronized (object) {
            WorkerTask newTask;
            ImagingTask nextTask;
            block27: {
                nextTask = this.getNext(availabilityZone);
                if (nextTask == null) {
                    return null;
                }
                this.imagingServiceKey = null;
                this.imagingServiceCertArn = null;
                this.loadImagingServiceKey();
                if (this.imagingServiceKey == null || this.imagingServiceCertArn == null) {
                    throw new Exception("Failed to load public key of the imaging service");
                }
                newTask = null;
                try {
                    if (nextTask instanceof DiskImagingTask) {
                        DiskImagingTask imagingTask = (DiskImagingTask)nextTask;
                        DiskImageConversionTask conversionTask = imagingTask.getTask();
                        try {
                            ArrayList importImages = conversionTask.getImportDisk().getDiskImageSet();
                            for (ImportDiskImageDetail image : importImages) {
                                String manifestUrl = image.getDownloadManifestUrl();
                                String key = manifestUrl.substring(manifestUrl.lastIndexOf("/") + 1);
                                manifestUrl = manifestUrl.substring(0, manifestUrl.lastIndexOf("/"));
                                String bucket = manifestUrl.substring(manifestUrl.lastIndexOf("/") + 1);
                                ImageManifestFile manifestFile = new ImageManifestFile(String.format("%s/%s", bucket, key), (com.eucalyptus.imaging.manifest.ImageManifest)BundleImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue());
                                String manifestName = String.format("%s-%s-%s", imagingTask.getDisplayName(), conversionTask.getImportDisk().getConvertedImage().getPrefix(), image.getFormat());
                                String downloadManifest = DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)manifestFile, (PublicKey)this.imagingServiceKey, (String)manifestName, (int)5, (boolean)false);
                                image.setDownloadManifestUrl(downloadManifest);
                            }
                        }
                        catch (Exception ex) {
                            ImagingTasks.setState(imagingTask, ImportTaskState.FAILED, "Failed to generate download manifest");
                            throw new EucalyptusCloudException("Failed to generate download manifest", (Throwable)ex);
                        }
                        newTask = new WorkerTask(imagingTask.getDisplayName(), WorkerTaskType.convert_image);
                        InstanceStoreTask ist = new InstanceStoreTask();
                        ist.setAccountId(imagingTask.getOwnerAccountNumber());
                        ist.setAccessKey(conversionTask.getImportDisk().getAccessKey());
                        ist.setConvertedImage(conversionTask.getImportDisk().getConvertedImage());
                        ist.setImportImageSet(conversionTask.getImportDisk().getDiskImageSet());
                        ist.setUploadPolicy(conversionTask.getImportDisk().getUploadPolicy());
                        ist.setUploadPolicySignature(conversionTask.getImportDisk().getUploadPolicySignature());
                        ist.setServiceCertArn(this.imagingServiceCertArn);
                        ServiceConfiguration osg = Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]);
                        URI osgUri = osg.getUri();
                        if ("localhost".equals(DNSProperties.DOMAIN)) {
                            ist.setS3Url(String.format("%s://%s:%d%s", osgUri.getScheme(), osgUri.getHost(), osgUri.getPort(), osgUri.getPath()));
                        } else {
                            ist.setS3Url(String.format("%s://objectstorage.%s:%d", osgUri.getScheme(), DNSProperties.DOMAIN, osgUri.getPort()));
                        }
                        newTask.setInstanceStoreTask(ist);
                        break block27;
                    }
                    if (nextTask instanceof ImportVolumeImagingTask) {
                        ImportVolumeImagingTask volumeTask = (ImportVolumeImagingTask)nextTask;
                        String manifestLocation = null;
                        if (volumeTask.getDownloadManifestUrl().size() == 0) {
                            try {
                                manifestLocation = DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)new ImageManifestFile(volumeTask.getImportManifestUrl(), (com.eucalyptus.imaging.manifest.ImageManifest)ImportImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue()), null, (String)volumeTask.getDisplayName(), (int)1, (boolean)false);
                            }
                            catch (InvalidBaseManifestException ex) {
                                ImagingTasks.setState(volumeTask, ImportTaskState.FAILED, "Failed to generate download manifest");
                                throw new EucalyptusCloudException("Failed to generate download manifest", (Throwable)ex);
                            }
                            ImagingTasks.addDownloadManifestUrl(volumeTask, volumeTask.getImportManifestUrl(), manifestLocation);
                        } else {
                            manifestLocation = volumeTask.getDownloadManifestUrl().get(0).getDownloadManifestUrl();
                        }
                        newTask = new WorkerTask(volumeTask.getDisplayName(), WorkerTaskType.import_volume);
                        VolumeTask vt = new VolumeTask();
                        ImageManifest im = new ImageManifest();
                        im.setManifestUrl(manifestLocation);
                        im.setFormat(volumeTask.getFormat());
                        vt.setImageManifestSet(Lists.newArrayList((Object[])new ImageManifest[]{im}));
                        vt.setVolumeId(volumeTask.getVolumeId());
                        newTask.setVolumeTask(vt);
                        break block27;
                    }
                    if (!(nextTask instanceof ImportInstanceImagingTask)) break block27;
                    ImportInstanceImagingTask instanceTask = (ImportInstanceImagingTask)nextTask;
                    for (ImportInstanceVolumeDetail volume : instanceTask.getVolumes()) {
                        String importManifestUrl = volume.getImage().getImportManifestUrl();
                        if (instanceTask.hasDownloadManifestUrl(importManifestUrl) || !availabilityZone.equals(volume.getAvailabilityZone())) continue;
                        String manifestLocation = null;
                        manifestLocation = instanceTask.getDownloadManifestUrl(importManifestUrl);
                        if (manifestLocation == null) {
                            try {
                                String manifestName = String.format("%s-%s", nextTask.getDisplayName(), volume.getVolume().getId());
                                manifestLocation = DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)new ImageManifestFile(importManifestUrl, (com.eucalyptus.imaging.manifest.ImageManifest)ImportImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue()), null, (String)manifestName, (int)1, (boolean)false);
                                ImagingTasks.addDownloadManifestUrl(instanceTask, importManifestUrl, manifestLocation);
                            }
                            catch (InvalidBaseManifestException ex) {
                                ImagingTasks.setState(instanceTask, ImportTaskState.FAILED, "Failed to generate download manifest");
                                throw new EucalyptusCloudException("Failed to generate download manifest", (Throwable)ex);
                            }
                        }
                        newTask = new WorkerTask(instanceTask.getDisplayName(), WorkerTaskType.import_volume);
                        VolumeTask vt = new VolumeTask();
                        ImageManifest im = new ImageManifest();
                        im.setManifestUrl(manifestLocation);
                        im.setFormat(volume.getImage().getFormat());
                        vt.setImageManifestSet(Lists.newArrayList((Object[])new ImageManifest[]{im}));
                        vt.setVolumeId(volume.getVolume().getId());
                        newTask.setVolumeTask(vt);
                        break;
                    }
                }
                catch (EucalyptusCloudException ex) {
                    throw new Exception("failed to prepare worker task", ex);
                }
                catch (Exception ex) {
                    ImagingTasks.setState(nextTask, ImportTaskState.FAILED, "Import task failed unexpectedly");
                    throw new Exception("failed to prepare worker task", ex);
                }
            }
            if (newTask != null) {
                try {
                    ImagingTasks.transitState(nextTask, ImportTaskState.PENDING, ImportTaskState.CONVERTING, "");
                }
                catch (Exception exception) {}
            } else {
                ImagingTasks.setState(nextTask, ImportTaskState.FAILED, "Import task failed unexpectedly");
            }
            return newTask;
        }
    }

    public static AbstractTaskScheduler getScheduler() {
        return new TaskSchedulers.ImportImageFirstTaskScheduler();
    }

    public static class WorkerTask {
        String importTaskId = null;
        WorkerTaskType importTaskType = null;
        VolumeTask volumeTask = null;
        InstanceStoreTask instanceStoreTask = null;

        public WorkerTask() {
        }

        public WorkerTask(String importTaskId, WorkerTaskType taskType) {
            this.importTaskId = importTaskId;
            this.importTaskType = taskType;
        }

        public String getImportTaskId() {
            return this.importTaskId;
        }

        public WorkerTaskType getImportTaskType() {
            return this.importTaskType;
        }

        public void setVolumeTask(VolumeTask volumeTask) {
            this.volumeTask = volumeTask;
        }

        public VolumeTask getVolumeTask() {
            return this.volumeTask;
        }

        public void setInstanceStoreTask(InstanceStoreTask task) {
            this.instanceStoreTask = task;
        }

        public InstanceStoreTask getInstanceStoreTask() {
            return this.instanceStoreTask;
        }
    }

    public static enum WorkerTaskType {
        import_volume,
        convert_image;

    }
}

