/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.conversion;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.ConversionTask;
import com.eucalyptus.compute.common.backend.CancelConversionTaskResponseType;
import com.eucalyptus.compute.common.backend.CancelConversionTaskType;
import com.eucalyptus.compute.common.backend.DescribeConversionTasksResponseType;
import com.eucalyptus.compute.common.backend.DescribeConversionTasksType;
import com.eucalyptus.compute.common.backend.ImportInstanceResponseType;
import com.eucalyptus.compute.common.backend.ImportInstanceType;
import com.eucalyptus.compute.common.backend.ImportVolumeResponseType;
import com.eucalyptus.compute.common.backend.ImportVolumeType;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.imaging.backend.ImagingServiceException;
import com.eucalyptus.imaging.backend.ImagingTask;
import com.eucalyptus.imaging.backend.ImagingTasks;
import com.eucalyptus.imaging.backend.ImportInstanceImagingTask;
import com.eucalyptus.imaging.backend.ImportTaskState;
import com.eucalyptus.imaging.backend.ImportVolumeImagingTask;
import com.eucalyptus.imaging.backend.VolumeImagingTask;
import com.eucalyptus.imaging.common.Imaging;
import com.eucalyptus.imaging.worker.ImagingServiceLaunchers;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ImportManager {
    private static Logger LOG = Logger.getLogger(ImportManager.class);

    public ImportInstanceResponseType ImportInstance(ImportInstanceType request) throws Exception {
        ImportInstanceResponseType reply = (ImportInstanceResponseType)request.getReply();
        Context context = Contexts.lookup();
        try {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabled(Imaging.class)) {
                throw new ImagingServiceException("500", "For import, Imaging service should be enabled");
            }
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "For import, Imaging service should be enabled");
        }
        try {
            if (!Permissions.isAuthorized((String)"ec2", (String)"instance", (String)"", null, (String)"importinstance", (AuthContextSupplier)context.getAuthContext())) {
                throw new ImagingServiceException("400", "Not authorized to import instance.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to import instance.");
        }
        try {
            if (ImagingServiceLaunchers.getInstance().shouldEnable()) {
                ImagingServiceLaunchers.getInstance().enable();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to enable imaging service workers");
            throw new ImagingServiceException("500", "Could not launch imaging service workers");
        }
        ImportInstanceImagingTask task = null;
        try {
            task = ImagingTasks.createImportInstanceTask(request);
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to import instance", (Throwable)ex);
            throw new ImagingServiceException("Failed to import instance", ex);
        }
        reply.setConversionTask(task.getTask());
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public static ImportVolumeResponseType ImportVolume(ImportVolumeType request) throws Exception {
        ImportVolumeResponseType reply = (ImportVolumeResponseType)request.getReply();
        Context context = Contexts.lookup();
        try {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabled(Imaging.class)) {
                throw new ImagingServiceException("500", "For import, Imaging service should be enabled");
            }
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "For import, Imaging service should be enabled");
        }
        try {
            if (!Permissions.isAuthorized((String)"ec2", (String)"volume", (String)"", null, (String)"importvolume", (AuthContextSupplier)context.getAuthContext())) {
                throw new ImagingServiceException("400", "Not authorized to import volume.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to import volume.");
        }
        try {
            if (ImagingServiceLaunchers.getInstance().shouldEnable()) {
                ImagingServiceLaunchers.getInstance().enable();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to enable imaging service workers");
            throw new ImagingServiceException("500", "Could not launch imaging service workers");
        }
        ImportVolumeImagingTask task = null;
        try {
            task = ImagingTasks.createImportVolumeTask(request);
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to import volume", (Throwable)ex);
            throw new ImagingServiceException("Failed to import volume", ex);
        }
        reply.setConversionTask(task.getTask());
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public CancelConversionTaskResponseType CancelConversionTask(CancelConversionTaskType request) throws Exception {
        CancelConversionTaskResponseType reply = (CancelConversionTaskResponseType)request.getReply();
        Context context = Contexts.lookup();
        try {
            if (!Permissions.isAuthorized((String)"ec2", (String)"volume", (String)"", null, (String)"cancelconversiontask", (AuthContextSupplier)context.getAuthContext())) {
                throw new ImagingServiceException("400", "Not authorized to cancel conversion task.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to cancel conversion task.");
        }
        try {
            ImagingTask task = ImagingTasks.lookup(request.getConversionTaskId());
            ImportTaskState state = (ImportTaskState)task.getState();
            if (state.equals((Object)ImportTaskState.NEW) || state.equals((Object)ImportTaskState.PENDING) || state.equals((Object)ImportTaskState.CONVERTING) || state.equals((Object)ImportTaskState.INSTANTIATING)) {
                ImagingTasks.setState(AccountFullName.getInstance((Account)Contexts.lookup().getAccount(), (String[])new String[0]), request.getConversionTaskId(), ImportTaskState.CANCELLING, "Cancelled by user");
            }
            reply.set_return(Boolean.valueOf(true));
        }
        catch (NoSuchElementException ex) {
            throw new ImagingServiceException("400", "Conversion task not found");
        }
        catch (Exception ex) {
            throw new ImagingServiceException("500", "Failed to cancel conversion task", ex);
        }
        return reply;
    }

    public DescribeConversionTasksResponseType DescribeConversionTasks(DescribeConversionTasksType request) throws Exception {
        DescribeConversionTasksResponseType reply = (DescribeConversionTasksResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean verbose = request.getConversionTaskIdSet().remove("verbose");
        Collection<Object> ownerInfo = ctx.isAdministrator() && verbose ? Collections.emptyList() : Collections.singleton(ctx.getAccount().getAccountNumber());
        try {
            if (!Permissions.isAuthorized((String)"ec2", (String)"volume", (String)"", null, (String)"describeconversiontasks", (AuthContextSupplier)ctx.getAuthContext())) {
                throw new ImagingServiceException("400", "Not authorized to describe conversion tasks.");
            }
        }
        catch (ImagingServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ImagingServiceException("400", "Not authorized to describe conversion tasks.");
        }
        Predicate requestedAndAccessible = RestrictedTypes.filteringFor(VolumeImagingTask.class).byId((Collection)request.getConversionTaskIdSet()).byOwningAccount(ownerInfo).byPrivileges().buildPredicate();
        List<VolumeImagingTask> tasksToList = ImagingTasks.getVolumeImagingTasks();
        for (VolumeImagingTask task : Iterables.filter(tasksToList, (Predicate)requestedAndAccessible)) {
            ConversionTask t = task.getTask();
            reply.getConversionTasks().add(t);
        }
        return reply;
    }
}

