/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tokens.ws;

import com.eucalyptus.auth.login.AccountUsernamePasswordCredentials;
import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.id.Tokens;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.SecurityHeader;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.tokens.ws.TokensQueryBinding;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.protocol.RequiredQueryParams;
import com.eucalyptus.ws.server.NioServerHandler;
import com.eucalyptus.ws.server.QueryPipeline;
import com.eucalyptus.ws.stages.UnrollableStage;
import com.google.common.base.Charsets;
import java.util.EnumSet;
import java.util.Map;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ComponentPart(value=Tokens.class)
public class TokensQueryPipeline
extends QueryPipeline {
    private final TokensAuthenticationStage auth = new TokensAuthenticationStage(super.getAuthenticationStage());

    public TokensQueryPipeline() {
        super("tokens-query-pipeline", "/services/Tokens", EnumSet.of(TemporaryAccessKey.TemporaryKeyType.Role), EnumSet.of(RequiredQueryParams.Version));
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        super.addHandlers(pipeline);
        pipeline.addLast("tokens-query-binding", (ChannelHandler)new TokensQueryBinding());
        return pipeline;
    }

    protected UnrollableStage getAuthenticationStage() {
        return this.auth;
    }

    public static class AccountUsernamePasswordHandler
    extends MessageStackHandler {
        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
            try {
                super.handleUpstream(ctx, channelEvent);
            }
            catch (ChallengeException e) {
                this.sendResponse(channelEvent, "Unauthorized", HttpResponseStatus.UNAUTHORIZED, true);
            }
            catch (CredentialExpiredException e) {
                this.sendResponse(channelEvent, "Expired credentials", HttpResponseStatus.FORBIDDEN, false);
            }
        }

        public void incomingMessage(MessageEvent event) throws Exception {
            if (event.getMessage() instanceof MappingHttpRequest) {
                String[] authorization;
                MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
                boolean challenge = true;
                if (httpRequest.containsHeader("Authorization") && (authorization = httpRequest.getHeader("Authorization").split(" ", 2)).length == 2 && "basic".equalsIgnoreCase(authorization[0])) {
                    boolean isChangePassword = false;
                    String unEncodedAuth = B64.standard.decString((String)authorization[1]);
                    if (unEncodedAuth.indexOf(";") > -1) {
                        isChangePassword = true;
                    }
                    String[] basicUsernamePassword = unEncodedAuth.split(isChangePassword ? ";" : ":", 2);
                    String[] encodedAccountUsername = basicUsernamePassword[0].split("@", 2);
                    if (basicUsernamePassword.length == 2 && encodedAccountUsername.length == 2) {
                        String account = B64.standard.decString((String)encodedAccountUsername[1]);
                        String username = B64.standard.decString((String)encodedAccountUsername[0]);
                        String passwordSubstring = basicUsernamePassword[1];
                        String[] passwords = passwordSubstring.split("@", 2);
                        String password = isChangePassword ? B64.standard.decString((String)passwords[0]) : passwordSubstring;
                        String newPassword = isChangePassword && passwords.length == 2 ? passwords[1] : null;
                        try {
                            SecurityContext.getLoginContext((WrappedCredentials)new AccountUsernamePasswordCredentials(httpRequest.getCorrelationId(), account, username, password, newPassword)).login();
                            challenge = false;
                        }
                        catch (CredentialExpiredException e) {
                            throw e;
                        }
                        catch (LoginException loginException) {
                            // empty catch block
                        }
                    }
                }
                if (challenge) {
                    throw new ChallengeException();
                }
            }
        }

        public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        }

        private void sendResponse(ChannelEvent channelEvent, String message, HttpResponseStatus status, boolean requestAuthenticate) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)((MessageEvent)channelEvent).getMessage();
            ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])message.getBytes(Charsets.UTF_8));
            DefaultHttpResponse response = new DefaultHttpResponse(httpRequest.getProtocolVersion(), status);
            response.setHeader("Content-Type", (Object)"text/plain; charset=utf8");
            response.setHeader("Content-Length", (Object)Integer.toString(buffer.readableBytes()));
            if (requestAuthenticate) {
                response.setHeader("WWW-Authenticate", (Object)"Basic realm=\"eucalyptus\"");
            }
            response.setContent(buffer);
            ChannelFuture writeFuture = channelEvent.getChannel().write((Object)response);
            if (!NioServerHandler.isPersistentConnection((MappingHttpRequest)httpRequest)) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }

        private static class ChallengeException
        extends Exception {
            private static final long serialVersionUID = 1L;

            private ChallengeException() {
            }
        }
    }

    public static class TokensAuthenticationHandler
    extends MessageStackHandler {
        private final UnrollableStage standardAuthenticationStage;

        public TokensAuthenticationHandler(UnrollableStage standardAuthenticationStage) {
            this.standardAuthenticationStage = standardAuthenticationStage;
        }

        public void incomingMessage(MessageEvent event) throws Exception {
            boolean usePasswordAuth = false;
            if (event.getMessage() instanceof MappingHttpRequest) {
                MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
                usePasswordAuth = !httpRequest.getParameters().containsKey(RequiredQueryParams.SignatureVersion.toString()) && !httpRequest.getParameters().containsKey(SecurityParameter.X_Amz_Algorithm.parameter()) && !SecurityHeader.Value.AWS4_HMAC_SHA256.matches(httpRequest.getHeader("Authorization"));
            }
            ChannelPipeline stagePipeline = Channels.pipeline();
            if (usePasswordAuth) {
                stagePipeline.addLast("tokens-password-authentication", (ChannelHandler)new AccountUsernamePasswordHandler());
            } else {
                this.standardAuthenticationStage.unrollStage(stagePipeline);
            }
            ChannelPipeline pipeline = event.getChannel().getPipeline();
            String addAfter = "tokens-authentication-method-selector";
            for (Map.Entry handlerEntry : stagePipeline.toMap().entrySet()) {
                pipeline.addAfter(addAfter, (String)handlerEntry.getKey(), (ChannelHandler)handlerEntry.getValue());
                addAfter = (String)handlerEntry.getKey();
            }
        }
    }

    private static class TokensAuthenticationStage
    implements UnrollableStage {
        private final UnrollableStage standardAuthenticationStage;

        private TokensAuthenticationStage(UnrollableStage standardAuthenticationStage) {
            this.standardAuthenticationStage = standardAuthenticationStage;
        }

        public void unrollStage(ChannelPipeline pipeline) {
            pipeline.addLast("tokens-authentication-method-selector", (ChannelHandler)new TokensAuthenticationHandler(this.standardAuthenticationStage));
        }

        public String getName() {
            return "tokens-user-authentication";
        }

        public int compareTo(UnrollableStage o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

