/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tokens.ws;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.tokens.TokensErrorResponseType;
import com.eucalyptus.tokens.TokensErrorType;
import com.eucalyptus.tokens.TokensException;
import com.eucalyptus.tokens.ws.TokensQueryBinding;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.LogUtil;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.api.MessagingException;
import org.mule.message.ExceptionMessage;

public class TokensErrorHandler {
    private static final Logger LOG = Logger.getLogger(TokensErrorHandler.class);
    private static final String INTERNAL_FAILURE = "InternalFailure";

    public void handle(ExceptionMessage exMsg) {
        EventRecord.here(TokensErrorHandler.class, (EventType)EventType.MSG_REPLY, (String[])new String[]{exMsg.getPayload().getClass().getSimpleName()}).debug();
        LOG.trace((Object)("Caught exception while servicing: " + exMsg.getPayload()));
        Throwable exception = exMsg.getException();
        if (exception instanceof MessagingException && exception.getCause() instanceof EucalyptusCloudException) {
            try {
                String type;
                String code;
                HttpResponseStatus status;
                EucalyptusCloudException cloudException = (EucalyptusCloudException)exception.getCause();
                BaseMessage payload = TokensErrorHandler.parsePayload(exMsg.getPayload());
                TokensErrorResponseType errorResp = new TokensErrorResponseType();
                if (cloudException instanceof TokensException) {
                    TokensException tokensException = (TokensException)cloudException;
                    status = tokensException.getStatus();
                    code = tokensException.getError();
                    type = tokensException.getType();
                } else {
                    status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                    code = INTERNAL_FAILURE;
                    type = "Receiver";
                }
                errorResp.setHttpStatus(status);
                errorResp.setCorrelationId(payload.getCorrelationId());
                errorResp.setRequestId(payload.getCorrelationId());
                TokensErrorType error = new TokensErrorType();
                error.setType(type);
                error.setCode(code);
                error.setMessage(cloudException.getMessage());
                errorResp.getErrors().add(error);
                Contexts.response((BaseMessage)errorResp);
            }
            catch (PayloadParseException e) {
                LOG.error((Object)"Failed to parse payload ", e.getCause());
            }
        } else {
            LOG.error((Object)"Unable to handle exception", exception);
        }
    }

    private static BaseMessage parsePayload(Object payload) throws PayloadParseException {
        if (payload instanceof BaseMessage) {
            return (BaseMessage)payload;
        }
        if (payload instanceof String) {
            try {
                return (BaseMessage)BindingManager.getBinding((String)BindingManager.sanitizeNamespace((String)TokensQueryBinding.STS_DEFAULT_NAMESPACE)).fromOM((String)payload);
            }
            catch (Exception e) {
                throw new PayloadParseException(e);
            }
        }
        return new EucalyptusErrorMessageType("TokensErrorHandler", LogUtil.dumpObject((Object)payload));
    }

    private static final class PayloadParseException
    extends Exception {
        public PayloadParseException(Throwable cause) {
            super(cause);
        }
    }
}

