/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tokens.policy;

import com.eucalyptus.util.Exceptions;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalIdContext {
    private static final ThreadLocal<String> externalIdLocal = new ThreadLocal();

    public static <R, T extends Throwable> R doWithExternalId(@Nullable String externalId, @Nonnull Class<T> thrown, @Nonnull Callable<R> callback) throws T {
        String previousId = externalIdLocal.get();
        externalIdLocal.set(externalId);
        try {
            R r = callback.call();
            return r;
        }
        catch (Exception e) {
            Throwable rethrow = Exceptions.findCause((Throwable)e, thrown);
            if (rethrow != null) {
                throw rethrow;
            }
            throw Exceptions.toUndeclared((Throwable)e);
        }
        finally {
            externalIdLocal.set(previousId);
        }
    }

    @Nullable
    static String getExternalId() {
        return externalIdLocal.get();
    }
}

