/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tokens;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.util.Strings;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

@ConfigurableClass(root="tokens", description="Parameters controlling tokens service")
public class TokensServiceConfiguration {
    private static final Logger logger = Logger.getLogger(TokensServiceConfiguration.class);
    @ConfigurableField(initial="", description="Actions to enable (ignored if empty)", changeListener=TokensServicePropertyChangeListener.class)
    public static volatile String enabledActions = "";
    @ConfigurableField(initial="", description="Actions to disable", changeListener=TokensServicePropertyChangeListener.class)
    public static volatile String disabledActions = "";
    private static final AtomicReference<Set<String>> enabledActionsSet = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<String>> disabledActionsSet = new AtomicReference(Collections.emptySet());

    public static Set<String> getEnabledActions() {
        return enabledActionsSet.get();
    }

    public static Set<String> getDisabledActions() {
        return disabledActionsSet.get();
    }

    public static final class TokensServicePropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            try {
                Splitter splitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE.or(CharMatcher.anyOf((CharSequence)",;|"))).trimResults().omitEmptyStrings();
                String fieldName = configurableProperty.getField().getName() + "Set";
                Field field = TokensServiceConfiguration.class.getDeclaredField(fieldName);
                field.setAccessible(true);
                ImmutableSet value = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)splitter.split((CharSequence)String.valueOf(newValue)), (Function)Strings.lower()));
                logger.info((Object)("Tokens service configuration updated " + configurableProperty.getDisplayName() + ": " + value));
                ((AtomicReference)field.get(null)).set(value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error((Object)("Error updating token service configuration for " + configurableProperty.getDisplayName()), (Throwable)e);
            }
        }
    }
}

