/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tokens;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.login.AccountUsernamePasswordCredentials;
import com.eucalyptus.auth.login.HmacCredentials;
import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.tokens.SecurityToken;
import com.eucalyptus.auth.tokens.SecurityTokenManager;
import com.eucalyptus.auth.tokens.SecurityTokenValidationException;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.tokens.AssumeRoleResponseType;
import com.eucalyptus.tokens.AssumeRoleType;
import com.eucalyptus.tokens.AssumedRoleUserType;
import com.eucalyptus.tokens.CredentialsType;
import com.eucalyptus.tokens.GetAccessTokenResponseType;
import com.eucalyptus.tokens.GetAccessTokenResultType;
import com.eucalyptus.tokens.GetAccessTokenType;
import com.eucalyptus.tokens.GetImpersonationTokenResponseType;
import com.eucalyptus.tokens.GetImpersonationTokenResultType;
import com.eucalyptus.tokens.GetImpersonationTokenType;
import com.eucalyptus.tokens.GetSessionTokenResponseType;
import com.eucalyptus.tokens.GetSessionTokenResultType;
import com.eucalyptus.tokens.GetSessionTokenType;
import com.eucalyptus.tokens.TokensException;
import com.eucalyptus.tokens.policy.ExternalIdContext;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public class TokensService {
    public GetSessionTokenResponseType getSessionToken(GetSessionTokenType request) throws EucalyptusCloudException {
        AccessKey accessKey;
        Set queryIdCreds;
        GetSessionTokenResponseType reply = (GetSessionTokenResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        Subject subject = ctx.getSubject();
        User requestUser = ctx.getUser();
        Set<Object> set = queryIdCreds = subject == null ? Collections.emptySet() : subject.getPublicCredentials(HmacCredentials.QueryIdCredential.class);
        if (queryIdCreds.isEmpty()) {
            throw new TokensException(TokensException.Code.MissingAuthenticationToken, "Missing credential.");
        }
        String queryId = ((HmacCredentials.QueryIdCredential)Iterables.getOnlyElement(queryIdCreds)).getQueryId();
        try {
            accessKey = Accounts.lookupAccessKeyById((String)queryId);
        }
        catch (AuthException e) {
            throw new TokensException(TokensException.Code.MissingAuthenticationToken, "Invalid credential: " + queryId);
        }
        try {
            int durationSeconds = (Integer)Objects.firstNonNull((Object)request.getDurationSeconds(), (Object)((int)TimeUnit.HOURS.toSeconds(12L)));
            SecurityToken token = SecurityTokenManager.issueSecurityToken((User)requestUser, (AccessKey)accessKey, (int)(requestUser.isAccountAdmin() ? (int)TimeUnit.HOURS.toSeconds(1L) : 0), (int)durationSeconds);
            reply.setResult(GetSessionTokenResultType.forCredentials((String)token.getAccessKeyId(), (String)token.getSecretKey(), (String)token.getToken(), (long)token.getExpires()));
        }
        catch (SecurityTokenValidationException e) {
            throw new TokensException(TokensException.Code.ValidationError, e.getMessage());
        }
        catch (AuthException e) {
            throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
        }
        return reply;
    }

    public AssumeRoleResponseType assumeRole(AssumeRoleType request) throws EucalyptusCloudException {
        Set queryIdCreds;
        AssumeRoleResponseType reply = (AssumeRoleResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        Subject subject = ctx.getSubject();
        Set<Object> set = queryIdCreds = subject == null ? Collections.emptySet() : subject.getPublicCredentials(HmacCredentials.QueryIdCredential.class);
        if (queryIdCreds.size() == 1 && ((HmacCredentials.QueryIdCredential)Iterables.get(queryIdCreds, (int)0)).getType().isPresent()) {
            throw new TokensException(TokensException.Code.MissingAuthenticationToken, "Temporary credential not permitted.");
        }
        TokensService.rejectPasswordCredentials();
        final Role role = TokensService.lookupRole(request.getRoleArn());
        try {
            ExternalIdContext.doWithExternalId(request.getExternalId(), EucalyptusCloudException.class, new Callable<Role>(){

                @Override
                public Role call() throws EucalyptusCloudException {
                    try {
                        return (Role)RestrictedTypes.doPrivilegedWithoutOwner((String)Accounts.getRoleFullName((Role)role), (Function)new RoleResolver(role));
                    }
                    catch (AuthException e) {
                        throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
                    }
                }
            });
            SecurityToken token = SecurityTokenManager.issueSecurityToken((Role)role, (int)((Integer)Objects.firstNonNull((Object)request.getDurationSeconds(), (Object)((int)TimeUnit.HOURS.toSeconds(1L)))));
            reply.getAssumeRoleResult().setCredentials(new CredentialsType(token.getAccessKeyId(), token.getSecretKey(), token.getToken(), token.getExpires()));
            reply.getAssumeRoleResult().setAssumedRoleUser(new AssumedRoleUserType(role.getRoleId() + ":" + request.getRoleSessionName(), TokensService.assumedRoleArn(role, request.getRoleSessionName())));
        }
        catch (SecurityTokenValidationException e) {
            throw new TokensException(TokensException.Code.ValidationError, e.getMessage());
        }
        catch (AuthException e) {
            throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
        }
        return reply;
    }

    public GetAccessTokenResponseType getAccessToken(GetAccessTokenType request) throws EucalyptusCloudException {
        AccountUsernamePasswordCredentials.AccountUsername accountUsername;
        GetAccessTokenResponseType reply = (GetAccessTokenResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        Subject subject = ctx.getSubject();
        User requestUser = ctx.getUser();
        AccountUsernamePasswordCredentials.AccountUsername accountUsername2 = accountUsername = subject == null ? null : (AccountUsernamePasswordCredentials.AccountUsername)Iterables.getFirst(subject.getPublicCredentials(AccountUsernamePasswordCredentials.AccountUsername.class), null);
        if (accountUsername == null || !accountUsername.getAccount().equals(ctx.getAccount().getName()) || !accountUsername.getUsername().equals(requestUser.getName())) {
            throw new EucalyptusCloudException("Invalid authentication");
        }
        try {
            SecurityToken token = SecurityTokenManager.issueSecurityToken((User)requestUser, (int)(requestUser.isAccountAdmin() ? (int)TimeUnit.DAYS.toSeconds(1L) : 0), (int)((Integer)Objects.firstNonNull((Object)request.getDurationSeconds(), (Object)((int)TimeUnit.HOURS.toSeconds(12L)))));
            reply.setResult(GetAccessTokenResultType.forCredentials((String)token.getAccessKeyId(), (String)token.getSecretKey(), (String)token.getToken(), (long)token.getExpires()));
        }
        catch (SecurityTokenValidationException e) {
            throw new TokensException(TokensException.Code.ValidationError, e.getMessage());
        }
        catch (AuthException e) {
            throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
        }
        return reply;
    }

    public GetImpersonationTokenResponseType getImpersonationToken(GetImpersonationTokenType request) throws EucalyptusCloudException {
        Account impersonatedAccount;
        User impersonated;
        GetImpersonationTokenResponseType reply = (GetImpersonationTokenResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        TokensService.rejectPasswordCredentials();
        try {
            if (!Strings.isNullOrEmpty((String)request.getImpersonatedUserId())) {
                impersonated = Accounts.lookupUserById((String)request.getImpersonatedUserId());
            } else {
                Account account = Accounts.lookupAccountByName((String)request.getAccountAlias());
                impersonated = account.lookupUserByName(request.getUserName());
            }
            impersonatedAccount = impersonated.getAccount();
        }
        catch (AuthException e) {
            throw new TokensException(TokensException.Code.ValidationError, e.getMessage());
        }
        try {
            if (!ctx.isAdministrator() || !Permissions.isAuthorized((String)"sts", (String)"user", (String)Accounts.getUserFullName((User)impersonated), (Account)impersonatedAccount, (String)"getimpersonationtoken", (AuthContextSupplier)ctx.getAuthContext())) {
                throw new EucalyptusCloudException("Permission denied");
            }
            SecurityToken token = SecurityTokenManager.issueSecurityToken((User)impersonated, (int)(impersonated.isAccountAdmin() ? (int)TimeUnit.DAYS.toSeconds(1L) : 0), (int)((Integer)Objects.firstNonNull((Object)request.getDurationSeconds(), (Object)((int)TimeUnit.HOURS.toSeconds(12L)))));
            reply.setResult(GetImpersonationTokenResultType.forCredentials((String)token.getAccessKeyId(), (String)token.getSecretKey(), (String)token.getToken(), (long)token.getExpires()));
        }
        catch (SecurityTokenValidationException e) {
            throw new TokensException(TokensException.Code.ValidationError, e.getMessage());
        }
        catch (AuthException e) {
            throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
        }
        return reply;
    }

    private static void rejectPasswordCredentials() throws TokensException {
        AccountUsernamePasswordCredentials.AccountUsername accountUsername;
        Context context = Contexts.lookup();
        Subject subject = context.getSubject();
        AccountUsernamePasswordCredentials.AccountUsername accountUsername2 = accountUsername = subject == null ? null : (AccountUsernamePasswordCredentials.AccountUsername)Iterables.getFirst(subject.getPublicCredentials(AccountUsernamePasswordCredentials.AccountUsername.class), null);
        if (accountUsername != null) {
            throw new TokensException(TokensException.Code.MissingAuthenticationToken, "Missing credential.");
        }
    }

    private static String assumedRoleArn(Role role, String roleSessionName) throws AuthException {
        return "arn:aws:sts::" + role.getAccount().getAccountNumber() + ":assumed-role" + Accounts.getRoleFullName((Role)role) + "/" + roleSessionName;
    }

    private static Role lookupRole(String roleArnString) throws TokensException {
        try {
            Ern roleArn = Ern.parse((String)roleArnString);
            if (!(roleArn instanceof EuareResourceName) || !"role".equals(((EuareResourceName)roleArn).getUserOrGroup())) {
                throw new IllegalArgumentException();
            }
            String roleAccountId = roleArn.getNamespace();
            String roleName = ((EuareResourceName)roleArn).getName();
            Account account = "eucalyptus".equals(roleAccountId) ? Accounts.lookupAccountByName((String)"eucalyptus") : Accounts.lookupAccountById((String)roleAccountId);
            return account.lookupRoleByName(roleName);
        }
        catch (Exception e) {
            throw new TokensException(TokensException.Code.InvalidParameterValue, "Invalid role: " + roleArnString);
        }
    }

    private static class RoleResolver
    implements Function<String, Role> {
        private final Role role;

        private RoleResolver(Role role) {
            this.role = role;
        }

        public Role apply(@Nullable String roleFullName) {
            return this.role;
        }
    }
}

