/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.tokens;

import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Parameters;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class TokensException
extends EucalyptusCloudException {
    private static final long serialVersionUID = 1L;
    private final Code code;

    public TokensException(Code code, String message) {
        super(message);
        this.code = (Code)((Object)Parameters.checkParam((String)"code", (Object)((Object)code), (Matcher)Matchers.notNullValue()));
    }

    public HttpResponseStatus getStatus() {
        return this.code.getHttpStatus();
    }

    public String getError() {
        return this.code.name();
    }

    public String getType() {
        return this.code.getType();
    }

    static enum Code {
        InvalidAction,
        InvalidParameterValue,
        MissingAuthenticationToken(HttpResponseStatus.FORBIDDEN, "Sender"),
        ServiceUnavailable(HttpResponseStatus.SERVICE_UNAVAILABLE, "Receiver"),
        ValidationError;

        private final HttpResponseStatus status;
        private final String type;

        private Code() {
            this(HttpResponseStatus.BAD_REQUEST, "Sender");
        }

        private Code(HttpResponseStatus status, String type) {
            this.status = status;
            this.type = type;
        }

        private HttpResponseStatus getHttpStatus() {
            return this.status;
        }

        private String getType() {
            return this.type;
        }
    }
}

