/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudwatch.common;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;

public class CloudWatchResourceName {
    private static final int MIN_PARTS = 7;
    private static final int MAX_PARTS = 7;
    private static final String prefix = "arn:aws:";
    private static final Splitter nameSpliter = Splitter.on((char)':').limit(7);
    private static final int PART_SERVICE = 2;
    private static final int PART_NAMESPACE = 4;
    private static final int PART_RELATIVE_ID_TYPE = 5;
    private static final int PART_RELATIVE_NAME = 6;
    private final String resourceName;
    private final String service;
    private final String namespace;
    private final String type;
    private final String name;

    public CloudWatchResourceName(String resourceName, String service, String namespace, String type, String name) {
        this.resourceName = resourceName;
        this.service = service;
        this.namespace = namespace;
        this.type = type;
        this.name = name;
    }

    public static CloudWatchResourceName parse(String resourceName) throws InvalidResourceNameException {
        return CloudWatchResourceName.parse(resourceName, null);
    }

    public static CloudWatchResourceName parse(String resourceName, @Nullable Type type) throws InvalidResourceNameException {
        if (!resourceName.startsWith(prefix)) {
            throw new InvalidResourceNameException(resourceName);
        }
        Iterable nameParts = nameSpliter.split((CharSequence)resourceName);
        int namePartCount = Iterables.size((Iterable)nameParts);
        if (namePartCount < 7 || namePartCount > 7) {
            throw new InvalidResourceNameException(resourceName);
        }
        if (!"cloudwatch".equals(Iterables.get((Iterable)nameParts, (int)2))) {
            throw new InvalidResourceNameException(resourceName);
        }
        if (type != null && !type.name().equals(Iterables.get((Iterable)nameParts, (int)5))) {
            throw new InvalidResourceNameException(resourceName);
        }
        return new CloudWatchResourceName(resourceName, (String)Iterables.get((Iterable)nameParts, (int)2), (String)Iterables.get((Iterable)nameParts, (int)4), (String)Iterables.get((Iterable)nameParts, (int)5), (String)Iterables.get((Iterable)nameParts, (int)6));
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getService() {
        return this.service;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.resourceName;
    }

    public static Set<String> simpleNames(Iterable<String> namesAndArns) {
        return Sets.newHashSet((Iterable)Iterables.filter(namesAndArns, (Predicate)Predicates.not(CloudWatchResourceName.isResourceName())));
    }

    public static Set<String> arns(Iterable<String> namesAndArns) {
        return Sets.newHashSet((Iterable)Iterables.filter(namesAndArns, CloudWatchResourceName.isResourceName()));
    }

    public static Function<String, Optional<CloudWatchResourceName>> asArnOfType(final Type type) {
        return new Function<String, Optional<CloudWatchResourceName>>(){

            public Optional<CloudWatchResourceName> apply(String value) {
                Optional name = Optional.absent();
                if (CloudWatchResourceName.isResourceName().apply((Object)value)) {
                    try {
                        name = Optional.of((Object)CloudWatchResourceName.parse(value, type));
                    }
                    catch (InvalidResourceNameException invalidResourceNameException) {
                        // empty catch block
                    }
                }
                return name;
            }
        };
    }

    public static Predicate<String> isResourceName() {
        return ResourceNamePredicate.INSTANCE;
    }

    public static Function<CloudWatchResourceName, String> toName() {
        return StringProperties.NAME;
    }

    public static Function<CloudWatchResourceName, String> toNamespace() {
        return StringProperties.NAMESPACE;
    }

    public static final class InvalidResourceNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidResourceNameException(String resourceName) {
            super("Invalid resource name: " + resourceName);
        }
    }

    private static enum ResourceNamePredicate implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String value) {
            return value != null && value.startsWith(CloudWatchResourceName.prefix);
        }
    }

    private static enum StringProperties implements Function<CloudWatchResourceName, String>
    {
        NAME{

            public String apply(@Nullable CloudWatchResourceName input) {
                return input == null ? null : input.getName();
            }
        }
        ,
        NAMESPACE{

            public String apply(@Nullable CloudWatchResourceName input) {
                return input == null ? null : input.getNamespace();
            }
        };

    }

    public static enum Type {
        alarm("alarm");

        private final String description;

        private Type(String description) {
            this.description = description;
        }

        public String describe() {
            return this.description;
        }
    }
}

