/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.ws;

import com.eucalyptus.util.Pair;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.protocol.OperationParameter;
import com.eucalyptus.ws.protocol.RequestLoggingFilter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public class CloudFormationRequestLoggingFilter
implements RequestLoggingFilter {
    private static final Iterable<String> ACTIONS = ImmutableList.of((Object)"CreateStack", (Object)"UpdateStack", (Object)"ValidateTemplate");
    private static final Iterable<String> ACTION_NVPS = FluentIterable.from(Arrays.asList(OperationParameter.values())).transform(Functions.toStringFunction()).transform(Strings.append((String)"=")).transformAndConcat((Function)Pair.explodeRight(ACTIONS)).transform((Function)Pair.transformer((Function)Strings.join()));
    private static final Pattern TEMPLATE_BODY_PARAMETER_REGEX = Pattern.compile("^(TemplateBody)=.*$");
    private static final Pattern PARAMETERS_PARAMETER_REGEX = Pattern.compile("^(Parameters\\.member\\.[0-9]+\\.ParameterValue)=.*$");

    public Collection<String> apply(Collection<String> parametersOrBody) {
        if (Iterables.tryFind(ACTION_NVPS, (Predicate)Predicates.in(parametersOrBody)).isPresent()) {
            Iterable templateBodyNVPs = Iterables.filter(parametersOrBody, (Predicate)Predicates.contains((Pattern)TEMPLATE_BODY_PARAMETER_REGEX));
            Iterable parametersNVPs = Iterables.filter(parametersOrBody, (Predicate)Predicates.contains((Pattern)PARAMETERS_PARAMETER_REGEX));
            if (!Iterables.isEmpty((Iterable)templateBodyNVPs) || !Iterables.isEmpty((Iterable)parametersNVPs)) {
                ArrayList parametersCopy = Lists.newArrayList(parametersOrBody);
                this.redactParameters(parametersCopy, templateBodyNVPs, TEMPLATE_BODY_PARAMETER_REGEX);
                this.redactParameters(parametersCopy, parametersNVPs, PARAMETERS_PARAMETER_REGEX);
                return parametersCopy;
            }
        }
        return parametersOrBody;
    }

    private void redactParameters(ArrayList<String> parameters, Iterable<String> nvps, Pattern pattern) {
        for (String nvp : nvps) {
            parameters.set(parameters.indexOf(nvp), pattern.matcher(nvp).replaceFirst("$1=********"));
        }
    }
}

