/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.ws;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.Logs;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.protocol.BaseQueryBinding;
import com.eucalyptus.ws.protocol.OperationParameter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class CloudFormationQueryBinding
extends BaseQueryBinding<OperationParameter> {
    static final String CLOUDFORMATION_NAMESPACE_PATTERN = "http://cloudformation.amazonaws.com/doc/%s/";
    static final String CLOUDFORMATION_DEFAULT_VERSION = "2010-05-15";
    static final String CLOUDFORMATION_DEFAULT_NAMESPACE = String.format("http://cloudformation.amazonaws.com/doc/%s/", "2010-05-15");
    private static final Logger LOG = Logger.getLogger(CloudFormationQueryBinding.class);

    public CloudFormationQueryBinding() {
        super(CLOUDFORMATION_NAMESPACE_PATTERN, CLOUDFORMATION_DEFAULT_VERSION, (Enum)OperationParameter.Action, (Enum[])new OperationParameter[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        Context context = Contexts.lookup((Channel)ctx.getChannel());
        if (context == null || context.getHttpRequest() == null || context.getHttpRequest().getParameters() == null || !"JSON".equals(context.getHttpRequest().getParameters().get("ContentType"))) {
            super.outgoingMessage(ctx, event);
        } else if (event.getMessage() instanceof MappingHttpResponse) {
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(8192);
            HoldMe.canHas.lock();
            try {
                if (httpResponse.getMessage() != null) {
                    if (httpResponse.getMessage() instanceof EucalyptusErrorMessageType) {
                        EucalyptusErrorMessageType errMsg = (EucalyptusErrorMessageType)httpResponse.getMessage();
                        byteOut.write(Binding.createRestFault((String)errMsg.getSource(), (String)errMsg.getMessage(), (String)errMsg.getCorrelationId()).getBytes());
                        httpResponse.setStatus(HttpResponseStatus.BAD_REQUEST);
                    } else if (httpResponse.getMessage() instanceof ExceptionResponseType) {
                        ExceptionResponseType msg = (ExceptionResponseType)httpResponse.getMessage();
                        String detail = msg.getError();
                        if (msg.getException() != null) {
                            Logs.extreme().debug((Object)msg, msg.getException());
                        }
                        if (msg.getException() instanceof EucalyptusWebServiceException) {
                            detail = msg.getCorrelationId();
                        }
                        String response = Binding.createRestFault((String)msg.getRequestType(), (String)msg.getMessage(), (String)detail);
                        byteOut.write(response.getBytes());
                        httpResponse.setStatus(msg.getHttpStatus());
                    } else {
                        try {
                            ObjectMapper mapper = new ObjectMapper();
                            String className = httpResponse.getMessage().getClass().getName();
                            className = className.substring(className.lastIndexOf(".") + 1);
                            String messageType = className.replace("ResponseType", "Response");
                            byteOut.write("{".getBytes());
                            byteOut.write(("\"" + messageType + "\" : ").getBytes());
                            mapper.writer().without(SerializationFeature.FAIL_ON_EMPTY_BEANS).writeValue((OutputStream)byteOut, httpResponse.getMessage());
                            byteOut.write("}".getBytes());
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e);
                            Logs.exhaust().error((Object)e, (Throwable)e);
                            throw e;
                        }
                    }
                }
                byte[] req = byteOut.toByteArray();
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])req);
                httpResponse.addHeader("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
                httpResponse.addHeader("Content-Type", (Object)"application/json; charset=UTF-8");
                httpResponse.setContent(buffer);
            }
            finally {
                HoldMe.canHas.unlock();
            }
        }
    }
}

