/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.ws;

import com.eucalyptus.cloudformation.CloudFormationErrorResponse;
import com.eucalyptus.cloudformation.Error;
import com.eucalyptus.cloudformation.ws.CloudFormationQueryBinding;
import com.eucalyptus.ws.Role;
import com.eucalyptus.ws.util.ErrorHandlerSupport;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.log4j.Logger;

public class CloudFormationErrorHandler
extends ErrorHandlerSupport {
    private static final Logger LOG = Logger.getLogger(CloudFormationErrorHandler.class);
    private static final String INTERNAL_FAILURE = "InternalFailure";

    public CloudFormationErrorHandler() {
        super(LOG, CloudFormationQueryBinding.CLOUDFORMATION_DEFAULT_NAMESPACE, INTERNAL_FAILURE);
    }

    protected BaseMessage buildErrorResponse(String correlationId, Role role, String code, String message) {
        CloudFormationErrorResponse errorResp = new CloudFormationErrorResponse();
        errorResp.setCorrelationId(correlationId);
        errorResp.setRequestId(correlationId);
        Error error = new Error();
        error.setType(role == Role.Receiver ? "Receiver" : "Sender");
        error.setCode(code);
        error.setMessage(message);
        errorResp.getError().add(error);
        return errorResp;
    }
}

