/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.workflow.steps;

import com.amazonaws.services.simpleworkflow.flow.interceptors.ExponentialRetryPolicy;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import com.eucalyptus.cloudformation.workflow.NotAResourceFailureException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;

public class StandardResourceRetryPolicy {
    private Integer retryExpirationIntervalSeconds;

    public StandardResourceRetryPolicy(Integer retryExpirationIntervalSeconds) {
        this.retryExpirationIntervalSeconds = retryExpirationIntervalSeconds;
    }

    public RetryPolicy getPolicy() {
        ArrayList exceptionList = Lists.newArrayList();
        exceptionList.add(NotAResourceFailureException.class);
        ExponentialRetryPolicy retryPolicy = new ExponentialRetryPolicy(1L).withExceptionsToRetry((Collection)exceptionList);
        if (this.retryExpirationIntervalSeconds != null && this.retryExpirationIntervalSeconds > 0) {
            retryPolicy.setRetryExpirationIntervalSeconds((long)this.retryExpirationIntervalSeconds.intValue());
        }
        retryPolicy.setMaximumRetryIntervalSeconds(30L);
        return retryPolicy;
    }
}

