/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.workflow;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.eucalyptus.cloudformation.CloudFormation;
import com.eucalyptus.cloudformation.bootstrap.CloudFormationAWSCredentialsProvider;
import com.eucalyptus.cloudformation.config.CloudFormationProperties;
import com.eucalyptus.simpleworkflow.common.client.Config;
import com.eucalyptus.simpleworkflow.common.client.WorkflowClient;
import com.google.common.base.Supplier;

public class WorkflowClientManager {
    private static volatile WorkflowClient workflowClient;

    public static synchronized AmazonSimpleWorkflow getSimpleWorkflowClient() {
        return workflowClient.getAmazonSimpleWorkflow();
    }

    public static void start() throws Exception {
        AmazonSimpleWorkflow simpleWorkflowClient;
        if (CloudFormationProperties.USE_AWS_SWF) {
            System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
            BasicAWSCredentials creds = new BasicAWSCredentials(CloudFormationProperties.AWS_ACCESS_KEY, CloudFormationProperties.AWS_SECRET_KEY);
            simpleWorkflowClient = new AmazonSimpleWorkflowClient((AWSCredentials)creds);
            simpleWorkflowClient.setRegion(Region.getRegion((Regions)Regions.US_EAST_1));
        } else {
            simpleWorkflowClient = Config.buildClient((Supplier)CloudFormationAWSCredentialsProvider.CloudFormationUserSupplier.INSTANCE, (String)CloudFormationProperties.SWF_CLIENT_CONFIG);
        }
        workflowClient = new WorkflowClient(CloudFormation.class, simpleWorkflowClient, CloudFormationProperties.SWF_DOMAIN, CloudFormationProperties.SWF_TASKLIST, CloudFormationProperties.SWF_WORKFLOW_WORKER_CONFIG, CloudFormationProperties.SWF_ACTIVITY_WORKER_CONFIG);
        workflowClient.start();
    }

    public static void stop() throws Exception {
        if (workflowClient != null) {
            workflowClient.stop();
        }
    }
}

