/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.workflow;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfo;
import com.eucalyptus.cloudformation.CloudFormation;
import com.eucalyptus.cloudformation.InternalFailureException;
import com.eucalyptus.cloudformation.StackEvent;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.entity.StackEntityHelper;
import com.eucalyptus.cloudformation.entity.StackEntityManager;
import com.eucalyptus.cloudformation.entity.StackEventEntityManager;
import com.eucalyptus.cloudformation.entity.StackResourceEntity;
import com.eucalyptus.cloudformation.entity.StackResourceEntityManager;
import com.eucalyptus.cloudformation.entity.StackWorkflowEntity;
import com.eucalyptus.cloudformation.entity.StackWorkflowEntityManager;
import com.eucalyptus.cloudformation.resources.ResourceAction;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.resources.ResourcePropertyResolver;
import com.eucalyptus.cloudformation.resources.ResourceResolverManager;
import com.eucalyptus.cloudformation.resources.standard.propertytypes.AWSCloudFormationWaitConditionProperties;
import com.eucalyptus.cloudformation.template.FunctionEvaluation;
import com.eucalyptus.cloudformation.template.IntrinsicFunctions;
import com.eucalyptus.cloudformation.template.JsonHelper;
import com.eucalyptus.cloudformation.workflow.ResourceFailureException;
import com.eucalyptus.cloudformation.workflow.StackActivity;
import com.eucalyptus.cloudformation.workflow.StackActivityImpl;
import com.eucalyptus.cloudformation.workflow.ValidationFailedException;
import com.eucalyptus.cloudformation.workflow.WorkflowClientManager;
import com.eucalyptus.component.annotation.ComponentPart;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.glisten.ActivityOperations;
import com.netflix.glisten.impl.swf.SwfActivityOperations;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentPart(value=CloudFormation.class)
public class StackActivityImpl
implements StackActivity,
GroovyObject,
ActivityOperations {
    private ActivityOperations activityOperations;
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166720073;
    private static /* synthetic */ SoftReference $callSiteArray;

    public StackActivityImpl() {
        MetaClass metaClass;
        SwfActivityOperations swfActivityOperations = new SwfActivityOperations();
        this.activityOperations = swfActivityOperations;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String createGlobalStackEvent(String stackId, String accountId, String resourceStatus, String resourceStatusReason) {
        LOG.info((Object)StringGroovyMethods.plus((String)"Creating global stack event: ", (CharSequence)resourceStatus));
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        String stackName = stackEntity.getStackName();
        StackEvent stackEvent = new StackEvent();
        stackEvent.setStackId(stackId);
        stackEvent.setStackName(stackName);
        stackEvent.setLogicalResourceId(stackName);
        stackEvent.setPhysicalResourceId(stackId);
        stackEvent.setEventId(UUID.randomUUID().toString());
        ObjectNode properties = new ObjectMapper().createObjectNode();
        StackEntity.Parameter parameter = null;
        Iterator<StackEntity.Parameter> iterator = StackEntityHelper.jsonToParameters(stackEntity.getParametersJson()).iterator();
        while (iterator.hasNext()) {
            parameter = (StackEntity.Parameter)ScriptBytecodeAdapter.castToType((Object)iterator.next(), StackEntity.Parameter.class);
            properties.put(parameter.getKey(), parameter.getStringValue());
        }
        stackEvent.setResourceProperties(JsonHelper.getStringFromJsonNode((JsonNode)properties));
        stackEvent.setResourceType("AWS::CloudFormation::Stack");
        stackEvent.setResourceStatus(resourceStatus);
        stackEvent.setResourceStatusReason(resourceStatusReason);
        stackEvent.setTimestamp(new Date());
        StackEventEntityManager.addStackEvent(stackEvent, accountId);
        StackEntity.Status status = StackEntity.Status.valueOf(resourceStatus);
        stackEntity.setStackStatus(status);
        stackEntity.setStackStatusReason(resourceStatusReason);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)status), (Object)((Object)StackEntity.Status.DELETE_IN_PROGRESS)) && stackEntity.getDeleteOperationTimestamp() == null) {
            stackEntity.setDeleteOperationTimestamp(new Date());
        }
        StackEntityManager.updateStack(stackEntity);
        LOG.info((Object)StringGroovyMethods.plus((String)"Done creating global stack event: ", (CharSequence)resourceStatus));
        return "";
    }

    @Override
    public String initCreateResource(String resourceId, String stackId, String accountId, String effectiveUserId, String reverseDependentResourcesJson) {
        StackResourceEntity stackResourceEntity;
        LOG.debug((Object)StringGroovyMethods.plus((String)"Creating resource ", (CharSequence)resourceId));
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        StackResourceEntity stackResourceEntity2 = StackResourceEntityManager.getStackResource(stackId, accountId, resourceId);
        ArrayList reverseDependentResourceIds = reverseDependentResourcesJson == null ? new ArrayList() : (ArrayList)ScriptBytecodeAdapter.castToType((Object)new ObjectMapper().readValue(reverseDependentResourcesJson, (TypeReference)new GroovyObject(this){
            public /* synthetic */ StackActivityImpl this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                StackActivityImpl stackActivityImpl;
                this.this$0 = stackActivityImpl = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$2(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectField((Object)object, 1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
            }

            public /* synthetic */ Object this$dist$get$2(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectField(1.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                1.__$swapInit();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ Type super$2$getType() {
                return super.getType();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ int super$2$compareTo(TypeReference typeReference) {
                return super.compareTo(typeReference);
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), ArrayList.class);
        LinkedHashMap resourceInfoMap = Maps.newLinkedHashMap();
        String reverseDependentResourceId = null;
        Iterator iterator = reverseDependentResourceIds.iterator();
        while (iterator.hasNext()) {
            reverseDependentResourceId = (String)ScriptBytecodeAdapter.castToType(iterator.next(), String.class);
            resourceInfoMap.put(reverseDependentResourceId, StackResourceEntityManager.getResourceInfo(stackId, accountId, reverseDependentResourceId));
        }
        ObjectNode returnNode = new ObjectMapper().createObjectNode();
        returnNode.put("resourceId", resourceId);
        String stackName = stackEntity.getStackName();
        ResourceInfo resourceInfo = StackResourceEntityManager.getResourceInfo(stackResourceEntity2);
        if (!DefaultTypeTransformation.booleanUnbox((Object)resourceInfo.getAllowedByCondition())) {
            LOG.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Resource ", (CharSequence)resourceId), (CharSequence)" not allowed by condition, skipping"));
            return "SKIP";
        }
        if (resourceInfo.getPropertiesJson() != null) {
            JsonNode propertiesJsonNode = JsonHelper.getJsonNodeFromString(resourceInfo.getPropertiesJson());
            ArrayList propertyKeys = Lists.newArrayList((Iterator)propertiesJsonNode.fieldNames());
            String propertyKey = null;
            Iterator iterator2 = propertyKeys.iterator();
            while (iterator2.hasNext()) {
                propertyKey = (String)ScriptBytecodeAdapter.castToType(iterator2.next(), String.class);
                JsonNode evaluatedPropertyNode = FunctionEvaluation.evaluateFunctions(propertiesJsonNode.get(propertyKey), stackEntity, resourceInfoMap);
                if (IntrinsicFunctions.NO_VALUE.evaluateMatch(evaluatedPropertyNode).isMatch()) {
                    ((ObjectNode)ScriptBytecodeAdapter.castToType((Object)propertiesJsonNode, ObjectNode.class)).remove(propertyKey);
                    continue;
                }
                ((ObjectNode)ScriptBytecodeAdapter.castToType((Object)propertiesJsonNode, ObjectNode.class)).put(propertyKey, evaluatedPropertyNode);
            }
            resourceInfo.setPropertiesJson(JsonHelper.getStringFromJsonNode(propertiesJsonNode));
        }
        if (resourceInfo.getMetadataJson() != null) {
            JsonNode metadataJsonNode = JsonHelper.getJsonNodeFromString(resourceInfo.getMetadataJson());
            ArrayList metadataKeys = Lists.newArrayList((Iterator)metadataJsonNode.fieldNames());
            String metadataKey = null;
            Iterator iterator3 = metadataKeys.iterator();
            while (iterator3.hasNext()) {
                metadataKey = (String)ScriptBytecodeAdapter.castToType(iterator3.next(), String.class);
                JsonNode evaluatedMetadataNode = FunctionEvaluation.evaluateFunctions(metadataJsonNode.get(metadataKey), stackEntity, resourceInfoMap);
                if (IntrinsicFunctions.NO_VALUE.evaluateMatch(evaluatedMetadataNode).isMatch()) {
                    ((ObjectNode)ScriptBytecodeAdapter.castToType((Object)metadataJsonNode, ObjectNode.class)).remove(metadataKey);
                    continue;
                }
                ((ObjectNode)ScriptBytecodeAdapter.castToType((Object)metadataJsonNode, ObjectNode.class)).put(metadataKey, evaluatedMetadataNode);
            }
            resourceInfo.setMetadataJson(JsonHelper.getStringFromJsonNode(metadataJsonNode));
        }
        if (resourceInfo.getUpdatePolicyJson() != null) {
            JsonNode updatePolicyJsonNode = JsonHelper.getJsonNodeFromString(resourceInfo.getUpdatePolicyJson());
            ArrayList updatePolicyKeys = Lists.newArrayList((Iterator)updatePolicyJsonNode.fieldNames());
            String updatePolicyKey = null;
            Iterator iterator4 = updatePolicyKeys.iterator();
            while (iterator4.hasNext()) {
                updatePolicyKey = (String)ScriptBytecodeAdapter.castToType(iterator4.next(), String.class);
                JsonNode evaluatedUpdatePolicyNode = FunctionEvaluation.evaluateFunctions(updatePolicyJsonNode.get(updatePolicyKey), stackEntity, resourceInfoMap);
                if (IntrinsicFunctions.NO_VALUE.evaluateMatch(evaluatedUpdatePolicyNode).isMatch()) {
                    ((ObjectNode)ScriptBytecodeAdapter.castToType((Object)updatePolicyJsonNode, ObjectNode.class)).remove(updatePolicyKey);
                    continue;
                }
                ((ObjectNode)ScriptBytecodeAdapter.castToType((Object)updatePolicyJsonNode, ObjectNode.class)).put(updatePolicyKey, evaluatedUpdatePolicyNode);
            }
            resourceInfo.setUpdatePolicyJson(JsonHelper.getStringFromJsonNode(updatePolicyJsonNode));
        }
        ResourceAction resourceAction = new ResourceResolverManager().resolveResourceAction(resourceInfo.getType());
        resourceAction.setStackEntity(stackEntity);
        resourceInfo.setEffectiveUserId(effectiveUserId);
        resourceAction.setResourceInfo(resourceInfo);
        StackEvent stackEvent = new StackEvent();
        stackEvent.setStackId(stackId);
        stackEvent.setStackName(stackName);
        stackEvent.setLogicalResourceId(resourceInfo.getLogicalResourceId());
        stackEvent.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
        stackEvent.setEventId(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)resourceInfo.getLogicalResourceId(), (CharSequence)"-"), (CharSequence)StackResourceEntity.Status.CREATE_IN_PROGRESS.toString()), (CharSequence)"-"), (Object)System.currentTimeMillis()));
        stackEvent.setResourceProperties(resourceInfo.getPropertiesJson());
        stackEvent.setResourceType(resourceInfo.getType());
        stackEvent.setResourceStatus(StackResourceEntity.Status.CREATE_IN_PROGRESS.toString());
        stackEvent.setResourceStatusReason(null);
        stackEvent.setTimestamp(new Date());
        StackEventEntityManager.addStackEvent(stackEvent, accountId);
        stackResourceEntity2.setResourceStatus(StackResourceEntity.Status.CREATE_IN_PROGRESS);
        stackResourceEntity2.setResourceStatusReason(null);
        stackResourceEntity2.setDescription("");
        stackResourceEntity2 = stackResourceEntity = StackResourceEntityManager.updateResourceInfo(stackResourceEntity2, resourceInfo);
        StackResourceEntityManager.updateStackResource(stackResourceEntity2);
        return "";
    }

    @Override
    public String getResourceType(String stackId, String accountId, String resourceId) {
        return StackResourceEntityManager.getStackResource(stackId, accountId, resourceId).getResourceType();
    }

    @Override
    public String initDeleteResource(String resourceId, String stackId, String accountId, String effectiveUserId) {
        LOG.info((Object)StringGroovyMethods.plus((String)"Deleting resource ", (CharSequence)resourceId));
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        String stackName = stackEntity.getStackName();
        StackResourceEntity stackResourceEntity = StackResourceEntityManager.getStackResource(stackId, accountId, resourceId);
        ResourceInfo resourceInfo = StackResourceEntityManager.getResourceInfo(stackResourceEntity);
        resourceInfo.setEffectiveUserId(effectiveUserId);
        if (stackResourceEntity != null && ScriptBytecodeAdapter.compareNotEqual((Object)((Object)stackResourceEntity.getResourceStatus()), (Object)((Object)StackResourceEntity.Status.DELETE_COMPLETE)) && ScriptBytecodeAdapter.compareNotEqual((Object)((Object)stackResourceEntity.getResourceStatus()), (Object)((Object)StackResourceEntity.Status.NOT_STARTED))) {
            StackResourceEntity stackResourceEntity2;
            ResourceAction resourceAction = new ResourceResolverManager().resolveResourceAction(resourceInfo.getType());
            resourceAction.setStackEntity(stackEntity);
            resourceAction.setResourceInfo(resourceInfo);
            if ("Retain".equals(resourceInfo.getDeletionPolicy())) {
                StackResourceEntity stackResourceEntity3;
                LOG.info((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Resource ", (CharSequence)resourceId), (CharSequence)" has a 'Retain' DeletionPolicy, skipping."));
                StackEvent stackEvent = new StackEvent();
                stackEvent.setStackId(stackId);
                stackEvent.setStackName(stackName);
                stackEvent.setLogicalResourceId(resourceInfo.getLogicalResourceId());
                stackEvent.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
                stackEvent.setEventId(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)resourceInfo.getLogicalResourceId(), (CharSequence)"-"), (CharSequence)StackResourceEntity.Status.DELETE_SKIPPED.toString()), (CharSequence)"-"), (Object)System.currentTimeMillis()));
                stackEvent.setResourceProperties(resourceInfo.getPropertiesJson());
                stackEvent.setResourceType(resourceInfo.getType());
                stackEvent.setResourceStatus(StackResourceEntity.Status.DELETE_SKIPPED.toString());
                stackEvent.setResourceStatusReason(null);
                stackEvent.setTimestamp(new Date());
                StackEventEntityManager.addStackEvent(stackEvent, accountId);
                stackResourceEntity = stackResourceEntity3 = StackResourceEntityManager.updateResourceInfo(stackResourceEntity, resourceInfo);
                stackResourceEntity.setResourceStatus(StackResourceEntity.Status.DELETE_SKIPPED);
                stackResourceEntity.setResourceStatusReason(null);
                StackResourceEntityManager.updateStackResource(stackResourceEntity);
                return "SKIP";
            }
            StackEvent stackEvent = new StackEvent();
            stackEvent.setStackId(stackId);
            stackEvent.setStackName(stackName);
            stackEvent.setLogicalResourceId(resourceInfo.getLogicalResourceId());
            stackEvent.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
            stackEvent.setEventId(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)resourceInfo.getLogicalResourceId(), (CharSequence)"-"), (CharSequence)StackResourceEntity.Status.DELETE_IN_PROGRESS.toString()), (CharSequence)"-"), (Object)System.currentTimeMillis()));
            stackEvent.setResourceProperties(resourceInfo.getPropertiesJson());
            stackEvent.setResourceType(resourceInfo.getType());
            stackEvent.setResourceStatus(StackResourceEntity.Status.DELETE_IN_PROGRESS.toString());
            stackEvent.setResourceStatusReason(null);
            stackEvent.setTimestamp(new Date());
            StackEventEntityManager.addStackEvent(stackEvent, accountId);
            stackResourceEntity = stackResourceEntity2 = StackResourceEntityManager.updateResourceInfo(stackResourceEntity, resourceInfo);
            stackResourceEntity.setResourceStatus(StackResourceEntity.Status.DELETE_IN_PROGRESS);
            stackResourceEntity.setResourceStatusReason(null);
            StackResourceEntityManager.updateStackResource(stackResourceEntity);
            return "";
        }
        return "SKIP";
    }

    @Override
    public String determineCreateResourceFailures(String stackId, String accountId) {
        ArrayList failedResources = Lists.newArrayList();
        ArrayList cancelledResources = Lists.newArrayList();
        StackResourceEntity stackResourceEntity = null;
        Iterator<StackResourceEntity> iterator = StackResourceEntityManager.getStackResources(stackId, accountId).iterator();
        while (iterator.hasNext()) {
            stackResourceEntity = (StackResourceEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)iterator.next()), StackResourceEntity.class));
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)stackResourceEntity.getResourceStatus()), (Object)((Object)StackResourceEntity.Status.CREATE_FAILED))) {
                failedResources.add(stackResourceEntity.getLogicalResourceId());
                continue;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)stackResourceEntity.getResourceStatus()), (Object)((Object)StackResourceEntity.Status.CREATE_IN_PROGRESS))) continue;
            cancelledResources.add(stackResourceEntity);
            failedResources.add(stackResourceEntity.getLogicalResourceId());
        }
        StackResourceEntity stackResourceEntity2 = null;
        Iterator iterator2 = cancelledResources.iterator();
        while (iterator2.hasNext()) {
            stackResourceEntity2 = (StackResourceEntity)((Object)ScriptBytecodeAdapter.castToType(iterator2.next(), StackResourceEntity.class));
            stackResourceEntity2.setResourceStatus(StackResourceEntity.Status.CREATE_FAILED);
            stackResourceEntity2.setResourceStatusReason("Resource creation cancelled");
            StackResourceEntityManager.updateStackResource(stackResourceEntity2);
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"The following resource(s) failed to create: ", (Object)failedResources), (CharSequence)".");
    }

    @Override
    public String determineDeleteResourceFailures(String stackId, String accountId) {
        ArrayList failedResources = Lists.newArrayList();
        ArrayList cancelledResources = Lists.newArrayList();
        StackResourceEntity stackResourceEntity = null;
        Iterator<StackResourceEntity> iterator = StackResourceEntityManager.getStackResources(stackId, accountId).iterator();
        while (iterator.hasNext()) {
            stackResourceEntity = (StackResourceEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)iterator.next()), StackResourceEntity.class));
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)stackResourceEntity.getResourceStatus()), (Object)((Object)StackResourceEntity.Status.DELETE_FAILED))) {
                failedResources.add(stackResourceEntity.getLogicalResourceId());
                continue;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)stackResourceEntity.getResourceStatus()), (Object)((Object)StackResourceEntity.Status.DELETE_IN_PROGRESS))) continue;
            cancelledResources.add(stackResourceEntity);
            failedResources.add(stackResourceEntity.getLogicalResourceId());
        }
        StackResourceEntity stackResourceEntity2 = null;
        Iterator iterator2 = cancelledResources.iterator();
        while (iterator2.hasNext()) {
            stackResourceEntity2 = (StackResourceEntity)((Object)ScriptBytecodeAdapter.castToType(iterator2.next(), StackResourceEntity.class));
            stackResourceEntity2.setResourceStatus(StackResourceEntity.Status.DELETE_FAILED);
            stackResourceEntity2.setResourceStatusReason("Resource deletion cancelled");
            StackResourceEntityManager.updateStackResource(stackResourceEntity2);
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"The following resource(s) failed to delete: ", (Object)failedResources), (CharSequence)".");
    }

    @Override
    public String finalizeCreateStack(String stackId, String accountId) {
        LOG.info((Object)"Finalizing create stack");
        try {
            StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
            LinkedHashMap resourceInfoMap = Maps.newLinkedHashMap();
            StackResourceEntity stackResourceEntity = null;
            Iterator<StackResourceEntity> iterator = StackResourceEntityManager.getStackResources(stackId, accountId).iterator();
            while (iterator.hasNext()) {
                stackResourceEntity = (StackResourceEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)iterator.next()), StackResourceEntity.class));
                resourceInfoMap.put(stackResourceEntity.getLogicalResourceId(), StackResourceEntityManager.getResourceInfo(stackResourceEntity));
            }
            ArrayList<StackEntity.Output> outputs = StackEntityHelper.jsonToOutputs(stackEntity.getOutputsJson());
            StackEntity.Output output = null;
            Iterator<StackEntity.Output> iterator2 = outputs.iterator();
            while (iterator2.hasNext()) {
                output = (StackEntity.Output)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), StackEntity.Output.class);
                output.setReady(true);
                output.setReady(true);
                JsonNode outputValue = FunctionEvaluation.evaluateFunctions(JsonHelper.getJsonNodeFromString(output.getJsonValue()), stackEntity, resourceInfoMap);
                if (outputValue == null || !outputValue.isValueNode()) {
                    throw (Throwable)((Object)new ValidationErrorException("Cannot create outputs: All outputs must be strings."));
                }
                output.setStringValue(outputValue.asText());
                output.setJsonValue(JsonHelper.getStringFromJsonNode(outputValue));
            }
            stackEntity.setOutputsJson(StackEntityHelper.outputsToJson(outputs));
            stackEntity.setStackStatus(StackEntity.Status.CREATE_COMPLETE);
            StackEntityManager.updateStack(stackEntity);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw (Throwable)e;
        }
        LOG.info((Object)"Done finalizing create stack");
        return "";
    }

    /*
     * Exception decompiling
     */
    @Override
    public Boolean performCreateStep(String stepId, String resourceId, String stackId, String accountId, String effectiveUserId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Boolean performDeleteStep(String stepId, String resourceId, String stackId, String accountId, String effectiveUserId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String finalizeCreateResource(String resourceId, String stackId, String accountId, String effectiveUserId) {
        StackResourceEntity stackResourceEntity;
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        StackResourceEntity stackResourceEntity2 = StackResourceEntityManager.getStackResource(stackId, accountId, resourceId);
        ResourceInfo resourceInfo = StackResourceEntityManager.getResourceInfo(stackResourceEntity2);
        ResourceAction resourceAction = new ResourceResolverManager().resolveResourceAction(resourceInfo.getType());
        ResourcePropertyResolver.populateResourceProperties(resourceAction.getResourceProperties(), JsonHelper.getJsonNodeFromString(resourceInfo.getPropertiesJson()));
        resourceAction.setStackEntity(stackEntity);
        resourceInfo.setEffectiveUserId(effectiveUserId);
        resourceAction.setResourceInfo(resourceInfo);
        resourceInfo.setReady(Boolean.TRUE);
        stackResourceEntity2 = stackResourceEntity = StackResourceEntityManager.updateResourceInfo(stackResourceEntity2, resourceInfo);
        stackResourceEntity2.setResourceStatus(StackResourceEntity.Status.CREATE_COMPLETE);
        stackResourceEntity2.setResourceStatusReason("");
        StackResourceEntityManager.updateStackResource(stackResourceEntity2);
        StackEvent stackEvent = new StackEvent();
        stackEvent.setStackId(stackId);
        stackEvent.setStackName(resourceAction.getStackEntity().getStackName());
        stackEvent.setLogicalResourceId(resourceInfo.getLogicalResourceId());
        stackEvent.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
        stackEvent.setEventId(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)resourceInfo.getLogicalResourceId(), (CharSequence)"-"), (CharSequence)StackResourceEntity.Status.CREATE_COMPLETE.toString()), (CharSequence)"-"), (Object)System.currentTimeMillis()));
        stackEvent.setResourceProperties(resourceInfo.getPropertiesJson());
        stackEvent.setResourceType(resourceInfo.getType());
        stackEvent.setResourceStatus(StackResourceEntity.Status.CREATE_COMPLETE.toString());
        stackEvent.setResourceStatusReason("");
        stackEvent.setTimestamp(new Date());
        StackEventEntityManager.addStackEvent(stackEvent, accountId);
        LOG.debug((Object)StringGroovyMethods.plus((String)"Finished creating resource ", (CharSequence)resourceId));
        return "";
    }

    @Override
    public String finalizeDeleteResource(String resourceId, String stackId, String accountId, String effectiveUserId) {
        StackResourceEntity stackResourceEntity;
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        StackResourceEntity stackResourceEntity2 = StackResourceEntityManager.getStackResource(stackId, accountId, resourceId);
        ResourceInfo resourceInfo = StackResourceEntityManager.getResourceInfo(stackResourceEntity2);
        resourceInfo.setEffectiveUserId(effectiveUserId);
        stackResourceEntity2 = stackResourceEntity = StackResourceEntityManager.updateResourceInfo(stackResourceEntity2, resourceInfo);
        stackResourceEntity2.setResourceStatus(StackResourceEntity.Status.DELETE_COMPLETE);
        stackResourceEntity2.setResourceStatusReason("");
        StackResourceEntityManager.updateStackResource(stackResourceEntity2);
        StackEvent stackEvent = new StackEvent();
        stackEvent.setStackId(stackId);
        stackEvent.setStackName(stackEntity.getStackName());
        stackEvent.setLogicalResourceId(resourceInfo.getLogicalResourceId());
        stackEvent.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
        stackEvent.setEventId(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)resourceInfo.getLogicalResourceId(), (CharSequence)"-"), (CharSequence)StackResourceEntity.Status.DELETE_COMPLETE.toString()), (CharSequence)"-"), (Object)System.currentTimeMillis()));
        stackEvent.setResourceProperties(resourceInfo.getPropertiesJson());
        stackEvent.setResourceType(resourceInfo.getType());
        stackEvent.setResourceStatus(StackResourceEntity.Status.DELETE_COMPLETE.toString());
        stackEvent.setResourceStatusReason("");
        stackEvent.setTimestamp(new Date());
        StackEventEntityManager.addStackEvent(stackEvent, accountId);
        LOG.debug((Object)StringGroovyMethods.plus((String)"Finished deleting resource ", (CharSequence)resourceId));
        return "SUCCESS";
    }

    @Override
    public String failDeleteResource(String resourceId, String stackId, String accountId, String effectiveUserId, String errorMessage) {
        StackResourceEntity stackResourceEntity;
        LOG.info((Object)StringGroovyMethods.plus((String)"Error deleting resource ", (CharSequence)resourceId));
        LOG.error((Object)errorMessage);
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        StackResourceEntity stackResourceEntity2 = StackResourceEntityManager.getStackResource(stackId, accountId, resourceId);
        ResourceInfo resourceInfo = StackResourceEntityManager.getResourceInfo(stackResourceEntity2);
        resourceInfo.setEffectiveUserId(effectiveUserId);
        stackResourceEntity2 = stackResourceEntity = StackResourceEntityManager.updateResourceInfo(stackResourceEntity2, resourceInfo);
        stackResourceEntity2.setResourceStatus(StackResourceEntity.Status.DELETE_FAILED);
        stackResourceEntity2.setResourceStatusReason(errorMessage);
        StackResourceEntityManager.updateStackResource(stackResourceEntity2);
        StackEvent stackEvent = new StackEvent();
        stackEvent.setStackId(stackId);
        stackEvent.setStackName(stackEntity.getStackName());
        stackEvent.setLogicalResourceId(resourceInfo.getLogicalResourceId());
        stackEvent.setPhysicalResourceId(resourceInfo.getPhysicalResourceId());
        stackEvent.setEventId(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)resourceInfo.getLogicalResourceId(), (CharSequence)"-"), (CharSequence)StackResourceEntity.Status.DELETE_FAILED.toString()), (CharSequence)"-"), (Object)System.currentTimeMillis()));
        stackEvent.setResourceProperties(resourceInfo.getPropertiesJson());
        stackEvent.setResourceType(resourceInfo.getType());
        stackEvent.setResourceStatus(StackResourceEntity.Status.DELETE_FAILED.toString());
        stackEvent.setResourceStatusReason(errorMessage);
        stackEvent.setTimestamp(new Date());
        StackEventEntityManager.addStackEvent(stackEvent, accountId);
        return "FAILURE";
    }

    @Override
    public String deleteAllStackRecords(String stackId, String accountId) {
        LOG.info((Object)"Deleting all stack records");
        StackResourceEntityManager.deleteStackResources(stackId, accountId);
        StackEventEntityManager.deleteStackEvents(stackId, accountId);
        StackEntityManager.deleteStack(stackId, accountId);
        LOG.info((Object)"Finished deleting all stack records");
        return "";
    }

    @Override
    public String getWorkflowExecutionCloseStatus(String stackId) {
        Reference simpleWorkflowClient = new Reference((Object)WorkflowClientManager.getSimpleWorkflowClient());
        List<StackWorkflowEntity> createStackWorkflowEntities = StackWorkflowEntityManager.getStackWorkflowEntities(stackId, StackWorkflowEntity.WorkflowType.CREATE_STACK_WORKFLOW);
        if (createStackWorkflowEntities == null || createStackWorkflowEntities.isEmpty()) {
            throw (Throwable)((Object)new InternalFailureException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{stackId}, new String[]{"There is no create stack workflow for stack id ", ""}), String.class)));
        }
        if (createStackWorkflowEntities.size() > 1) {
            throw (Throwable)((Object)new InternalFailureException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{stackId}, new String[]{"More than one create stack workflow was found for stack id ", ""}), String.class)));
        }
        return (String)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)((Object)createStackWorkflowEntities.get(0)), (Closure)new GeneratedClosure(this, this, simpleWorkflowClient){
            private /* synthetic */ Reference simpleWorkflowClient;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.simpleWorkflowClient = reference = simpleWorkflowClient;
            }

            public Object doCall(Object it) {
                AmazonSimpleWorkflow amazonSimpleWorkflow = (AmazonSimpleWorkflow)this.simpleWorkflowClient.get();
                DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest = new DescribeWorkflowExecutionRequest();
                describeWorkflowExecutionRequest.setDomain((String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("domain"), String.class));
                WorkflowExecution workflowExecution = new WorkflowExecution();
                workflowExecution.setRunId((String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("runId"), String.class));
                workflowExecution.setWorkflowId((String)ScriptBytecodeAdapter.castToType((Object)this.getProperty("workflowId"), String.class));
                describeWorkflowExecutionRequest.setExecution(workflowExecution);
                return DefaultGroovyMethods.with((Object)amazonSimpleWorkflow.describeWorkflowExecution(describeWorkflowExecutionRequest), (Closure)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public Object doCall(Object it) {
                        return ((WorkflowExecutionInfo)this.getProperty("executionInfo")).getCloseStatus();
                    }

                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getWorkflowExecutionCloseStatus_closure1_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                    }

                    static {
                        _getWorkflowExecutionCloseStatus_closure1_closure2.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_getWorkflowExecutionCloseStatus_closure1_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _getWorkflowExecutionCloseStatus_closure1_closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }

            public AmazonSimpleWorkflow getSimpleWorkflowClient() {
                return (AmazonSimpleWorkflow)ScriptBytecodeAdapter.castToType((Object)this.simpleWorkflowClient.get(), AmazonSimpleWorkflow.class);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getWorkflowExecutionCloseStatus_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _getWorkflowExecutionCloseStatus_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getWorkflowExecutionCloseStatus_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getWorkflowExecutionCloseStatus_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), String.class);
    }

    @Override
    public String getStackStatus(String stackId, String accountId) {
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        if (stackEntity == null) {
            throw (Throwable)((Object)new ValidationErrorException(StringGroovyMethods.plus((String)"No stack found with id ", (CharSequence)stackId)));
        }
        return stackEntity.getStackStatus().toString();
    }

    @Override
    public String setStackStatus(String stackId, String accountId, String status, String statusReason) {
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        if (stackEntity == null) {
            throw (Throwable)((Object)new ValidationErrorException(StringGroovyMethods.plus((String)"No stack found with id ", (CharSequence)stackId)));
        }
        stackEntity.setStackStatus(StackEntity.Status.valueOf(status));
        stackEntity.setStackStatusReason(statusReason);
        StackEntityManager.updateStack(stackEntity);
        return "";
    }

    @Override
    public String cancelCreateAndMonitorWorkflows(String stackId) {
        AmazonSimpleWorkflow simpleWorkflowClient = WorkflowClientManager.getSimpleWorkflowClient();
        this.cancelOpenWorkflows(simpleWorkflowClient, StackWorkflowEntityManager.getStackWorkflowEntities(stackId, StackWorkflowEntity.WorkflowType.MONITOR_CREATE_STACK_WORKFLOW));
        this.cancelOpenWorkflows(simpleWorkflowClient, StackWorkflowEntityManager.getStackWorkflowEntities(stackId, StackWorkflowEntity.WorkflowType.CREATE_STACK_WORKFLOW));
        return "";
    }

    private boolean isWorkflowOpen(AmazonSimpleWorkflow simpleWorkflowClient, StackWorkflowEntity stackWorkflowEntity) {
        boolean isOpen = false;
        try {
            DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest = new DescribeWorkflowExecutionRequest();
            describeWorkflowExecutionRequest.setDomain(stackWorkflowEntity.getDomain());
            WorkflowExecution execution = new WorkflowExecution();
            execution.setRunId(stackWorkflowEntity.getRunId());
            execution.setWorkflowId(stackWorkflowEntity.getWorkflowId());
            describeWorkflowExecutionRequest.setExecution(execution);
            WorkflowExecutionDetail workflowExecutionDetail = simpleWorkflowClient.describeWorkflowExecution(describeWorkflowExecutionRequest);
            if ("OPEN".equals(workflowExecutionDetail.getExecutionInfo().getExecutionStatus())) {
                boolean bl;
                isOpen = bl = true;
            }
        }
        catch (Exception ex) {
        }
        return isOpen;
    }

    private void cancelOpenWorkflows(AmazonSimpleWorkflow simpleWorkflowClient, List<StackWorkflowEntity> workflows) {
        if (workflows != null) {
            StackWorkflowEntity workflow = null;
            Iterator<StackWorkflowEntity> iterator = workflows.iterator();
            while (iterator.hasNext()) {
                workflow = (StackWorkflowEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)iterator.next()), StackWorkflowEntity.class));
                if (!this.isWorkflowOpen(simpleWorkflowClient, workflow)) continue;
                RequestCancelWorkflowExecutionRequest requestCancelWorkflowRequest = new RequestCancelWorkflowExecutionRequest();
                requestCancelWorkflowRequest.setDomain(workflow.getDomain());
                requestCancelWorkflowRequest.setWorkflowId(workflow.getWorkflowId());
                requestCancelWorkflowRequest.setRunId(workflow.getRunId());
                simpleWorkflowClient.requestCancelWorkflowExecution(requestCancelWorkflowRequest);
            }
        }
    }

    @Override
    public String verifyCreateAndMonitorWorkflowsClosed(String stackId) {
        AmazonSimpleWorkflow simpleWorkflowClient = WorkflowClientManager.getSimpleWorkflowClient();
        List<StackWorkflowEntity> monitorWorkflows = StackWorkflowEntityManager.getStackWorkflowEntities(stackId, StackWorkflowEntity.WorkflowType.MONITOR_CREATE_STACK_WORKFLOW);
        if (monitorWorkflows != null) {
            StackWorkflowEntity workflow = null;
            Iterator<StackWorkflowEntity> iterator = monitorWorkflows.iterator();
            while (iterator.hasNext()) {
                workflow = (StackWorkflowEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)iterator.next()), StackWorkflowEntity.class));
                if (!this.isWorkflowOpen(simpleWorkflowClient, workflow)) continue;
                throw (Throwable)new ValidationFailedException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"A monitoring workflow for ", (CharSequence)stackId), (CharSequence)" has not yet been canceled"));
            }
        }
        List<StackWorkflowEntity> createWorkflows = StackWorkflowEntityManager.getStackWorkflowEntities(stackId, StackWorkflowEntity.WorkflowType.CREATE_STACK_WORKFLOW);
        if (createWorkflows != null) {
            StackWorkflowEntity workflow = null;
            Iterator<StackWorkflowEntity> iterator = createWorkflows.iterator();
            while (iterator.hasNext()) {
                workflow = (StackWorkflowEntity)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)iterator.next()), StackWorkflowEntity.class));
                if (!this.isWorkflowOpen(simpleWorkflowClient, workflow)) continue;
                throw (Throwable)new ValidationFailedException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"A create workflow for ", (CharSequence)stackId), (CharSequence)" has not yet been canceled"));
            }
        }
        return "";
    }

    @Override
    public Integer getAWSCloudFormationWaitConditionTimeout(String resourceId, String stackId, String accountId, String effectiveUserId) {
        StackEntity stackEntity = StackEntityManager.getNonDeletedStackById(stackId, accountId);
        StackResourceEntity stackResourceEntity = StackResourceEntityManager.getStackResource(stackId, accountId, resourceId);
        ResourceInfo resourceInfo = StackResourceEntityManager.getResourceInfo(stackResourceEntity);
        ResourceAction resourceAction = new ResourceResolverManager().resolveResourceAction(resourceInfo.getType());
        resourceAction.setStackEntity(stackEntity);
        resourceInfo.setEffectiveUserId(effectiveUserId);
        resourceAction.setResourceInfo(resourceInfo);
        ResourcePropertyResolver.populateResourceProperties(resourceAction.getResourceProperties(), JsonHelper.getJsonNodeFromString(resourceInfo.getPropertiesJson()));
        Integer timeout = ((AWSCloudFormationWaitConditionProperties)ScriptBytecodeAdapter.castToType((Object)resourceAction.getResourceProperties(), AWSCloudFormationWaitConditionProperties.class)).getTimeout();
        Integer n = timeout;
        try {
            return n;
        }
        catch (Exception ex) {
            Throwable rootCause = Throwables.getRootCause((Throwable)ex);
            LOG.debug((Object)StringGroovyMethods.plus((String)"Error getting timeout for resource ", (CharSequence)resourceId));
            LOG.error((Object)ex, (Throwable)ex);
            throw (Throwable)new ResourceFailureException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)rootCause.getClass().getName(), (CharSequence)":"), (CharSequence)rootCause.getMessage()));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StackActivityImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.activityOperations.getWorkflowExecution();
    }

    public void recordHeartbeat(String param0) {
        this.activityOperations.recordHeartbeat(param0);
    }

    public String getTaskToken() {
        return this.activityOperations.getTaskToken();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StackActivityImpl.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, StackActivityImpl.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(StackActivityImpl.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        Logger logger;
        long l;
        long l2;
        StackActivityImpl.__$swapInit();
        __timeStamp__239_neverHappen1453166720073 = l2 = 0L;
        __timeStamp = l = 1453166720073L;
        LOG = logger = Logger.getLogger(StackActivityImpl.class);
    }

    public ActivityOperations getActivityOperations() {
        return this.activityOperations;
    }

    public void setActivityOperations(ActivityOperations activityOperations) {
        this.activityOperations = activityOperations;
    }

    public /* synthetic */ boolean this$2$isWorkflowOpen(AmazonSimpleWorkflow amazonSimpleWorkflow, StackWorkflowEntity stackWorkflowEntity) {
        return this.isWorkflowOpen(amazonSimpleWorkflow, stackWorkflowEntity);
    }

    public /* synthetic */ void this$2$cancelOpenWorkflows(AmazonSimpleWorkflow amazonSimpleWorkflow, List list) {
        this.cancelOpenWorkflows(amazonSimpleWorkflow, list);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(StackActivityImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StackActivityImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

