/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.util;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.InternalFailureException;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.log4j.Logger;

public class MessageHelper {
    private static final Logger LOG = Logger.getLogger(MessageHelper.class);

    public static <T extends BaseMessage> T createMessage(Class<T> tClass, String effectiveUserId) throws CloudFormationException {
        try {
            BaseMessage t = (BaseMessage)tClass.newInstance();
            t.setEffectiveUserId(effectiveUserId);
            return (T)t;
        }
        catch (Exception e) {
            throw new InternalFailureException(e.getMessage());
        }
    }

    public static <T extends BaseMessage> T createPrivilegedMessage(Class<T> tClass, String effectiveUserId) throws CloudFormationException {
        try {
            BaseMessage t = (BaseMessage)tClass.newInstance();
            t.setUserId(effectiveUserId);
            t.markPrivileged();
            return (T)t;
        }
        catch (Exception e) {
            throw new InternalFailureException(e.getMessage());
        }
    }
}

